import { GenerateLatData } from "./GenerateLatData";

/**
 * 地图数据接口
 * 包括地图格子，和地图上的特殊元素，生成口，联通口
 */
export interface MapData {
    /**
     * 一维格子数组，步长9
     * 
     * 9*9长度
     * 0无格子
     * 1普通格子
     * 2浅冰块
     * 3深冰块
     * 4石门  额外加一位就是开门下同
     * 5石门+浅冰块
     * 6石门+深冰块
     */
    lattices: number[];
    /**
     * 能生成元素的格子索引
     * 
     */
    generateLats?: GenerateLatData[];
    /**
     * 一维格子数组，步长9,
     * 9*9
     * 如果没有就用地图数据,全变01
     * 0无元素
     * 1普通元素
     * 2石头
     * 3棒棒糖
     * 4元素枷锁
     * 5果冻
     * 6鸡蛋
     * 7变色气泡
     * 8灰色毛球 一次消除
     * 9褐色毛球 特效消除，分裂
     * 10黑色毛球 两次消除，一次眩晕，
     */
    elements?: number[];
    /**
     * 9*9的格子，不修改写null或[]
     * 十位是基础元素类型，对应数字减1就是基础元素类型
     * 个位是特效类型（0表示无特效），对应数字减1就是特效类型
     * 10
     * 11
     * 12
     * 13
     * 14
     */
    baseElements?: number[];
    /**
     * 再考虑
     * 元素为两个索引的数组[8,9]，第一个元素为up，第二个元素为down
     * [[8,9],[10,13]]
     */
    connectedLats?: any[];

    /**
     * 棒棒糖回收口
     * 格子索引
     */
    recycles?: number[];
}