import { RES } from "../../../module/RES";

/**
 * 位图数字，单个
 */
export class BitmapNumber extends FYGE.Sprite {
    /**
     * 图片前缀
     * 就是那些图片名字
     */
    resName: string
    /**
     * 数字0到9
     */
    private _num: number;
    get num(): number {
        return this._num
    }
    set num(value: number) {
        if (value == this._num) return;
        this._num = value;
        var texture: FYGE.Texture = RES.getRes(this.resName + value + ".png");
        this.texture = texture;
    }

    constructor(resName: string) {
        super();
        this.resName = resName;
    }

    reset(resName: string) {
        this.resName = resName
    }
}