import { ChapterData } from "../interface/ChapterData";
import { PassType } from "../enum/PassType";
import { ElementType } from "../enum/ElementType";

/**
 * 61到80关数据
 */
export const Chapters4: ChapterData[] = [
    //61 鸡蛋引导 待加引导
    {
        baseElementTypes: [0, 4, 2, 3],
        bubbleProbability: 0,
        stepCount: 37,
        passTarget: { type: 1, elements: [{ type: 1, count: 30 }] },
        starScores: [8000, 15000, 22000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0
            ],
            connectedLats: [],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 6, 1, 1, 1, 6, 1, 1,
                1, 1, 6, 1, 1, 1, 6, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 10, 50, 30, 0, 0, 0,
                0, 0, 40, 40, 30, 50, 50, 0, 0,
                0, 30, 30, 50, 50, 40, 40, 10, 0,
                50, 40, 0, 10, 20, 30, 0, 10, 20,
                50, 40, 0, 10, 20, 50, 0, 30, 20,
                0, 50, 40, 20, 40, 30, 30, 50, 0,
                0, 0, 20, 10, 40, 10, 10, 0, 0,
                0, 0, 0, 50, 30, 30, 0, 0, 0,
            ],
            recycles: [],
            generateLats: [
                { index: 12, type: null },
                { index: 13, type: null },
                { index: 14, type: null },

                { index: 20, type: null },
                { index: 24, type: null },
                { index: 28, type: null },

                { index: 34, type: null },
                { index: 36, type: null },
                { index: 44, type: null }
            ]
        }
    },
    //62
    {
        baseElementTypes: [2, 3, 4, 0],
        bubbleProbability: 0,
        stepCount: 34,
        passTarget: { type: 1, elements: [{ type: 1, count: 50 }, { type: 0, count: 30 }, { type: 2, count: 30 }] },
        starScores: [5000, 12000, 18000],
        map: {
            lattices: [1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1], connectedLats: [], elements: [1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }]
        }
    },
    //63
    {
        baseElementTypes: [2, 3, 4, 0],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 1, count: 40 }, { type: 0, count: 30 }, { type: 2, count: 30 }] }, starScores: [5000, 12000, 18000], map: { lattices: [1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1], connectedLats: [[72, 5], [73, 6], [74, 7], [75, 8]], elements: [1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 6, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 6, 1, 1, 1, 1, 0, 1, 1, 1, 1, 2, 2, 2, 2, 0, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] }
    },
    //64
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 6, count: 2 }] },
        starScores: [5000, 12000, 18000],
        map: { lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0], connectedLats: [], elements: [0, 3, 1, 1, 1, 1, 1, 3, 0, 0, 4, 1, 1, 1, 1, 1, 4, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 4, 1, 1, 1, 1, 1, 4, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }] }
    },
    //65
    {
        baseElementTypes: [0, 2, 3, 4], bubbleProbability: 0, stepCount: 37, passTarget: { type: 1, elements: [{ type: 1, count: 36 }] }, starScores: [5000, 12000, 17000], map: { lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0], connectedLats: [], elements: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 6, 1, 1, 1, 6, 1, 1, 1, 1, 6, 1, 1, 1, 6, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0], baseElements: [0, 0, 10, 10, 30, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: [10, 30] }, { index: 3, type: [10, 30] }, { index: 4, type: [10, 30] }, { index: 5, type: [10, 30] }, { index: 6, type: [10, 30] }, { index: 20, type: null }, { index: 21, type: null }, { index: 22, type: null }, { index: 23, type: null }, { index: 24, type: null }] }
    },
    //66
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 34,
        passTarget: {
            type: 1, elements: [
                { type: 1, count: 60 },
                { type: 0, count: 50 },
                { type: 2, count: 50 }
            ]
        },
        starScores: [6000, 12000, 24000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                6, 1, 1, 1, 1, 1, 1, 1, 6,
                6, 1, 1, 1, 1, 1, 1, 1, 6,
                6, 1, 1, 1, 1, 1, 1, 1, 6,
                0, 1, 1, 4, 4, 4, 1, 1, 0,
                0, 1, 1, 4, 6, 4, 1, 1, 0,
                6, 1, 1, 4, 4, 4, 1, 1, 6,
                6, 1, 1, 1, 1, 1, 1, 1, 6,
                6, 1, 1, 1, 1, 1, 1, 1, 6
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
            ]
        }
    },
    //67
    {
        baseElementTypes: [0, 1, 3, 2, 4],
        bubbleProbability: 0.2,
        stepCount: 32,
        passTarget: { type: 1, elements: [{ type: 9, count: 28 }] },
        starScores: [6000, 12000, 24000],
        map: {
            lattices: [
                0, 0, 1, 2, 1, 2, 1, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 1, 0, 1, 0, 0, 0
            ],
            connectedLats: [],
            elements: [
                0, 0, 1, 2, 1, 2, 1, 0, 0,
                0, 7, 2, 7, 2, 7, 2, 7, 0,
                4, 2, 4, 2, 4, 2, 4, 2, 4,
                2, 1, 2, 1, 2, 1, 2, 1, 2,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 1, 0, 1, 0, 0, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 10, type: null },
                { index: 11, type: null },
                { index: 12, type: null },
                { index: 13, type: null },
                { index: 14, type: null },
                { index: 15, type: null },
                { index: 16, type: null },
                { index: 18, type: null },
                { index: 19, type: null },
                { index: 20, type: null },
                { index: 21, type: null },
                { index: 22, type: null },
                { index: 23, type: null },
                { index: 24, type: null },
                { index: 25, type: null },
                { index: 26, type: null },
                { index: 27, type: null },
                { index: 28, type: null },
                { index: 29, type: null },
                { index: 30, type: null },
                { index: 31, type: null },
                { index: 32, type: null },
                { index: 33, type: null },
                { index: 34, type: null },
                { index: 35, type: null },
                { index: 36, type: null },
                { index: 37, type: null },
                { index: 38, type: null },
                { index: 39, type: null },
                { index: 40, type: null },
                { index: 41, type: null },
                { index: 42, type: null },
                { index: 43, type: null },
                { index: 44, type: null }]
        }
    },
    //68
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: 1,
            elements: [
                { type: 1, count: 45 },
                { type: 0, count: 28 },
                { type: 2, count: 28 }
            ]
        }, starScores: [5000, 12000, 18000], map: { lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0], connectedLats: [], elements: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 2, 1, 1, 1, 0, 1, 1, 1, 2, 4, 2, 1, 1, 1, 1, 1, 2, 4, 6, 4, 2, 1, 1, 1, 2, 4, 6, 1, 6, 4, 2, 1, 1, 1, 2, 4, 6, 4, 2, 1, 1, 1, 1, 1, 2, 4, 2, 1, 1, 1, 0, 1, 1, 1, 2, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 10, 0, 30, 0, 0, 0, 0, 0, 30, 0, 14, 0, 10, 0, 0, 0, 0, 0, 10, 0, 40, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 10, type: null }, { index: 16, type: null }, { index: 18, type: null }, { index: 26, type: null }] }
    },
    //69
    {
        baseElementTypes: [0, 2, 1, 3, 4], bubbleProbability: 0, stepCount: 29, passTarget: { type: 1, elements: [{ type: 9, count: 68 }] }, starScores: [8000, 15000, 22200], map: { lattices: [1, 0, 1, 0, 1, 0, 1, 0, 1, 2, 0, 2, 0, 2, 0, 2, 0, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2], connectedLats: [], elements: [1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 5, 2, 5, 2, 5, 2, 5, 2, 2, 4, 2, 4, 2, 4, 2, 4, 2, 1, 4, 2, 4, 2, 4, 2, 4, 2], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 0, 13, 0, 13, 0, 23, 0, 0, 13, 0, 21, 0, 31, 0, 11, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 2, type: null }, { index: 4, type: null }, { index: 6, type: null }, { index: 8, type: null }] }
    },
    //70
    {
        baseElementTypes: [1, 0, 2, 3],
        bubbleProbability: 0,
        stepCount: 20,
        passTarget: { type: 1, elements: [{ type: 1, count: 90 }] },
        starScores: [5000, 11000, 20000],
        map: {
            lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], connectedLats: [[11, 29], [12, 30], [13, 31], [14, 32], [15, 33]], elements: [0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 7, 7, 0, 0, 0, 7, 7, 7, 7, 7, 7, 7, 0, 0, 6, 7, 7, 7, 7, 7, 6, 0, 0, 2, 7, 7, 7, 7, 7, 2, 0, 0, 0, 2, 6, 2, 6, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 11, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }, { index: 15, type: null }]
        }
    },
    //71
    {
        baseElementTypes: [1, 2, 3, 4], bubbleProbability: 0, stepCount: 25, passTarget: { type: 1, elements: [{ type: 9, count: 45 }] }, starScores: [6000, 13000, 25000], map: { lattices: [0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 0, 1, 3, 3, 3, 3, 3, 0, 0, 0, 0, 1, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 2, 3, 3, 3, 3, 1, 0, 0, 3, 3, 3, 3, 3, 1, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 0], connectedLats: [], elements: [0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 6, 1, 1, 1, 1, 1, 0, 0, 0, 0, 6, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 6, 0, 0, 1, 1, 1, 1, 1, 6, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 10, type: null }, { index: 11, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }] }
    },
    //72
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: 1, elements: [
                { type: 2, count: 58 },
                { type: 1, count: 48 },
                { type: 5, count: 14 }
            ]
        },
        starScores: [6000, 12000, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 0, 1, 1, 1, 1, 0, 1, 0,
                0, 0, 1, 1, 1, 1, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 0, 2, 2, 2, 2, 0, 1, 0,
                0, 0, 2, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 2, 0,
                2, 0, 0, 6, 6, 0, 0, 2, 0,
                2, 0, 0, 0, 0, 0, 0, 2, 0,
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },

            ]
        }
    },
    //73
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: { type: 1, elements: [{ type: 9, count: 37 }] },
        starScores: [6000, 11000, 22000],
        map: {
            lattices: [
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2
            ],
            connectedLats: [],
            elements: [
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 5, 0, 5, 2, 2, 1,
                1, 2, 2, 0, 5, 0, 2, 2, 1,
                1, 2, 2, 5, 5, 5, 2, 2, 1,
                1, 1, 2, 2, 5, 2, 2, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null },
                { index: 72, type: null },
                { index: 73, type: null },
                { index: 79, type: null },
                { index: 80, type: null },
            ]
        }
    },
    //74
    {
        baseElementTypes: [1, 2, 3, 4], bubbleProbability: 0, stepCount: 25, passTarget: { type: 1, elements: [{ type: 9, count: 18 }] }, starScores: [5000, 12000, 18000], map: { lattices: [0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 0, 1, 1, 1, 1, 1, 3, 3, 3, 0, 1, 1, 1, 1, 1, 3, 3, 3, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 3, 3, 3, 0, 1, 1, 1, 1, 1, 3, 3, 3, 0, 1, 1, 1, 1, 1, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], connectedLats: [[27, 45], [28, 46], [29, 47]], elements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 6, 1, 1, 1, 6, 0, 0, 0, 0, 6, 1, 1, 1, 6, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 40, 20, 0, 0, 0, 0, 0, 0, 40, 20, 30, 0, 0, 0, 0, 0, 0, 20, 30, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, 20, 40, 0, 0, 0, 0, 0, 0, 20, 50, 20, 0, 0, 0, 0, 0, 0, 50, 20, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 9, type: null }, { index: 10, type: null }, { index: 11, type: null }, { index: 13, type: null }, { index: 14, type: null }, { index: 15, type: null }, { index: 16, type: null }, { index: 17, type: null }] }
    },
    //75
    {
        baseElementTypes: [0, 2, 3, 4], bubbleProbability: 0.1, stepCount: 29, passTarget: { type: 1, elements: [{ type: 1, count: 32 }, { type: 3, count: 35 }, { type: 4, count: 35 }] }, starScores: [6000, 12000, 21000], map: { lattices: [0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0], connectedLats: [], elements: [0, 0, 0, 7, 7, 7, 0, 0, 0, 0, 0, 4, 1, 1, 1, 4, 0, 0, 0, 0, 4, 1, 1, 1, 4, 0, 0, 6, 0, 4, 1, 1, 1, 4, 0, 6, 6, 0, 4, 1, 1, 1, 4, 0, 6, 0, 0, 7, 1, 1, 1, 7, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 6, 6, 6, 1, 1, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 11, type: null }, { index: 15, type: null }, { index: 73, type: null }, { index: 79, type: null }] }
    },
    //76
    {
        baseElementTypes: [0, 3, 4, 2],
        bubbleProbability: 0,
        stepCount: 22,
        passTarget: { type: 1, elements: [{ type: 1, count: 40 }] },
        starScores: [5000, 11111, 23000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 0, 0, 1, 1, 1, 4, 6, 1,
                1, 0, 0, 1, 1, 1, 4, 6, 1,
                1, 1, 1, 1, 1, 1, 4, 4, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 4, 4, 1, 1, 1, 1, 1, 1,
                1, 2, 4, 1, 1, 1, 0, 0, 1,
                1, 2, 4, 1, 1, 1, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null }
            ]
        }
    },
    //77
    {
        baseElementTypes: [0, 1, 3, 2],
        bubbleProbability: 0.2,
        stepCount: 20,
        passTarget: { type: 1, elements: [{ type: 6, count: 3 }] },
        starScores: [5000, 12000, 18000],
        map: {
            lattices: [1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0],
            connectedLats: [[45, 2], [53, 6]],
            elements: [1, 0, 1, 0, 1, 0, 1, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [55, 61, 65, 69, 75, 76, 77], generateLats: [{ index: 0, type: null }, { index: 4, type: null }, { index: 8, type: null }, { index: 10, type: null }, { index: 12, type: null }, { index: 14, type: null }, { index: 16, type: null }]
        }
    },
    //78
    {
        baseElementTypes: [0, 1, 3, 2, 4],
        bubbleProbability: 0,
        stepCount: 35,
        passTarget: { type: 1, elements: [{ type: 9, count: 12 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                3, 0, 1, 1, 1, 1, 1, 0, 3,
                3, 3, 1, 1, 1, 1, 1, 3, 3,
                3, 0, 1, 1, 1, 1, 1, 0, 3,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 0, 3, 0, 1, 1, 1,
                1, 1, 0, 3, 3, 3, 0, 1, 1
            ],
            connectedLats: [],
            elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 4, 1, 0, 1, 4, 1, 0, 2, 4], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }]
        }
    },
    //79
    {
        baseElementTypes: [0, 2, 1, 4, 3], bubbleProbability: 0, stepCount: 35, passTarget: { type: 1, elements: [{ type: 9, count: 32 }] }, starScores: [6000, 11000, 21000], map: { lattices: [1, 3, 3, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 3, 3, 1], connectedLats: [], elements: [1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1], baseElements: [0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }, { index: 10, type: null }, { index: 11, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }, { index: 15, type: null }, { index: 16, type: null }, { index: 18, type: null }, { index: 19, type: null }, { index: 20, type: null }, { index: 21, type: null }, { index: 22, type: null }, { index: 23, type: null }, { index: 24, type: null }, { index: 25, type: null }] }
    },
    //80
    {
        baseElementTypes: [0, 2, 1, 3, 4],
        bubbleProbability: 0,
        stepCount: 23,
        passTarget: { type: 1, elements: [{ type: 1, count: 50 }, { type: 5, count: 26 }] },
        starScores: [5000, 11000, 19000],
        map: {
            lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
            connectedLats: [],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 7, 2, 7, 2, 7, 2, 7, 0,
                7, 7, 2, 7, 2, 7, 2, 7, 7,
                2, 7, 2, 7, 2, 7, 2, 7, 2,
                2, 7, 6, 7, 6, 7, 6, 7, 2,
                2, 7, 2, 7, 2, 7, 2, 7, 2,
                2, 7, 2, 7, 2, 7, 2, 7, 2,
                7, 7, 2, 7, 2, 7, 2, 7, 7,
                7, 7, 7, 7, 7, 7, 7, 7, 7
            ],
            baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            recycles: [],
            generateLats: [
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 18, type: null },
                { index: 26, type: null }
            ]
        }
    }
]