import { Ani } from "../class/Ani";
import { RecoverName } from "../enum/RecoverName";
import { RES } from "../../../module/RES";


export class MagicLionAni extends Ani {
    downImage: FYGE.Container;
    upImage: FYGE.Sprite;
    constructor() {
        super()
        this.aniName = RecoverName.MAGICLION_ANI//"MagicLionAni";

        this.downImage = new FYGE.Container();
        // this.downImage.scaleX = this.downImage.scaleY = 0.7;
        this.addChild(this.downImage)
        var texture: FYGE.Texture = RES.getRes("magicLionBg.png")
        let one = new FYGE.Sprite(texture);
        one.anchorTexture.set(0.5,0.5)
        // one.anchorOffsetX = texture.textureWidth / 2;
        // one.anchorOffsetY = texture.textureHeight / 2;
        this.downImage.addChild(one);
        this.addEventListener(FYGE.Event.ENTER_FRAME, () => {
            one.rotation -= 5;
        }, this);

        let other = new FYGE.Sprite(texture);
        other.anchorTexture.set(0.5,0.5);
        // other.anchorOffsetX = texture.textureWidth / 2;
        // other.anchorOffsetY = texture.textureHeight / 2;
        this.downImage.addChild(other);
        this.addEventListener(FYGE.Event.ENTER_FRAME, () => {
            other.rotation -= 5;
        }, this);

        //上图
        var texture: FYGE.Texture = RES.getRes("magicLion.png")
        this.upImage = new FYGE.Sprite(texture);
        this.upImage.anchorTexture.set(0.5,0.5);
        // this.upImage.anchorOffsetX = texture.textureWidth / 2;
        // this.upImage.anchorOffsetY = texture.textureHeight / 2;
        // this.upImage.scaleX = this.upImage.scaleY = 0.7
        this.addChild(this.upImage);
        this.addEventListener(FYGE.Event.ENTER_FRAME, () => {
            this.upImage.rotation += 2;
        }, this)
    }

    play() {
        this.downImage.scaleX = this.downImage.scaleY = 0.7//1;
        this.downImage.alpha = 1;
        this.upImage.scaleX = this.upImage.scaleY = 1;
        this.upImage.alpha = 1;
        FYGE.Tween.get(this.downImage)
            .to({ scaleX: 2, scaleY: 2 }, 300)
            .to({ scaleX: 1.2, scaleY: 1.2 }, 200)
            .wait(150)//和所有元素旋转时间一致，反正到时调整
            .to({ alpha: 0, scaleX: 0.2, scaleY: 0.2 }, 100)
            .call(() => {
                this.recover();
            })
        FYGE.Tween.get(this.upImage)
            .to({ scaleX: 1, scaleY: 1 }, 300)
            .to({ scaleX: 0, scaleY: 0, alpha: 0 }, 200)
    }

}
