import { Ani } from "../class/Ani";

import { RES } from "../../../module/RES";
import { RecoverName } from "../enum/RecoverName";

const offsetX = 71 / 2;
const offsetY = 62 / 2;


/**
 * 碎片位置参数
 */
const config = [
    {
        "name": "hairballPiece1",
        "x": 5,
        "y": 46,
        "width": 33,
        "height": 15
    },
    {
        "name": "hairballPiece2",
        "x": 32,
        "y": 41,
        "width": 36,
        "height": 21
    },
    {
        "name": "hairballPiece3",
        "x": 0,
        "y": 37,
        "width": 36,
        "height": 21
    },
    {
        "name": "hairballPiece4",
        "x": 30,
        "y": 26,
        "width": 41,
        "height": 31
    },
    {
        "name": "hairballPiece5",
        "x": 1,
        "y": 32,
        "width": 42,
        "height": 17
    },
    {
        "name": "hairballPiece6",
        "x": 33,
        "y": 30,
        "width": 34,
        "height": 17
    },
    {
        "name": "hairballPiece7",
        "x": 1,
        "y": 23,
        "width": 47,
        "height": 15
    },
    {
        "name": "hairballPiece8",
        "x": 33,
        "y": 20,
        "width": 38,
        "height": 14
    },
    {
        "name": "hairballPiece9",
        "x": 2,
        "y": 16,
        "width": 41,
        "height": 11
    },
    {
        "name": "hairballPiece10",
        "x": 31,
        "y": 13,
        "width": 39,
        "height": 10
    },
    {
        "name": "hairballPiece11",
        "x": 5,
        "y": 0,
        "width": 65,
        "height": 23
    }
]

/**
 * 毛球消失动效
 */
export class HairballGreyDisAni extends Ani {
    pieces: FYGE.Sprite[];
    upBg: FYGE.Sprite;
    constructor() {
        super();
        this.aniName = RecoverName.HAIRBALLGREYDIS_ANI// "HairballGreyDisAni";

        this.pieces = []
        for (var i = 0; i < config.length; i++) {
            var bitmap = new FYGE.Sprite(RES.getRes(config[i].name + ".png"))
            this.addChild(bitmap)
            this.pieces.push(bitmap);
        }



        this.upBg = new FYGE.Sprite(RES.getRes("hairballDisBg.png"));

        // this.upBg.anchorOffsetX = offsetX;
        // this.upBg.anchorOffsetY = offsetY;
        this.upBg.anchorTexture.set(offsetX / this.upBg.texture.width, offsetY / this.upBg.texture.height)
        this.addChild(this.upBg);

        this.reset();
    }

    private reset() {
        for (var i = 0; i < config.length; i++) {
            this.pieces[i].x = config[i].x - offsetX;
            this.pieces[i].y = config[i].y - offsetY;
            this.pieces[i].alpha = 1;
        }
        this.upBg.scaleX = this.upBg.scaleY = 1;
        this.upBg.alpha = 1;
    }

    play() {
        //重置
        this.reset();
        //动画，完了要调this.recover()
        FYGE.Tween.get(this.upBg)
            .to({ scaleX: 1.5, scaleY: 1.5 }, 150)
        FYGE.Tween.get(this.upBg)
            .wait(50)
            .to({ alpha: 0 }, 100)
            .call(() => {
                //碎片掉落
                for (let i = 0; i < config.length; i++) {
                    let p = this.pieces[i];
                    let y = config[i].y;
                    FYGE.Tween.get(p)
                        .wait(i * 30)
                        .to({ y: y + 6 }, 200);
                    FYGE.Tween.get(p)
                        .wait(i * 30 + 150)
                        .to({ alpha: 0 }, 50)
                        .call(() => {
                            if (i == config.length - 1) {
                                this.recover();
                            }
                        })
                }
            })


    }
}
