
import { RecoverName } from "../enum/RecoverName";
import { Pool } from "../Pool";
import { Element } from "../class/Element";
import { Ice } from "../class/Ice";
import { ElementType } from "../enum/ElementType";
import { BitmapRecycle } from "../class/BitmapRecycle";
import { RES } from "../../../module/RES";
export function FlyTargetAni(
    type: ElementType,
    fromP: number[],
    targetP: number[],
    callback: Function
) {
    var texture: FYGE.Texture = RES.getRes("ele" + type + ".png");
    //弄一个替代的
    let eleC: BitmapRecycle = Pool.takeOut(RecoverName.BITMAPRECYCLE);
    if (!eleC) {
        eleC = new BitmapRecycle(texture);
    } else {
        eleC.reset(texture);
    }
    eleC.x = fromP[0];
    eleC.y = fromP[1];
    FYGE.Tween.get(eleC)
        .to({ x: targetP[0], y: targetP[1], scaleX: 0.7, scaleY: 0.7 }, 500 + (Math.random() * 100) >> 0)
        .call(() => {
            //回收
            if (eleC.parent) {
                eleC.parent.removeChild(eleC);
                Pool.recover(RecoverName.BITMAPRECYCLE, eleC);
            }
            //回调
            callback();
            // con["elementTargets"].targets[type].count--;
        })

    return eleC
}