import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { ElementType } from "../enum/ElementType";
import { RES } from "../../../module/RES";

/**
 * 变成function了
 * 自行添加到容器
 * 自行赋值位置
 * @param type 只能式基础元素
 * @param p
 */
export function EleDisAni(type: ElementType): FYGE.FrameAni {
    var arr: FYGE.Texture[] = [];
    for (var i = 0; i <= 21; i++) {
        arr.push(RES.getRes("dis_ele_" + i + ".png"));
    }
    let frameAni: FYGE.FrameAni = Pool.takeOut(RecoverName.FRAME_ANI);
    if (!frameAni) {
        frameAni = new FYGE.FrameAni(arr);
    } else {
        frameAni.resetTexturesAll(arr);
    }
    frameAni.play(1, () => {
        //回收
        if (frameAni.parent) {
            (frameAni.parent as FYGE.Container).removeChild(frameAni);
            Pool.recover(RecoverName.FRAME_ANI, frameAni);
        }
    })
    return frameAni
}



// import { Ani } from "../class/Ani";
/**
 * 普通元素消失特效
 *
 */
// export class EleDisAni extends Ani {
//     /**
//      * 图片
//      */
//     showImage: FYGE.FrameAni;
//     constructor(type) {
//         super();
//         this.aniName = "EleDisAni";
//         var arr = []
//         for (var i = 1; i <= 13; i++) {
//             arr.push("eleDis" + i + ".png");
//         }
//         this.showImage = new FYGE.FrameAni(arr);
//         this.addChild(this.showImage)
//     }
//     play() {
//         //重置图片
//         this.showImage.currentFrame = 0;
//         this.showImage.source = this.showImage.sourceAll[0];
//         this.showImage.play(() => {
//             this.recover();
//         })
//     }
// }
