
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { RES } from "../../../module/RES";
import { Tool } from "../Tool";


export const stepPosition: number[] = [100, 120, 100];
/**
 * 需要回调的
 * 手动修改this.shoot.rotation=
 */
export class BonusShootAni extends FYGE.Container {
    shoot: FYGE.Sprite;
    imageAni: FYGE.FrameAni;
    constructor() {
        super()
        var texture = RES.getRes("bonusShoot.png")
        this.shoot = new FYGE.Sprite(texture);
        this.shoot.anchorTexture.set(78 / 95, 0.5)
        // this.shoot.anchorOffsetX = 78;
        // this.shoot.anchorOffsetY = 37 / 2;
        this.addChild(this.shoot);
        var arr = []
        for (var i = 0; i <= 11; i++) arr.push(RES.getRes("bonusFra" + i + ".png"));

        this.imageAni = new FYGE.FrameAni(arr);
        this.addChild(this.imageAni);
        this.imageAni.visible = false;
    }
    reset() {
        this.shoot.visible = true;
        this.imageAni.visible = false;
        this.x = stepPosition[0];
        this.y = stepPosition[1];
    }

    play(p: number[], callback: Function) {
        this.reset()
        this.shoot.rotation = Tool.getForwardRotation(stepPosition, p) * 180 / Math.PI;
        FYGE.Tween.get(this)
            .to({ x: p[0], y: p[1] }, 300)
            .call(() => {
                callback();
                // playSound(SoundType.bonusShoot)
                this.shoot.visible = false;
                this.imageAni.visible = true;
                this.imageAni.play(1, () => {
                    if (this.parent) {
                        this.parent.removeChild(this)
                    };
                    Pool.recover(RecoverName.BONUSSHOOT_ANI, this)
                    // callback();
                })
            })
    }
}
