import Container = FYGE.Container;
import Button = FYGE.Button;
import TextField = FYGE.TextField;
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import MouseEvent = FYGE.MouseEvent;
import { RES } from "../../../module/RES";
import { Tools } from "../../Tools";
import { showPanel, showToast } from "../../../module/ctrls";
import { RulePanel } from "../../panels/RulePanel";
import { sendTbNet, TbNetName } from "../../TaoBaoNet";
import { layers } from "../../../module/views/layers";
import { LotteryPanel } from "../../panels/LotteryPanel";

export default class MapUI extends Container {
    public energyBox: EnergyBox = null;

    private myPrizeBtn: Button = null;
    private ruleBtn: Button = null;
    private taskBtn: Button = null;
    private clearanceBtn: Button = null;

    constructor() {
        super();

        this.initUi();
        this.initEvent();

    }

    private initEvent() {
        this.ruleBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.myPrizeBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.taskBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.clearanceBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
    }

    private removeEvent() {
        this.ruleBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.myPrizeBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.taskBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.clearanceBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
    }

    private clickBtn(e) {
        switch (e.target) {
            case this.ruleBtn:
                showPanel(RulePanel);
                break;
            case this.myPrizeBtn:
                sendTbNet(
                    TbNetName.navigateTo,
                    { url: '/pages/myprize/myprize' },
                    () => {
                    },
                    true
                );
                break;

            case this.taskBtn:
                if (Tools.actEnd) {
                    showToast("活动已结束");
                    return;
                }
                Tools.openTask();
                break;

            case this.clearanceBtn:
                showPanel(LotteryPanel, { callFun: () => this.updateUI() })
                break;
        }
    }

    public destroy() {
        super.destroy();
        this.removeEvent();
    }

    private initUi() {
        // const _y = (1624 - layers.stageOffsetY) / 1624 * 213;
        const _y = layers.stageHeight * 0.1311576354679803;

        // 我的奖品
        this.myPrizeBtn = this.addChild(new Button(RES.getRes('map_prizeBtn.png')));
        this.myPrizeBtn.position.set(617, _y);
        this.myPrizeBtn.anchorX = 133;

        // 规则按钮
        this.ruleBtn = this.addChild(new Button(RES.getRes('map_ruleBtn.png')));
        this.ruleBtn.position.set(0, _y);
        this.ruleBtn.anchorX = 0;

        // 任务按钮
        this.taskBtn = this.addChild(new Button(RES.getRes('map_taskBtn.png')));
        this.taskBtn.position.set(643, _y + 65);

        this.energyBox = this.addChild(new EnergyBox());
        this.energyBox.position.set(8, _y + 65);

        this.clearanceBtn = this.addChild(new Button(RES.getRes('clearanceBtn.png')));
        this.clearanceBtn.position.set(0, _y + 174);
        this.clearanceBtn.visible = false;
    }

    public updateUI() {
        this.energyBox.count = Tools.gameData.power;
        const { topLevelVisitSuccess, isDrawTopLevelPrize } = Tools.gameData;
        this.clearanceBtn.visible = topLevelVisitSuccess && !isDrawTopLevelPrize;
    }
}

/**
 * 能量
 */
class EnergyBox extends Container {

    private countLabel: TextField = null;

    private _count = 0;
    public set count(count: number) {
        this._count = count;
        this.countLabel.text = '' + count;
    }

    constructor() {
        super();

        this.initUi();

    }

    private initUi() {

        this.addChild(Tools.getSprite('map_energyBg.png'));

        this.countLabel = this.addChild(Tools.getText(
            '0', 33, '#ffffff',
            TEXT_ALIGN.CENTER, 80, 110, 40
        ));

    }

    public destroy() {
        super.destroy();
    }
}
