import MapPart from "./MapPart";
import { RES } from "../../../module/RES";
import Point = FYGE.Point;

export default class MapBottom extends MapPart {

    public static HEIGHT = 856;

    public static totalCount = 2;

    protected btnPos = [
        [215, 386],
        [404, 79],
    ];

    constructor(data) {
        super(data);
        this.data = data;

        this.bg.texture = RES.getRes('map_bg1.jpg');
        this.initIcon();
        this.initEffect();
    }

    private initEffect() {

    }

    public update() {
        super.update();
        let up = this.localToGlobal(new Point(0, -10), new Point());
        let bp = this.localToGlobal(new Point(0, MapBottom.HEIGHT + 10), new Point());
        let ucp = this.localToGlobal(new Point(0, MapBottom.HEIGHT / 4), new Point());
        let bcp = this.localToGlobal(new Point(0, MapBottom.HEIGHT / 4 * 3), new Point());
        this.alpha = +(this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp));
    }

    public destroy() {
        super.destroy();
    }

}
