import { Scene } from "../../module/views/Scene";
import { Tools } from "../Tools";
import { ProgressBarS } from "../common/ProgressBarS";
import { RES } from "../../module/RES";
import { sendTbNet, TbNetName } from "../TaoBaoNet";
import { layers } from "../../module/views/layers";
import { changeScene, showToast } from "../../module/ctrls";
import { MapScene } from "./map/MapScene";
import TextField = FYGE.TextField;
import Tween = FYGE.Tween;
import FrameAni = FYGE.FrameAni;
import Sprite = FYGE.Sprite;
import Event = FYGE.Event;
import Ease = FYGE.Ease;

export class LoadingScene extends Scene {
    get groupNames() {
        return ["loadingScene"]
    }

    progressBar: ProgressBarS;
    loadingTxt: TextField;
    shoes: Sprite;
    line_L1: Sprite;
    line_L2: Sprite;
    line_R: Sprite;

    initUi() {
        //适配
        this.y = -layers.stageOffsetY;
        //背景
        this.addChild(FYGE.Sprite.fromFrame("loadingBg.jpg"));

        this.shoes = this.addChild(Tools.getSprite("loading_shoes.png"));
        this.shoes.position.set(257, 1010);

        this.line_L1 = this.addChild(Tools.getSprite("loading_line_left1.png"));
        this.line_L1.position.set(205, 552);

        this.line_L2 = this.addChild(Tools.getSprite("loading_line_left2.png"));
        this.line_L2.position.set(162, 576);

        this.line_R = this.addChild(Tools.getSprite("loading_line_right.png"));
        this.line_R.position.set(527, 554);

        //进度条帧动画
        const pro = this.addChild(Tools.getSprite('loadingPro.png'));
        pro.position.set(126, 792)//位置按正常满条的位置

        //@ts-ignore 进度条托管
        this.progressBar = new ProgressBarS(pro);

        const frames = [];
        for (let i = 0; i <= 29; i++) {
            frames.push(RES.getRes(`loadingLight${i}.png`));
        }
        const ani = new FrameAni(frames);
        this.addChild(ani);
        ani.position.set(375, 665);
        ani.play(1);

        this.shoes.anchor.set(20, 200);

        Tween.get(this.shoes, { loop: true })
            .to({ rotation: 10 }, 2000)
            .to({ rotation: 0 }, 2000);

        Tween.get(this.line_L1, { loop: true })
            .to({ x: 175 }, 700)
            .to({ x: 205 }, 700);

        Tween.get(this.line_L2, { loop: true })
            .to({ x: 190 }, 700)
            .to({ x: 162 }, 700);

        Tween.get(this.line_R, { loop: true })
            .to({ x: 497 }, 700)
            .to({ x: 527 }, 700);
    }

    async start() {
        super.start()

        this.addEventListener(Event.PROGRESS, this.progressEvent, this)
        //首次进度一点
        this.dispatchEvent(Event.PROGRESS, 0.2)

        //获取app数据
        const { data } = await sendTbNet(TbNetName.getAppData);
        Tools.globalData = data;
        Tools.globalData.oldInviteId = Tools.globalData.inviteId;
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.3);

        //询问读取权限，不阻止进程
        // Tools.checkPermission();//这个需要吗？

        // 游戏基本信息
        const baseInfo = await Tools.getGameInfo();
        if (!baseInfo) showToast("获取游戏信息失败");

        this.dispatchEvent(Event.PROGRESS, 0.5);

        await RES.loadGroup("map");
        this.dispatchEvent(Event.PROGRESS, 0.65);

        await RES.loadGroup('StartPanel');
        this.dispatchEvent(Event.PROGRESS, 0.7);

        await RES.loadGroup('UseStep');
        this.dispatchEvent(Event.PROGRESS, 0.85);

        this.dispatchEvent(Event.PROGRESS, 1);
    }

    // private lastP=0
    progressEvent(e: Event) {
        let pro = e.data;
        Tween.get(this.progressBar, null, null, true)
            .to({ value: pro }, 2000/**(p-this.lastP)*/)
            .call(() => {
                if (pro >= 1) {
                    this.removeEventListener(FYGE.Event.PROGRESS, this.progressEvent, this);
                    changeScene(MapScene, { from: "loading" });
                    // changeScene(PlayScene, { chapter: 20 });
                    sendTbNet(TbNetName.openMusic, { isOn: true });
                }
            });
        // this.lastP=p
    }

    destroy() {
        //动效要去掉
        // FYGE.Tween.removeTweens()
        super.destroy()
        //到时如果内存炸了，考虑销毁用过的贴图缓存，待测试，在RES里写个根据销毁组内贴图的方法

        Tween.removeTweens(this.shoes);
        Tween.removeTweens(this.line_L1);
        Tween.removeTweens(this.line_L2);
        Tween.removeTweens(this.line_R);
    }
}


