import { Panel } from "../../module/views/Panel";
import TextField = FYGE.TextField;
import Button = FYGE.Button;
import Sprite = FYGE.Sprite;
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import Texture = FYGE.Texture;
import MouseEvent = FYGE.MouseEvent;
import { sendTbNet, TbNetName } from "../TaoBaoNet";
import { showToast } from "../../module/ctrls";
import { Tool } from "../something/Tool";
import { Tools } from "../Tools";
import { RES } from "../../module/RES";

/**
 * 处理微信渠道中奖信息，皮肤和资源用的PrizePanel
 */
export class WxPrizePanel extends Panel {
    get groupNames() {
        return ["PrizePanel"]
    }

    get skinName() {
        return "PrizePanel"
    }

    protected get closeBtns(): any[] {
        return [this.closeBtn, this.prizeBtn]
    }

    closeBtn: Button;
    prizeTxt: TextField;
    prizeImg: Sprite;
    prizeBtn: Button;

    data: {
        "type": number,//6（锤子）7（炸弹）8（步数）9（体力）
        "name": string,
        "rewardNum": number
    }

    initUi() {
        this.prizeTxt.textAlign = TEXT_ALIGN.CENTER;
        this.prizeTxt.textWidth = 750;
        this.prizeTxt.x = 0;
        this.prizeTxt.text = `恭喜获得${this.data.name}`;

        this.prizeImg.anchorTexture.x = 0.5;
        this.prizeImg.width = this.prizeImg.height = 220;
        this.prizeImg.x = 375;
        this.prizeImg.texture = RES.getRes(
            (() => {
                var str = "aaaaaa.png"
                switch (this.data.type) {
                    case 6://锤子
                        str = "hammerBtn.png"
                        break;
                    case 7://炸弹
                        str = "boomBtn.png"
                        break;
                    case 8://步数
                        str = "stepBtn.png"
                        break;
                    case 9://体力
                        str = "powerImg.png"
                        break;
                }
                return str
            })()
        );

    }

    hidePanel() {
        super.hidePanel();
        showToast("领取成功")
    }
}
