import {Panel} from "../../module/views/Panel";
import {Tools} from "../Tools";
import {RES} from "../../module/RES";
import Button = FYGE.Button;
import MouseEvent = FYGE.MouseEvent;
import TEXT_ALIGN = FYGE.TEXT_ALIGN;

export class UseStep extends Panel {
    get groupNames() {
        return ["UseStep"]
    };

    initUi() {
        this.addChild(Tools.getSprite('useStepBg.png')).position.set(80, 486);

        this.addChild(Tools.getText(    /// TODO 道具加步数
            `确定要使用步数道具+${Tools.addSteps}步数吗？`, 36, '#ffffff',
            TEXT_ALIGN.CENTER, 750, 0, 650
        ));

        this.addChild(new Button(RES.getRes('useStepOk.png')))
            .addEventListener(MouseEvent.CLICK, () => {
                this.hidePanel();
                this.data.ok();
            }, this)
            .position.set(383, 835);

        this.addChild(new Button(RES.getRes('useStepCancel.png')))
            .addEventListener(MouseEvent.CLICK, () => {
                this.hidePanel();
                this.data.cancel();
            }, this)
            .position.set(102, 835);

        this.addChild(new Button(RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, () => {
                this.hidePanel();
                this.data.cancel();
            }, this)
            .position.set(629, 463);
    }

}
