import { Panel } from "../../module/views/Panel";
import { changeScene, showPanel, showToast } from "../../module/ctrls";
import { PlayScene } from "../scene/PlayScene";
import { Tools } from "../Tools";
import { sendTbNet, TbNetName } from "../TaoBaoNet";
import { NoEnergyPanel } from "./NoEnergyPanel";
import { ElementTargetData } from "../something/interface/ElementTargetData";
import { getChapterData } from "../something/chapters/getChapter";
import { RES } from "../../module/RES";
import MouseEvent = FYGE.MouseEvent;
import Tween = FYGE.Tween;
import Ease = FYGE.Ease;
import Sprite = FYGE.Sprite;
import Container = FYGE.Container;
import Button = FYGE.Button;
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import VERTICAL_ALIGN = FYGE.VERTICAL_ALIGN;

export class StartPanel extends Panel {
    get groupNames() {
        return ["StartPanel"]
    }

    public showAni() {
        if (this.isShowing) return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({scaleX: 0, scaleY: 0})
            .to({scaleX: 1, scaleY: 1}, 400, Ease.backOut)
            .call(() => {
                this.isShowing = false;
            });
    }

    initUi() {

        const { level } = this.data;

        this.addChild(Tools.getSprite('startBg.png')).position.set(80, 259);

        //第几关
        const chapterTex = Tools.getNumTextures("startNum");
        ["第", "关"].forEach(e => chapterTex[e] = RES.getRes(`startNum${e}.png`));
        const chapterTxt = this.addChild(new FYGE.BitmapText(chapterTex));
        chapterTxt.text = "第" + (level >> 0) + "关";
        chapterTxt.position.set(376, 476);

        this.addChild(new StartTarget(level)).position.set(0, 649);

        // this.addChild(Tools.getRect(595, 80)).position.set(79, 730);

        const tipTxt = level == Tools.maxLevel ? '通过此关即可获得抽取大奖的机会哦' : '通关即可抽取大奖\n分数越高几率越大哦';
        const tip = this.addChild(Tools.getText(
            tipTxt, 26, '#ffffff',
            TEXT_ALIGN.CENTER, 595, 79, 762
        ));
        tip.textHeight = 80;
        tip.lineSpacing = 10;
        tip.verticalAlign = VERTICAL_ALIGN.MIDDLE;

        const { prizeLevels, levelPrize } = Tools.gameData;

        let pLevel = prizeLevels[0];
        for (let i = 0; i < prizeLevels.length; i++) {
            if (level <= prizeLevels[i]) {
                pLevel = prizeLevels[i];
                break;
            }
        }

        const prizeImg = this.addChild(Sprite.fromUrl(levelPrize[`level${pLevel}`]));
        prizeImg.position.set(375, 940);
        prizeImg.anchorTexture.set(0.5, 0.5);

        this.addChild(new Button(RES.getRes("startBtn.png")))
            .addEventListener(MouseEvent.CLICK, this.startGame, this)
            .position.set(185, 1063);

        this.addChild(new Button(RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, this.hidePanel, this)
            .position.set(629, 469);
    }

    start(data) {
        super.start();
    }

    private startGame() {
        sendTbNet(TbNetName.addStats, { type: "CLICK_DOJOIN" }, () => 0, true);
        this.enableMouseEvt(false);
        if (Tools.gameData.power <= 0) {// 体力不足
            showPanel(NoEnergyPanel);
            this.enableMouseEvt(true);
            this.hidePanel();
            return;
        }
        sendTbNet(TbNetName.dojoin, { level: this.data.level },
            async (success, res) => {
                this.enableMouseEvt(true);
                if (!success) {
                    if (res.data && !res.data.isVip) {
                        showToast('请入会后参与');
                        setTimeout(() => {
                            sendTbNet(TbNetName.openMember);
                        }, 1500);
                    }
                    return;
                }

                // Tools.gameData.power = res.data.power;
                changeScene(PlayScene, { chapter: this.data.level });
                this.hidePanel();
            }
        );
    }
}


const pos = [
    [345],
    [295, 390],
    [250, 345, 430],
]

export class StartTarget extends Container {
    constructor(checkNum: number) {
        super();

        const passTarget = getChapterData(checkNum).passTarget;
        if (passTarget.type == 0) { // 分数

        } else if (passTarget.type == 1) {  // 消除元素个数
            passTarget.elements.forEach((v, i) => {
                const targetItem = this.addChild(new StartTargetItem(v));
                targetItem.x = pos[passTarget.elements.length - 1][i];
                setTimeout(() => {
                    targetItem.playEffect();
                }, i * 200);
            });
        }

    }
}

export class StartTargetItem extends Container {

    constructor(data: ElementTargetData) {
        super();

        let targetKey = 'ele';
        if ([0, 1, 2, 3, 4].indexOf(+data.type) > -1) {
            targetKey = 'target';
        }
        const targetImg = this.addChild(Tools.getSprite(`${targetKey}${data.type}.png`));
        targetImg.width = targetImg.height = 65;

        const countNum = new FYGE.BitmapText(Tools.getNumTextures("tarNum"));//文字待定
        countNum.position.set(65, 52);
        countNum.text = data.count + "";
        this.addChild(countNum);

        this.anchor.set(50, 79);
        this.scale.set(0, 0);

    }

    // 变大的动效
    public playEffect() {
        Tween.get(this)
            .set({scaleX: 0, scaleY: 0})
            .to({scaleX: 1, scaleY: 1}, 500, Ease.backOut);
    }
}

