import { Panel } from "../../module/views/Panel";
import { Tools } from "../Tools";
import { RES } from "../../module/RES";
import TextField = FYGE.TextField;
import TEXT_lINETYPE = FYGE.TEXT_lINETYPE;
import ScrollPage = FYGE.ScrollPage;
import Button = FYGE.Button;
import MouseEvent = FYGE.MouseEvent;

export class RulePanel extends Panel {
    get groupNames() {
        return ["RulePanel"]
    }

    get skinName() {
        return "RulePanel"
    }

    closeBtn: FYGE.Button;
    ruleTex: TextField;
    scroll: ScrollPage;

    initUi() {

    }

    start(data) {
        super.start();

        const rule = Tools.gameData.rule;
        this.ruleTex = this.addChild(Tools.getText(
            rule, 26, '#fffeef',
            FYGE.TEXT_ALIGN.LEFT, 530
        ));
        this.ruleTex.lineType = TEXT_lINETYPE.MULTI;

        this.scroll = this.addChild(new ScrollPage(
            570, 590, this.ruleTex.textHeight + 30
        ));
        this.scroll.position.set(119, 445);
        this.scroll.view.addChild(this.ruleTex);

        this.addChild(new Button(RES.getRes('ruleBtn.png')))
            .addEventListener(MouseEvent.CLICK, () => this.hidePanel())
            .position.set(185, 1063);

    }

    initEvents() {
        super.initEvents();
    }

    removeEvents() {
        super.removeEvents();
    }
}
