import { Panel } from "../../module/views/Panel";
import { Tools } from "../Tools";
import { getCurrentScene } from "../../module/ctrls";
import { RES } from "../../module/RES";
import Button = FYGE.Button;
import TextField = FYGE.TextField;

export class NoStepPanel extends Panel {
	get groupNames() {
		return ["NoStepPanel"]
	}

	okBtn: Button;
	cancelBtn: Button;
	closeBtn: Button;
	tipsTex: TextField;

	data: {
		reviveFun: () => void
	}

	initUi() {
		this.addChild(Tools.getSprite('noStepBg.png')).position.set(80, 274);
		this.okBtn = this.addChild(new Button(RES.getRes('noStepOk.png')));
		this.okBtn.position.set(383, 915);

		this.cancelBtn = this.addChild(new Button(RES.getRes('noStepCancel.png')));
		this.cancelBtn.position.set(102, 915);

		this.addChild(Tools.getText(
			`是否使用步数道具\n增加${Tools.addSteps}次步数？`, 36, "#ffffff",
			FYGE.TEXT_ALIGN.CENTER, 750, 0, 650
		));

		this.closeBtn = this.addChild(new Button(RES.getRes('关闭按钮.png')));
		this.closeBtn.position.set(629, 469);
	}
	initEvents() {
		//结束
		[this.closeBtn, this.cancelBtn].forEach((e) => {
			e.addEventListener(FYGE.MouseEvent.CLICK, () => {
				getCurrentScene().submit(false);
				this.hidePanel();
			}, this)
		})
		//复活
		this.okBtn.addEventListener(FYGE.MouseEvent.CLICK, () => {
			//无步数道具，弹出积分兑换
			if (!Tools.gameData.tools.steps) {
			} else {
				this.data.reviveFun();
				this.hidePanel();
			}
		}, this)
	}
	removeEvents() {

	}
}
