import { Panel } from "../../module/views/Panel";
import { RES } from "../../module/RES";
import { Tools } from "../Tools";
import { sendTbNet, TbNetName } from "../TaoBaoNet";
import { showToast } from "../../module/ctrls";
import Button = FYGE.Button;
import MouseEvent = FYGE.MouseEvent;

export class HelpPanel extends Panel {
    get groupNames() {
        return ["HelpPanel"]
    }

    vip: false;

    async initUi() {
        this.vip = await this.queryVip();
    }

    start(data) {
        super.start();

        this.addChild(Tools.getSprite('helpBg.png')).position.set(80, 549);

        this.addChild(new Button(RES.getRes('helpBtn.png')))
            .addEventListener(MouseEvent.CLICK, this.doHelp, this)
            .position.set(185, 910);

        this.addChild(new Button(RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, () => this.hidePanel())
            .position.set(629, 520);
    }

    hidePanel() {
        super.hidePanel();
        Tools.globalData.inviteId = '';
    }

    async doHelp(e) {
        this.btnDelay(e.target);
        if (Tools.globalData.inviteId == Tools.globalData.openId) {
            showToast('自己不能给自己助力');
            this.hidePanel();
            return;
        }

        if (this.vip) {
            this.hidePanel();
            return;
        }

        if (await this.queryVip()) {
            sendTbNet(TbNetName.doHelp, { inviteId: Tools.globalData.inviteId },
                (success, res) => {
                    if (!success) { // 失败唤起入会插件
                        showToast(res.message);
                        this.hidePanel();
                        return;
                    }
                    showToast('接受邀请成功');
                    this.hidePanel();
                });
        } else {
            showToast('请先加入会员');
            setTimeout(() => {
                sendTbNet(TbNetName.openMember);
            }, 1500);
        }
    }

    async queryVip() {
        const { success, data } = await sendTbNet(TbNetName.getVipInfo);
        return success && data.isVip;
    }

    initEvents() {
        super.initEvents();
    }

    removeEvents() {
        super.removeEvents();
    }
}
