import { Panel } from "../../module/views/Panel";
import { Tools } from "../Tools";
import { RES } from "../../module/RES";
import Button = FYGE.Button;
import MouseEvent = FYGE.MouseEvent;
import TEXT_ALIGN = FYGE.TEXT_ALIGN;

export class FreePowerPanel extends Panel {
	get groupNames() {
		return ["FreePowerPanel"]
	}


	protected initUi() {
		super.initUi();
		this.addChild(Tools.getSprite('freePowerBg.png')).position.set(80, 274);

		this.addChild(new Button(RES.getRes('freePowerBtn.png')))
			.addEventListener(MouseEvent.CLICK, this.hidePanel, this)
			.position.set(185, 943);

		this.addChild(Tools.getSprite('powerIcon.png')).position.set(280, 801);
		const powerTxt = this.addChild(Tools.getText(
			`+${this.data.loginAddPower}`, 48, "#ffffff",
			TEXT_ALIGN.LEFT,
		));
		powerTxt.position.set(400, 823);

		this.addChild(new Button(RES.getRes('关闭按钮.png')))
			.addEventListener(MouseEvent.CLICK, this.hidePanel, this)
			.position.set(629, 469);


	}

	hidePanel() {
		super.hidePanel();
		//显示倒计时
	}

}
