(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/Main.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./module/RES.ts":
/*!***********************!*\
  !*** ./module/RES.ts ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.RES = void 0;
var RES;
(function (RES) {
    var resData;
    var videoEntityHash = {};
    var soundHash = {};
    var groupsCompleteHash = {};
    var groupsPromiseHash = {};
    var singleResPromiseHash = {};
    function loadConfig(res) {
        resData = res;
        RES.resPath = res.path;
    }
    RES.loadConfig = loadConfig;
    function loadGroup(name) {
        if (groupsCompleteHash[name]) {
            return new Promise(function (resolve) {
                resolve();
            });
        }
        if (groupsPromiseHash[name]) {
            return groupsPromiseHash[name];
        }
        var arr = getGroupResByName(name);
        if (!arr || !arr.length) {
            groupsCompleteHash[name] = true;
            return new Promise(function (resolve) {
                resolve();
            });
        }
        var p = new Promise(function (resolve, reject) {
            loadResList(function (s) {
                delete groupsPromiseHash[name];
                if (s) {
                    groupsCompleteHash[name] = true;
                    resolve();
                }
                else {
                    reject();
                }
            }, arr);
        });
        groupsPromiseHash[name] = p;
        return p;
    }
    RES.loadGroup = loadGroup;
    function getResAsync(str, comFun, thisObj) {
        var type = str.substring(str.lastIndexOf(".") + 1, str.length);
        if (type == "png" || type == "jpg") {
            if (FYGE.TextureCache[str]) {
                comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                new Promise(function (r) {
                    r(FYGE.TextureCache[str]);
                });
            }
            else if (singleResPromiseHash[str]) {
                return returnSingleResPromise(str, comFun, thisObj);
            }
            else {
                var groupName = hasRes(str);
                if (groupName && type != "jpg") {
                    var group = getGroupByName(groupName);
                    if (group && group.atlas) {
                        var json = groupName + ".json";
                        if (singleResPromiseHash[json]) {
                            return singleResPromiseHash[json].then(function (r) {
                                comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                                return FYGE.TextureCache[str];
                            }, function () {
                                comFun && comFun.call(thisObj, null, str);
                                return null;
                            });
                        }
                        else {
                            return getResAsync(json)
                                .then(function () {
                                comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                                return FYGE.TextureCache[str];
                            }, function () {
                                comFun && comFun.call(thisObj, null, str);
                                return null;
                            });
                        }
                    }
                }
                var src = groupName ? RES.resPath + groupName + "/" + str : str;
                var p = new Promise(function (resolve, reject) {
                    FYGE.GlobalLoader.loadImage(function (s, image) {
                        delete singleResPromiseHash[str];
                        if (s) {
                            FYGE.Texture.addToCache(FYGE.Texture.from(image), str);
                            comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                            resolve(FYGE.TextureCache[str]);
                        }
                        else {
                            comFun && comFun.call(thisObj, null, str);
                            reject();
                        }
                    }, src);
                });
                singleResPromiseHash[str] = p;
                return p;
            }
        }
        else if (type == "svga") {
            if (videoEntityHash[str]) {
                comFun && comFun.call(thisObj, videoEntityHash[str], str);
                return new Promise(function (r) {
                    r(videoEntityHash[str]);
                });
            }
            else if (singleResPromiseHash[str]) {
                return returnSingleResPromise(str, comFun, thisObj);
            }
            else {
                var groupName = hasRes(str);
                var src = groupName ? RES.resPath + groupName + "/" + str : str;
                var p = new Promise(function (resolve, reject) {
                    FYGE.GlobalLoader.loadSvga(function (s, v) {
                        delete singleResPromiseHash[str];
                        if (s) {
                            if (s)
                                videoEntityHash[str] = v;
                            comFun && comFun.call(thisObj, v, str);
                            resolve(v);
                        }
                        else {
                            comFun && comFun.call(thisObj, null, str);
                            reject();
                        }
                    }, src);
                });
                singleResPromiseHash[str] = p;
                return p;
            }
        }
        else if (type == "json") {
            if (singleResPromiseHash[str]) {
                return returnSingleResPromise(str, comFun, thisObj);
            }
            else {
                var groupName = hasRes(str);
                var src = groupName ? RES.resPath + groupName + "/" + str : str;
                var p = new Promise(function (resolve, reject) {
                    var jsonData = getGroupByName(groupName).atlas;
                    FYGE.GlobalLoader.loadImage(function (s, data) {
                        if (s) {
                            var t = FYGE.createTextureSheet(new FYGE.BaseTexture(data), jsonData);
                            comFun && comFun.call(thisObj, t, str);
                            resolve(t);
                        }
                        else {
                            delete singleResPromiseHash[str];
                            comFun && comFun.call(thisObj, null, str);
                            reject();
                        }
                    }, src.replace("json", "png"));
                });
                singleResPromiseHash[str] = p;
                return p;
            }
        }
    }
    RES.getResAsync = getResAsync;
    function getResByUrl() {
    }
    RES.getResByUrl = getResByUrl;
    function getRes(str) {
        var type = str.substring(str.lastIndexOf(".") + 1, str.length);
        if (type == "png" || type == "jpg") {
            return FYGE.TextureCache[str] || null;
        }
        else if (type == "svga") {
            return videoEntityHash[str] || null;
        }
        else if (type == "mp3") {
            return soundHash[str] || null;
        }
    }
    RES.getRes = getRes;
    function hasRes(str) {
        for (var i = 0; i < resData.groups.length; i++) {
            var group = resData.groups[i];
            var keys = group.keys;
            if (keys && keys.split(",").indexOf(str) > -1) {
                return group.name;
            }
            if (group.atlas && group.name + ".json" == str) {
                return group.name;
            }
        }
        return null;
    }
    function getGroupResByName(name) {
        var group = getGroupByName(name);
        if (!group)
            return null;
        if (group.atlas) {
            var arr = [name + ".json"];
            if (group.keys) {
                arr = arr.concat(group.keys.split(",").filter(function (k) {
                    return k.substr(-4) != ".png";
                }));
            }
            return arr;
        }
        else if (group.keys) {
            return group.keys.split(",");
        }
        else {
            return null;
        }
    }
    function getGroupByName(name) {
        var groups = resData.groups;
        var group;
        for (var i = 0; i < groups.length; i++) {
            if (groups[i].name === name) {
                group = groups[i];
                break;
            }
        }
        return group;
    }
    function loadResList(callback, arr) {
        var count = 0;
        var countAll = arr.length;
        if (!countAll)
            callback(true);
        var mark = true;
        for (var i = 0; i < countAll; i++) {
            var resName = arr[i];
            getResAsync(resName, function (res, str) {
                if (!res)
                    mark = false;
                if (++count == countAll)
                    callback(mark);
            }, this);
        }
    }
    function returnSingleResPromise(str, comFun, thisObj) {
        singleResPromiseHash[str].then(function (r) {
            comFun && comFun.call(thisObj, r, str);
        }, function () {
            comFun && comFun.call(thisObj, null, str);
        });
        return singleResPromiseHash[str];
    }
    var skinData;
    function loadSkinConfig(skinJson) {
        skinData = skinJson;
    }
    RES.loadSkinConfig = loadSkinConfig;
    function initSkinDisplay(con, skin, root) {
        var data = typeof (skin) == 'string' ? getSkinDataByName(skin) : skin;
        if (!data.children || !data.children.length)
            return;
        for (var i = 0; i < data.children.length; i++) {
            var child = data.children[i];
            if (child.type == "skin")
                continue;
            var dis = con.addChild(getDisplayByData(child));
            if (root && child.id)
                root[child.id] = dis;
            if (child.type == "container")
                initSkinDisplay(dis, child, root);
        }
    }
    RES.initSkinDisplay = initSkinDisplay;
    function getSkinDataByName(skinName, skinNode) {
        if (skinNode === void 0) { skinNode = skinData; }
        if (!skinNode || !skinNode.children || !skinNode.children.length)
            return null;
        for (var i = 0; i < skinNode.children.length; i++) {
            var child = skinNode.children[i];
            if (child.name == skinName && (child.type == "container" || child.type == "skin"))
                return child;
            var gson = getSkinDataByName(skinName, child);
            if (gson)
                return gson;
        }
        return null;
    }
    RES.getSkinDataByName = getSkinDataByName;
    function getDisplayByData(data) {
        var dis;
        switch (data.type) {
            case "container":
                dis = new FYGE.Container();
                break;
            case "button":
                dis = new FYGE.Button(getRes(data.props.tUp), data.props.tDown ? getRes(data.props.tDown) : null, data.props.tDisable ? getRes(data.props.tDisable) : null);
                break;
            case "text":
                dis = new FYGE.TextField();
                for (var key in data.props)
                    dis[key] = data.props[key];
                break;
            case "sprite":
                dis = new FYGE.Sprite(getRes(data.props.source));
                break;
            case "rect":
                dis = new FYGE.Shape();
                dis.beginFill(FYGE.string2hex(data.props.fillColor));
                dis.drawRect(0, 0, data.props.width, data.props.height);
                dis.endFill();
                break;
        }
        dis.name = data.name;
        dis.alpha = data.alpha || 1;
        dis.position.set(data.x, data.y);
        return dis;
    }
    function destroyRES() {
    }
})(RES = exports.RES || (exports.RES = {}));


/***/ }),

/***/ "./module/ctrls/index.ts":
/*!*******************************!*\
  !*** ./module/ctrls/index.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.destroyAllCtrls = exports.removeTweens = exports.clearWait = exports.wait = exports.showAlert = exports.getCurrentScene = exports.changeScene = exports.closeCurrentPanel = exports.closeAllPanels = exports.showConfirm = exports.showPanel = exports.showToast = void 0;
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var panelCtrl_1 = __webpack_require__(/*! ./panelCtrl */ "./module/ctrls/panelCtrl.ts");
var sceneCtrl_1 = __webpack_require__(/*! ./sceneCtrl */ "./module/ctrls/sceneCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var toastCtrl_2 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
Object.defineProperty(exports, "showToast", { enumerable: true, get: function () { return toastCtrl_2.showToast; } });
__exportStar(__webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts"), exports);
var showPanel = function (panel, data) {
    return panelCtrl_1.default.instance.show(panel, data);
};
exports.showPanel = showPanel;
var showConfirm = function (panel, data) {
    var confirmPanel = panelCtrl_1.default.instance.show(panel, data);
    return confirmPanel.makePromise();
};
exports.showConfirm = showConfirm;
var closeAllPanels = function () {
    panelCtrl_1.default.instance.closeAll();
};
exports.closeAllPanels = closeAllPanels;
var closeCurrentPanel = function () {
    panelCtrl_1.default.instance.closeCurrent();
};
exports.closeCurrentPanel = closeCurrentPanel;
var changeScene = function (scene, data) {
    sceneCtrl_1.default.instance.change(scene, data);
};
exports.changeScene = changeScene;
function getCurrentScene() {
    return sceneCtrl_1.default.instance.currentScene;
}
exports.getCurrentScene = getCurrentScene;
var showAlert = function (title, content) {
    if (my) {
        my.alert({
            title: title || "",
            content: content || ""
        });
    }
    else {
        console.log(title, content);
    }
};
exports.showAlert = showAlert;
function wait(callback, time) {
    var obj = {};
    FYGE.Tween.get(obj)
        .wait(time)
        .call(callback);
    return obj;
}
exports.wait = wait;
function clearWait(obj) {
    obj && FYGE.Tween.removeTweens(obj);
}
exports.clearWait = clearWait;
function removeTweens(obj, isRecursive) {
    if (isRecursive === void 0) { isRecursive = true; }
    if (!obj)
        return;
    FYGE.Tween.removeTweens(obj);
    if (!isRecursive || !obj.children || !obj.children.length)
        return;
    obj.children.forEach(function (child) {
        removeTweens(child);
    });
}
exports.removeTweens = removeTweens;
function destroyAllCtrls() {
    toastCtrl_1.destroyToast();
    waitingCtrl_1.destroyWaiting();
    panelCtrl_1.default.instance.destroy();
    sceneCtrl_1.default.instance.destroy();
}
exports.destroyAllCtrls = destroyAllCtrls;


/***/ }),

/***/ "./module/ctrls/panelCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/panelCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var PanelCtrl = (function () {
    function PanelCtrl() {
        this.stacks = [];
    }
    Object.defineProperty(PanelCtrl, "instance", {
        get: function () {
            return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl());
        },
        enumerable: false,
        configurable: true
    });
    PanelCtrl.prototype.init = function (parent) {
        this._parent = parent;
        var bg = new FYGE.Shape();
        bg.beginFill(0);
        bg.drawRect(layers_1.layers.stageOffsetX - parent.x, layers_1.layers.stageOffsetY - parent.y, layers_1.layers.stageWidth, layers_1.layers.stageHeight);
        bg.endFill();
        bg.hitTestByPixel = false;
        bg.visible = false;
        this._parent.addChild(bg);
        this._bg = bg;
    };
    PanelCtrl.prototype.closeAll = function () {
        this.stacks.forEach(function (e) { return e.hidePanel(); });
    };
    PanelCtrl.prototype.show = function (cls, data) {
        var _this = this;
        waitingCtrl_1.showWaiting();
        var panel = new cls(data);
        this.add(panel);
        this.stacks.push(panel);
        panel.onLoaded = function () {
            waitingCtrl_1.hideWaiting();
            _this.updateView(false);
            panel.start(data);
            if (panel.visible)
                panel.showAni();
        };
        panel.onLoadError = function () {
            waitingCtrl_1.hideWaiting();
            toastCtrl_1.showToast("资源加载失败");
            panel.removeEventListener('onDestroy', _this.onPanelHide, _this);
            _this.remove(panel);
        };
        return panel;
    };
    PanelCtrl.prototype.updateView = function (showPanelAni) {
        var _this = this;
        if (showPanelAni === void 0) { showPanelAni = true; }
        if (!this.stacks.length) {
            if (this._bg.visible) {
                this.bgAni = "hide";
                FYGE.Tween.removeTweens(this._bg);
                FYGE.Tween.get(this._bg)
                    .to({ alpha: 0 }, 200, FYGE.Ease.cubicOut)
                    .call(function () {
                    _this._bg.visible = false;
                    _this._current = null;
                    _this._parent.visible = false;
                });
            }
        }
        else {
            this._parent.visible = true;
            if (this.bgAni == "hide") {
                this.bgAni = "show";
                FYGE.Tween.removeTweens(this._bg);
                this._bg.alpha = 0.7;
            }
            if (this._bg.visible === false) {
                this._bg.visible = true;
                this._bg.alpha = 0;
                FYGE.Tween.get(this._bg).to({ alpha: 0.7 }, 200, FYGE.Ease.cubicOut);
            }
        }
        for (var i = 0; i < this.stacks.length; i++) {
            if (i < this.stacks.length - 1) {
                this.stacks[i].visible = false;
            }
            else {
                this.stacks[i].visible = true;
                if (showPanelAni)
                    this.stacks[i].showAni();
                this._current = this.stacks[i];
            }
        }
    };
    PanelCtrl.prototype.add = function (panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    };
    PanelCtrl.prototype.remove = function (panel) {
        this._parent.removeChild(panel);
        this.stacks = this.stacks.filter(function (e) { return e != panel; });
    };
    PanelCtrl.prototype.onPanelHide = function (e) {
        var panel = e.target;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        this.updateView();
    };
    PanelCtrl.prototype.closeCurrent = function () {
        if (this._current) {
            this._current.hidePanel();
        }
    };
    PanelCtrl.prototype.destroy = function () {
        PanelCtrl._instance = null;
        this.stacks = null;
        this._current = null;
        this._parent = null;
        FYGE.Tween.removeTweens(this._bg);
        this._bg = null;
    };
    return PanelCtrl;
}());
exports.default = PanelCtrl;


/***/ }),

/***/ "./module/ctrls/sceneCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/sceneCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var SceneCtrl = (function () {
    function SceneCtrl() {
    }
    Object.defineProperty(SceneCtrl, "instance", {
        get: function () {
            return SceneCtrl._instance || (SceneCtrl._instance = new SceneCtrl());
        },
        enumerable: false,
        configurable: true
    });
    SceneCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    SceneCtrl.prototype.change = function (cls, data) {
        var _this = this;
        var scene = new cls(data);
        scene.visible = false;
        waitingCtrl_1.showWaiting();
        var preScene = this._currentScene;
        scene.onLoaded = function () {
            waitingCtrl_1.hideWaiting();
            scene.showAni(function () {
                if (preScene)
                    preScene.destroy();
            });
            scene.visible = true;
            scene.start(data);
        };
        scene.onLoadError = function () {
            waitingCtrl_1.hideWaiting();
            toastCtrl_1.showToast("资源加载失败");
            _this._currentScene = preScene || null;
            _this._parent.removeChild(scene);
        };
        this._currentScene = scene;
        this._parent.addChild(scene);
    };
    Object.defineProperty(SceneCtrl.prototype, "currentScene", {
        get: function () {
            return this._currentScene;
        },
        enumerable: false,
        configurable: true
    });
    SceneCtrl.prototype.destroy = function () {
        SceneCtrl._instance = null;
        this._currentScene = null;
        this._parent = null;
    };
    return SceneCtrl;
}());
exports.default = SceneCtrl;


/***/ }),

/***/ "./module/ctrls/toastCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/toastCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.destroyToast = exports.showToast = void 0;
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var inited = false;
var _toast;
var _parent;
var startY;
var endY;
var initToast = function () {
    if (!inited) {
        inited = true;
        _toast = new Toast();
        _parent = layers_1.layers.toastLayer;
        _toast.alpha = 0;
        _toast.x = layers_1.layers.stageOffsetX - _parent.x + (layers_1.layers.stageWidth - _toast.width) / 2;
        var h = _toast.height;
        var y = layers_1.layers.stageOffsetY - _parent.y;
        startY = y - h;
        endY = y + (layers_1.layers.stageHeight - h) / 2;
    }
};
var showToast = function (msg) {
    initToast();
    _toast.show(msg);
    _parent.addChild(_toast);
    FYGE.Tween.removeTweens(_toast);
    FYGE.Tween.get(_toast)
        .set({ y: startY, alpha: 1 })
        .to({ y: endY }, 500, FYGE.Ease.quartOut)
        .wait(800)
        .to({ alpha: 0 }, 300)
        .call(function () {
        _parent.removeChild(_toast);
    });
};
exports.showToast = showToast;
var destroyToast = function () {
    if (inited && _toast && !_toast.destroyed) {
        _toast.destroy();
        _toast = null;
        _parent = null;
        inited = false;
    }
};
exports.destroyToast = destroyToast;
var Toast = (function (_super) {
    __extends(Toast, _super);
    function Toast() {
        var _this = _super.call(this) || this;
        _this.PADDING = 40;
        _this.mouseChildren = false;
        _this.mouseEnable = false;
        var toastBgTexture = RES_1.RES.getRes("toastBg.png");
        _this.bg = new FYGE.Sprite(toastBgTexture);
        _this.addChild(_this.bg);
        _this.msg = new FYGE.TextField();
        _this.msg.size = 28;
        _this.msg.fillColor = "0xffffff";
        _this.msg.text = "";
        _this.msg.verticalAlign = FYGE.VERTICAL_ALIGN.MIDDLE;
        _this.msg.textHeight = toastBgTexture.height;
        _this.msg.textAlign = FYGE.TEXT_ALIGN.CENTER;
        _this.addChild(_this.msg);
        return _this;
    }
    Toast.prototype.show = function (msg) {
        this.msg.text = msg;
        this.msg.x = (this.bg.width - this.msg.textWidth) / 2;
    };
    Toast.prototype.destroy = function () {
        FYGE.Tween.removeTweens(this);
        _super.prototype.destroy.call(this);
        this.msg = null;
        this.bg = null;
    };
    return Toast;
}(FYGE.Container));


/***/ }),

/***/ "./module/ctrls/waitingCtrl.ts":
/*!*************************************!*\
  !*** ./module/ctrls/waitingCtrl.ts ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.destroyWaiting = exports.hideWaiting = exports.showWaiting = void 0;
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var inited = false;
var _waiting;
var _parent;
var initWaiting = function () {
    if (!inited) {
        inited = true;
        var waiting = new Waiting();
        _parent = layers_1.layers.topLayer;
        _waiting = waiting;
        var offX = (layers_1.layers.stageWidth - 160) / 2;
        var offY = (layers_1.layers.stageHeight - _waiting.height) / 2;
        _waiting.x = layers_1.layers.stageOffsetX - _parent.x + offX;
        _waiting.y = layers_1.layers.stageOffsetY - _parent.y + offY;
        var bg = new FYGE.Graphics()
            .beginFill(0x000000)
            .drawRect(-offX, -offY, layers_1.layers.stageWidth, layers_1.layers.stageHeight)
            .endFill();
        bg.alpha = 0;
        _waiting.addChildAt(bg, 0);
    }
};
var showWaiting = function (msg) {
    initWaiting();
    _waiting.show(msg);
    _parent.addChild(_waiting);
};
exports.showWaiting = showWaiting;
var hideWaiting = function () {
    _parent.removeChild(_waiting);
};
exports.hideWaiting = hideWaiting;
var destroyWaiting = function () {
    if (inited && _waiting && !_waiting.destroyed) {
        _waiting.destroy();
        _waiting = null;
        _parent = null;
        inited = false;
    }
};
exports.destroyWaiting = destroyWaiting;
var Waiting = (function (_super) {
    __extends(Waiting, _super);
    function Waiting() {
        var _this = _super.call(this) || this;
        var rectBgTexture = RES_1.RES.getRes("waitingBg.png");
        var rectBg = new FYGE.Sprite(rectBgTexture);
        _this.addChild(rectBg);
        var rotTexture = RES_1.RES.getRes("waitingRot.png");
        var rot = new FYGE.Sprite(rotTexture);
        rot.x = (rectBgTexture.width - rotTexture.width) / 2;
        rot.y = 47;
        rot.anchorX = rotTexture.width / 2;
        rot.anchorY = rotTexture.height / 2;
        _this.addChild(rot);
        var count = 0;
        rot.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            count++;
            if (count % 30 == 0)
                rot.rotation += 45;
        }, _this);
        _this.msg = new FYGE.TextField();
        _this.msg.y = 125;
        _this.msg.textWidth = rectBgTexture.width;
        _this.msg.textAlign = FYGE.TEXT_ALIGN.CENTER;
        _this.msg.size = 26;
        _this.msg.fillColor = "#ffffff";
        _this.addChild(_this.msg);
        return _this;
    }
    Waiting.prototype.show = function (msg) {
        if (msg === void 0) { msg = "加载中"; }
        this.msg.text = msg;
    };
    Waiting.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.msg = null;
    };
    return Waiting;
}(FYGE.Container));


/***/ }),

/***/ "./module/tools/GTool.ts":
/*!*******************************!*\
  !*** ./module/tools/GTool.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.GTool = void 0;
var GTool = (function () {
    function GTool() {
    }
    GTool.changeURLArg = function (url, arg, arg_val) {
        var pattern = arg + '=([^&]*)';
        var replaceText = arg + '=' + arg_val;
        if (url.match(pattern)) {
            var tmp = '/(' + arg + '=)([^&]*)/gi';
            tmp = url.replace(new RegExp(tmp), replaceText);
            return tmp;
        }
        else {
            if (url.match('[\?]')) {
                return url + '&' + replaceText;
            }
            else {
                return url + '?' + replaceText;
            }
        }
    };
    GTool.readCache = function (key) {
        return my ? my.getStorageSync({ key: key }).data : localStorage.getItem(key);
    };
    GTool.writeCache = function (key, value) {
        if (value === void 0) { value = 'true'; }
        my ? my.setStorageSync({ key: key, data: value }) : localStorage.setItem(key, value);
    };
    GTool.returnTodayTimes = function (cacheKey) {
        var year1 = this.readCache("year" + cacheKey);
        var month1 = this.readCache("month" + cacheKey);
        var day1 = this.readCache("day" + cacheKey);
        var date = new Date();
        var year2 = date.getFullYear().toString();
        var month2 = date.getMonth().toString();
        var day2 = date.getDate().toString();
        if (this.int(year2) <= this.int(year1)) {
            if (this.int(month2) <= this.int(month1)) {
                if (this.int(day2) <= this.int(day1)) {
                    return this.int(this.readCache(cacheKey));
                }
            }
        }
        var today = "0";
        this.writeCache("year" + cacheKey, year2);
        this.writeCache("month" + cacheKey, month2);
        this.writeCache("day" + cacheKey, day2);
        this.writeCache(cacheKey, today);
        return 0;
    };
    GTool.randomT = function (e, n) {
        return e && "number" == typeof e.length && e.length ? e[Math.floor(Math.random() * e.length)] : ("number" != typeof n && (n = e || 1, e = 0), e + Math.random() * (n - e));
    };
    GTool.removeEle = function (e, arr) {
        var index = arr.indexOf(e);
        if (index >= 0) {
            arr.splice(index, 1);
        }
    };
    GTool.insert = function (num, arr) {
        for (var i = arr.length - 1; i >= 0; i--) {
            if (num > arr[i]) {
                arr.splice(i + 1, 0, num);
                break;
            }
        }
    };
    GTool.getRandomNumber = function (start, end, n) {
        var arr = [];
        for (var i = 0; i < n; i++) {
            var number = Math.floor(Math.random() * (end - start + 1) + start);
            if (arr.indexOf(number) < 0) {
                arr.push(number);
            }
            else {
                i--;
            }
        }
        return arr;
    };
    GTool.disturbNumberArr = function (arr) {
        arr.sort(function () {
            return (0.5 - Math.random());
        });
    };
    GTool.disturbArr = function (arr) {
        return arr.sort(function () {
            return (0.5 - Math.random());
        });
    };
    GTool.getRandomArrayElements = function (arr, count) {
        var shuffled = arr.slice(0), i = arr.length, min = i - count, temp, index;
        if (min <= 0)
            return shuffled;
        if (count <= 0)
            return [];
        while (i-- > min) {
            index = Math.floor((i + 1) * Math.random());
            temp = shuffled[index];
            shuffled[index] = shuffled[i];
            shuffled[i] = temp;
        }
        return shuffled.slice(min);
    };
    GTool.getRandomArrayElementsEx = function (arr, count) {
        if (arr.length <= count)
            return arr.slice();
        if (count <= 0)
            return [];
        var arrCopy = arr.slice();
        var outArr = [];
        while (count--) {
            var rand = Math.floor(Math.random() * arrCopy.length);
            var ele = arrCopy.splice(rand, 1)[0];
            outArr.push(ele);
        }
        return outArr;
    };
    GTool.int = function (n) {
        return n >> 0;
    };
    ;
    GTool.addSpaceInString = function (str) {
        if (!str.length || str.length == 1)
            return str;
        var txt = "";
        for (var i = 0; i < str.length - 1; i++) {
            txt = txt + str[i] + " ";
        }
        txt = txt + str[str.length - 1];
        return txt;
    };
    GTool.getShiFenMiaoByTimeStamp = function (timeStamp) {
        var hours = Math.floor((timeStamp % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        var minutes = Math.floor((timeStamp % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((timeStamp % (1000 * 60)) / 1000);
        hours = hours < 10 ? ('0' + hours) : hours;
        minutes = minutes < 10 ? ('0' + minutes) : minutes;
        seconds = seconds < 10 && seconds >= 1 ? ('0' + seconds) : seconds;
        return hours + "小时" + minutes + "分" + seconds + "秒";
    };
    GTool.emojiReg = /[\uD83C|\uD83D|\uD83E][\uDC00-\uDFFF][\u200D|\uFE0F]|[\uD83C|\uD83D|\uD83E][\uDC00-\uDFFF]|[0-9|*|#]\uFE0F\u20E3|[0-9|#]\u20E3|[\u203C-\u3299]\uFE0F\u200D|[\u203C-\u3299]\uFE0F|[\u2122-\u2B55]|\u303D|[\A9|\AE]\u3030|\uA9|\uAE|\u3030/ig;
    return GTool;
}());
exports.GTool = GTool;


/***/ }),

/***/ "./module/views/Module.ts":
/*!********************************!*\
  !*** ./module/views/Module.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Module = void 0;
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../ctrls */ "./module/ctrls/index.ts");
var Module = (function (_super) {
    __extends(Module, _super);
    function Module(data) {
        var _this = _super.call(this) || this;
        _this.data = data;
        _this.init();
        return _this;
    }
    Module.prototype.init = function () {
        var _this = this;
        this.preLoadRes().then(function () {
            if (_this.skinName)
                RES_1.RES.initSkinDisplay(_this, _this.skinName, _this);
            _this.initUi();
            _this.onLoaded && _this.onLoaded();
        }, function () {
            _this.onLoadError && _this.onLoadError();
        });
    };
    Module.prototype.preLoadRes = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (_this.groupNames && _this.groupNames.length) {
                var arr = [];
                for (var i = 0; i < _this.groupNames.length; i++) {
                    arr.push(RES_1.RES.loadGroup(_this.groupNames[i]));
                }
                Promise.all(arr).then(resolve, reject);
            }
            else {
                resolve(null);
            }
        });
    };
    Module.prototype.initUi = function () {
    };
    Object.defineProperty(Module.prototype, "groupNames", {
        get: function () { return null; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Module.prototype, "skinName", {
        get: function () { return null; },
        enumerable: false,
        configurable: true
    });
    ;
    Module.prototype.start = function (data) {
        this.initEvents();
    };
    Module.prototype.initEvents = function () {
    };
    Module.prototype.removeEvents = function () {
    };
    Module.prototype.enableMouseEvt = function (enable) {
        this.mouseEnable = enable;
        this.mouseChildren = enable;
    };
    Module.prototype.btnDelay = function (target, delay) {
        if (delay === void 0) { delay = 2000; }
        target.mouseEnable = false;
        target.mouseChildren = false;
        setTimeout(function () {
            target.mouseEnable = true;
            target.mouseChildren = true;
        }, delay);
    };
    Module.prototype.destroy = function () {
        ctrls_1.removeTweens(this);
        this.removeEvents();
        this.dispatchEvent("onDestroy");
        _super.prototype.destroy.call(this);
    };
    return Module;
}(FYGE.Container));
exports.Module = Module;


/***/ }),

/***/ "./module/views/Panel.ts":
/*!*******************************!*\
  !*** ./module/views/Panel.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Panel = void 0;
var Module_1 = __webpack_require__(/*! ./Module */ "./module/views/Module.ts");
var Panel = (function (_super) {
    __extends(Panel, _super);
    function Panel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Panel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        var oriY = this.y || 0;
        this.y = -200;
        FYGE.Tween.get(this)
            .to({ y: oriY }, 500, FYGE.Ease.quartOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    Panel.prototype.initEvents = function () {
        var _this = this;
        this.closeBtns.forEach(function (btn) {
            if (btn)
                btn.addEventListener(FYGE.MouseEvent.CLICK, _this.hidePanel, _this);
        });
    };
    Panel.prototype.removeEvents = function () {
        var _this = this;
        this.closeBtns.forEach(function (btn) {
            if (btn)
                btn.removeEventListener(FYGE.MouseEvent.CLICK, _this.hidePanel, _this);
        });
    };
    Object.defineProperty(Panel.prototype, "closeBtns", {
        get: function () {
            return [this['closeBtn']];
        },
        enumerable: false,
        configurable: true
    });
    Panel.prototype.hidePanel = function () {
        this.destroy();
    };
    return Panel;
}(Module_1.Module));
exports.Panel = Panel;


/***/ }),

/***/ "./module/views/Scene.ts":
/*!*******************************!*\
  !*** ./module/views/Scene.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Scene = void 0;
var Module_1 = __webpack_require__(/*! ./Module */ "./module/views/Module.ts");
var Scene = (function (_super) {
    __extends(Scene, _super);
    function Scene() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene.prototype.showAni = function (callback) {
        callback();
    };
    Scene.prototype.updateScene = function () {
    };
    return Scene;
}(Module_1.Module));
exports.Scene = Scene;


/***/ }),

/***/ "./module/views/layers.ts":
/*!********************************!*\
  !*** ./module/views/layers.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.destroyLayers = exports.layers = void 0;
var panelCtrl_1 = __webpack_require__(/*! ../ctrls/panelCtrl */ "./module/ctrls/panelCtrl.ts");
var sceneCtrl_1 = __webpack_require__(/*! ../ctrls/sceneCtrl */ "./module/ctrls/sceneCtrl.ts");
var Layers = (function (_super) {
    __extends(Layers, _super);
    function Layers() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Layers.prototype.init = function (stage) {
        stage.addChild(this);
        var arr = [
            "_bottomLayer",
            "_sceneLayer",
            "_popupLayer",
            "_toastLayer",
            "_topLayer",
            "_shareLayer"
        ];
        for (var i = 0; i < arr.length; i++) {
            this[arr[i]] = new FYGE.Container();
            this.addChild(this[arr[i]]);
        }
        this.sceneLayer.y = this.stageOffsetY;
        this.shareLayer.y = -this.stageOffsetY;
        sceneCtrl_1.default.instance.init(this.sceneLayer);
        panelCtrl_1.default.instance.init(this.popupLayer);
    };
    Object.defineProperty(Layers.prototype, "bottomLayer", {
        get: function () { return this._bottomLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "sceneLayer", {
        get: function () { return this._sceneLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "popupLayer", {
        get: function () { return this._popupLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "toastLayer", {
        get: function () { return this._toastLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "topLayer", {
        get: function () { return this._topLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "shareLayer", {
        get: function () { return this._shareLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageHeight", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.height;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageWidth", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.width;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageOffsetX", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.x;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageOffsetY", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.y;
        },
        enumerable: false,
        configurable: true
    });
    return Layers;
}(FYGE.Container));
exports.layers = new Layers();
function destroyLayers() {
    exports.layers.removeChildren();
    if (exports.layers.parent)
        exports.layers.parent.removeChild(exports.layers);
}
exports.destroyLayers = destroyLayers;


/***/ }),

/***/ "./src/Main.ts":
/*!*********************!*\
  !*** ./src/Main.ts ***!
  \*********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Main = exports.GDispatcher = void 0;
var layers_1 = __webpack_require__(/*! ../module/views/layers */ "./module/views/layers.ts");
var RES_1 = __webpack_require__(/*! ../module/RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var ResJson_1 = __webpack_require__(/*! ./ResJson */ "./src/ResJson.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ./TaoBaoNet */ "./src/TaoBaoNet.ts");
var SkinJson_1 = __webpack_require__(/*! ./SkinJson */ "./src/SkinJson.ts");
var G_EVENT_1 = __webpack_require__(/*! ./common/G_EVENT */ "./src/common/G_EVENT.ts");
var LoadingScene_1 = __webpack_require__(/*! ./scene/LoadingScene */ "./src/scene/LoadingScene.ts");
exports.GDispatcher = new FYGE.EventDispatcher();
var Main = (function () {
    function Main(canvas) {
        var sysInfo;
        if (my) {
            FYGE.initedByCanvas(canvas);
            sysInfo = my.getSystemInfoSync();
        }
        var stage = new FYGE.Stage(canvas, 750, 1624, sysInfo && sysInfo.windowWidth || document.body.clientWidth, sysInfo && sysInfo.windowHeight || document.body.clientHeight, FYGE.RENDERER_TYPE.CANVAS, true);
        this.stage = stage;
        this.canvas = canvas;
        stage.addEventListener(FYGE.Event.INIT_STAGE, this.onAddToStage, this);
        var self = this;
        loop();
        function loop() {
            if (!self._pause) {
                FYGE.Tween.flush();
                stage.flush();
            }
            my ? self.requestID = canvas.requestAnimationFrame(loop) :
                self.requestID = window.requestAnimationFrame(loop);
        }
    }
    Main.prototype.onAddToStage = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        layers_1.layers.init(this.stage);
                        console.log("初始化层级完成");
                        RES_1.RES.loadConfig(ResJson_1.ResJson);
                        console.log("初始化资源配置完成");
                        RES_1.RES.loadSkinConfig(SkinJson_1.SkinJson);
                        return [4, RES_1.RES.loadGroup("common")];
                    case 1:
                        _a.sent();
                        console.log("通用资源加载完成");
                        ctrls_1.changeScene(LoadingScene_1.LoadingScene);
                        return [2];
                }
            });
        });
    };
    Main.prototype.run = function () {
        this._pause = false;
        FYGE.Tween._lastTime = null;
        exports.GDispatcher.dispatchEvent({ type: G_EVENT_1.G_EVENT.ON_SHOW });
    };
    Main.prototype.pause = function () {
        exports.GDispatcher.dispatchEvent({ type: G_EVENT_1.G_EVENT.ON_HIDE });
    };
    Main.prototype.addGlobalEvent = function (name, fun, thisObj, once) {
        if (once === void 0) { once = false; }
        if (once) {
            exports.GDispatcher.once(name, fun, thisObj);
        }
        else {
            exports.GDispatcher.addEventListener(name, fun, thisObj);
        }
    };
    Main.prototype.dispatchGlobalEvent = function (name, data) {
        exports.GDispatcher.dispatchEvent(name, data);
    };
    Main.prototype.removeGlobalEvent = function (name, fun, thisObj) {
        exports.GDispatcher.removeEventListener(name, fun, thisObj);
    };
    Main.prototype.destroy = function () {
        FYGE.Tween.removeAllTweens();
        my ? this.canvas.cancelAnimationFrame(this.requestID) :
            window.cancelAnimationFrame(this.requestID);
        layers_1.destroyLayers();
        ctrls_1.destroyAllCtrls();
        this.stage.destroy();
        exports.GDispatcher.removeAllEventListener();
        TaoBaoNet_1.destroyNetData();
    };
    return Main;
}());
exports.Main = Main;
function createNineTextures(imageUrl) {
    return new Promise(function (resolve, reject) {
        var image = new Image();
        image.setAttribute("crossOrigin", "anonymous");
        image.onload = function () {
            var obj = {};
            var name = "lalala";
            var row = 4, col = 3;
            var w = image.width / col;
            var h = image.height / row;
            for (var i = 0; i < col * row; i++)
                obj[name + i] = {
                    "x": i % col * w,
                    "y": ~~(i / col) * h,
                    w: w, h: h,
                    sw: w, sh: h, ox: 0, oy: 0, ro: false
                };
            FYGE.createTextureSheet(new FYGE.BaseTexture(image), obj);
            var arr = [];
            for (var i = 0; i < col * row; i++)
                arr.push(FYGE.TextureCache[name + i]);
            resolve(arr);
        };
        image.onerror = function (err) {
            reject(err);
        };
        image.src = imageUrl;
    });
}


/***/ }),

/***/ "./src/ResJson.ts":
/*!************************!*\
  !*** ./src/ResJson.ts ***!
  \************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ResJson = void 0;
exports.ResJson = {
    "groups": [
        {
            "keys": "18986110-634a-4248-a956-b2861424ff16.png,24131c00-9062-43a1-b52d-00d788f75b79.png,2d6cba7b-b5f7-42ef-81e9-bb15a5e6266b.png,2e5f1f43-9af3-4b9b-a8fc-db17964eecb6.png,52e8af6a-f83c-4c95-9f44-d5bb1c20493b.png,5d6129c5-6206-47d5-bb42-b9274ad37e9d.png,6e5ccdc9-ce62-4e1b-88ca-0e269f492ec1.png,778a9647-034e-4fad-8a79-d9226ae2ed5d.png,796267bf-092e-44c9-999b-574d305c8769.png,7d410e98-3af4-4bb8-98ac-acf1a8bd48fa.png,93ea4980-6258-4413-bbd7-3260e1117bb6.png,b9f72eac-22ea-4505-b043-24c8a83acd05.png",
            "name": "BonusTime",
            "atlas": {
                "18986110-634a-4248-a956-b2861424ff16.png": {
                    "x": 2,
                    "y": 2,
                    "w": 898,
                    "h": 839,
                    "ox": 0,
                    "oy": 0,
                    "sw": 898,
                    "sh": 839,
                    "ro": false
                },
                "52e8af6a-f83c-4c95-9f44-d5bb1c20493b.png": {
                    "x": 2,
                    "y": 843,
                    "w": 322,
                    "h": 266,
                    "ox": 0,
                    "oy": 0,
                    "sw": 322,
                    "sh": 266,
                    "ro": false
                },
                "24131c00-9062-43a1-b52d-00d788f75b79.png": {
                    "x": 326,
                    "y": 843,
                    "w": 292,
                    "h": 131,
                    "ox": 0,
                    "oy": 0,
                    "sw": 292,
                    "sh": 131,
                    "ro": false
                },
                "2d6cba7b-b5f7-42ef-81e9-bb15a5e6266b.png": {
                    "x": 326,
                    "y": 976,
                    "w": 247,
                    "h": 132,
                    "ox": 0,
                    "oy": 0,
                    "sw": 247,
                    "sh": 132,
                    "ro": false
                },
                "778a9647-034e-4fad-8a79-d9226ae2ed5d.png": {
                    "x": 620,
                    "y": 843,
                    "w": 176,
                    "h": 201,
                    "ox": 0,
                    "oy": 0,
                    "sw": 176,
                    "sh": 201,
                    "ro": false
                },
                "93ea4980-6258-4413-bbd7-3260e1117bb6.png": {
                    "x": 902,
                    "y": 2,
                    "w": 120,
                    "h": 104,
                    "ox": 0,
                    "oy": 0,
                    "sw": 120,
                    "sh": 104,
                    "ro": true
                },
                "b9f72eac-22ea-4505-b043-24c8a83acd05.png": {
                    "x": 575,
                    "y": 1046,
                    "w": 53,
                    "h": 57,
                    "ox": 0,
                    "oy": 0,
                    "sw": 53,
                    "sh": 57,
                    "ro": false
                },
                "7d410e98-3af4-4bb8-98ac-acf1a8bd48fa.png": {
                    "x": 575,
                    "y": 976,
                    "w": 25,
                    "h": 25,
                    "ox": 0,
                    "oy": 0,
                    "sw": 25,
                    "sh": 25,
                    "ro": false
                },
                "6e5ccdc9-ce62-4e1b-88ca-0e269f492ec1.png": {
                    "x": 575,
                    "y": 1003,
                    "w": 24,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 24,
                    "sh": 24,
                    "ro": false
                },
                "796267bf-092e-44c9-999b-574d305c8769.png": {
                    "x": 630,
                    "y": 1046,
                    "w": 22,
                    "h": 22,
                    "ox": 0,
                    "oy": 0,
                    "sw": 22,
                    "sh": 22,
                    "ro": false
                },
                "2e5f1f43-9af3-4b9b-a8fc-db17964eecb6.png": {
                    "x": 630,
                    "y": 1070,
                    "w": 21,
                    "h": 19,
                    "ox": 0,
                    "oy": 0,
                    "sw": 21,
                    "sh": 19,
                    "ro": true
                },
                "5d6129c5-6206-47d5-bb42-b9274ad37e9d.png": {
                    "x": 575,
                    "y": 1029,
                    "w": 6,
                    "h": 7,
                    "ox": 0,
                    "oy": 0,
                    "sw": 6,
                    "sh": 7,
                    "ro": false
                }
            }
        },
        {
            "keys": "failedBtn.png,failedTxt.png",
            "name": "FailedPanel",
            "atlas": {
                "failedTxt.png": {
                    "x": 2,
                    "y": 2,
                    "w": 595,
                    "h": 792,
                    "ox": 0,
                    "oy": 0,
                    "sw": 595,
                    "sh": 792,
                    "ro": false
                },
                "failedBtn.png": {
                    "x": 599,
                    "y": 2,
                    "w": 381,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 381,
                    "sh": 90,
                    "ro": true
                }
            }
        },
        {
            "keys": "freePowerBg.png,freePowerBtn.png",
            "name": "FreePowerPanel",
            "atlas": {
                "freePowerBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 595,
                    "h": 891,
                    "ox": 0,
                    "oy": 0,
                    "sw": 595,
                    "sh": 891,
                    "ro": false
                },
                "freePowerBtn.png": {
                    "x": 599,
                    "y": 2,
                    "w": 381,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 381,
                    "sh": 90,
                    "ro": true
                }
            }
        },
        {
            "keys": "helpBg.png,helpBtn.png",
            "name": "HelpPanel",
            "atlas": {
                "helpBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 595,
                    "h": 546,
                    "ox": 0,
                    "oy": 0,
                    "sw": 595,
                    "sh": 546,
                    "ro": false
                },
                "helpBtn.png": {
                    "x": 2,
                    "y": 550,
                    "w": 381,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 381,
                    "sh": 90,
                    "ro": false
                }
            }
        },
        {
            "keys": "体力不足.png,体力不足按钮.png",
            "name": "NoEnergyPanel",
            "atlas": {
                "体力不足.png": {
                    "x": 2,
                    "y": 2,
                    "w": 595,
                    "h": 509,
                    "ox": 0,
                    "oy": 0,
                    "sw": 595,
                    "sh": 509,
                    "ro": false
                },
                "体力不足按钮.png": {
                    "x": 2,
                    "y": 513,
                    "w": 381,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 381,
                    "sh": 90,
                    "ro": false
                }
            }
        },
        {
            "keys": "noPrizeBg.png,知道了.png",
            "name": "NoPrizePanel",
            "atlas": {
                "noPrizeBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 437,
                    "ox": 55,
                    "oy": 498,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "知道了.png": {
                    "x": 2,
                    "y": 441,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": false
                }
            }
        },
        {
            "keys": "noStepBg.png,noStepCancel.png,noStepOk.png",
            "name": "NoStepPanel",
            "atlas": {
                "noStepBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 595,
                    "h": 792,
                    "ox": 0,
                    "oy": 0,
                    "sw": 595,
                    "sh": 792,
                    "ro": false
                },
                "noStepCancel.png": {
                    "x": 599,
                    "y": 2,
                    "w": 264,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 264,
                    "sh": 90,
                    "ro": true
                },
                "noStepOk.png": {
                    "x": 599,
                    "y": 268,
                    "w": 264,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 264,
                    "sh": 90,
                    "ro": true
                }
            }
        },
        {
            "keys": "prizePanel.png,prizePanelBtn.png",
            "name": "PrizePanel",
            "atlas": {
                "prizePanel.png": {
                    "x": 2,
                    "y": 2,
                    "w": 640,
                    "h": 789,
                    "ox": 0,
                    "oy": 0,
                    "sw": 640,
                    "sh": 789,
                    "ro": false
                },
                "prizePanelBtn.png": {
                    "x": 644,
                    "y": 2,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": true
                }
            }
        },
        {
            "keys": "ruleBtn.png,活动规则背景.png",
            "name": "RulePanel",
            "atlas": {
                "活动规则背景.png": {
                    "x": 2,
                    "y": 2,
                    "w": 595,
                    "h": 898,
                    "ox": 0,
                    "oy": 0,
                    "sw": 595,
                    "sh": 898,
                    "ro": false
                },
                "ruleBtn.png": {
                    "x": 599,
                    "y": 2,
                    "w": 381,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 381,
                    "sh": 90,
                    "ro": true
                }
            }
        },
        {
            "keys": "startBg.png,startBtn.png,startNum0.png,startNum1.png,startNum2.png,startNum3.png,startNum4.png,startNum5.png,startNum6.png,startNum7.png,startNum8.png,startNum9.png,startNum关.png,startNum第.png",
            "name": "StartPanel",
            "atlas": {
                "startBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 595,
                    "h": 978,
                    "ox": 0,
                    "oy": 0,
                    "sw": 595,
                    "sh": 978,
                    "ro": false
                },
                "startBtn.png": {
                    "x": 599,
                    "y": 2,
                    "w": 381,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 381,
                    "sh": 90,
                    "ro": true
                },
                "startNum第.png": {
                    "x": 599,
                    "y": 385,
                    "w": 57,
                    "h": 59,
                    "ox": 0,
                    "oy": 0,
                    "sw": 57,
                    "sh": 59,
                    "ro": true
                },
                "startNum关.png": {
                    "x": 599,
                    "y": 444,
                    "w": 56,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 56,
                    "sh": 58,
                    "ro": true
                },
                "startNum0.png": {
                    "x": 599,
                    "y": 502,
                    "w": 35,
                    "h": 47,
                    "ox": 0,
                    "oy": 0,
                    "sw": 35,
                    "sh": 47,
                    "ro": true
                },
                "startNum3.png": {
                    "x": 648,
                    "y": 502,
                    "w": 33,
                    "h": 47,
                    "ox": 0,
                    "oy": 0,
                    "sw": 33,
                    "sh": 47,
                    "ro": false
                },
                "startNum5.png": {
                    "x": 599,
                    "y": 539,
                    "w": 33,
                    "h": 47,
                    "ox": 0,
                    "oy": 0,
                    "sw": 33,
                    "sh": 47,
                    "ro": true
                },
                "startNum6.png": {
                    "x": 648,
                    "y": 551,
                    "w": 35,
                    "h": 47,
                    "ox": 0,
                    "oy": 0,
                    "sw": 35,
                    "sh": 47,
                    "ro": false
                },
                "startNum8.png": {
                    "x": 599,
                    "y": 574,
                    "w": 36,
                    "h": 47,
                    "ox": 0,
                    "oy": 0,
                    "sw": 36,
                    "sh": 47,
                    "ro": true
                },
                "startNum9.png": {
                    "x": 648,
                    "y": 600,
                    "w": 35,
                    "h": 47,
                    "ox": 0,
                    "oy": 0,
                    "sw": 35,
                    "sh": 47,
                    "ro": false
                },
                "startNum1.png": {
                    "x": 599,
                    "y": 612,
                    "w": 25,
                    "h": 46,
                    "ox": 0,
                    "oy": 0,
                    "sw": 25,
                    "sh": 46,
                    "ro": true
                },
                "startNum2.png": {
                    "x": 599,
                    "y": 639,
                    "w": 34,
                    "h": 46,
                    "ox": 0,
                    "oy": 0,
                    "sw": 34,
                    "sh": 46,
                    "ro": true
                },
                "startNum4.png": {
                    "x": 647,
                    "y": 649,
                    "w": 37,
                    "h": 46,
                    "ox": 0,
                    "oy": 0,
                    "sw": 37,
                    "sh": 46,
                    "ro": false
                },
                "startNum7.png": {
                    "x": 599,
                    "y": 675,
                    "w": 33,
                    "h": 46,
                    "ox": 0,
                    "oy": 0,
                    "sw": 33,
                    "sh": 46,
                    "ro": true
                }
            }
        },
        {
            "keys": "star_dis.png,star_en.png,sucAgain.png,sucContinueL.png,sucContinueS.png,sucContinueSR.png,sucGet.png,sucGoPrize.png,successBgL.png,successBgS.png",
            "name": "SuccessPanel",
            "atlas": {
                "successBgL.png": {
                    "x": 2,
                    "y": 2,
                    "w": 595,
                    "h": 978,
                    "ox": 0,
                    "oy": 0,
                    "sw": 595,
                    "sh": 978,
                    "ro": false
                },
                "successBgS.png": {
                    "x": 599,
                    "y": 2,
                    "w": 595,
                    "h": 807,
                    "ox": 0,
                    "oy": 0,
                    "sw": 595,
                    "sh": 807,
                    "ro": false
                },
                "sucContinueL.png": {
                    "x": 599,
                    "y": 811,
                    "w": 381,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 381,
                    "sh": 90,
                    "ro": false
                },
                "sucGoPrize.png": {
                    "x": 2,
                    "y": 982,
                    "w": 381,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 381,
                    "sh": 90,
                    "ro": false
                },
                "sucAgain.png": {
                    "x": 385,
                    "y": 982,
                    "w": 264,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 264,
                    "sh": 90,
                    "ro": false
                },
                "sucContinueS.png": {
                    "x": 651,
                    "y": 903,
                    "w": 264,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 264,
                    "sh": 90,
                    "ro": false
                },
                "sucContinueSR.png": {
                    "x": 917,
                    "y": 903,
                    "w": 264,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 264,
                    "sh": 90,
                    "ro": false
                },
                "sucGet.png": {
                    "x": 2,
                    "y": 1074,
                    "w": 264,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 264,
                    "sh": 90,
                    "ro": false
                },
                "star_dis.png": {
                    "x": 651,
                    "y": 995,
                    "w": 103,
                    "h": 95,
                    "ox": 0,
                    "oy": 0,
                    "sw": 103,
                    "sh": 95,
                    "ro": true
                },
                "star_en.png": {
                    "x": 748,
                    "y": 995,
                    "w": 103,
                    "h": 99,
                    "ox": 0,
                    "oy": 0,
                    "sw": 103,
                    "sh": 99,
                    "ro": true
                }
            }
        },
        {
            "keys": "任务背景.png,去完成.png,去完成灰.png,待领取.png",
            "name": "TaskPanel",
            "atlas": {
                "任务背景.png": {
                    "x": 2,
                    "y": 2,
                    "w": 750,
                    "h": 1046,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 1046,
                    "ro": false
                },
                "去完成.png": {
                    "x": 754,
                    "y": 2,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": true
                },
                "去完成灰.png": {
                    "x": 754,
                    "y": 187,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": true
                },
                "待领取.png": {
                    "x": 754,
                    "y": 372,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": true
                }
            }
        },
        {
            "keys": "useStepBg.png,useStepCancel.png,useStepOk.png",
            "name": "UseStep",
            "atlas": {
                "useStepBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 595,
                    "h": 509,
                    "ox": 0,
                    "oy": 0,
                    "sw": 595,
                    "sh": 509,
                    "ro": false
                },
                "useStepCancel.png": {
                    "x": 2,
                    "y": 513,
                    "w": 264,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 264,
                    "sh": 90,
                    "ro": false
                },
                "useStepOk.png": {
                    "x": 268,
                    "y": 513,
                    "w": 264,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 264,
                    "sh": 90,
                    "ro": false
                }
            }
        },
        {
            "keys": "boomBtn.png,comCloseBtn.png,comm_light.png,e305be55-fdfd-453b-9e6d-41edfe68c0f1.png,ele0.png,ele1.png,ele10.png,ele11.png,ele12.png,ele13.png,ele14.png,ele2.png,ele3.png,ele4.png,ele5.png,ele6.png,ele7.png,ele8.png,ele9.png,hammerBtn.png,powerIcon.png,powerImg.png,stepBtn.png,tarNum0.png,tarNum1.png,tarNum2.png,tarNum3.png,tarNum4.png,tarNum5.png,tarNum6.png,tarNum7.png,tarNum8.png,tarNum9.png,target0.png,target1.png,target2.png,target3.png,target4.png,toastBg.png,waitingBg.png,waitingRot.png,关闭按钮.png",
            "name": "common",
            "atlas": {
                "toastBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 460,
                    "h": 130,
                    "ox": 0,
                    "oy": 0,
                    "sw": 460,
                    "sh": 130,
                    "ro": false
                },
                "comm_light.png": {
                    "x": 2,
                    "y": 134,
                    "w": 439,
                    "h": 439,
                    "ox": 0,
                    "oy": 0,
                    "sw": 439,
                    "sh": 439,
                    "ro": false
                },
                "waitingBg.png": {
                    "x": 464,
                    "y": 2,
                    "w": 160,
                    "h": 180,
                    "ox": 0,
                    "oy": 0,
                    "sw": 160,
                    "sh": 180,
                    "ro": false
                },
                "e305be55-fdfd-453b-9e6d-41edfe68c0f1.png": {
                    "x": 443,
                    "y": 184,
                    "w": 165,
                    "h": 108,
                    "ox": 0,
                    "oy": 0,
                    "sw": 165,
                    "sh": 108,
                    "ro": false
                },
                "powerImg.png": {
                    "x": 443,
                    "y": 294,
                    "w": 152,
                    "h": 152,
                    "ox": 0,
                    "oy": 0,
                    "sw": 152,
                    "sh": 152,
                    "ro": false
                },
                "boomBtn.png": {
                    "x": 2,
                    "y": 575,
                    "w": 146,
                    "h": 139,
                    "ox": 0,
                    "oy": 0,
                    "sw": 146,
                    "sh": 139,
                    "ro": false
                },
                "hammerBtn.png": {
                    "x": 150,
                    "y": 575,
                    "w": 146,
                    "h": 139,
                    "ox": 0,
                    "oy": 0,
                    "sw": 146,
                    "sh": 139,
                    "ro": false
                },
                "stepBtn.png": {
                    "x": 298,
                    "y": 575,
                    "w": 146,
                    "h": 139,
                    "ox": 0,
                    "oy": 0,
                    "sw": 146,
                    "sh": 139,
                    "ro": false
                },
                "powerIcon.png": {
                    "x": 443,
                    "y": 448,
                    "w": 97,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 97,
                    "sh": 90,
                    "ro": true
                },
                "ele10.png": {
                    "x": 535,
                    "y": 448,
                    "w": 76,
                    "h": 74,
                    "ox": 2,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele11.png": {
                    "x": 535,
                    "y": 524,
                    "w": 76,
                    "h": 74,
                    "ox": 2,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele12.png": {
                    "x": 446,
                    "y": 547,
                    "w": 76,
                    "h": 74,
                    "ox": 2,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele2.png": {
                    "x": 446,
                    "y": 623,
                    "w": 76,
                    "h": 66,
                    "ox": 2,
                    "oy": 7,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele9.png": {
                    "x": 514,
                    "y": 623,
                    "w": 75,
                    "h": 76,
                    "ox": 2,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "target2.png": {
                    "x": 626,
                    "y": 2,
                    "w": 76,
                    "h": 66,
                    "ox": 2,
                    "oy": 7,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele1.png": {
                    "x": 626,
                    "y": 80,
                    "w": 65,
                    "h": 75,
                    "ox": 7,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "target1.png": {
                    "x": 626,
                    "y": 157,
                    "w": 65,
                    "h": 75,
                    "ox": 7,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele7.png": {
                    "x": 613,
                    "y": 234,
                    "w": 74,
                    "h": 74,
                    "ox": 3,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele3.png": {
                    "x": 613,
                    "y": 310,
                    "w": 60,
                    "h": 73,
                    "ox": 10,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele5.png": {
                    "x": 597,
                    "y": 372,
                    "w": 73,
                    "h": 73,
                    "ox": 4,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "target3.png": {
                    "x": 613,
                    "y": 447,
                    "w": 60,
                    "h": 73,
                    "ox": 10,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele8.png": {
                    "x": 613,
                    "y": 509,
                    "w": 61,
                    "h": 71,
                    "ox": 10,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele4.png": {
                    "x": 613,
                    "y": 572,
                    "w": 70,
                    "h": 70,
                    "ox": 5,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "target4.png": {
                    "x": 591,
                    "y": 644,
                    "w": 70,
                    "h": 70,
                    "ox": 5,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "关闭按钮.png": {
                    "x": 693,
                    "y": 80,
                    "w": 68,
                    "h": 69,
                    "ox": 0,
                    "oy": 0,
                    "sw": 68,
                    "sh": 69,
                    "ro": true
                },
                "ele0.png": {
                    "x": 694,
                    "y": 2,
                    "w": 67,
                    "h": 67,
                    "ox": 6,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele13.png": {
                    "x": 693,
                    "y": 150,
                    "w": 67,
                    "h": 67,
                    "ox": 0,
                    "oy": 0,
                    "sw": 67,
                    "sh": 67,
                    "ro": false
                },
                "target0.png": {
                    "x": 693,
                    "y": 219,
                    "w": 67,
                    "h": 67,
                    "ox": 6,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele14.png": {
                    "x": 663,
                    "y": 644,
                    "w": 61,
                    "h": 66,
                    "ox": 0,
                    "oy": 0,
                    "sw": 61,
                    "sh": 66,
                    "ro": false
                },
                "waitingRot.png": {
                    "x": 685,
                    "y": 572,
                    "w": 56,
                    "h": 56,
                    "ox": 0,
                    "oy": 0,
                    "sw": 56,
                    "sh": 56,
                    "ro": false
                },
                "comCloseBtn.png": {
                    "x": 686,
                    "y": 509,
                    "w": 48,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 48,
                    "sh": 48,
                    "ro": false
                },
                "ele6.png": {
                    "x": 736,
                    "y": 288,
                    "w": 33,
                    "h": 24,
                    "ox": 23,
                    "oy": 28,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "tarNum0.png": {
                    "x": 524,
                    "y": 600,
                    "w": 16,
                    "h": 21,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 21,
                    "ro": false
                },
                "tarNum3.png": {
                    "x": 542,
                    "y": 600,
                    "w": 15,
                    "h": 21,
                    "ox": 0,
                    "oy": 0,
                    "sw": 15,
                    "sh": 21,
                    "ro": false
                },
                "tarNum5.png": {
                    "x": 559,
                    "y": 600,
                    "w": 15,
                    "h": 21,
                    "ox": 0,
                    "oy": 0,
                    "sw": 15,
                    "sh": 21,
                    "ro": false
                },
                "tarNum6.png": {
                    "x": 576,
                    "y": 600,
                    "w": 16,
                    "h": 21,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 21,
                    "ro": false
                },
                "tarNum8.png": {
                    "x": 594,
                    "y": 600,
                    "w": 16,
                    "h": 21,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 21,
                    "ro": false
                },
                "tarNum9.png": {
                    "x": 443,
                    "y": 134,
                    "w": 16,
                    "h": 21,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 21,
                    "ro": false
                },
                "tarNum1.png": {
                    "x": 446,
                    "y": 701,
                    "w": 13,
                    "h": 20,
                    "ox": 0,
                    "oy": 0,
                    "sw": 13,
                    "sh": 20,
                    "ro": true
                },
                "tarNum2.png": {
                    "x": 591,
                    "y": 623,
                    "w": 16,
                    "h": 20,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 20,
                    "ro": true
                },
                "tarNum4.png": {
                    "x": 743,
                    "y": 323,
                    "w": 17,
                    "h": 20,
                    "ox": 0,
                    "oy": 0,
                    "sw": 17,
                    "sh": 20,
                    "ro": false
                },
                "tarNum7.png": {
                    "x": 443,
                    "y": 157,
                    "w": 15,
                    "h": 20,
                    "ox": 0,
                    "oy": 0,
                    "sw": 15,
                    "sh": 20,
                    "ro": false
                }
            }
        },
        {
            "keys": "fesEleSmallDis1.png,fesEleSmallDis10.png,fesEleSmallDis2.png,fesEleSmallDis3.png,fesEleSmallDis4.png,fesEleSmallDis5.png,fesEleSmallDis6.png,fesEleSmallDis7.png,fesEleSmallDis8.png,fesEleSmallDis9.png,fesRedBigLight.png,fesRedBombSta1.png,fesRedCap.png,fesRedDown.png,fesRedSmallLight.png,fesRedUp.png,festivalTargetBg.png,lineLight1.png,lineLight10.png,lineLight11.png,lineLight12.png,lineLight13.png,lineLight2.png,lineLight3.png,lineLight4.png,lineLight5.png,lineLight6.png,lineLight7.png,lineLight8.png,lineLight9.png,xingxingbi.png",
            "name": "festival",
            "atlas": {
                "fesRedBigLight.png": {
                    "x": 2,
                    "y": 2,
                    "w": 438,
                    "h": 431,
                    "ox": 0,
                    "oy": 0,
                    "sw": 438,
                    "sh": 431,
                    "ro": false
                },
                "lineLight1.png": {
                    "x": 2,
                    "y": 435,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight13.png": {
                    "x": 442,
                    "y": 2,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": true
                },
                "lineLight2.png": {
                    "x": 2,
                    "y": 495,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight3.png": {
                    "x": 502,
                    "y": 2,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": true
                },
                "lineLight6.png": {
                    "x": 2,
                    "y": 555,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight7.png": {
                    "x": 442,
                    "y": 297,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": true
                },
                "lineLight8.png": {
                    "x": 502,
                    "y": 297,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": true
                },
                "lineLight5.png": {
                    "x": 562,
                    "y": 2,
                    "w": 292,
                    "h": 56,
                    "ox": 2,
                    "oy": 2,
                    "sw": 293,
                    "sh": 58,
                    "ro": true
                },
                "lineLight11.png": {
                    "x": 562,
                    "y": 296,
                    "w": 286,
                    "h": 51,
                    "ox": 2,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": true
                },
                "lineLight4.png": {
                    "x": 2,
                    "y": 615,
                    "w": 286,
                    "h": 58,
                    "ox": 1,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight10.png": {
                    "x": 290,
                    "y": 615,
                    "w": 285,
                    "h": 56,
                    "ox": 1,
                    "oy": 2,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight9.png": {
                    "x": 620,
                    "y": 2,
                    "w": 274,
                    "h": 58,
                    "ox": 16,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": true
                },
                "fesRedCap.png": {
                    "x": 2,
                    "y": 675,
                    "w": 251,
                    "h": 104,
                    "ox": 0,
                    "oy": 0,
                    "sw": 251,
                    "sh": 104,
                    "ro": false
                },
                "fesRedSmallLight.png": {
                    "x": 680,
                    "y": 2,
                    "w": 249,
                    "h": 159,
                    "ox": 0,
                    "oy": 0,
                    "sw": 249,
                    "sh": 159,
                    "ro": true
                },
                "lineLight12.png": {
                    "x": 577,
                    "y": 584,
                    "w": 238,
                    "h": 58,
                    "ox": 16,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "fesRedBombSta1.png": {
                    "x": 2,
                    "y": 781,
                    "w": 237,
                    "h": 237,
                    "ox": 0,
                    "oy": 0,
                    "sw": 237,
                    "sh": 237,
                    "ro": false
                },
                "fesRedDown.png": {
                    "x": 241,
                    "y": 781,
                    "w": 237,
                    "h": 237,
                    "ox": 0,
                    "oy": 0,
                    "sw": 237,
                    "sh": 237,
                    "ro": false
                },
                "fesRedUp.png": {
                    "x": 577,
                    "y": 644,
                    "w": 237,
                    "h": 185,
                    "ox": 0,
                    "oy": 0,
                    "sw": 237,
                    "sh": 185,
                    "ro": false
                },
                "xingxingbi.png": {
                    "x": 480,
                    "y": 831,
                    "w": 178,
                    "h": 178,
                    "ox": 0,
                    "oy": 0,
                    "sw": 178,
                    "sh": 178,
                    "ro": false
                },
                "fesEleSmallDis10.png": {
                    "x": 680,
                    "y": 253,
                    "w": 146,
                    "h": 144,
                    "ox": 1,
                    "oy": 6,
                    "sw": 150,
                    "sh": 150,
                    "ro": false
                },
                "fesEleSmallDis9.png": {
                    "x": 297,
                    "y": 435,
                    "w": 135,
                    "h": 140,
                    "ox": 7,
                    "oy": 9,
                    "sw": 150,
                    "sh": 150,
                    "ro": true
                },
                "fesEleSmallDis8.png": {
                    "x": 660,
                    "y": 831,
                    "w": 122,
                    "h": 128,
                    "ox": 13,
                    "oy": 15,
                    "sw": 150,
                    "sh": 150,
                    "ro": true
                },
                "fesEleSmallDis7.png": {
                    "x": 615,
                    "y": 399,
                    "w": 111,
                    "h": 116,
                    "ox": 19,
                    "oy": 21,
                    "sw": 150,
                    "sh": 150,
                    "ro": false
                },
                "fesEleSmallDis1.png": {
                    "x": 290,
                    "y": 673,
                    "w": 101,
                    "h": 105,
                    "ox": 24,
                    "oy": 25,
                    "sw": 150,
                    "sh": 150,
                    "ro": false
                },
                "fesEleSmallDis6.png": {
                    "x": 393,
                    "y": 673,
                    "w": 99,
                    "h": 102,
                    "ox": 25,
                    "oy": 28,
                    "sw": 150,
                    "sh": 150,
                    "ro": false
                },
                "fesEleSmallDis2.png": {
                    "x": 728,
                    "y": 399,
                    "w": 97,
                    "h": 99,
                    "ox": 27,
                    "oy": 28,
                    "sw": 150,
                    "sh": 150,
                    "ro": true
                },
                "festivalTargetBg.png": {
                    "x": 494,
                    "y": 673,
                    "w": 77,
                    "h": 98,
                    "ox": 0,
                    "oy": 0,
                    "sw": 77,
                    "sh": 98,
                    "ro": false
                },
                "fesEleSmallDis3.png": {
                    "x": 841,
                    "y": 2,
                    "w": 90,
                    "h": 91,
                    "ox": 30,
                    "oy": 32,
                    "sw": 150,
                    "sh": 150,
                    "ro": false
                },
                "fesEleSmallDis4.png": {
                    "x": 728,
                    "y": 498,
                    "w": 82,
                    "h": 85,
                    "ox": 34,
                    "oy": 35,
                    "sw": 150,
                    "sh": 150,
                    "ro": true
                },
                "fesEleSmallDis5.png": {
                    "x": 815,
                    "y": 498,
                    "w": 80,
                    "h": 84,
                    "ox": 34,
                    "oy": 37,
                    "sw": 150,
                    "sh": 150,
                    "ro": false
                }
            }
        },
        {
            "keys": "dis_ele_0.png,dis_ele_1.png,dis_ele_10.png,dis_ele_11.png,dis_ele_12.png,dis_ele_13.png,dis_ele_14.png,dis_ele_15.png,dis_ele_16.png,dis_ele_17.png,dis_ele_18.png,dis_ele_19.png,dis_ele_2.png,dis_ele_20.png,dis_ele_21.png,dis_ele_3.png,dis_ele_4.png,dis_ele_5.png,dis_ele_6.png,dis_ele_7.png,dis_ele_8.png,dis_ele_9.png",
            "name": "fiveVerHorDis",
            "atlas": {
                "dis_ele_14.png": {
                    "x": 2,
                    "y": 2,
                    "w": 101,
                    "h": 98,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele_15.png": {
                    "x": 2,
                    "y": 102,
                    "w": 100,
                    "h": 98,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele_16.png": {
                    "x": 105,
                    "y": 2,
                    "w": 100,
                    "h": 98,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele_10.png": {
                    "x": 104,
                    "y": 104,
                    "w": 99,
                    "h": 98,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele_11.png": {
                    "x": 2,
                    "y": 202,
                    "w": 98,
                    "h": 98,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele_12.png": {
                    "x": 205,
                    "y": 2,
                    "w": 98,
                    "h": 98,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele_13.png": {
                    "x": 205,
                    "y": 102,
                    "w": 98,
                    "h": 98,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele_17.png": {
                    "x": 205,
                    "y": 202,
                    "w": 98,
                    "h": 98,
                    "ox": 2,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele_18.png": {
                    "x": 2,
                    "y": 302,
                    "w": 98,
                    "h": 98,
                    "ox": 2,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele_19.png": {
                    "x": 102,
                    "y": 302,
                    "w": 98,
                    "h": 93,
                    "ox": 2,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele_20.png": {
                    "x": 197,
                    "y": 302,
                    "w": 98,
                    "h": 72,
                    "ox": 2,
                    "oy": 1,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele_9.png": {
                    "x": 102,
                    "y": 204,
                    "w": 95,
                    "h": 98,
                    "ox": 1,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele_7.png": {
                    "x": 305,
                    "y": 2,
                    "w": 87,
                    "h": 97,
                    "ox": 7,
                    "oy": 1,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele_8.png": {
                    "x": 271,
                    "y": 302,
                    "w": 86,
                    "h": 97,
                    "ox": 9,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele_21.png": {
                    "x": 305,
                    "y": 101,
                    "w": 96,
                    "h": 73,
                    "ox": 4,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele_6.png": {
                    "x": 305,
                    "y": 199,
                    "w": 86,
                    "h": 95,
                    "ox": 9,
                    "oy": 1,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele_5.png": {
                    "x": 394,
                    "y": 2,
                    "w": 80,
                    "h": 90,
                    "ox": 12,
                    "oy": 3,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele_4.png": {
                    "x": 394,
                    "y": 94,
                    "w": 77,
                    "h": 78,
                    "ox": 15,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele_3.png": {
                    "x": 393,
                    "y": 173,
                    "w": 74,
                    "h": 66,
                    "ox": 15,
                    "oy": 8,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele_2.png": {
                    "x": 393,
                    "y": 241,
                    "w": 64,
                    "h": 54,
                    "ox": 15,
                    "oy": 20,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele_0.png": {
                    "x": 359,
                    "y": 297,
                    "w": 54,
                    "h": 37,
                    "ox": 15,
                    "oy": 36,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele_1.png": {
                    "x": 359,
                    "y": 353,
                    "w": 54,
                    "h": 37,
                    "ox": 15,
                    "oy": 36,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                }
            }
        },
        {
            "keys": "loadingBg.jpg,loadingLight0.png,loadingLight1.png,loadingLight10.png,loadingLight11.png,loadingLight12.png,loadingLight13.png,loadingLight14.png,loadingLight15.png,loadingLight16.png,loadingLight17.png,loadingLight18.png,loadingLight19.png,loadingLight2.png,loadingLight20.png,loadingLight21.png,loadingLight22.png,loadingLight23.png,loadingLight24.png,loadingLight25.png,loadingLight26.png,loadingLight27.png,loadingLight28.png,loadingLight29.png,loadingLight3.png,loadingLight4.png,loadingLight5.png,loadingLight6.png,loadingLight7.png,loadingLight8.png,loadingLight9.png,loadingPro.png,loading_line_left1.png,loading_line_left2.png,loading_line_right.png,loading_shoes.png",
            "name": "loadingScene",
            "atlas": {
                "loadingLight0.png": {
                    "x": 2,
                    "y": 2,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": false
                },
                "loadingLight1.png": {
                    "x": 2,
                    "y": 94,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": false
                },
                "loadingLight10.png": {
                    "x": 2,
                    "y": 186,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": false
                },
                "loadingLight11.png": {
                    "x": 2,
                    "y": 278,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": false
                },
                "loadingLight12.png": {
                    "x": 2,
                    "y": 370,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": false
                },
                "loadingLight13.png": {
                    "x": 2,
                    "y": 462,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": false
                },
                "loadingLight14.png": {
                    "x": 2,
                    "y": 554,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": false
                },
                "loadingLight15.png": {
                    "x": 2,
                    "y": 646,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": false
                },
                "loadingLight16.png": {
                    "x": 660,
                    "y": 2,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": true
                },
                "loadingLight17.png": {
                    "x": 2,
                    "y": 738,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": false
                },
                "loadingLight18.png": {
                    "x": 752,
                    "y": 2,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": true
                },
                "loadingLight19.png": {
                    "x": 2,
                    "y": 830,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": false
                },
                "loadingLight2.png": {
                    "x": 844,
                    "y": 2,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": true
                },
                "loadingLight20.png": {
                    "x": 2,
                    "y": 922,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": false
                },
                "loadingLight21.png": {
                    "x": 936,
                    "y": 2,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": true
                },
                "loadingLight22.png": {
                    "x": 2,
                    "y": 1014,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": false
                },
                "loadingLight23.png": {
                    "x": 1028,
                    "y": 2,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": true
                },
                "loadingLight24.png": {
                    "x": 2,
                    "y": 1106,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": false
                },
                "loadingLight25.png": {
                    "x": 1120,
                    "y": 2,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": true
                },
                "loadingLight26.png": {
                    "x": 2,
                    "y": 1198,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": false
                },
                "loadingLight27.png": {
                    "x": 1212,
                    "y": 2,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": true
                },
                "loadingLight28.png": {
                    "x": 2,
                    "y": 1290,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": false
                },
                "loadingLight29.png": {
                    "x": 660,
                    "y": 660,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": true
                },
                "loadingLight3.png": {
                    "x": 752,
                    "y": 660,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": true
                },
                "loadingLight4.png": {
                    "x": 844,
                    "y": 660,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": true
                },
                "loadingLight5.png": {
                    "x": 936,
                    "y": 660,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": true
                },
                "loadingLight6.png": {
                    "x": 1028,
                    "y": 660,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": true
                },
                "loadingLight7.png": {
                    "x": 1120,
                    "y": 660,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": true
                },
                "loadingLight8.png": {
                    "x": 1212,
                    "y": 660,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": true
                },
                "loadingLight9.png": {
                    "x": 1304,
                    "y": 2,
                    "w": 656,
                    "h": 90,
                    "ox": 38,
                    "oy": 57,
                    "sw": 750,
                    "sh": 200,
                    "ro": true
                },
                "loadingPro.png": {
                    "x": 660,
                    "y": 1318,
                    "w": 521,
                    "h": 50,
                    "ox": 0,
                    "oy": 0,
                    "sw": 521,
                    "sh": 50,
                    "ro": false
                },
                "loading_shoes.png": {
                    "x": 2,
                    "y": 1382,
                    "w": 243,
                    "h": 222,
                    "ox": 0,
                    "oy": 0,
                    "sw": 243,
                    "sh": 222,
                    "ro": false
                },
                "loading_line_right.png": {
                    "x": 1304,
                    "y": 660,
                    "w": 60,
                    "h": 7,
                    "ox": 0,
                    "oy": 0,
                    "sw": 60,
                    "sh": 7,
                    "ro": false
                },
                "loading_line_left2.png": {
                    "x": 1366,
                    "y": 660,
                    "w": 46,
                    "h": 7,
                    "ox": 0,
                    "oy": 0,
                    "sw": 46,
                    "sh": 7,
                    "ro": true
                },
                "loading_line_left1.png": {
                    "x": 1375,
                    "y": 660,
                    "w": 38,
                    "h": 7,
                    "ox": 0,
                    "oy": 0,
                    "sw": 38,
                    "sh": 7,
                    "ro": true
                }
            }
        },
        {
            "keys": "lotteryBtn.png,lotteryMachineBg.png,lotteryReturnBtn.png,prizeItemBg.png,老虎机好的.png,老虎机领取奖励.png",
            "name": "lotteryScene",
            "atlas": {
                "lotteryMachineBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 695,
                    "h": 836,
                    "ox": 31,
                    "oy": 245,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "lotteryBtn.png": {
                    "x": 699,
                    "y": 2,
                    "w": 387,
                    "h": 112,
                    "ox": 0,
                    "oy": 0,
                    "sw": 387,
                    "sh": 112,
                    "ro": true
                },
                "老虎机好的.png": {
                    "x": 699,
                    "y": 391,
                    "w": 387,
                    "h": 112,
                    "ox": 0,
                    "oy": 0,
                    "sw": 387,
                    "sh": 112,
                    "ro": true
                },
                "老虎机领取奖励.png": {
                    "x": 813,
                    "y": 2,
                    "w": 387,
                    "h": 112,
                    "ox": 0,
                    "oy": 0,
                    "sw": 387,
                    "sh": 112,
                    "ro": true
                },
                "lotteryReturnBtn.png": {
                    "x": 813,
                    "y": 391,
                    "w": 126,
                    "h": 59,
                    "ox": 0,
                    "oy": 0,
                    "sw": 126,
                    "sh": 59,
                    "ro": true
                },
                "prizeItemBg.png": {
                    "x": 813,
                    "y": 519,
                    "w": 109,
                    "h": 109,
                    "ox": 0,
                    "oy": 0,
                    "sw": 109,
                    "sh": 109,
                    "ro": false
                }
            }
        },
        {
            "keys": "checkTip1.png,clearanceBtn.png,guide_hand.png,guide_light.png,guide_tip.png,map_bg1.jpg,map_bg2.jpg,map_bg3.jpg,map_energyBg.png,map_prizeBtn.png,map_ruleBtn.png,map_star_disable.png,map_star_enable.png,map_taskBtn.png,mcd0.png,mcd1.png,mcd2.png,mce0.png,mce1.png,mce2.png",
            "name": "map",
            "atlas": {
                "guide_tip.png": {
                    "x": 2,
                    "y": 2,
                    "w": 541,
                    "h": 282,
                    "ox": 0,
                    "oy": 0,
                    "sw": 541,
                    "sh": 282,
                    "ro": false
                },
                "checkTip1.png": {
                    "x": 2,
                    "y": 286,
                    "w": 234,
                    "h": 62,
                    "ox": 0,
                    "oy": 0,
                    "sw": 234,
                    "sh": 62,
                    "ro": false
                },
                "map_energyBg.png": {
                    "x": 2,
                    "y": 350,
                    "w": 211,
                    "h": 97,
                    "ox": 0,
                    "oy": 0,
                    "sw": 211,
                    "sh": 97,
                    "ro": false
                },
                "mce0.png": {
                    "x": 238,
                    "y": 286,
                    "w": 164,
                    "h": 128,
                    "ox": 0,
                    "oy": 0,
                    "sw": 164,
                    "sh": 128,
                    "ro": false
                },
                "mce1.png": {
                    "x": 2,
                    "y": 449,
                    "w": 164,
                    "h": 128,
                    "ox": 0,
                    "oy": 0,
                    "sw": 164,
                    "sh": 128,
                    "ro": false
                },
                "mce2.png": {
                    "x": 168,
                    "y": 449,
                    "w": 164,
                    "h": 128,
                    "ox": 0,
                    "oy": 0,
                    "sw": 164,
                    "sh": 128,
                    "ro": false
                },
                "mcd0.png": {
                    "x": 334,
                    "y": 416,
                    "w": 150,
                    "h": 115,
                    "ox": 7,
                    "oy": 7,
                    "sw": 164,
                    "sh": 128,
                    "ro": true
                },
                "mcd1.png": {
                    "x": 545,
                    "y": 2,
                    "w": 150,
                    "h": 115,
                    "ox": 7,
                    "oy": 7,
                    "sw": 164,
                    "sh": 128,
                    "ro": true
                },
                "mcd2.png": {
                    "x": 545,
                    "y": 154,
                    "w": 150,
                    "h": 115,
                    "ox": 7,
                    "oy": 6,
                    "sw": 164,
                    "sh": 127,
                    "ro": true
                },
                "map_prizeBtn.png": {
                    "x": 404,
                    "y": 286,
                    "w": 133,
                    "h": 45,
                    "ox": 0,
                    "oy": 0,
                    "sw": 133,
                    "sh": 45,
                    "ro": false
                },
                "map_ruleBtn.png": {
                    "x": 404,
                    "y": 333,
                    "w": 133,
                    "h": 45,
                    "ox": 0,
                    "oy": 0,
                    "sw": 133,
                    "sh": 45,
                    "ro": false
                },
                "map_taskBtn.png": {
                    "x": 539,
                    "y": 306,
                    "w": 103,
                    "h": 105,
                    "ox": 0,
                    "oy": 0,
                    "sw": 103,
                    "sh": 105,
                    "ro": true
                },
                "clearanceBtn.png": {
                    "x": 451,
                    "y": 411,
                    "w": 103,
                    "h": 104,
                    "ox": 0,
                    "oy": 0,
                    "sw": 103,
                    "sh": 104,
                    "ro": false
                },
                "guide_hand.png": {
                    "x": 556,
                    "y": 411,
                    "w": 103,
                    "h": 104,
                    "ox": 0,
                    "oy": 0,
                    "sw": 103,
                    "sh": 104,
                    "ro": true
                },
                "guide_light.png": {
                    "x": 451,
                    "y": 517,
                    "w": 58,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 58,
                    "sh": 58,
                    "ro": false
                },
                "map_star_enable.png": {
                    "x": 511,
                    "y": 517,
                    "w": 48,
                    "h": 47,
                    "ox": 0,
                    "oy": 0,
                    "sw": 48,
                    "sh": 47,
                    "ro": true
                },
                "map_star_disable.png": {
                    "x": 560,
                    "y": 516,
                    "w": 45,
                    "h": 42,
                    "ox": 0,
                    "oy": 0,
                    "sw": 45,
                    "sh": 42,
                    "ro": true
                }
            }
        },
        {
            "keys": "prize_check_0.png,prize_check_1.png,prize_check_10.png,prize_check_11.png,prize_check_12.png,prize_check_13.png,prize_check_14.png,prize_check_15.png,prize_check_16.png,prize_check_2.png,prize_check_3.png,prize_check_4.png,prize_check_5.png,prize_check_6.png,prize_check_7.png,prize_check_8.png,prize_check_9.png",
            "name": "mapCheckPrizeEffect",
            "atlas": {
                "prize_check_0.png": {
                    "x": 2,
                    "y": 2,
                    "w": 111,
                    "h": 104,
                    "ox": 5,
                    "oy": 6,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_1.png": {
                    "x": 2,
                    "y": 108,
                    "w": 111,
                    "h": 104,
                    "ox": 5,
                    "oy": 6,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_10.png": {
                    "x": 115,
                    "y": 2,
                    "w": 111,
                    "h": 104,
                    "ox": 5,
                    "oy": 6,
                    "sw": 120,
                    "sh": 126,
                    "ro": true
                },
                "prize_check_14.png": {
                    "x": 2,
                    "y": 214,
                    "w": 111,
                    "h": 105,
                    "ox": 5,
                    "oy": 5,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_15.png": {
                    "x": 221,
                    "y": 2,
                    "w": 111,
                    "h": 105,
                    "ox": 5,
                    "oy": 5,
                    "sw": 120,
                    "sh": 126,
                    "ro": true
                },
                "prize_check_4.png": {
                    "x": 115,
                    "y": 115,
                    "w": 111,
                    "h": 104,
                    "ox": 5,
                    "oy": 6,
                    "sw": 120,
                    "sh": 126,
                    "ro": true
                },
                "prize_check_5.png": {
                    "x": 221,
                    "y": 115,
                    "w": 111,
                    "h": 105,
                    "ox": 5,
                    "oy": 5,
                    "sw": 120,
                    "sh": 126,
                    "ro": true
                },
                "prize_check_9.png": {
                    "x": 2,
                    "y": 321,
                    "w": 111,
                    "h": 105,
                    "ox": 5,
                    "oy": 5,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_11.png": {
                    "x": 115,
                    "y": 228,
                    "w": 110,
                    "h": 104,
                    "ox": 5,
                    "oy": 6,
                    "sw": 120,
                    "sh": 126,
                    "ro": true
                },
                "prize_check_12.png": {
                    "x": 221,
                    "y": 228,
                    "w": 110,
                    "h": 104,
                    "ox": 5,
                    "oy": 6,
                    "sw": 120,
                    "sh": 126,
                    "ro": true
                },
                "prize_check_13.png": {
                    "x": 328,
                    "y": 2,
                    "w": 110,
                    "h": 105,
                    "ox": 5,
                    "oy": 5,
                    "sw": 120,
                    "sh": 126,
                    "ro": true
                },
                "prize_check_16.png": {
                    "x": 328,
                    "y": 114,
                    "w": 110,
                    "h": 105,
                    "ox": 5,
                    "oy": 5,
                    "sw": 120,
                    "sh": 126,
                    "ro": true
                },
                "prize_check_2.png": {
                    "x": 328,
                    "y": 226,
                    "w": 110,
                    "h": 104,
                    "ox": 5,
                    "oy": 6,
                    "sw": 120,
                    "sh": 126,
                    "ro": true
                },
                "prize_check_3.png": {
                    "x": 2,
                    "y": 428,
                    "w": 110,
                    "h": 104,
                    "ox": 5,
                    "oy": 6,
                    "sw": 120,
                    "sh": 126,
                    "ro": false
                },
                "prize_check_6.png": {
                    "x": 327,
                    "y": 338,
                    "w": 110,
                    "h": 106,
                    "ox": 5,
                    "oy": 4,
                    "sw": 120,
                    "sh": 126,
                    "ro": true
                },
                "prize_check_7.png": {
                    "x": 115,
                    "y": 340,
                    "w": 110,
                    "h": 108,
                    "ox": 5,
                    "oy": 2,
                    "sw": 120,
                    "sh": 126,
                    "ro": true
                },
                "prize_check_8.png": {
                    "x": 434,
                    "y": 226,
                    "w": 110,
                    "h": 106,
                    "ox": 5,
                    "oy": 4,
                    "sw": 120,
                    "sh": 126,
                    "ro": true
                }
            }
        },
        {
            "keys": "amazing.png,blueDoorBg.png,brownBallFace.png,bubleEle0.png,bubleEle1.png,bubleEle2.png,bubleEle3.png,bubleEle4.png,chooseRect.png,doorClosed.png,doorOpen.png,eggPiece1.png,eggPiece2.png,eggPiece3.png,eggPiece4.png,eggPiece5.png,eggStatus0.png,eggStatus1.png,eggStatus2.png,ele0Exp.png,ele0Hor.png,ele1Exp.png,ele1Hor.png,ele2Exp.png,ele2Hor.png,ele3Exp.png,ele3Hor.png,ele4Exp.png,ele4Hor.png,eyeDownLeft.png,eyeDownRight.png,eyeSingle.png,good.png,great.png,greenCircleDown.png,greenCircleUp.png,greyBallFace.png,hairballDisBg.png,hairballPiece1.png,hairballPiece2.png,hairballPiece3.png,hairballPiece4.png,hairballPiece5.png,hairballPiece6.png,hairballPiece7.png,hairballPiece8.png,hairballPiece9.png,ice2.png,ice3.png,ice4.png,ice5.png,jellyArrow.png,leftArrow.png,lightedStar.png,lineLight.png,lockVine.png,magicLion.png,magicLionBg.png,main_mapbottom.png,musicOff.png,musicOn.png,perfect.png,playBg.jpg,propCancel.png,propNumBg.png,rectLat.png,rectLatWhite.png,redDoorBg.png,rightArrow.png,rightMark.png,rock2.png,rock3.png,rock4.png,rock5.png,starProgress.png,stepAni11.png,topBg.png,unlightedStar.png,yellowCircleDown.png,yellowCircleUp.png,yellowDoorBg.png,闪闪.png",
            "name": "playScene",
            "atlas": {
                "lineLight.png": {
                    "x": 2,
                    "y": 2,
                    "w": 56,
                    "h": 750,
                    "ox": 0,
                    "oy": 0,
                    "sw": 56,
                    "sh": 750,
                    "ro": false
                },
                "topBg.png": {
                    "x": 60,
                    "y": 2,
                    "w": 680,
                    "h": 221,
                    "ox": 0,
                    "oy": 0,
                    "sw": 680,
                    "sh": 221,
                    "ro": true
                },
                "starProgress.png": {
                    "x": 283,
                    "y": 2,
                    "w": 573,
                    "h": 50,
                    "ox": 0,
                    "oy": 0,
                    "sw": 573,
                    "sh": 50,
                    "ro": true
                },
                "amazing.png": {
                    "x": 335,
                    "y": 2,
                    "w": 475,
                    "h": 198,
                    "ox": 0,
                    "oy": 0,
                    "sw": 475,
                    "sh": 198,
                    "ro": true
                },
                "perfect.png": {
                    "x": 535,
                    "y": 2,
                    "w": 432,
                    "h": 179,
                    "ox": 0,
                    "oy": 0,
                    "sw": 432,
                    "sh": 179,
                    "ro": true
                },
                "great.png": {
                    "x": 335,
                    "y": 479,
                    "w": 359,
                    "h": 183,
                    "ox": 0,
                    "oy": 0,
                    "sw": 359,
                    "sh": 183,
                    "ro": false
                },
                "good.png": {
                    "x": 716,
                    "y": 2,
                    "w": 309,
                    "h": 177,
                    "ox": 0,
                    "oy": 0,
                    "sw": 309,
                    "sh": 177,
                    "ro": true
                },
                "stepAni11.png": {
                    "x": 716,
                    "y": 313,
                    "w": 155,
                    "h": 199,
                    "ox": 225,
                    "oy": 79,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "propCancel.png": {
                    "x": 696,
                    "y": 514,
                    "w": 196,
                    "h": 55,
                    "ox": 0,
                    "oy": 0,
                    "sw": 196,
                    "sh": 55,
                    "ro": false
                },
                "闪闪.png": {
                    "x": 535,
                    "y": 436,
                    "w": 171,
                    "h": 39,
                    "ox": 0,
                    "oy": 0,
                    "sw": 171,
                    "sh": 39,
                    "ro": false
                },
                "yellowCircleUp.png": {
                    "x": 696,
                    "y": 571,
                    "w": 144,
                    "h": 140,
                    "ox": 0,
                    "oy": 0,
                    "sw": 144,
                    "sh": 140,
                    "ro": true
                },
                "greenCircleUp.png": {
                    "x": 2,
                    "y": 754,
                    "w": 129,
                    "h": 126,
                    "ox": 0,
                    "oy": 0,
                    "sw": 129,
                    "sh": 126,
                    "ro": false
                },
                "magicLionBg.png": {
                    "x": 133,
                    "y": 717,
                    "w": 123,
                    "h": 119,
                    "ox": 0,
                    "oy": 0,
                    "sw": 123,
                    "sh": 119,
                    "ro": true
                },
                "greenCircleDown.png": {
                    "x": 254,
                    "y": 717,
                    "w": 108,
                    "h": 106,
                    "ox": 0,
                    "oy": 1,
                    "sw": 108,
                    "sh": 108,
                    "ro": true
                },
                "yellowCircleDown.png": {
                    "x": 362,
                    "y": 717,
                    "w": 108,
                    "h": 106,
                    "ox": 0,
                    "oy": 0,
                    "sw": 108,
                    "sh": 106,
                    "ro": true
                },
                "redDoorBg.png": {
                    "x": 470,
                    "y": 717,
                    "w": 96,
                    "h": 97,
                    "ox": 0,
                    "oy": 0,
                    "sw": 96,
                    "sh": 97,
                    "ro": false
                },
                "blueDoorBg.png": {
                    "x": 568,
                    "y": 664,
                    "w": 94,
                    "h": 95,
                    "ox": 0,
                    "oy": 0,
                    "sw": 94,
                    "sh": 95,
                    "ro": true
                },
                "yellowDoorBg.png": {
                    "x": 568,
                    "y": 760,
                    "w": 94,
                    "h": 95,
                    "ox": 0,
                    "oy": 0,
                    "sw": 94,
                    "sh": 95,
                    "ro": false
                },
                "chooseRect.png": {
                    "x": 664,
                    "y": 760,
                    "w": 86,
                    "h": 83,
                    "ox": 0,
                    "oy": 0,
                    "sw": 86,
                    "sh": 83,
                    "ro": true
                },
                "ele2Exp.png": {
                    "x": 749,
                    "y": 717,
                    "w": 81,
                    "h": 78,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele2Hor.png": {
                    "x": 749,
                    "y": 797,
                    "w": 81,
                    "h": 78,
                    "ox": 0,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "lockVine.png": {
                    "x": 2,
                    "y": 882,
                    "w": 81,
                    "h": 81,
                    "ox": 0,
                    "oy": 0,
                    "sw": 81,
                    "sh": 81,
                    "ro": false
                },
                "main_mapbottom.png": {
                    "x": 283,
                    "y": 577,
                    "w": 81,
                    "h": 50,
                    "ox": 0,
                    "oy": 0,
                    "sw": 81,
                    "sh": 50,
                    "ro": true
                },
                "ele0Exp.png": {
                    "x": 85,
                    "y": 882,
                    "w": 80,
                    "h": 79,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele0Hor.png": {
                    "x": 664,
                    "y": 848,
                    "w": 80,
                    "h": 79,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele1Exp.png": {
                    "x": 746,
                    "y": 880,
                    "w": 76,
                    "h": 80,
                    "ox": 2,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele1Hor.png": {
                    "x": 470,
                    "y": 816,
                    "w": 76,
                    "h": 80,
                    "ox": 2,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele3Exp.png": {
                    "x": 552,
                    "y": 857,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele3Hor.png": {
                    "x": 166,
                    "y": 842,
                    "w": 72,
                    "h": 80,
                    "ox": 4,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele4Exp.png": {
                    "x": 240,
                    "y": 842,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele4Hor.png": {
                    "x": 322,
                    "y": 827,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "bubleEle2.png": {
                    "x": 895,
                    "y": 2,
                    "w": 79,
                    "h": 75,
                    "ox": 1,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "rectLat.png": {
                    "x": 824,
                    "y": 880,
                    "w": 78,
                    "h": 78,
                    "ox": 0,
                    "oy": 0,
                    "sw": 78,
                    "sh": 78,
                    "ro": false
                },
                "rectLatWhite.png": {
                    "x": 829,
                    "y": 797,
                    "w": 78,
                    "h": 78,
                    "ox": 0,
                    "oy": 0,
                    "sw": 78,
                    "sh": 78,
                    "ro": false
                },
                "bubleEle0.png": {
                    "x": 895,
                    "y": 83,
                    "w": 77,
                    "h": 75,
                    "ox": 2,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "bubleEle1.png": {
                    "x": 895,
                    "y": 162,
                    "w": 77,
                    "h": 75,
                    "ox": 2,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "bubleEle3.png": {
                    "x": 895,
                    "y": 241,
                    "w": 77,
                    "h": 75,
                    "ox": 2,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "bubleEle4.png": {
                    "x": 832,
                    "y": 717,
                    "w": 77,
                    "h": 75,
                    "ox": 2,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "eggStatus0.png": {
                    "x": 404,
                    "y": 827,
                    "w": 64,
                    "h": 77,
                    "ox": 8,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "brownBallFace.png": {
                    "x": 894,
                    "y": 320,
                    "w": 76,
                    "h": 72,
                    "ox": 2,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "doorOpen.png": {
                    "x": 894,
                    "y": 394,
                    "w": 76,
                    "h": 76,
                    "ox": 0,
                    "oy": 0,
                    "sw": 76,
                    "sh": 76,
                    "ro": false
                },
                "greyBallFace.png": {
                    "x": 894,
                    "y": 472,
                    "w": 76,
                    "h": 74,
                    "ox": 2,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hairballDisBg.png": {
                    "x": 894,
                    "y": 548,
                    "w": 76,
                    "h": 75,
                    "ox": 0,
                    "oy": 0,
                    "sw": 76,
                    "sh": 75,
                    "ro": false
                },
                "ice2.png": {
                    "x": 838,
                    "y": 625,
                    "w": 75,
                    "h": 76,
                    "ox": 0,
                    "oy": 0,
                    "sw": 75,
                    "sh": 76,
                    "ro": false
                },
                "ice3.png": {
                    "x": 85,
                    "y": 964,
                    "w": 75,
                    "h": 76,
                    "ox": 0,
                    "oy": 0,
                    "sw": 75,
                    "sh": 76,
                    "ro": false
                },
                "ice4.png": {
                    "x": 162,
                    "y": 964,
                    "w": 75,
                    "h": 76,
                    "ox": 0,
                    "oy": 0,
                    "sw": 75,
                    "sh": 76,
                    "ro": false
                },
                "ice5.png": {
                    "x": 2,
                    "y": 965,
                    "w": 75,
                    "h": 76,
                    "ox": 0,
                    "oy": 0,
                    "sw": 75,
                    "sh": 76,
                    "ro": true
                },
                "doorClosed.png": {
                    "x": 239,
                    "y": 962,
                    "w": 74,
                    "h": 75,
                    "ox": 0,
                    "oy": 0,
                    "sw": 74,
                    "sh": 75,
                    "ro": false
                },
                "rock3.png": {
                    "x": 315,
                    "y": 962,
                    "w": 74,
                    "h": 73,
                    "ox": 0,
                    "oy": 0,
                    "sw": 74,
                    "sh": 73,
                    "ro": true
                },
                "rock4.png": {
                    "x": 390,
                    "y": 962,
                    "w": 74,
                    "h": 73,
                    "ox": 0,
                    "oy": 0,
                    "sw": 74,
                    "sh": 73,
                    "ro": true
                },
                "rock5.png": {
                    "x": 465,
                    "y": 962,
                    "w": 74,
                    "h": 73,
                    "ox": 0,
                    "oy": 0,
                    "sw": 74,
                    "sh": 73,
                    "ro": true
                },
                "unlightedStar.png": {
                    "x": 540,
                    "y": 962,
                    "w": 74,
                    "h": 69,
                    "ox": 0,
                    "oy": 0,
                    "sw": 74,
                    "sh": 69,
                    "ro": true
                },
                "rock2.png": {
                    "x": 611,
                    "y": 962,
                    "w": 72,
                    "h": 73,
                    "ox": 0,
                    "oy": 0,
                    "sw": 72,
                    "sh": 73,
                    "ro": false
                },
                "eggStatus1.png": {
                    "x": 685,
                    "y": 962,
                    "w": 70,
                    "h": 71,
                    "ox": 5,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "eggStatus2.png": {
                    "x": 60,
                    "y": 684,
                    "w": 61,
                    "h": 71,
                    "ox": 10,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "musicOff.png": {
                    "x": 757,
                    "y": 962,
                    "w": 71,
                    "h": 70,
                    "ox": 0,
                    "oy": 0,
                    "sw": 71,
                    "sh": 70,
                    "ro": true
                },
                "musicOn.png": {
                    "x": 829,
                    "y": 960,
                    "w": 71,
                    "h": 70,
                    "ox": 0,
                    "oy": 0,
                    "sw": 71,
                    "sh": 70,
                    "ro": true
                },
                "lightedStar.png": {
                    "x": 972,
                    "y": 2,
                    "w": 70,
                    "h": 70,
                    "ox": 0,
                    "oy": 0,
                    "sw": 70,
                    "sh": 70,
                    "ro": false
                },
                "magicLion.png": {
                    "x": 470,
                    "y": 894,
                    "w": 68,
                    "h": 65,
                    "ox": 0,
                    "oy": 0,
                    "sw": 68,
                    "sh": 65,
                    "ro": false
                },
                "propNumBg.png": {
                    "x": 972,
                    "y": 74,
                    "w": 61,
                    "h": 61,
                    "ox": 0,
                    "oy": 0,
                    "sw": 61,
                    "sh": 61,
                    "ro": false
                },
                "rightMark.png": {
                    "x": 166,
                    "y": 924,
                    "w": 48,
                    "h": 37,
                    "ox": 0,
                    "oy": 0,
                    "sw": 48,
                    "sh": 37,
                    "ro": false
                },
                "hairballPiece4.png": {
                    "x": 665,
                    "y": 664,
                    "w": 43,
                    "h": 23,
                    "ox": 0,
                    "oy": 0,
                    "sw": 43,
                    "sh": 23,
                    "ro": true
                },
                "jellyArrow.png": {
                    "x": 665,
                    "y": 709,
                    "w": 43,
                    "h": 23,
                    "ox": 0,
                    "oy": 0,
                    "sw": 43,
                    "sh": 23,
                    "ro": true
                },
                "hairballPiece9.png": {
                    "x": 626,
                    "y": 929,
                    "w": 41,
                    "h": 31,
                    "ox": 0,
                    "oy": 0,
                    "sw": 41,
                    "sh": 31,
                    "ro": false
                },
                "leftArrow.png": {
                    "x": 133,
                    "y": 684,
                    "w": 31,
                    "h": 41,
                    "ox": 0,
                    "oy": 0,
                    "sw": 31,
                    "sh": 41,
                    "ro": true
                },
                "rightArrow.png": {
                    "x": 690,
                    "y": 717,
                    "w": 31,
                    "h": 41,
                    "ox": 0,
                    "oy": 0,
                    "sw": 31,
                    "sh": 41,
                    "ro": false
                },
                "hairballPiece2.png": {
                    "x": 669,
                    "y": 929,
                    "w": 40,
                    "h": 30,
                    "ox": 0,
                    "oy": 0,
                    "sw": 40,
                    "sh": 30,
                    "ro": false
                },
                "hairballPiece6.png": {
                    "x": 176,
                    "y": 684,
                    "w": 40,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 40,
                    "sh": 26,
                    "ro": false
                },
                "hairballPiece1.png": {
                    "x": 218,
                    "y": 684,
                    "w": 39,
                    "h": 28,
                    "ox": 0,
                    "oy": 0,
                    "sw": 39,
                    "sh": 28,
                    "ro": false
                },
                "hairballPiece8.png": {
                    "x": 216,
                    "y": 924,
                    "w": 38,
                    "h": 36,
                    "ox": 0,
                    "oy": 0,
                    "sw": 38,
                    "sh": 36,
                    "ro": false
                },
                "hairballPiece3.png": {
                    "x": 133,
                    "y": 842,
                    "w": 37,
                    "h": 28,
                    "ox": 0,
                    "oy": 0,
                    "sw": 37,
                    "sh": 28,
                    "ro": true
                },
                "hairballPiece7.png": {
                    "x": 723,
                    "y": 717,
                    "w": 32,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 32,
                    "sh": 24,
                    "ro": true
                },
                "hairballPiece5.png": {
                    "x": 696,
                    "y": 477,
                    "w": 25,
                    "h": 18,
                    "ox": 0,
                    "oy": 0,
                    "sw": 25,
                    "sh": 18,
                    "ro": true
                },
                "eyeDownLeft.png": {
                    "x": 540,
                    "y": 939,
                    "w": 22,
                    "h": 21,
                    "ox": 0,
                    "oy": 0,
                    "sw": 22,
                    "sh": 21,
                    "ro": false
                },
                "eyeDownRight.png": {
                    "x": 564,
                    "y": 939,
                    "w": 22,
                    "h": 21,
                    "ox": 0,
                    "oy": 0,
                    "sw": 22,
                    "sh": 21,
                    "ro": false
                },
                "eggPiece5.png": {
                    "x": 873,
                    "y": 313,
                    "w": 19,
                    "h": 20,
                    "ox": 0,
                    "oy": 0,
                    "sw": 19,
                    "sh": 20,
                    "ro": false
                },
                "eggPiece4.png": {
                    "x": 873,
                    "y": 335,
                    "w": 16,
                    "h": 17,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 17,
                    "ro": true
                },
                "eggPiece1.png": {
                    "x": 873,
                    "y": 353,
                    "w": 15,
                    "h": 16,
                    "ox": 0,
                    "oy": 0,
                    "sw": 15,
                    "sh": 16,
                    "ro": true
                },
                "eggPiece2.png": {
                    "x": 838,
                    "y": 703,
                    "w": 12,
                    "h": 12,
                    "ox": 0,
                    "oy": 0,
                    "sw": 12,
                    "sh": 12,
                    "ro": false
                },
                "eyeSingle.png": {
                    "x": 852,
                    "y": 703,
                    "w": 12,
                    "h": 11,
                    "ox": 0,
                    "oy": 0,
                    "sw": 12,
                    "sh": 11,
                    "ro": true
                },
                "eggPiece3.png": {
                    "x": 746,
                    "y": 848,
                    "w": 1,
                    "h": 1,
                    "ox": 0,
                    "oy": 0,
                    "sw": 19,
                    "sh": 15,
                    "ro": false
                }
            }
        },
        {
            "keys": "bonusShoot.png,boom0.png,boom1.png,boom10.png,boom11.png,boom12.png,boom13.png,boom14.png,boom15.png,boom16.png,boom17.png,boom18.png,boom19.png,boom2.png,boom20.png,boom21.png,boom22.png,boom23.png,boom24.png,boom25.png,boom26.png,boom27.png,boom28.png,boom29.png,boom3.png,boom4.png,boom5.png,boom6.png,boom7.png,boom8.png,boom9.png,bubbleStar1.png,bubbleStar10.png,bubbleStar11.png,bubbleStar12.png,bubbleStar13.png,bubbleStar14.png,bubbleStar15.png,bubbleStar16.png,bubbleStar17.png,bubbleStar18.png,bubbleStar19.png,bubbleStar2.png,bubbleStar20.png,bubbleStar21.png,bubbleStar22.png,bubbleStar23.png,bubbleStar24.png,bubbleStar25.png,bubbleStar26.png,bubbleStar27.png,bubbleStar28.png,bubbleStar29.png,bubbleStar3.png,bubbleStar30.png,bubbleStar31.png,bubbleStar32.png,bubbleStar33.png,bubbleStar34.png,bubbleStar35.png,bubbleStar36.png,bubbleStar37.png,bubbleStar38.png,bubbleStar39.png,bubbleStar4.png,bubbleStar40.png,bubbleStar41.png,bubbleStar42.png,bubbleStar43.png,bubbleStar44.png,bubbleStar45.png,bubbleStar46.png,bubbleStar47.png,bubbleStar48.png,bubbleStar49.png,bubbleStar5.png,bubbleStar50.png,bubbleStar51.png,bubbleStar52.png,bubbleStar53.png,bubbleStar54.png,bubbleStar55.png,bubbleStar56.png,bubbleStar57.png,bubbleStar58.png,bubbleStar59.png,bubbleStar6.png,bubbleStar7.png,bubbleStar8.png,bubbleStar9.png,exLighting0.png,exLighting10.png,exLighting13.png,exLighting15.png,exLighting2.png,exLighting4.png,exLighting6.png,exLighting8.png,stepAni1.png,stepAni10.png,stepAni2.png,stepAni3.png,stepAni4.png,stepAni5.png,stepAni6.png,stepAni7.png,stepAni8.png,stepAni9.png",
            "name": "playSceneEffect",
            "atlas": {
                "stepAni5.png": {
                    "x": 2,
                    "y": 2,
                    "w": 401,
                    "h": 377,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni6.png": {
                    "x": 2,
                    "y": 381,
                    "w": 401,
                    "h": 364,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni7.png": {
                    "x": 405,
                    "y": 2,
                    "w": 401,
                    "h": 367,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": true
                },
                "stepAni2.png": {
                    "x": 2,
                    "y": 747,
                    "w": 361,
                    "h": 400,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": true
                },
                "stepAni3.png": {
                    "x": 774,
                    "y": 2,
                    "w": 400,
                    "h": 400,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni4.png": {
                    "x": 774,
                    "y": 404,
                    "w": 400,
                    "h": 382,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni8.png": {
                    "x": 405,
                    "y": 405,
                    "w": 400,
                    "h": 363,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": true
                },
                "stepAni9.png": {
                    "x": 404,
                    "y": 807,
                    "w": 299,
                    "h": 348,
                    "ox": 102,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": true
                },
                "stepAni1.png": {
                    "x": 754,
                    "y": 807,
                    "w": 250,
                    "h": 290,
                    "ox": 0,
                    "oy": 110,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni10.png": {
                    "x": 2,
                    "y": 1110,
                    "w": 284,
                    "h": 274,
                    "ox": 116,
                    "oy": 65,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "boom19.png": {
                    "x": 288,
                    "y": 1110,
                    "w": 252,
                    "h": 252,
                    "ox": 4,
                    "oy": 4,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom10.png": {
                    "x": 542,
                    "y": 1108,
                    "w": 251,
                    "h": 250,
                    "ox": 5,
                    "oy": 5,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom8.png": {
                    "x": 794,
                    "y": 1099,
                    "w": 251,
                    "h": 250,
                    "ox": 5,
                    "oy": 5,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom9.png": {
                    "x": 1176,
                    "y": 2,
                    "w": 251,
                    "h": 250,
                    "ox": 5,
                    "oy": 5,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom18.png": {
                    "x": 1176,
                    "y": 255,
                    "w": 248,
                    "h": 248,
                    "ox": 6,
                    "oy": 6,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom20.png": {
                    "x": 1176,
                    "y": 505,
                    "w": 248,
                    "h": 247,
                    "ox": 6,
                    "oy": 6,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom17.png": {
                    "x": 1176,
                    "y": 754,
                    "w": 243,
                    "h": 242,
                    "ox": 9,
                    "oy": 9,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom4.png": {
                    "x": 1046,
                    "y": 998,
                    "w": 227,
                    "h": 238,
                    "ox": 17,
                    "oy": 11,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom16.png": {
                    "x": 2,
                    "y": 1386,
                    "w": 234,
                    "h": 234,
                    "ox": 13,
                    "oy": 13,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom15.png": {
                    "x": 238,
                    "y": 1386,
                    "w": 224,
                    "h": 224,
                    "ox": 18,
                    "oy": 18,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom14.png": {
                    "x": 464,
                    "y": 1364,
                    "w": 216,
                    "h": 216,
                    "ox": 22,
                    "oy": 22,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom3.png": {
                    "x": 682,
                    "y": 1361,
                    "w": 202,
                    "h": 211,
                    "ox": 30,
                    "oy": 24,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom26.png": {
                    "x": 886,
                    "y": 1352,
                    "w": 188,
                    "h": 204,
                    "ox": 36,
                    "oy": 29,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom27.png": {
                    "x": 1076,
                    "y": 1227,
                    "w": 190,
                    "h": 204,
                    "ox": 35,
                    "oy": 29,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom28.png": {
                    "x": 1076,
                    "y": 1419,
                    "w": 189,
                    "h": 200,
                    "ox": 36,
                    "oy": 32,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom25.png": {
                    "x": 1428,
                    "y": 2,
                    "w": 182,
                    "h": 198,
                    "ox": 39,
                    "oy": 32,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom13.png": {
                    "x": 1267,
                    "y": 1419,
                    "w": 194,
                    "h": 194,
                    "ox": 33,
                    "oy": 33,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom29.png": {
                    "x": 1428,
                    "y": 202,
                    "w": 178,
                    "h": 191,
                    "ox": 41,
                    "oy": 36,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom24.png": {
                    "x": 1421,
                    "y": 754,
                    "w": 177,
                    "h": 189,
                    "ox": 42,
                    "oy": 37,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom23.png": {
                    "x": 1426,
                    "y": 395,
                    "w": 169,
                    "h": 180,
                    "ox": 47,
                    "oy": 41,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom22.png": {
                    "x": 1006,
                    "y": 788,
                    "w": 160,
                    "h": 173,
                    "ox": 51,
                    "oy": 45,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom21.png": {
                    "x": 1426,
                    "y": 566,
                    "w": 159,
                    "h": 172,
                    "ox": 52,
                    "oy": 45,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom12.png": {
                    "x": 1421,
                    "y": 933,
                    "w": 165,
                    "h": 164,
                    "ox": 48,
                    "oy": 48,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom2.png": {
                    "x": 1282,
                    "y": 1227,
                    "w": 148,
                    "h": 154,
                    "ox": 57,
                    "oy": 53,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom11.png": {
                    "x": 1286,
                    "y": 998,
                    "w": 130,
                    "h": 129,
                    "ox": 65,
                    "oy": 65,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "bonusShoot.png": {
                    "x": 464,
                    "y": 1582,
                    "w": 95,
                    "h": 37,
                    "ox": 0,
                    "oy": 0,
                    "sw": 95,
                    "sh": 37,
                    "ro": false
                },
                "exLighting4.png": {
                    "x": 1286,
                    "y": 1129,
                    "w": 94,
                    "h": 75,
                    "ox": 0,
                    "oy": 13,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting6.png": {
                    "x": 1363,
                    "y": 1129,
                    "w": 94,
                    "h": 73,
                    "ox": 0,
                    "oy": 15,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting10.png": {
                    "x": 1463,
                    "y": 1099,
                    "w": 91,
                    "h": 73,
                    "ox": 5,
                    "oy": 11,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting13.png": {
                    "x": 1463,
                    "y": 1174,
                    "w": 91,
                    "h": 76,
                    "ox": 2,
                    "oy": 12,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting8.png": {
                    "x": 1463,
                    "y": 1252,
                    "w": 90,
                    "h": 70,
                    "ox": 5,
                    "oy": 17,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting0.png": {
                    "x": 1432,
                    "y": 1324,
                    "w": 77,
                    "h": 83,
                    "ox": 7,
                    "oy": 8,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting15.png": {
                    "x": 1511,
                    "y": 1324,
                    "w": 81,
                    "h": 75,
                    "ox": 5,
                    "oy": 13,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting2.png": {
                    "x": 1511,
                    "y": 1401,
                    "w": 77,
                    "h": 80,
                    "ox": 3,
                    "oy": 11,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "boom1.png": {
                    "x": 1463,
                    "y": 1480,
                    "w": 68,
                    "h": 68,
                    "ox": 96,
                    "oy": 96,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "bubbleStar33.png": {
                    "x": 682,
                    "y": 1574,
                    "w": 47,
                    "h": 43,
                    "ox": 19,
                    "oy": 21,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar19.png": {
                    "x": 1006,
                    "y": 963,
                    "w": 46,
                    "h": 33,
                    "ox": 19,
                    "oy": 46,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar20.png": {
                    "x": 1463,
                    "y": 1409,
                    "w": 46,
                    "h": 32,
                    "ox": 19,
                    "oy": 45,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar21.png": {
                    "x": 731,
                    "y": 1574,
                    "w": 46,
                    "h": 32,
                    "ox": 19,
                    "oy": 44,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar22.png": {
                    "x": 1054,
                    "y": 963,
                    "w": 46,
                    "h": 33,
                    "ox": 19,
                    "oy": 42,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar23.png": {
                    "x": 765,
                    "y": 1574,
                    "w": 46,
                    "h": 39,
                    "ox": 19,
                    "oy": 40,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar24.png": {
                    "x": 561,
                    "y": 1582,
                    "w": 46,
                    "h": 38,
                    "ox": 19,
                    "oy": 39,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar25.png": {
                    "x": 806,
                    "y": 1574,
                    "w": 46,
                    "h": 39,
                    "ox": 19,
                    "oy": 37,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar26.png": {
                    "x": 847,
                    "y": 1574,
                    "w": 46,
                    "h": 40,
                    "ox": 19,
                    "oy": 35,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar29.png": {
                    "x": 1556,
                    "y": 1099,
                    "w": 46,
                    "h": 41,
                    "ox": 19,
                    "oy": 29,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar32.png": {
                    "x": 1556,
                    "y": 1142,
                    "w": 46,
                    "h": 42,
                    "ox": 19,
                    "oy": 23,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar34.png": {
                    "x": 1556,
                    "y": 1186,
                    "w": 46,
                    "h": 43,
                    "ox": 19,
                    "oy": 19,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar35.png": {
                    "x": 1556,
                    "y": 1231,
                    "w": 46,
                    "h": 45,
                    "ox": 19,
                    "oy": 16,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar37.png": {
                    "x": 889,
                    "y": 1558,
                    "w": 45,
                    "h": 46,
                    "ox": 20,
                    "oy": 12,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar18.png": {
                    "x": 1046,
                    "y": 1227,
                    "w": 45,
                    "h": 27,
                    "ox": 20,
                    "oy": 47,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar28.png": {
                    "x": 1555,
                    "y": 1278,
                    "w": 45,
                    "h": 41,
                    "ox": 19,
                    "oy": 31,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar30.png": {
                    "x": 936,
                    "y": 1558,
                    "w": 45,
                    "h": 42,
                    "ox": 19,
                    "oy": 27,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar31.png": {
                    "x": 980,
                    "y": 1558,
                    "w": 45,
                    "h": 42,
                    "ox": 19,
                    "oy": 25,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar36.png": {
                    "x": 1024,
                    "y": 1558,
                    "w": 45,
                    "h": 45,
                    "ox": 20,
                    "oy": 14,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar17.png": {
                    "x": 1046,
                    "y": 1274,
                    "w": 44,
                    "h": 27,
                    "ox": 20,
                    "oy": 48,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar27.png": {
                    "x": 1463,
                    "y": 1550,
                    "w": 44,
                    "h": 40,
                    "ox": 20,
                    "oy": 33,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar38.png": {
                    "x": 1432,
                    "y": 1225,
                    "w": 44,
                    "h": 27,
                    "ox": 21,
                    "oy": 29,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar16.png": {
                    "x": 1418,
                    "y": 1099,
                    "w": 43,
                    "h": 27,
                    "ox": 20,
                    "oy": 49,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar39.png": {
                    "x": 1432,
                    "y": 1271,
                    "w": 43,
                    "h": 28,
                    "ox": 21,
                    "oy": 27,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar15.png": {
                    "x": 1463,
                    "y": 1443,
                    "w": 42,
                    "h": 27,
                    "ox": 21,
                    "oy": 50,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar40.png": {
                    "x": 1102,
                    "y": 963,
                    "w": 42,
                    "h": 29,
                    "ox": 22,
                    "oy": 25,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar14.png": {
                    "x": 1282,
                    "y": 1383,
                    "w": 40,
                    "h": 26,
                    "ox": 22,
                    "oy": 52,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar41.png": {
                    "x": 1324,
                    "y": 1383,
                    "w": 40,
                    "h": 30,
                    "ox": 23,
                    "oy": 23,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar13.png": {
                    "x": 1366,
                    "y": 1383,
                    "w": 39,
                    "h": 26,
                    "ox": 22,
                    "oy": 53,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar42.png": {
                    "x": 1006,
                    "y": 998,
                    "w": 38,
                    "h": 31,
                    "ox": 24,
                    "oy": 21,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar12.png": {
                    "x": 1438,
                    "y": 1128,
                    "w": 37,
                    "h": 23,
                    "ox": 23,
                    "oy": 54,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar43.png": {
                    "x": 609,
                    "y": 1582,
                    "w": 37,
                    "h": 30,
                    "ox": 25,
                    "oy": 20,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar11.png": {
                    "x": 1588,
                    "y": 933,
                    "w": 35,
                    "h": 22,
                    "ox": 24,
                    "oy": 56,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar44.png": {
                    "x": 1006,
                    "y": 1031,
                    "w": 35,
                    "h": 31,
                    "ox": 26,
                    "oy": 18,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar10.png": {
                    "x": 1407,
                    "y": 1383,
                    "w": 34,
                    "h": 22,
                    "ox": 25,
                    "oy": 57,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar45.png": {
                    "x": 1006,
                    "y": 1064,
                    "w": 33,
                    "h": 30,
                    "ox": 27,
                    "oy": 17,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar9.png": {
                    "x": 288,
                    "y": 1364,
                    "w": 32,
                    "h": 20,
                    "ox": 26,
                    "oy": 59,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar46.png": {
                    "x": 641,
                    "y": 1582,
                    "w": 31,
                    "h": 29,
                    "ox": 28,
                    "oy": 16,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar8.png": {
                    "x": 1046,
                    "y": 1320,
                    "w": 29,
                    "h": 19,
                    "ox": 27,
                    "oy": 60,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar7.png": {
                    "x": 1146,
                    "y": 963,
                    "w": 27,
                    "h": 11,
                    "ox": 28,
                    "oy": 62,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar47.png": {
                    "x": 1594,
                    "y": 1321,
                    "w": 26,
                    "h": 16,
                    "ox": 33,
                    "oy": 28,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar48.png": {
                    "x": 1426,
                    "y": 727,
                    "w": 25,
                    "h": 15,
                    "ox": 33,
                    "oy": 27,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar49.png": {
                    "x": 936,
                    "y": 1605,
                    "w": 25,
                    "h": 15,
                    "ox": 32,
                    "oy": 25,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar6.png": {
                    "x": 1463,
                    "y": 1596,
                    "w": 24,
                    "h": 11,
                    "ox": 30,
                    "oy": 63,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar5.png": {
                    "x": 1600,
                    "y": 566,
                    "w": 23,
                    "h": 10,
                    "ox": 31,
                    "oy": 65,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar4.png": {
                    "x": 1600,
                    "y": 591,
                    "w": 19,
                    "h": 10,
                    "ox": 32,
                    "oy": 66,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar50.png": {
                    "x": 963,
                    "y": 1605,
                    "w": 19,
                    "h": 15,
                    "ox": 32,
                    "oy": 23,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar51.png": {
                    "x": 984,
                    "y": 1605,
                    "w": 18,
                    "h": 15,
                    "ox": 32,
                    "oy": 21,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar3.png": {
                    "x": 770,
                    "y": 788,
                    "w": 17,
                    "h": 10,
                    "ox": 33,
                    "oy": 67,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar52.png": {
                    "x": 1593,
                    "y": 1401,
                    "w": 17,
                    "h": 15,
                    "ox": 32,
                    "oy": 20,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar53.png": {
                    "x": 1004,
                    "y": 1605,
                    "w": 16,
                    "h": 15,
                    "ox": 32,
                    "oy": 18,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar54.png": {
                    "x": 889,
                    "y": 1606,
                    "w": 15,
                    "h": 14,
                    "ox": 32,
                    "oy": 17,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar2.png": {
                    "x": 1600,
                    "y": 612,
                    "w": 14,
                    "h": 10,
                    "ox": 35,
                    "oy": 68,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar55.png": {
                    "x": 906,
                    "y": 1606,
                    "w": 14,
                    "h": 13,
                    "ox": 32,
                    "oy": 16,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar1.png": {
                    "x": 1600,
                    "y": 628,
                    "w": 12,
                    "h": 10,
                    "ox": 36,
                    "oy": 69,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar58.png": {
                    "x": 754,
                    "y": 1099,
                    "w": 8,
                    "h": 7,
                    "ox": 34,
                    "oy": 17,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar59.png": {
                    "x": 238,
                    "y": 1612,
                    "w": 8,
                    "h": 6,
                    "ox": 35,
                    "oy": 16,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar56.png": {
                    "x": 794,
                    "y": 1352,
                    "w": 7,
                    "h": 6,
                    "ox": 33,
                    "oy": 21,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar57.png": {
                    "x": 1432,
                    "y": 1316,
                    "w": 7,
                    "h": 6,
                    "ox": 34,
                    "oy": 19,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "boom0.png": {
                    "x": 542,
                    "y": 1361,
                    "w": 1,
                    "h": 1,
                    "ox": 0,
                    "oy": 0,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom5.png": {
                    "x": 886,
                    "y": 1558,
                    "w": 1,
                    "h": 1,
                    "ox": 0,
                    "oy": 0,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom6.png": {
                    "x": 1418,
                    "y": 998,
                    "w": 1,
                    "h": 1,
                    "ox": 0,
                    "oy": 0,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom7.png": {
                    "x": 641,
                    "y": 1619,
                    "w": 1,
                    "h": 1,
                    "ox": 0,
                    "oy": 0,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                }
            }
        },
        {
            "keys": "gameGuideBoard.png,gameGuide_1.png,gameGuide_5.png,gameGuide_5_1.png,gameGuide_8.png,gameGuide_8_1.png,guidePropBoom.png,guidePropCow.png,guidePropHammer.png,guidePropHand.png,guidePropMsgPanel.png,guidePropShoe.png,propGuideBoard.png",
            "name": "playSceneGuide",
            "atlas": {
                "propGuideBoard.png": {
                    "x": 2,
                    "y": 2,
                    "w": 636,
                    "h": 601,
                    "ox": 0,
                    "oy": 0,
                    "sw": 636,
                    "sh": 601,
                    "ro": false
                },
                "gameGuide_8_1.png": {
                    "x": 2,
                    "y": 605,
                    "w": 575,
                    "h": 238,
                    "ox": 0,
                    "oy": 0,
                    "sw": 575,
                    "sh": 238,
                    "ro": false
                },
                "gameGuide_8.png": {
                    "x": 640,
                    "y": 2,
                    "w": 565,
                    "h": 238,
                    "ox": 0,
                    "oy": 0,
                    "sw": 565,
                    "sh": 238,
                    "ro": true
                },
                "gameGuide_1.png": {
                    "x": 2,
                    "y": 845,
                    "w": 539,
                    "h": 241,
                    "ox": 0,
                    "oy": 0,
                    "sw": 539,
                    "sh": 241,
                    "ro": false
                },
                "gameGuideBoard.png": {
                    "x": 880,
                    "y": 2,
                    "w": 519,
                    "h": 261,
                    "ox": 0,
                    "oy": 0,
                    "sw": 519,
                    "sh": 261,
                    "ro": true
                },
                "gameGuide_5.png": {
                    "x": 880,
                    "y": 523,
                    "w": 519,
                    "h": 261,
                    "ox": 0,
                    "oy": 0,
                    "sw": 519,
                    "sh": 261,
                    "ro": true
                },
                "gameGuide_5_1.png": {
                    "x": 579,
                    "y": 605,
                    "w": 480,
                    "h": 250,
                    "ox": 0,
                    "oy": 0,
                    "sw": 480,
                    "sh": 250,
                    "ro": true
                },
                "guidePropMsgPanel.png": {
                    "x": 2,
                    "y": 1088,
                    "w": 470,
                    "h": 192,
                    "ox": 0,
                    "oy": 0,
                    "sw": 470,
                    "sh": 192,
                    "ro": false
                },
                "guidePropCow.png": {
                    "x": 1143,
                    "y": 2,
                    "w": 253,
                    "h": 299,
                    "ox": 0,
                    "oy": 0,
                    "sw": 253,
                    "sh": 299,
                    "ro": false
                },
                "guidePropBoom.png": {
                    "x": 474,
                    "y": 1088,
                    "w": 103,
                    "h": 115,
                    "ox": 0,
                    "oy": 0,
                    "sw": 103,
                    "sh": 115,
                    "ro": false
                },
                "guidePropHammer.png": {
                    "x": 579,
                    "y": 1087,
                    "w": 109,
                    "h": 115,
                    "ox": 0,
                    "oy": 0,
                    "sw": 109,
                    "sh": 115,
                    "ro": false
                },
                "guidePropHand.png": {
                    "x": 690,
                    "y": 1087,
                    "w": 113,
                    "h": 113,
                    "ox": 0,
                    "oy": 0,
                    "sw": 113,
                    "sh": 113,
                    "ro": false
                },
                "guidePropShoe.png": {
                    "x": 805,
                    "y": 1087,
                    "w": 102,
                    "h": 109,
                    "ox": 0,
                    "oy": 0,
                    "sw": 102,
                    "sh": 109,
                    "ro": false
                }
            }
        },
        {
            "keys": "chapterNum0.png,chapterNum1.png,chapterNum2.png,chapterNum3.png,chapterNum4.png,chapterNum5.png,chapterNum6.png,chapterNum7.png,chapterNum8.png,chapterNum9.png,chapterNum关.png,chapterNum第.png,propNum0.png,propNum1.png,propNum2.png,propNum3.png,propNum4.png,propNum5.png,propNum6.png,propNum7.png,propNum8.png,propNum9.png,scoreNum0.png,scoreNum1.png,scoreNum2.png,scoreNum3.png,scoreNum4.png,scoreNum5.png,scoreNum6.png,scoreNum7.png,scoreNum8.png,scoreNum9.png,scoreNum当.png,stepNum0.png,stepNum1.png,stepNum2.png,stepNum3.png,stepNum4.png,stepNum5.png,stepNum6.png,stepNum7.png,stepNum8.png,stepNum9.png",
            "name": "playSceneNum",
            "atlas": {
                "scoreNum当.png": {
                    "x": 2,
                    "y": 2,
                    "w": 113,
                    "h": 27,
                    "ox": 0,
                    "oy": 0,
                    "sw": 113,
                    "sh": 27,
                    "ro": false
                },
                "stepNum0.png": {
                    "x": 2,
                    "y": 31,
                    "w": 36,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 36,
                    "sh": 48,
                    "ro": true
                },
                "stepNum3.png": {
                    "x": 52,
                    "y": 31,
                    "w": 34,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 34,
                    "sh": 48,
                    "ro": true
                },
                "stepNum6.png": {
                    "x": 2,
                    "y": 69,
                    "w": 36,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 36,
                    "sh": 48,
                    "ro": true
                },
                "stepNum8.png": {
                    "x": 52,
                    "y": 67,
                    "w": 36,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 36,
                    "sh": 48,
                    "ro": true
                },
                "stepNum9.png": {
                    "x": 2,
                    "y": 107,
                    "w": 36,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 36,
                    "sh": 48,
                    "ro": true
                },
                "stepNum2.png": {
                    "x": 52,
                    "y": 105,
                    "w": 36,
                    "h": 47,
                    "ox": 0,
                    "oy": 0,
                    "sw": 36,
                    "sh": 47,
                    "ro": true
                },
                "stepNum5.png": {
                    "x": 117,
                    "y": 2,
                    "w": 33,
                    "h": 47,
                    "ox": 0,
                    "oy": 0,
                    "sw": 33,
                    "sh": 47,
                    "ro": false
                },
                "stepNum1.png": {
                    "x": 102,
                    "y": 51,
                    "w": 26,
                    "h": 46,
                    "ox": 0,
                    "oy": 0,
                    "sw": 26,
                    "sh": 46,
                    "ro": true
                },
                "stepNum4.png": {
                    "x": 101,
                    "y": 105,
                    "w": 37,
                    "h": 46,
                    "ox": 0,
                    "oy": 0,
                    "sw": 37,
                    "sh": 46,
                    "ro": true
                },
                "stepNum7.png": {
                    "x": 2,
                    "y": 145,
                    "w": 34,
                    "h": 46,
                    "ox": 0,
                    "oy": 0,
                    "sw": 34,
                    "sh": 46,
                    "ro": true
                },
                "chapterNum关.png": {
                    "x": 50,
                    "y": 145,
                    "w": 30,
                    "h": 32,
                    "ox": 0,
                    "oy": 0,
                    "sw": 30,
                    "sh": 32,
                    "ro": false
                },
                "chapterNum第.png": {
                    "x": 82,
                    "y": 144,
                    "w": 29,
                    "h": 32,
                    "ox": 0,
                    "oy": 0,
                    "sw": 29,
                    "sh": 32,
                    "ro": false
                },
                "propNum0.png": {
                    "x": 102,
                    "y": 79,
                    "w": 23,
                    "h": 31,
                    "ox": 0,
                    "oy": 0,
                    "sw": 23,
                    "sh": 31,
                    "ro": true
                },
                "propNum3.png": {
                    "x": 113,
                    "y": 144,
                    "w": 21,
                    "h": 31,
                    "ox": 0,
                    "oy": 0,
                    "sw": 21,
                    "sh": 31,
                    "ro": false
                },
                "propNum6.png": {
                    "x": 152,
                    "y": 2,
                    "w": 23,
                    "h": 31,
                    "ox": 0,
                    "oy": 0,
                    "sw": 23,
                    "sh": 31,
                    "ro": false
                },
                "propNum8.png": {
                    "x": 152,
                    "y": 35,
                    "w": 23,
                    "h": 31,
                    "ox": 0,
                    "oy": 0,
                    "sw": 23,
                    "sh": 31,
                    "ro": false
                },
                "propNum9.png": {
                    "x": 135,
                    "y": 79,
                    "w": 23,
                    "h": 31,
                    "ox": 0,
                    "oy": 0,
                    "sw": 23,
                    "sh": 31,
                    "ro": true
                },
                "propNum2.png": {
                    "x": 149,
                    "y": 104,
                    "w": 23,
                    "h": 30,
                    "ox": 0,
                    "oy": 0,
                    "sw": 23,
                    "sh": 30,
                    "ro": false
                },
                "propNum5.png": {
                    "x": 136,
                    "y": 144,
                    "w": 21,
                    "h": 30,
                    "ox": 0,
                    "oy": 0,
                    "sw": 21,
                    "sh": 30,
                    "ro": false
                },
                "propNum1.png": {
                    "x": 159,
                    "y": 136,
                    "w": 16,
                    "h": 29,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 29,
                    "ro": false
                },
                "propNum4.png": {
                    "x": 177,
                    "y": 2,
                    "w": 23,
                    "h": 29,
                    "ox": 0,
                    "oy": 0,
                    "sw": 23,
                    "sh": 29,
                    "ro": false
                },
                "propNum7.png": {
                    "x": 177,
                    "y": 33,
                    "w": 21,
                    "h": 29,
                    "ox": 0,
                    "oy": 0,
                    "sw": 21,
                    "sh": 29,
                    "ro": false
                },
                "chapterNum0.png": {
                    "x": 174,
                    "y": 68,
                    "w": 16,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 24,
                    "ro": true
                },
                "chapterNum1.png": {
                    "x": 159,
                    "y": 167,
                    "w": 11,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 11,
                    "sh": 24,
                    "ro": true
                },
                "chapterNum2.png": {
                    "x": 168,
                    "y": 86,
                    "w": 16,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 24,
                    "ro": true
                },
                "chapterNum3.png": {
                    "x": 185,
                    "y": 104,
                    "w": 15,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 15,
                    "sh": 24,
                    "ro": false
                },
                "chapterNum4.png": {
                    "x": 177,
                    "y": 130,
                    "w": 18,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 18,
                    "sh": 24,
                    "ro": false
                },
                "chapterNum5.png": {
                    "x": 185,
                    "y": 156,
                    "w": 15,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 15,
                    "sh": 24,
                    "ro": false
                },
                "chapterNum6.png": {
                    "x": 50,
                    "y": 180,
                    "w": 16,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 24,
                    "ro": true
                },
                "chapterNum7.png": {
                    "x": 76,
                    "y": 180,
                    "w": 16,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 24,
                    "ro": true
                },
                "chapterNum8.png": {
                    "x": 102,
                    "y": 180,
                    "w": 16,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 24,
                    "ro": true
                },
                "chapterNum9.png": {
                    "x": 128,
                    "y": 180,
                    "w": 16,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 24,
                    "ro": true
                },
                "scoreNum0.png": {
                    "x": 2,
                    "y": 198,
                    "w": 17,
                    "h": 23,
                    "ox": 0,
                    "oy": 0,
                    "sw": 17,
                    "sh": 23,
                    "ro": true
                },
                "scoreNum3.png": {
                    "x": 27,
                    "y": 198,
                    "w": 16,
                    "h": 23,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 23,
                    "ro": true
                },
                "scoreNum6.png": {
                    "x": 52,
                    "y": 198,
                    "w": 17,
                    "h": 23,
                    "ox": 0,
                    "oy": 0,
                    "sw": 17,
                    "sh": 23,
                    "ro": true
                },
                "scoreNum8.png": {
                    "x": 77,
                    "y": 198,
                    "w": 17,
                    "h": 23,
                    "ox": 0,
                    "oy": 0,
                    "sw": 17,
                    "sh": 23,
                    "ro": true
                },
                "scoreNum9.png": {
                    "x": 102,
                    "y": 198,
                    "w": 17,
                    "h": 23,
                    "ox": 0,
                    "oy": 0,
                    "sw": 17,
                    "sh": 23,
                    "ro": true
                },
                "scoreNum2.png": {
                    "x": 127,
                    "y": 198,
                    "w": 17,
                    "h": 22,
                    "ox": 0,
                    "oy": 0,
                    "sw": 17,
                    "sh": 22,
                    "ro": true
                },
                "scoreNum5.png": {
                    "x": 151,
                    "y": 198,
                    "w": 16,
                    "h": 22,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 22,
                    "ro": true
                },
                "scoreNum1.png": {
                    "x": 154,
                    "y": 182,
                    "w": 13,
                    "h": 21,
                    "ox": 0,
                    "oy": 0,
                    "sw": 13,
                    "sh": 21,
                    "ro": true
                },
                "scoreNum4.png": {
                    "x": 175,
                    "y": 197,
                    "w": 17,
                    "h": 21,
                    "ox": 0,
                    "oy": 0,
                    "sw": 17,
                    "sh": 21,
                    "ro": true
                },
                "scoreNum7.png": {
                    "x": 198,
                    "y": 182,
                    "w": 17,
                    "h": 21,
                    "ox": 0,
                    "oy": 0,
                    "sw": 17,
                    "sh": 21,
                    "ro": true
                }
            }
        }
    ],
    "path": "https://yun.duiba.com.cn/db_games/activity/feile_xiaoxiao/1618484215/resource/"
};


/***/ }),

/***/ "./src/SkinJson.ts":
/*!*************************!*\
  !*** ./src/SkinJson.ts ***!
  \*************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SkinJson = void 0;
exports.SkinJson = {
    "x": 0,
    "y": 0,
    "type": "container",
    "children": [
        {
            "name": "RulePanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "活动规则背景",
                    "x": 80,
                    "y": 310,
                    "type": "sprite",
                    "props": {
                        "source": "活动规则背景.png"
                    }
                },
                {
                    "name": "关闭按钮",
                    "x": 629,
                    "y": 282,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                }
            ]
        },
        {
            "name": "PrizePanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "背景",
                    "x": 55,
                    "y": 376,
                    "type": "sprite",
                    "props": {
                        "source": "prizePanel.png"
                    }
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 500,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                },
                {
                    "name": "文案",
                    "x": 203,
                    "y": 650,
                    "type": "text",
                    "props": {
                        "text": "恭喜获得XX奖品",
                        "size": 34,
                        "fillColor": "#df5942",
                        "textAlpha": 1
                    },
                    "id": "prizeTxt"
                },
                {
                    "name": "prizeImg",
                    "x": 250,
                    "y": 732,
                    "type": "sprite",
                    "props": {
                        "source": ""
                    },
                    "id": "prizeImg"
                },
                {
                    "name": "立即领取",
                    "x": 163,
                    "y": 1002,
                    "type": "button",
                    "props": {
                        "tUp": "prizePanelBtn.png"
                    },
                    "id": "prizeBtn"
                }
            ]
        },
    ]
};


/***/ }),

/***/ "./src/TaoBaoNet.ts":
/*!**************************!*\
  !*** ./src/TaoBaoNet.ts ***!
  \**************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.destroyNetData = exports.getTbData = exports.sendTbNet = exports.TbNetName = void 0;
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var Main_1 = __webpack_require__(/*! ./Main */ "./src/Main.ts");
var TbNetName;
(function (TbNetName) {
    TbNetName["addStats"] = "feile.addStats";
    TbNetName["receiveEnamePrize"] = "feile.receiveEnamePrize";
    TbNetName["getRemainTimes"] = "feile.getRemainTimes";
    TbNetName["doHelp"] = "feile.doHelp";
    TbNetName["getVipInfo"] = "feile.getVipInfo";
    TbNetName["getActivityBaseInfoById"] = "feile.getActivityBaseInfoById";
    TbNetName["updateActivityInfo"] = "mine.updateActivityInfo";
    TbNetName["openMember"] = "mine.openMember";
    TbNetName["getToolsInfo"] = "feile.getToolsInfo";
    TbNetName["consumerTools"] = "feile.consumerTools";
    TbNetName["dojoin"] = "feile.doJoin";
    TbNetName["gameOver"] = "feile.gameOver";
    TbNetName["getTopLevelPrizes"] = "feile.getTopLevelPrizes";
    TbNetName["drawTopLevelPrize"] = "feile.drawTopLevelPrize";
    TbNetName["receiveTaskRewards"] = "babycare.receiveTaskRewards";
    TbNetName["exchange"] = "babycare.exchange";
    TbNetName["getPrizesByLevel"] = "babycare.getPrizesByLevel";
    TbNetName["queryCredits"] = "babycare.queryCredits";
    TbNetName["completeTask"] = "babycare.completeTask";
    TbNetName["getTaskList"] = "babycare.getTaskList";
    TbNetName["luckyDraw"] = "feile.drawTopLevelPrize";
    TbNetName["getAppointCount"] = "babycare.getAppointCount";
    TbNetName["authorize"] = "mine.authorize";
    TbNetName["favorShop"] = "mine.favorShop";
    TbNetName["getUserAddress"] = "mine.getUserAddress";
    TbNetName["getAdoptName"] = "mine.getAdoptName";
    TbNetName["getAppData"] = "mine.getAppData";
    TbNetName["navigateToOutside"] = "mine.navigateToOutside";
    TbNetName["navigateTo"] = "mine.navigateTo";
    TbNetName["navigateBack"] = "mine.navigateBack";
    TbNetName["showSharePanel"] = "mine.showSharePanel";
    TbNetName["openDetail"] = "mine.openDetail";
    TbNetName["openTask"] = "mine.openTask";
    TbNetName["reportAnalytics"] = "mine.reportAnalytics";
    TbNetName["openMusic"] = "mine.openMusic";
})(TbNetName = exports.TbNetName || (exports.TbNetName = {}));
var dataRecord = {};
var fc;
function sendTbNet(netName, parameter, callback, hideMsg) {
    if (hideMsg === void 0) { hideMsg = false; }
    return new Promise(function (resolve, reject) {
        if (!my) {
            var url = "../../mock/miniTb/" + netName + ".json";
            fetchAsync(url)
                .then(function (data) {
                dataRecord[netName] = data;
                if (!hideMsg && !data.success)
                    ctrls_1.showToast(data.message || "网络异常");
                callback && callback(data.success, data);
                resolve(data);
                console.log("\n%c[ mock ]\n"
                    + ("NAME  : " + netName + " \n")
                    + "STATE : %o \n"
                    + "PARAM : %o \n"
                    + "%cDATA  : %o \n", "" + (data.success ? 'color:green' : 'color:red'), data.success, parameter, "" + (data.success ? 'color:green' : 'color:red'), data);
            }, function () {
            });
            return;
        }
        var fun = function (e) {
            Main_1.GDispatcher.removeEventListener(netName, fun);
            var d = e.data;
            dataRecord[netName] = d;
            if (!hideMsg && !d.success)
                ctrls_1.showToast(d.message || "网络超时");
            callback && callback(d.success, d);
            resolve(d);
            console.log("\n%c[ request ]\n"
                + ("NAME  : " + netName + " \n")
                + "STATE : %o \n"
                + "PARAM : %o \n"
                + "%cDATA  : %o \n", "" + (d.success ? 'color:green' : 'color:red'), d.success, parameter, "" + (d.success ? 'color:green' : 'color:red'), d);
        };
        Main_1.GDispatcher.addEventListener(netName, fun);
        Main_1.GDispatcher.dispatchEvent({ type: "onMessage" }, { netName: netName, parameter: parameter });
    });
}
exports.sendTbNet = sendTbNet;
function getTbData(netName) {
    return dataRecord[netName] || null;
}
exports.getTbData = getTbData;
function destroyNetData() {
    dataRecord = {};
}
exports.destroyNetData = destroyNetData;
function fetchAsync(url) {
    return __awaiter(this, void 0, void 0, function () {
        var response, data;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, fetch(url)];
                case 1:
                    response = _a.sent();
                    return [4, response.json()];
                case 2:
                    data = _a.sent();
                    return [2, data];
            }
        });
    });
}
var codeMsg = {
    "210001": "服务器异常",
    "210002": "用户不存在",
    "210003": "邀请已达上限",
    "210004": "无法邀请自己",
    "210006": "该活动ID无效",
    "210009": "该活动暂未开始",
    "210010": "该分享ID不存在",
    "210012": "该用户暂未获奖",
    "210013": "领取失败",
    "210015": "该活动已删除",
    "210016": "该活动已经结束",
    "210017": "该奖品已达领取上线",
    "210018": "请先分享好友",
    "210019": "暂有奖品未领取",
    "210020": "暂有奖品未完成",
    "210021": "请先玩一局游戏",
    "210022": "请先选择奖品",
    "210023": "领取失败，库存不足",
    "210024": "请先成为会员",
    "210025": "奖品已经过期",
    "210026": "不能重复助力",
    "210028": "请至我的奖品页重新领取",
};


/***/ }),

/***/ "./src/Tools.ts":
/*!**********************!*\
  !*** ./src/Tools.ts ***!
  \**********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tools = void 0;
var RES_1 = __webpack_require__(/*! ../module/RES */ "./module/RES.ts");
var layers_1 = __webpack_require__(/*! ../module/views/layers */ "./module/views/layers.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ./TaoBaoNet */ "./src/TaoBaoNet.ts");
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var FailedPanel_1 = __webpack_require__(/*! ./panels/FailedPanel */ "./src/panels/FailedPanel.ts");
var SuccessPrizePanel_1 = __webpack_require__(/*! ./panels/SuccessPrizePanel */ "./src/panels/SuccessPrizePanel.ts");
var SuccessNoPrizePanel_1 = __webpack_require__(/*! ./panels/SuccessNoPrizePanel */ "./src/panels/SuccessNoPrizePanel.ts");
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var Tools = (function () {
    function Tools() {
    }
    Tools.openTask = function () {
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openTask);
    };
    Tools.getGameInfo = function () {
        var _this = this;
        return new Promise(function (r) {
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getActivityBaseInfoById, {}, function (s, res) {
                if (s) {
                    _this.gameData = res.data;
                    TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.updateActivityInfo, { data: JSON.parse(JSON.stringify(res.data)) });
                    Tools.gameData.prizeLevels = [];
                    for (var k in Tools.gameData.levelPrize) {
                        Tools.gameData.prizeLevels.push(+k.split('level')[1]);
                    }
                    Tools.gameData.prizeLevels.sort(function (a, b) { return a - b; });
                    if (my && my.getServerTime) {
                        my.getServerTime({
                            success: function (t) {
                                Tools.actEnd = (+res.data.endTime <= +t.time);
                            },
                            failed: function () {
                                Tools.actEnd = (+res.data.endTime <= Date.now());
                            }
                        });
                    }
                    else {
                        Tools.actEnd = (+res.data.endTime <= Date.now());
                    }
                }
                r(s);
            });
        });
    };
    Tools.consumerTools = function (type) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.consumerTools, { type: type }, function (s, res) { return __awaiter(_this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            if (!s) return [3, 2];
                            return [4, Tools.updateTools()];
                        case 1:
                            _a.sent();
                            resolve(true);
                            return [3, 3];
                        case 2:
                            resolve(false);
                            _a.label = 3;
                        case 3: return [2];
                    }
                });
            }); });
        });
    };
    Tools.updateTools = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getToolsInfo, {}, function (s, res) {
                if (s) {
                    _this.gameData.tools = res.data.tools;
                    resolve(true);
                }
                else {
                    resolve(false);
                }
            });
        });
    };
    Tools.updatePower = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getRemainTimes, {}, function (s, res) {
                if (s) {
                    _this.gameData.power = res.data.power;
                    resolve(true);
                }
                else {
                    resolve(false);
                }
            });
        });
    };
    Tools.gameOver = function (data) {
        if (!data.isVisitSuccess) {
            ctrls_1.showPanel(FailedPanel_1.FailedPanel, data);
        }
        else if (data.level == Tools.maxLevel) {
            ctrls_1.showPanel(SuccessNoPrizePanel_1.SuccessNoPrizePanel, data);
        }
        else if (data.prize && data.prize.type != 5) {
            ctrls_1.showPanel(SuccessPrizePanel_1.SuccessPrizePanel, data);
        }
        else {
            ctrls_1.showPanel(SuccessNoPrizePanel_1.SuccessNoPrizePanel, data);
        }
    };
    Tools.checkPermission = function () {
        return __awaiter(this, void 0, void 0, function () {
            var tbMy, cloud, url, urls;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        tbMy = my;
                        if (!tbMy)
                            return [2];
                        cloud = getApp().cloud;
                        url = "cloud://B4F0300E5148F478B506DEDC26EA4C6C//butterfly0.svga";
                        return [4, cloud.file.getTempFileURL({ fileId: [url] })];
                    case 1:
                        urls = _a.sent();
                        url = urls[0].url.replace('-internal', '');
                        tbMy.downloadFile({
                            url: url,
                            success: function (res) {
                                var i = res.apFilePath;
                                tbMy.getFileSystemManager().readFile({
                                    filePath: i,
                                    success: function (r) {
                                    },
                                    fail: function (res) {
                                    }
                                });
                            },
                            fail: function (res) {
                            },
                        });
                        return [2];
                }
            });
        });
    };
    Tools.getSprite = function (imageName, x, y) {
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var sprite = new FYGE.Sprite(RES_1.RES.getRes(imageName));
        sprite.x = x;
        sprite.y = y;
        return sprite;
    };
    Tools.getText = function (txt, size, color, align, textWidth, x, y) {
        if (color === void 0) { color = "#000000"; }
        if (align === void 0) { align = FYGE.TEXT_ALIGN.LEFT; }
        if (textWidth === void 0) { textWidth = 0; }
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var text = new FYGE.TextField();
        text.fillColor = color;
        text.size = size;
        text.textWidth = textWidth;
        text.textAlign = align;
        text.x = x;
        text.y = y;
        text.text = txt;
        return text;
    };
    Tools.getRect = function (width, height, color, alpha, radius, x, y) {
        if (color === void 0) { color = 0xff0000; }
        if (alpha === void 0) { alpha = 1; }
        if (radius === void 0) { radius = 0; }
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var g = new FYGE.Graphics();
        g.beginFill(color);
        g.alpha = alpha;
        if (!radius) {
            g.drawRect(0, 0, width, height);
        }
        else {
            g.drawRoundedRect(0, 0, width, height, radius);
        }
        g.endFill();
        g.position.set(x, y);
        return g;
    };
    Tools.getCircle = function (radius, color, alpha, x, y) {
        if (radius === void 0) { radius = 10; }
        if (color === void 0) { color = 0xff0000; }
        if (alpha === void 0) { alpha = 1; }
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var g = new FYGE.Graphics();
        g.beginFill(color);
        g.alpha = alpha;
        g.drawCircle(0, 0, radius);
        g.endFill();
        g.position.set(x, y);
        return g;
    };
    Tools.getAdjustHeight = function (maxDis, minDis, type) {
        if (type === void 0) { type = "bot"; }
        var offsetY = (function () {
            if (type == "top")
                return 0;
            if (type == "bot")
                return layers_1.layers.stageOffsetY * 2;
            return layers_1.layers.stageOffsetY;
        })();
        if (layers_1.layers.stageHeight <= 1206)
            return minDis + offsetY;
        return (layers_1.layers.stageHeight - 1206) / (1624 - 1206) * (maxDis - minDis) + minDis + offsetY;
    };
    Tools.changeTextAlign = function (text, align, textWidth) {
        if (align == FYGE.TEXT_ALIGN.LEFT)
            return;
        text.textAlign = align;
        if (!textWidth)
            return;
        if (align == FYGE.TEXT_ALIGN.CENTER)
            text.x -= (textWidth - text.textWidth) / 2;
        if (align == FYGE.TEXT_ALIGN.RIGHT)
            text.x -= textWidth - text.textWidth;
        text.textWidth = textWidth;
    };
    Tools.customToast = function (target, call, time, showTime) {
        if (call === void 0) { call = function () { return 0; }; }
        if (time === void 0) { time = 2000; }
        if (showTime === void 0) { showTime = 300; }
        Tween.get(target)
            .set({ alpha: 0, visible: true })
            .to({ alpha: 1 }, showTime, Ease.quadIn)
            .wait(time)
            .to({ alpha: 0 }, showTime, Ease.quadOut)
            .set({ alpha: 0, visible: false })
            .call(function () {
            call();
        });
    };
    Tools.btnDelay = function (target, delay) {
        if (delay === void 0) { delay = 2000; }
        target.mouseEnable = false;
        target.mouseChildren = false;
        setTimeout(function () {
            target.mouseEnable = true;
            target.mouseChildren = true;
        }, delay);
    };
    Tools.getNumTextures = function (name) {
        var arr = {};
        for (var i = 0; i <= 9; i++)
            arr[i] = RES_1.RES.getRes(name + i + ".png");
        return arr;
    };
    Tools.addSteps = 5;
    Tools.maxLevel = 99;
    Tools.musicOn = true;
    Tools.cacheKey = "guideFLXXL";
    Tools.actEnd = false;
    return Tools;
}());
exports.Tools = Tools;


/***/ }),

/***/ "./src/common/G_EVENT.ts":
/*!*******************************!*\
  !*** ./src/common/G_EVENT.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.G_EVENT = void 0;
var G_EVENT;
(function (G_EVENT) {
    G_EVENT["ON_SHOW"] = "onShow";
    G_EVENT["ON_HIDE"] = "onHide";
    G_EVENT["UPDATE_TASK"] = "UpdateTask";
})(G_EVENT = exports.G_EVENT || (exports.G_EVENT = {}));


/***/ }),

/***/ "./src/common/ProgressBarS.ts":
/*!************************************!*\
  !*** ./src/common/ProgressBarS.ts ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ProgressBarS = void 0;
var ProgressBarS = (function () {
    function ProgressBarS(upImage, txt) {
        this._value = 0;
        this.maxLength = upImage.width;
        this.upImage = upImage;
        this.progressTxt = txt;
        this.oriX = upImage.x;
        var delta = 0;
        if (upImage instanceof FYGE.FrameAni)
            delta = 0.5;
        this.upImage.mask = this.upImage.parent.addChild(new FYGE.Graphics())
            .beginFill(0xf8c862)
            .drawRoundedRect(upImage.x - upImage.width * delta, upImage.y - upImage.height * delta, upImage.width, upImage.height, 111)
            .endFill();
        this.value = 0;
    }
    Object.defineProperty(ProgressBarS.prototype, "value", {
        get: function () {
            return this._value;
        },
        set: function (v) {
            if (v < 0)
                v = 0;
            if (v > 1)
                v = 1;
            this._value = v;
            if (this.progressTxt)
                this.progressTxt.text = ((v * 100) >> 0) + "%";
            this.upImage.x = this.oriX - (1 - this._value) * this.maxLength;
        },
        enumerable: false,
        configurable: true
    });
    return ProgressBarS;
}());
exports.ProgressBarS = ProgressBarS;


/***/ }),

/***/ "./src/lotties/BonusTime.ts":
/*!**********************************!*\
  !*** ./src/lotties/BonusTime.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.BonusTime = void 0;
exports.BonusTime = {
    "fr": 30,
    "ip": 0,
    "op": 66,
    "w": 700,
    "h": 720,
    "nm": "BonusTime",
    "layers": [
        {
            "ind": 1,
            "ty": 2,
            "nm": "图层 93 拷贝 3",
            "refId": "5d6129c5-6206-47d5-bb42-b9274ad37e9d",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                365,
                                320.5,
                                0
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                254,
                                332.5,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "k": [
                        3,
                        3.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        {
                            "t": 18,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                14,
                                14,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 11,
            "op": 30
        },
        {
            "ind": 2,
            "ty": 2,
            "nm": "图层 93 拷贝 4",
            "refId": "5d6129c5-6206-47d5-bb42-b9274ad37e9d",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                365,
                                320.5,
                                0
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                585,
                                389.5,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "k": [
                        3,
                        3.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        {
                            "t": 18,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                14,
                                14,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 11,
            "op": 30
        },
        {
            "ind": 3,
            "ty": 2,
            "nm": "图层 93 拷贝 2",
            "refId": "5d6129c5-6206-47d5-bb42-b9274ad37e9d",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                365,
                                320.5,
                                0
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                490,
                                339.5,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "k": [
                        3,
                        3.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        {
                            "t": 18,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                14,
                                14,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 11,
            "op": 30
        },
        {
            "ind": 4,
            "ty": 2,
            "nm": "图层 1312 拷贝",
            "refId": "2e5f1f43-9af3-4b9b-a8fc-db17964eecb6",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 13,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                365,
                                320.5,
                                0
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                216.5,
                                359.5,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "k": [
                        10.5,
                        9.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        {
                            "t": 18,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                14,
                                14,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 11,
            "op": 30
        },
        {
            "ind": 5,
            "ty": 2,
            "nm": "图层 1312 拷贝 2",
            "refId": "2e5f1f43-9af3-4b9b-a8fc-db17964eecb6",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                365,
                                320.5,
                                0
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                353.5,
                                220.5,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "k": [
                        10.5,
                        9.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        {
                            "t": 18,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                14,
                                14,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 11,
            "op": 30
        },
        {
            "ind": 6,
            "ty": 2,
            "nm": "图层 1312",
            "refId": "2e5f1f43-9af3-4b9b-a8fc-db17964eecb6",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                365,
                                320.5,
                                0
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                240.5,
                                119.5,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "k": [
                        10.5,
                        9.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        {
                            "t": 18,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                14,
                                14,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 11,
            "op": 30
        },
        {
            "ind": 7,
            "ty": 2,
            "nm": "图层 1313",
            "refId": "2d6cba7b-b5f7-42ef-81e9-bb15a5e6266b",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 60,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 66,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                486.5,
                                495,
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                486.5,
                                483,
                                0
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                486.5,
                                495,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "k": [
                        123.5,
                        132,
                        0
                    ]
                },
                "s": {
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                0,
                                0,
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                122,
                                142,
                                100
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                104,
                                90,
                                100
                            ]
                        },
                        {
                            "t": 25,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 66,
                            "s": [
                                128,
                                0,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 900
        },
        {
            "ind": 8,
            "ty": 2,
            "nm": "Bonus Time",
            "refId": "24131c00-9062-43a1-b52d-00d788f75b79",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 60,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 66,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                246,
                                495,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                246,
                                470,
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                246,
                                495,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "k": [
                        146,
                        131,
                        0
                    ]
                },
                "s": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0,
                                0,
                                100
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                122,
                                142,
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                104,
                                90,
                                100
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 66,
                            "s": [
                                128,
                                0,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 900
        },
        {
            "ind": 9,
            "ty": 2,
            "nm": "boa旋风箭头",
            "refId": "52e8af6a-f83c-4c95-9f44-d5bb1c20493b",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 10,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 66,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                -28
                            ]
                        },
                        {
                            "t": 10,
                            "s": [
                                20
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "k": [
                        373,
                        325,
                        0
                    ]
                },
                "a": {
                    "k": [
                        165,
                        137,
                        0
                    ]
                },
                "s": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                20,
                                20,
                                100
                            ]
                        },
                        {
                            "t": 10,
                            "s": [
                                112,
                                112,
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 900
        },
        {
            "ind": 10,
            "ty": 2,
            "nm": "boa",
            "refId": "b9f72eac-22ea-4505-b043-24c8a83acd05",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 16,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 20,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 66,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        284,
                        304,
                        0
                    ]
                },
                "a": {
                    "k": [
                        51,
                        32,
                        0
                    ]
                },
                "s": {
                    "k": [
                        {
                            "t": 16,
                            "s": [
                                20,
                                20,
                                100
                            ]
                        },
                        {
                            "t": 31,
                            "s": [
                                112,
                                112,
                                100
                            ]
                        },
                        {
                            "t": 39,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 16,
            "op": 900
        },
        {
            "ind": 11,
            "ty": 2,
            "nm": "龙卷风",
            "refId": "778a9647-034e-4fad-8a79-d9226ae2ed5d",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 14,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 18,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 66,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "k": [
                        {
                            "t": 14,
                            "s": [
                                -11
                            ]
                        },
                        {
                            "t": 23,
                            "s": [
                                5
                            ]
                        },
                        {
                            "t": 28,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "k": [
                        313,
                        307.5,
                        0
                    ]
                },
                "a": {
                    "k": [
                        168,
                        197.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        {
                            "t": 14,
                            "s": [
                                8,
                                8,
                                100
                            ]
                        },
                        {
                            "t": 23,
                            "s": [
                                106,
                                106,
                                100
                            ]
                        },
                        {
                            "t": 28,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 14,
            "op": 900
        },
        {
            "ind": 12,
            "ty": 2,
            "nm": "星球",
            "refId": "93ea4980-6258-4413-bbd7-3260e1117bb6",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 60,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 66,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        510,
                        435,
                        0
                    ]
                },
                "a": {
                    "k": [
                        60,
                        104,
                        0
                    ]
                },
                "s": {
                    "k": [
                        {
                            "t": 18,
                            "s": [
                                0,
                                0,
                                100
                            ]
                        },
                        {
                            "t": 24,
                            "s": [
                                122,
                                142,
                                100
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                104,
                                90,
                                100
                            ]
                        },
                        {
                            "t": 34,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 900
        },
        {
            "ind": 13,
            "ty": 2,
            "nm": "椭圆 1334 拷贝 3",
            "refId": "7d410e98-3af4-4bb8-98ac-acf1a8bd48fa",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 19,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 27,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                344.5,
                                324.5,
                                0
                            ]
                        },
                        {
                            "t": 27,
                            "s": [
                                200.5,
                                235.5,
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                200.5,
                                235.5,
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "a": {
                    "k": [
                        12.5,
                        12.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 900
        },
        {
            "ind": 14,
            "ty": 2,
            "nm": "椭圆 1334 拷贝 2",
            "refId": "796267bf-092e-44c9-999b-574d305c8769",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 25,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                344.5,
                                324.5,
                                0
                            ]
                        },
                        {
                            "t": 25,
                            "s": [
                                154,
                                269,
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                154,
                                269,
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "a": {
                    "k": [
                        11,
                        11,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 900
        },
        {
            "ind": 15,
            "ty": 2,
            "nm": "椭圆 1334 拷贝",
            "refId": "796267bf-092e-44c9-999b-574d305c8769",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 22,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                344.5,
                                324.5,
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                472,
                                327,
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "a": {
                    "k": [
                        11,
                        11,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 900
        },
        {
            "ind": 16,
            "ty": 2,
            "nm": "椭圆 1334 拷贝 4",
            "refId": "6e5ccdc9-ce62-4e1b-88ca-0e269f492ec1",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 20,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 28,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                344.5,
                                324.5,
                                0
                            ]
                        },
                        {
                            "t": 28,
                            "s": [
                                322,
                                88,
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                322,
                                88,
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "a": {
                    "k": [
                        12,
                        12,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 900
        },
        {
            "ind": 17,
            "ty": 2,
            "nm": "椭圆 1334 拷贝 5",
            "refId": "6e5ccdc9-ce62-4e1b-88ca-0e269f492ec1",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 22,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                344.5,
                                324.5,
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                505,
                                158,
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "a": {
                    "k": [
                        12,
                        12,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 900
        },
        {
            "ind": 18,
            "ty": 2,
            "nm": "椭圆 1334",
            "refId": "6e5ccdc9-ce62-4e1b-88ca-0e269f492ec1",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 24,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                344.5,
                                324.5,
                                0
                            ]
                        },
                        {
                            "t": 24,
                            "s": [
                                528,
                                267,
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                528,
                                267,
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "a": {
                    "k": [
                        12,
                        12,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 900
        },
        {
            "ind": 19,
            "ty": 2,
            "nm": "发光",
            "refId": "18986110-634a-4248-a956-b2861424ff16",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 60,
                            "s": [
                                60
                            ]
                        },
                        {
                            "t": 66,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "k": 0,
                    "x": "var $bm_rt;\n$bm_rt = $bm_mul(time, 60);"
                },
                "p": {
                    "k": [
                        359,
                        342.5,
                        0
                    ]
                },
                "a": {
                    "k": [
                        452,
                        382.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        {
                            "t": 10,
                            "s": [
                                0,
                                0,
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 900
        }
    ],
    "markers": []
};


/***/ }),

/***/ "./src/panels/FailedPanel.ts":
/*!***********************************!*\
  !*** ./src/panels/FailedPanel.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.FailedPanel = void 0;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var MapScene_1 = __webpack_require__(/*! ../scene/map/MapScene */ "./src/scene/map/MapScene.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var MouseEvent = FYGE.MouseEvent;
var Button = FYGE.Button;
var FailedPanel = (function (_super) {
    __extends(FailedPanel, _super);
    function FailedPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(FailedPanel.prototype, "groupNames", {
        get: function () {
            return ["FailedPanel"];
        },
        enumerable: false,
        configurable: true
    });
    FailedPanel.prototype.initUi = function () {
        this.addChild(Tools_1.Tools.getSprite('failedTxt.png')).position.set(80, 274);
        this.addChild(new Button(RES_1.RES.getRes("failedBtn.png")))
            .addEventListener(MouseEvent.CLICK, this.again, this)
            .position.set(185, 921);
        this.addChild(new Button(RES_1.RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, this.hidePanel, this)
            .position.set(629, 469);
    };
    FailedPanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    FailedPanel.prototype.hidePanel = function () {
        ctrls_1.changeScene(MapScene_1.MapScene);
        _super.prototype.hidePanel.call(this);
    };
    FailedPanel.prototype.again = function () {
        ctrls_1.changeScene(MapScene_1.MapScene, { level: this.data.level });
        _super.prototype.hidePanel.call(this);
    };
    return FailedPanel;
}(Panel_1.Panel));
exports.FailedPanel = FailedPanel;


/***/ }),

/***/ "./src/panels/FreePowerPanel.ts":
/*!**************************************!*\
  !*** ./src/panels/FreePowerPanel.ts ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.FreePowerPanel = void 0;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var Button = FYGE.Button;
var MouseEvent = FYGE.MouseEvent;
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var FreePowerPanel = (function (_super) {
    __extends(FreePowerPanel, _super);
    function FreePowerPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(FreePowerPanel.prototype, "groupNames", {
        get: function () {
            return ["FreePowerPanel"];
        },
        enumerable: false,
        configurable: true
    });
    FreePowerPanel.prototype.initUi = function () {
        _super.prototype.initUi.call(this);
        this.addChild(Tools_1.Tools.getSprite('freePowerBg.png')).position.set(80, 274);
        this.addChild(new Button(RES_1.RES.getRes('freePowerBtn.png')))
            .addEventListener(MouseEvent.CLICK, this.hidePanel, this)
            .position.set(185, 943);
        this.addChild(Tools_1.Tools.getSprite('powerIcon.png')).position.set(280, 801);
        var powerTxt = this.addChild(Tools_1.Tools.getText("+" + this.data.loginAddPower, 48, "#ffffff", TEXT_ALIGN.LEFT));
        powerTxt.position.set(400, 823);
        this.addChild(new Button(RES_1.RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, this.hidePanel, this)
            .position.set(629, 469);
    };
    FreePowerPanel.prototype.hidePanel = function () {
        _super.prototype.hidePanel.call(this);
    };
    return FreePowerPanel;
}(Panel_1.Panel));
exports.FreePowerPanel = FreePowerPanel;


/***/ }),

/***/ "./src/panels/HelpPanel.ts":
/*!*********************************!*\
  !*** ./src/panels/HelpPanel.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelpPanel = void 0;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var Button = FYGE.Button;
var MouseEvent = FYGE.MouseEvent;
var HelpPanel = (function (_super) {
    __extends(HelpPanel, _super);
    function HelpPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(HelpPanel.prototype, "groupNames", {
        get: function () {
            return ["HelpPanel"];
        },
        enumerable: false,
        configurable: true
    });
    HelpPanel.prototype.initUi = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this;
                        return [4, this.queryVip()];
                    case 1:
                        _a.vip = _b.sent();
                        return [2];
                }
            });
        });
    };
    HelpPanel.prototype.start = function (data) {
        var _this = this;
        _super.prototype.start.call(this);
        this.addChild(Tools_1.Tools.getSprite('helpBg.png')).position.set(80, 549);
        this.addChild(new Button(RES_1.RES.getRes('helpBtn.png')))
            .addEventListener(MouseEvent.CLICK, this.doHelp, this)
            .position.set(185, 910);
        this.addChild(new Button(RES_1.RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, function () { return _this.hidePanel(); })
            .position.set(629, 520);
    };
    HelpPanel.prototype.hidePanel = function () {
        _super.prototype.hidePanel.call(this);
        Tools_1.Tools.globalData.inviteId = '';
    };
    HelpPanel.prototype.doHelp = function (e) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.btnDelay(e.target);
                        if (Tools_1.Tools.globalData.inviteId == Tools_1.Tools.globalData.openId) {
                            ctrls_1.showToast('自己不能给自己助力');
                            this.hidePanel();
                            return [2];
                        }
                        if (this.vip) {
                            this.hidePanel();
                            return [2];
                        }
                        return [4, this.queryVip()];
                    case 1:
                        if (_a.sent()) {
                            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.doHelp, { inviteId: Tools_1.Tools.globalData.inviteId }, function (success, res) {
                                if (!success) {
                                    ctrls_1.showToast(res.message);
                                    _this.hidePanel();
                                    return;
                                }
                                ctrls_1.showToast('接受邀请成功');
                                _this.hidePanel();
                            });
                        }
                        else {
                            ctrls_1.showToast('请先加入会员');
                            setTimeout(function () {
                                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openMember);
                            }, 1500);
                        }
                        return [2];
                }
            });
        });
    };
    HelpPanel.prototype.queryVip = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, success, data;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getVipInfo)];
                    case 1:
                        _a = _b.sent(), success = _a.success, data = _a.data;
                        return [2, success && data.isVip];
                }
            });
        });
    };
    HelpPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
    };
    HelpPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
    };
    return HelpPanel;
}(Panel_1.Panel));
exports.HelpPanel = HelpPanel;


/***/ }),

/***/ "./src/panels/LotteryPanel.ts":
/*!************************************!*\
  !*** ./src/panels/LotteryPanel.ts ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LotteryPanel = void 0;
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var GTool_1 = __webpack_require__(/*! ../../module/tools/GTool */ "./module/tools/GTool.ts");
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var LotteryPanel = (function (_super) {
    __extends(LotteryPanel, _super);
    function LotteryPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(LotteryPanel.prototype, "groupNames", {
        get: function () { return ["lotteryScene"]; },
        enumerable: false,
        configurable: true
    });
    LotteryPanel.prototype.initUi = function () {
        var _this = this;
        this.addChild(new FYGE.Sprite(RES_1.RES.getRes("lotteryMachineBg.png")));
        this.lotBtn = this.addChild(new FYGE.Button(RES_1.RES.getRes("lotteryBtn.png")))
            .addEventListener(FYGE.MouseEvent.CLICK, this.lottery, this);
        this.lotBtn.position.set((750 - RES_1.RES.getRes("lotteryBtn.png").width) / 2, 1170);
        this.useBtn = this.addChild(new FYGE.Button(RES_1.RES.getRes("老虎机领取奖励.png")))
            .addEventListener(FYGE.MouseEvent.CLICK, this.getPrize, this);
        this.useBtn.position.set((750 - RES_1.RES.getRes("老虎机领取奖励.png").width) / 2, 1170);
        this.useBtn.visible = false;
        this.thanksBtn = this.addChild(new FYGE.Button(RES_1.RES.getRes("老虎机好的.png")))
            .addEventListener(FYGE.MouseEvent.CLICK, this.hidePanel, this);
        this.thanksBtn.position.set((750 - RES_1.RES.getRes("老虎机好的.png").width) / 2, 1170);
        this.thanksBtn.visible = false;
        this.addChild(new FYGE.Sprite(RES_1.RES.getRes("lotteryReturnBtn.png")))
            .addEventListener(FYGE.MouseEvent.CLICK, function () {
            _this.hidePanel();
        }, this)
            .position.set(0, 250);
        this.addChild(Tools_1.Tools.getText("\u901A\u5173\u62BD\u5956\u5956\u52B1", 36, "#ffffff", FYGE.TEXT_ALIGN.CENTER, 750, 0, 1103));
        this.updatePrizes();
    };
    LotteryPanel.prototype.getPrize = function (e) {
        var _this = this;
        this.btnDelay(e.target);
        var _a = this.prizeData, type = _a.type, _id = _a._id;
        switch (type) {
            case 1:
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.receiveEnamePrize, { _id: _id, id: _id }, function (success, res) {
                    if (!success || !res) {
                        ctrls_1.showToast('奖品发放失败\n请前往我的奖品处进行处理');
                        _this.hidePanel();
                        return;
                    }
                    if (res.data && res.data.drawStatus == 3) {
                        ctrls_1.showToast('奖品发放成功\n请前往我的奖品处查看');
                    }
                    else {
                        ctrls_1.showToast('奖品发放失败\n请前往我的奖品处进行处理');
                    }
                    _this.data.callFun && _this.data.callFun();
                    _this.hidePanel();
                }, true);
                break;
            case 3:
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getUserAddress, { prizeId: _id }, function (success, res) {
                    if (!success) {
                        return;
                    }
                    ctrls_1.showToast('奖品发放成功\n请前往我的奖品处查看');
                    _this.hidePanel();
                }, true);
                break;
            case 2:
            case 5:
                this.hidePanel();
                break;
        }
    };
    LotteryPanel.prototype.hidePanel = function () {
        this.data.callFun && this.data.callFun();
        _super.prototype.hidePanel.call(this);
    };
    LotteryPanel.prototype.updatePrizes = function () {
        return __awaiter(this, void 0, void 0, function () {
            var prizeList, list, p;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        ctrls_1.showWaiting();
                        return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getTopLevelPrizes)];
                    case 1:
                        prizeList = (_a.sent()).data;
                        list = prizeList.slice().filter(function (e) {
                            return e.type != 5;
                        });
                        p = [91, 738];
                        list.push({
                            activityId: "6073afbd9da67145df2c6bf3",
                            image: "https://yun.duiba.com.cn/aurora/assets/40e9968aa117e43b37442e0bd16ff8e22b65acae.png",
                            name: "谢谢参与",
                            type: 5,
                            _id: "thanks",
                        });
                        this.lotScroll = this.addChild(new LotteryScroll(list));
                        this.lotScroll.position.set(p[0], p[1]);
                        console.log(this.lotScroll.position);
                        return [2];
                }
            });
        });
    };
    LotteryPanel.prototype.lottery = function () {
        var _this = this;
        ctrls_1.showWaiting();
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.drawTopLevelPrize)
            .then(function (res) {
            ctrls_1.hideWaiting();
            if (!res.success)
                return;
            Tools_1.Tools.gameData.isDrawTopLevelPrize = true;
            var id;
            if (res.data && res.data.type == 5) {
                id = 'thanks';
            }
            else if (res.data && res.data.prizeId) {
                id = res.data.prizeId;
            }
            _this.enableMouseEvt(false);
            console.log(id);
            _this.prizeData = res.data;
            _this.lotScroll.lot(id, function () {
                _this.enableMouseEvt(true);
                _this.lotBtn.visible = false;
                if (!id || res.data.type == 5) {
                    _this.thanksBtn.visible = true;
                }
                else {
                    _this.useBtn.visible = true;
                }
            });
        });
    };
    return LotteryPanel;
}(Panel_1.Panel));
exports.LotteryPanel = LotteryPanel;
var LotteryItem = (function (_super) {
    __extends(LotteryItem, _super);
    function LotteryItem(data) {
        var _this = _super.call(this) || this;
        _this.id = data._id;
        _this.showImage = _this.addChild(new FYGE.Sprite(FYGE.Texture.from(data.image)));
        _this.showImage.width = _this.showImage.height = 160;
        var mask = _this.addChild(new FYGE.Shape());
        mask.beginFill(0);
        mask.drawRoundedRect(0, 0, 160, 160, 15);
        mask.endFill();
        _this.showImage.mask = mask;
        return _this;
    }
    LotteryItem.prototype.reset = function (data) {
        this.showImage.texture = FYGE.Texture.from(data.image);
        this.id = data._id;
    };
    return LotteryItem;
}(FYGE.Container));
var HEIGHT = 200;
var LotteryScrollItem = (function (_super) {
    __extends(LotteryScrollItem, _super);
    function LotteryScrollItem(datas) {
        var _this = _super.call(this) || this;
        datas.forEach(function (d) {
            _this.addChild(new LotteryItem(d));
        });
        _this.cusP = 0;
        _this.updatePosition();
        _this.addEventListener(FYGE.Event.ENTER_FRAME, _this.updatePosition, _this);
        return _this;
    }
    Object.defineProperty(LotteryScrollItem.prototype, "currentIndex", {
        get: function () {
            var a = 1 - this.cusP;
            var l = this.children.length;
            return a < 0 ? a % l + l : a % l;
        },
        enumerable: false,
        configurable: true
    });
    ;
    LotteryScrollItem.prototype.scrollTo = function (id, callback) {
        var child, curIndex;
        for (var i = 0; i < this.children.length; i++) {
            if (this.children[i].id == id) {
                child = this.children[i];
                curIndex = i;
                break;
            }
        }
        var delta = this.currentIndex - curIndex;
        if (delta < 0)
            delta += this.children.length;
        var cusP = this.cusP + delta + 10 * this.children.length;
        FYGE.Tween.get(this)
            .to({ cusP: cusP }, 5000, FYGE.Ease.quadInOut)
            .call(function () {
            callback && callback();
        });
    };
    LotteryScrollItem.prototype.reset = function () {
    };
    LotteryScrollItem.prototype.updatePosition = function () {
        var _this = this;
        this.children.forEach(function (c, j) {
            c.y = ((_this.cusP + j) % _this.children.length) * HEIGHT - HEIGHT;
            if (c.y > HEIGHT * 1.5) {
                c.y = c.y - _this.children.length * HEIGHT;
            }
        });
    };
    LotteryScrollItem.prototype.destroy = function () {
        FYGE.Tween.removeTweens(this);
        _super.prototype.destroy.call(this);
    };
    return LotteryScrollItem;
}(FYGE.Container));
var LotteryScroll = (function (_super) {
    __extends(LotteryScroll, _super);
    function LotteryScroll(datas) {
        var _this = _super.call(this) || this;
        _this.scrollItems = [];
        for (var i = 0; i < 3; i++) {
            var s = _this.addChild(new LotteryScrollItem(GTool_1.GTool.disturbArr(datas.slice())));
            s.position.set(208 * i, 0);
            _this.scrollItems.push(s);
        }
        _this.ids = [];
        datas.forEach(function (d) { _this.ids.push(d._id); });
        var h = -130;
        var mask = _this.addChild(new FYGE.Shape());
        mask.beginFill(0);
        mask.drawRoundedRect(-6, h + 3, 590, 417, 19);
        mask.endFill();
        _this.mask = mask;
        return _this;
    }
    LotteryScroll.prototype.lot = function (id, callback) {
        var _this = this;
        if (id && this.ids.indexOf(id) != -1) {
            var count_1 = 0;
            var countAll_1 = this.scrollItems.length;
            this.scrollItems.forEach(function (c, i) {
                ctrls_1.wait(function () {
                    c.scrollTo(id, function () {
                        if (++count_1 == countAll_1 && callback)
                            callback();
                    });
                }, 400 * i);
            });
        }
        else {
            var ids = [
                GTool_1.GTool.randomT(this.ids),
                GTool_1.GTool.randomT(this.ids),
            ];
            ids[0] === ids[1] ? ids.push(GTool_1.GTool.randomT((function () {
                var arr = _this.ids.slice();
                arr.splice(_this.ids.indexOf(ids[0]), 1);
                return arr;
            })())) : ids.push(GTool_1.GTool.randomT(this.ids));
            var count_2 = 0;
            var countAll_2 = this.scrollItems.length;
            this.scrollItems.forEach(function (c, i) {
                ctrls_1.wait(function () {
                    c.scrollTo(ids[i], function () {
                        if (++count_2 == countAll_2 && callback)
                            callback();
                    });
                }, 400 * i);
            });
        }
    };
    return LotteryScroll;
}(FYGE.Container));


/***/ }),

/***/ "./src/panels/NoEnergyPanel.ts":
/*!*************************************!*\
  !*** ./src/panels/NoEnergyPanel.ts ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.NoEnergyPanel = void 0;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var MouseEvent = FYGE.MouseEvent;
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var Button = FYGE.Button;
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var NoEnergyPanel = (function (_super) {
    __extends(NoEnergyPanel, _super);
    function NoEnergyPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(NoEnergyPanel.prototype, "groupNames", {
        get: function () {
            return ["NoEnergyPanel"];
        },
        enumerable: false,
        configurable: true
    });
    NoEnergyPanel.prototype.initUi = function () {
        var _this = this;
        this.addChild(Tools_1.Tools.getSprite('体力不足.png')).position.set(80, 486);
        this.okBtn = this.addChild(new Button(RES_1.RES.getRes('体力不足按钮.png')));
        this.okBtn.position.set(185, 858);
        this.addChild(new Button(RES_1.RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, function () {
            _this.hidePanel();
        }, this)
            .position.set(629, 463);
    };
    NoEnergyPanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    NoEnergyPanel.prototype.initEvents = function () {
        var _this = this;
        _super.prototype.initEvents.call(this);
        this.okBtn.addEventListener(MouseEvent.CLICK, function () {
            Tools_1.Tools.openTask();
            _this.hidePanel();
        }, this);
    };
    NoEnergyPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
    };
    return NoEnergyPanel;
}(Panel_1.Panel));
exports.NoEnergyPanel = NoEnergyPanel;


/***/ }),

/***/ "./src/panels/NoStepPanel.ts":
/*!***********************************!*\
  !*** ./src/panels/NoStepPanel.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.NoStepPanel = void 0;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var Button = FYGE.Button;
var NoStepPanel = (function (_super) {
    __extends(NoStepPanel, _super);
    function NoStepPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(NoStepPanel.prototype, "groupNames", {
        get: function () {
            return ["NoStepPanel"];
        },
        enumerable: false,
        configurable: true
    });
    NoStepPanel.prototype.initUi = function () {
        this.addChild(Tools_1.Tools.getSprite('noStepBg.png')).position.set(80, 274);
        this.okBtn = this.addChild(new Button(RES_1.RES.getRes('noStepOk.png')));
        this.okBtn.position.set(383, 915);
        this.cancelBtn = this.addChild(new Button(RES_1.RES.getRes('noStepCancel.png')));
        this.cancelBtn.position.set(102, 915);
        this.addChild(Tools_1.Tools.getText("\u662F\u5426\u4F7F\u7528\u6B65\u6570\u9053\u5177\n\u589E\u52A0" + Tools_1.Tools.addSteps + "\u6B21\u6B65\u6570\uFF1F", 36, "#ffffff", FYGE.TEXT_ALIGN.CENTER, 750, 0, 650));
        this.closeBtn = this.addChild(new Button(RES_1.RES.getRes('关闭按钮.png')));
        this.closeBtn.position.set(629, 469);
    };
    NoStepPanel.prototype.initEvents = function () {
        var _this = this;
        [this.closeBtn, this.cancelBtn].forEach(function (e) {
            e.addEventListener(FYGE.MouseEvent.CLICK, function () {
                ctrls_1.getCurrentScene().submit(false);
                _this.hidePanel();
            }, _this);
        });
        this.okBtn.addEventListener(FYGE.MouseEvent.CLICK, function () {
            if (!Tools_1.Tools.gameData.tools.steps) {
            }
            else {
                _this.data.reviveFun();
                _this.hidePanel();
            }
        }, this);
    };
    NoStepPanel.prototype.removeEvents = function () {
    };
    return NoStepPanel;
}(Panel_1.Panel));
exports.NoStepPanel = NoStepPanel;


/***/ }),

/***/ "./src/panels/RulePanel.ts":
/*!*********************************!*\
  !*** ./src/panels/RulePanel.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.RulePanel = void 0;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var TEXT_lINETYPE = FYGE.TEXT_lINETYPE;
var ScrollPage = FYGE.ScrollPage;
var Button = FYGE.Button;
var MouseEvent = FYGE.MouseEvent;
var RulePanel = (function (_super) {
    __extends(RulePanel, _super);
    function RulePanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(RulePanel.prototype, "groupNames", {
        get: function () {
            return ["RulePanel"];
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(RulePanel.prototype, "skinName", {
        get: function () {
            return "RulePanel";
        },
        enumerable: false,
        configurable: true
    });
    RulePanel.prototype.initUi = function () {
    };
    RulePanel.prototype.start = function (data) {
        var _this = this;
        _super.prototype.start.call(this);
        var rule = Tools_1.Tools.gameData.rule;
        this.ruleTex = this.addChild(Tools_1.Tools.getText(rule, 26, '#fffeef', FYGE.TEXT_ALIGN.LEFT, 530));
        this.ruleTex.lineType = TEXT_lINETYPE.MULTI;
        this.scroll = this.addChild(new ScrollPage(570, 590, this.ruleTex.textHeight + 30));
        this.scroll.position.set(119, 445);
        this.scroll.view.addChild(this.ruleTex);
        this.addChild(new Button(RES_1.RES.getRes('ruleBtn.png')))
            .addEventListener(MouseEvent.CLICK, function () { return _this.hidePanel(); })
            .position.set(185, 1063);
    };
    RulePanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
    };
    RulePanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
    };
    return RulePanel;
}(Panel_1.Panel));
exports.RulePanel = RulePanel;


/***/ }),

/***/ "./src/panels/StartPanel.ts":
/*!**********************************!*\
  !*** ./src/panels/StartPanel.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StartTargetItem = exports.StartTarget = exports.StartPanel = void 0;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var PlayScene_1 = __webpack_require__(/*! ../scene/PlayScene */ "./src/scene/PlayScene.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var NoEnergyPanel_1 = __webpack_require__(/*! ./NoEnergyPanel */ "./src/panels/NoEnergyPanel.ts");
var getChapter_1 = __webpack_require__(/*! ../something/chapters/getChapter */ "./src/something/chapters/getChapter.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var MouseEvent = FYGE.MouseEvent;
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var Sprite = FYGE.Sprite;
var Container = FYGE.Container;
var Button = FYGE.Button;
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var VERTICAL_ALIGN = FYGE.VERTICAL_ALIGN;
var StartPanel = (function (_super) {
    __extends(StartPanel, _super);
    function StartPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(StartPanel.prototype, "groupNames", {
        get: function () {
            return ["StartPanel"];
        },
        enumerable: false,
        configurable: true
    });
    StartPanel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 400, Ease.backOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    StartPanel.prototype.initUi = function () {
        var level = this.data.level;
        this.addChild(Tools_1.Tools.getSprite('startBg.png')).position.set(80, 259);
        var chapterTex = Tools_1.Tools.getNumTextures("startNum");
        ["第", "关"].forEach(function (e) { return chapterTex[e] = RES_1.RES.getRes("startNum" + e + ".png"); });
        var chapterTxt = this.addChild(new FYGE.BitmapText(chapterTex));
        chapterTxt.text = "第" + (level >> 0) + "关";
        chapterTxt.position.set(376, 476);
        this.addChild(new StartTarget(level)).position.set(0, 649);
        var tipTxt = level == Tools_1.Tools.maxLevel ? '通过此关即可获得抽取大奖的机会哦' : '通关即可抽取大奖\n分数越高几率越大哦';
        var tip = this.addChild(Tools_1.Tools.getText(tipTxt, 26, '#ffffff', TEXT_ALIGN.CENTER, 595, 79, 762));
        tip.textHeight = 80;
        tip.lineSpacing = 10;
        tip.verticalAlign = VERTICAL_ALIGN.MIDDLE;
        var _a = Tools_1.Tools.gameData, prizeLevels = _a.prizeLevels, levelPrize = _a.levelPrize;
        var pLevel = prizeLevels[0];
        for (var i = 0; i < prizeLevels.length; i++) {
            if (level <= prizeLevels[i]) {
                pLevel = prizeLevels[i];
                break;
            }
        }
        var prizeImg = this.addChild(Sprite.fromUrl(levelPrize["level" + pLevel]));
        prizeImg.position.set(375, 940);
        prizeImg.anchorTexture.set(0.5, 0.5);
        this.addChild(new Button(RES_1.RES.getRes("startBtn.png")))
            .addEventListener(MouseEvent.CLICK, this.startGame, this)
            .position.set(185, 1063);
        this.addChild(new Button(RES_1.RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, this.hidePanel, this)
            .position.set(629, 469);
    };
    StartPanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    StartPanel.prototype.startGame = function () {
        var _this = this;
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.addStats, { type: "CLICK_DOJOIN" }, function () { return 0; }, true);
        this.enableMouseEvt(false);
        if (Tools_1.Tools.gameData.power <= 0) {
            ctrls_1.showPanel(NoEnergyPanel_1.NoEnergyPanel);
            this.enableMouseEvt(true);
            this.hidePanel();
            return;
        }
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.dojoin, { level: this.data.level }, function (success, res) { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.enableMouseEvt(true);
                if (!success) {
                    if (res.data && !res.data.isVip) {
                        ctrls_1.showToast('请入会后参与');
                        setTimeout(function () {
                            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openMember);
                        }, 1500);
                    }
                    return [2];
                }
                ctrls_1.changeScene(PlayScene_1.PlayScene, { chapter: this.data.level });
                this.hidePanel();
                return [2];
            });
        }); });
    };
    return StartPanel;
}(Panel_1.Panel));
exports.StartPanel = StartPanel;
var pos = [
    [345],
    [295, 390],
    [250, 345, 430],
];
var StartTarget = (function (_super) {
    __extends(StartTarget, _super);
    function StartTarget(checkNum) {
        var _this = _super.call(this) || this;
        var passTarget = getChapter_1.getChapterData(checkNum).passTarget;
        if (passTarget.type == 0) {
        }
        else if (passTarget.type == 1) {
            passTarget.elements.forEach(function (v, i) {
                var targetItem = _this.addChild(new StartTargetItem(v));
                targetItem.x = pos[passTarget.elements.length - 1][i];
                setTimeout(function () {
                    targetItem.playEffect();
                }, i * 200);
            });
        }
        return _this;
    }
    return StartTarget;
}(Container));
exports.StartTarget = StartTarget;
var StartTargetItem = (function (_super) {
    __extends(StartTargetItem, _super);
    function StartTargetItem(data) {
        var _this = _super.call(this) || this;
        var targetKey = 'ele';
        if ([0, 1, 2, 3, 4].indexOf(+data.type) > -1) {
            targetKey = 'target';
        }
        var targetImg = _this.addChild(Tools_1.Tools.getSprite("" + targetKey + data.type + ".png"));
        targetImg.width = targetImg.height = 65;
        var countNum = new FYGE.BitmapText(Tools_1.Tools.getNumTextures("tarNum"));
        countNum.position.set(65, 52);
        countNum.text = data.count + "";
        _this.addChild(countNum);
        _this.anchor.set(50, 79);
        _this.scale.set(0, 0);
        return _this;
    }
    StartTargetItem.prototype.playEffect = function () {
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 500, Ease.backOut);
    };
    return StartTargetItem;
}(Container));
exports.StartTargetItem = StartTargetItem;


/***/ }),

/***/ "./src/panels/SuccessNoPrizePanel.ts":
/*!*******************************************!*\
  !*** ./src/panels/SuccessNoPrizePanel.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.SuccessStarGroup = exports.SuccessNoPrizePanel = void 0;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var MapScene_1 = __webpack_require__(/*! ../scene/map/MapScene */ "./src/scene/map/MapScene.ts");
var LotteryPanel_1 = __webpack_require__(/*! ./LotteryPanel */ "./src/panels/LotteryPanel.ts");
var Container = FYGE.Container;
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var MouseEvent = FYGE.MouseEvent;
var Button = FYGE.Button;
var SuccessNoPrizePanel = (function (_super) {
    __extends(SuccessNoPrizePanel, _super);
    function SuccessNoPrizePanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(SuccessNoPrizePanel.prototype, "groupNames", {
        get: function () {
            return ['SuccessPanel'];
        },
        enumerable: false,
        configurable: true
    });
    SuccessNoPrizePanel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 400, Ease.backOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    SuccessNoPrizePanel.prototype.initUi = function () {
        var _a = this.data, level = _a.level, isVisitSuccess = _a.isVisitSuccess, score = _a.score, stars = _a.stars;
        this.addChild(Tools_1.Tools.getSprite("successBgS.png")).position.set(80, 259);
        var starGroup = this.addChild(new SuccessStarGroup());
        starGroup.position.set(375, 620);
        starGroup.play(stars);
        var tipLabel = this.addChild(Tools_1.Tools.getText("闯关成功！", 36, "#ffffff", FYGE.TEXT_ALIGN.CENTER, 750, 23, 745));
        if (level == Tools_1.Tools.maxLevel && !Tools_1.Tools.gameData.isDrawTopLevelPrize) {
            tipLabel.text = '成功通关！\n获得一次抽奖机会！';
            this.addChild(new Button(RES_1.RES.getRes("sucGoPrize.png")))
                .addEventListener(MouseEvent.CLICK, this.goPrize, this)
                .position.set(185, 934);
        }
        else {
            if (stars >= 3) {
                this.addChild(new Button(RES_1.RES.getRes("sucContinueL.png")))
                    .addEventListener(MouseEvent.CLICK, this.continue, this)
                    .position.set(190, 860);
            }
            else {
                tipLabel.text = '闯关成功！';
                this.addChild(new Button(RES_1.RES.getRes("sucAgain.png")))
                    .addEventListener(MouseEvent.CLICK, this.again, this)
                    .position.set(102, 915);
                this.addChild(new Button(RES_1.RES.getRes("sucContinueSR.png")))
                    .addEventListener(MouseEvent.CLICK, this.continue, this)
                    .position.set(383, 915);
            }
        }
        this.addChild(new Button(RES_1.RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, this.hidePanel, this)
            .position.set(629, 469);
    };
    SuccessNoPrizePanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    SuccessNoPrizePanel.prototype.again = function () {
        ctrls_1.changeScene(MapScene_1.MapScene, { level: this.data.level });
        _super.prototype.hidePanel.call(this);
    };
    SuccessNoPrizePanel.prototype.goPrize = function () {
        ctrls_1.showPanel(LotteryPanel_1.LotteryPanel, { callFun: function () { return ctrls_1.changeScene(MapScene_1.MapScene); } });
        _super.prototype.hidePanel.call(this);
    };
    SuccessNoPrizePanel.prototype.continue = function () {
        if (this.data.level == Tools_1.Tools.maxLevel) {
            ctrls_1.changeScene(MapScene_1.MapScene);
        }
        else {
            ctrls_1.changeScene(MapScene_1.MapScene, { level: this.data.level + 1 });
        }
        _super.prototype.hidePanel.call(this);
    };
    SuccessNoPrizePanel.prototype.hidePanel = function () {
        ctrls_1.changeScene(MapScene_1.MapScene);
        _super.prototype.hidePanel.call(this);
    };
    return SuccessNoPrizePanel;
}(Panel_1.Panel));
exports.SuccessNoPrizePanel = SuccessNoPrizePanel;
var SuccessStarGroup = (function (_super) {
    __extends(SuccessStarGroup, _super);
    function SuccessStarGroup() {
        var _this = _super.call(this) || this;
        _this.leftStarDis = null;
        _this.midStarDis = null;
        _this.rightStarDis = null;
        _this.leftStarEn = null;
        _this.midStarEn = null;
        _this.rightStarEn = null;
        _this.leftStarDis = _this.addChild(Tools_1.Tools.getSprite('star_dis.png'));
        _this.midStarDis = _this.addChild(Tools_1.Tools.getSprite('star_dis.png'));
        _this.rightStarDis = _this.addChild(Tools_1.Tools.getSprite('star_dis.png'));
        _this.leftStarDis.anchorTexture.set(0.5, 0.5);
        _this.midStarDis.anchorTexture.set(0.5, 0.5);
        _this.rightStarDis.anchorTexture.set(0.5, 0.5);
        _this.leftStarDis.position.set(-140, 19);
        _this.rightStarDis.position.set(140, 19);
        _this.leftStarEn = _this.addChild(Tools_1.Tools.getSprite('star_en.png'));
        _this.midStarEn = _this.addChild(Tools_1.Tools.getSprite('star_en.png'));
        _this.rightStarEn = _this.addChild(Tools_1.Tools.getSprite('star_en.png'));
        _this.leftStarEn.anchorTexture.set(0.5, 0.5);
        _this.midStarEn.anchorTexture.set(0.5, 0.5);
        _this.rightStarEn.anchorTexture.set(0.5, 0.5);
        _this.leftStarEn.position.set(-140, 19);
        _this.rightStarEn.position.set(140, 19);
        _this.leftStarEn.scale.set(0, 0);
        _this.midStarEn.scale.set(0, 0);
        _this.rightStarEn.scale.set(0, 0);
        return _this;
    }
    SuccessStarGroup.prototype.play = function (count, wait) {
        var _this = this;
        if (wait === void 0) { wait = 600; }
        var time1 = 200;
        var time2 = 100;
        var max = 3;
        var interval = 80;
        if (count < 1)
            return;
        Tween.get(this.leftStarEn)
            .wait(wait)
            .set({ scaleX: max, scaleY: max })
            .to({ scaleX: 0.648, scaleY: 0.648 }, time1, Ease.quadOut)
            .to({ scaleX: 1, scaleY: 1 }, time2, Ease.quadOut)
            .wait(interval)
            .call(function () {
            if (count <= 1)
                return;
            Tween.get(_this.midStarEn)
                .set({ scaleX: max, scaleY: max })
                .to({ scaleX: 0.8, scaleY: 0.8 }, time1, Ease.quadOut)
                .to({ scaleX: 1, scaleY: 1 }, time2, Ease.quadOut)
                .wait(interval)
                .call(function () {
                if (count <= 2)
                    return;
                Tween.get(_this.rightStarEn)
                    .set({ scaleX: max, scaleY: max })
                    .to({ scaleX: 0.648, scaleY: 0.648 }, time1, Ease.quadOut)
                    .to({ scaleX: 1, scaleY: 1 }, time2, Ease.quadOut);
            });
        });
    };
    return SuccessStarGroup;
}(Container));
exports.SuccessStarGroup = SuccessStarGroup;


/***/ }),

/***/ "./src/panels/SuccessPrizePanel.ts":
/*!*****************************************!*\
  !*** ./src/panels/SuccessPrizePanel.ts ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.SuccessPrizePanel = void 0;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var SuccessNoPrizePanel_1 = __webpack_require__(/*! ./SuccessNoPrizePanel */ "./src/panels/SuccessNoPrizePanel.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var MapScene_1 = __webpack_require__(/*! ../scene/map/MapScene */ "./src/scene/map/MapScene.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var PropType_1 = __webpack_require__(/*! ../something/enum/PropType */ "./src/something/enum/PropType.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var MouseEvent = FYGE.MouseEvent;
var Button = FYGE.Button;
var Sprite = FYGE.Sprite;
var Texture = FYGE.Texture;
var SuccessPrizePanel = (function (_super) {
    __extends(SuccessPrizePanel, _super);
    function SuccessPrizePanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(SuccessPrizePanel.prototype, "groupNames", {
        get: function () {
            return ['SuccessPanel'];
        },
        enumerable: false,
        configurable: true
    });
    SuccessPrizePanel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 400, Ease.backOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    SuccessPrizePanel.prototype.initUi = function () {
        var _a = this.data, prize = _a.prize, level = _a.level, isVisitSuccess = _a.isVisitSuccess, score = _a.score, stars = _a.stars;
        var name = prize.name, _id = prize._id, image = prize.image, type = prize.type, toolType = prize.toolType;
        this.addChild(Tools_1.Tools.getSprite("successBgL.png")).position.set(80, 259);
        var starGroup = this.addChild(new SuccessNoPrizePanel_1.SuccessStarGroup());
        starGroup.position.set(375, 600);
        starGroup.play(stars);
        this.addChild(Tools_1.Tools.getText("闯关成功！获得奖励", 36, "#ffffff", FYGE.TEXT_ALIGN.CENTER, 750, 0, 713));
        var prizeImg = this.addChild(new Sprite());
        prizeImg.anchorTexture.set(0.5, 0.5);
        prizeImg.position.set(375, 890);
        prizeImg.width = 200;
        prizeImg.height = 200;
        if (type == 6) {
            switch (toolType) {
                case PropType_1.PropType.BOOMS:
                    prizeImg.texture = RES_1.RES.getRes('boomBtn.png');
                    break;
                case PropType_1.PropType.HAMMERS:
                    prizeImg.texture = RES_1.RES.getRes('hammerBtn.png');
                    break;
                case PropType_1.PropType.STEPS:
                    prizeImg.texture = RES_1.RES.getRes('stepBtn.png');
                    break;
            }
            if (stars >= 3) {
                this.addChild(new Button(RES_1.RES.getRes('sucContinueL.png')))
                    .addEventListener(MouseEvent.CLICK, this.continue, this)
                    .position.set(190, 1050);
            }
            else {
                this.addChild(Tools_1.Tools.getText("满星通关可抽取更大奖励哦", 26, "#ffffff", FYGE.TEXT_ALIGN.CENTER, 750, 0, 1020));
                this.addChild(new Button(RES_1.RES.getRes("sucAgain.png")))
                    .addEventListener(MouseEvent.CLICK, this.again, this)
                    .position.set(100, 1089);
                this.addChild(new Button(RES_1.RES.getRes("sucContinueS.png")))
                    .addEventListener(MouseEvent.CLICK, this.continue, this)
                    .position.set(385, 1089);
            }
        }
        else {
            prizeImg.texture = Texture.fromUrl(image);
            this.addChild(Tools_1.Tools.getText("奖品可在“我的奖品”页面查看", 26, "#ffffff", FYGE.TEXT_ALIGN.CENTER, 750, 0, 1020));
            this.addChild(new Button(RES_1.RES.getRes("sucContinueS.png")))
                .addEventListener(MouseEvent.CLICK, this.continue, this)
                .position.set(100, 1089);
            this.addChild(new Button(RES_1.RES.getRes("sucGet.png")))
                .addEventListener(MouseEvent.CLICK, this.getPrize, this)
                .position.set(385, 1089);
        }
        this.addChild(new Button(RES_1.RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, this.hidePanel, this)
            .position.set(640, 460);
    };
    SuccessPrizePanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    SuccessPrizePanel.prototype.again = function () {
        ctrls_1.changeScene(MapScene_1.MapScene, { level: this.data.level });
        _super.prototype.hidePanel.call(this);
    };
    SuccessPrizePanel.prototype.continue = function () {
        if (this.data.level == Tools_1.Tools.maxLevel) {
            ctrls_1.changeScene(MapScene_1.MapScene);
        }
        else {
            ctrls_1.changeScene(MapScene_1.MapScene, { level: this.data.level + 1 });
        }
        _super.prototype.hidePanel.call(this);
    };
    SuccessPrizePanel.prototype.getPrize = function (e) {
        var _this = this;
        this.btnDelay(e.target);
        var _a = this.data.prize, name = _a.name, _id = _a._id, image = _a.image, type = _a.type, toolType = _a.toolType;
        switch (this.data.prize.type) {
            case 1:
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.receiveEnamePrize, { _id: _id, id: _id }, function (success, res) {
                    if (!success || !res) {
                        ctrls_1.showToast('奖品发放失败\n请前往我的奖品处进行处理');
                        _this.hidePanel();
                        return;
                    }
                    if (res.data && res.data.drawStatus == 3) {
                        ctrls_1.showToast('奖品发放成功\n请前往我的奖品处查看');
                    }
                    else {
                        ctrls_1.showToast('奖品发放失败\n请前往我的奖品处进行处理');
                    }
                    _this.hidePanel();
                }, true);
                break;
            case 3:
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getUserAddress, { prizeId: _id }, function (success, res) {
                    if (!success) {
                        return;
                    }
                    ctrls_1.showToast('奖品发放成功\n请前往我的奖品处查看');
                    _this.hidePanel();
                }, true);
                break;
            case 2:
            case 5:
                this.hidePanel();
                break;
        }
    };
    SuccessPrizePanel.prototype.hidePanel = function () {
        ctrls_1.changeScene(MapScene_1.MapScene);
        _super.prototype.hidePanel.call(this);
    };
    return SuccessPrizePanel;
}(Panel_1.Panel));
exports.SuccessPrizePanel = SuccessPrizePanel;


/***/ }),

/***/ "./src/panels/UseStep.ts":
/*!*******************************!*\
  !*** ./src/panels/UseStep.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.UseStep = void 0;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var Button = FYGE.Button;
var MouseEvent = FYGE.MouseEvent;
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var UseStep = (function (_super) {
    __extends(UseStep, _super);
    function UseStep() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(UseStep.prototype, "groupNames", {
        get: function () {
            return ["UseStep"];
        },
        enumerable: false,
        configurable: true
    });
    ;
    UseStep.prototype.initUi = function () {
        var _this = this;
        this.addChild(Tools_1.Tools.getSprite('useStepBg.png')).position.set(80, 486);
        this.addChild(Tools_1.Tools.getText("\u786E\u5B9A\u8981\u4F7F\u7528\u6B65\u6570\u9053\u5177+" + Tools_1.Tools.addSteps + "\u6B65\u6570\u5417\uFF1F", 36, '#ffffff', TEXT_ALIGN.CENTER, 750, 0, 650));
        this.addChild(new Button(RES_1.RES.getRes('useStepOk.png')))
            .addEventListener(MouseEvent.CLICK, function () {
            _this.hidePanel();
            _this.data.ok();
        }, this)
            .position.set(383, 835);
        this.addChild(new Button(RES_1.RES.getRes('useStepCancel.png')))
            .addEventListener(MouseEvent.CLICK, function () {
            _this.hidePanel();
            _this.data.cancel();
        }, this)
            .position.set(102, 835);
        this.addChild(new Button(RES_1.RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, function () {
            _this.hidePanel();
            _this.data.cancel();
        }, this)
            .position.set(629, 463);
    };
    return UseStep;
}(Panel_1.Panel));
exports.UseStep = UseStep;


/***/ }),

/***/ "./src/scene/LoadingScene.ts":
/*!***********************************!*\
  !*** ./src/scene/LoadingScene.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadingScene = void 0;
var Scene_1 = __webpack_require__(/*! ../../module/views/Scene */ "./module/views/Scene.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var ProgressBarS_1 = __webpack_require__(/*! ../common/ProgressBarS */ "./src/common/ProgressBarS.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var layers_1 = __webpack_require__(/*! ../../module/views/layers */ "./module/views/layers.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var MapScene_1 = __webpack_require__(/*! ./map/MapScene */ "./src/scene/map/MapScene.ts");
var Tween = FYGE.Tween;
var FrameAni = FYGE.FrameAni;
var Event = FYGE.Event;
var LoadingScene = (function (_super) {
    __extends(LoadingScene, _super);
    function LoadingScene() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(LoadingScene.prototype, "groupNames", {
        get: function () {
            return ["loadingScene"];
        },
        enumerable: false,
        configurable: true
    });
    LoadingScene.prototype.initUi = function () {
        this.y = -layers_1.layers.stageOffsetY;
        this.addChild(FYGE.Sprite.fromFrame("loadingBg.jpg"));
        this.shoes = this.addChild(Tools_1.Tools.getSprite("loading_shoes.png"));
        this.shoes.position.set(257, 1010);
        this.line_L1 = this.addChild(Tools_1.Tools.getSprite("loading_line_left1.png"));
        this.line_L1.position.set(205, 552);
        this.line_L2 = this.addChild(Tools_1.Tools.getSprite("loading_line_left2.png"));
        this.line_L2.position.set(162, 576);
        this.line_R = this.addChild(Tools_1.Tools.getSprite("loading_line_right.png"));
        this.line_R.position.set(527, 554);
        var pro = this.addChild(Tools_1.Tools.getSprite('loadingPro.png'));
        pro.position.set(126, 792);
        this.progressBar = new ProgressBarS_1.ProgressBarS(pro);
        var frames = [];
        for (var i = 0; i <= 29; i++) {
            frames.push(RES_1.RES.getRes("loadingLight" + i + ".png"));
        }
        var ani = new FrameAni(frames);
        this.addChild(ani);
        ani.position.set(375, 665);
        ani.play(1);
        this.shoes.anchor.set(20, 200);
        Tween.get(this.shoes, { loop: true })
            .to({ rotation: 10 }, 2000)
            .to({ rotation: 0 }, 2000);
        Tween.get(this.line_L1, { loop: true })
            .to({ x: 175 }, 700)
            .to({ x: 205 }, 700);
        Tween.get(this.line_L2, { loop: true })
            .to({ x: 190 }, 700)
            .to({ x: 162 }, 700);
        Tween.get(this.line_R, { loop: true })
            .to({ x: 497 }, 700)
            .to({ x: 527 }, 700);
    };
    LoadingScene.prototype.start = function () {
        return __awaiter(this, void 0, void 0, function () {
            var data, baseInfo;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _super.prototype.start.call(this);
                        this.addEventListener(Event.PROGRESS, this.progressEvent, this);
                        this.dispatchEvent(Event.PROGRESS, 0.2);
                        return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getAppData)];
                    case 1:
                        data = (_a.sent()).data;
                        Tools_1.Tools.globalData = data;
                        Tools_1.Tools.globalData.oldInviteId = Tools_1.Tools.globalData.inviteId;
                        this.dispatchEvent(FYGE.Event.PROGRESS, 0.3);
                        return [4, Tools_1.Tools.getGameInfo()];
                    case 2:
                        baseInfo = _a.sent();
                        if (!baseInfo)
                            ctrls_1.showToast("获取游戏信息失败");
                        this.dispatchEvent(Event.PROGRESS, 0.5);
                        return [4, RES_1.RES.loadGroup("map")];
                    case 3:
                        _a.sent();
                        this.dispatchEvent(Event.PROGRESS, 0.6);
                        return [4, RES_1.RES.loadGroup('StartPanel')];
                    case 4:
                        _a.sent();
                        this.dispatchEvent(Event.PROGRESS, 0.7);
                        return [4, RES_1.RES.loadGroup('UseStep')];
                    case 5:
                        _a.sent();
                        this.dispatchEvent(Event.PROGRESS, 0.8);
                        return [4, RES_1.RES.loadGroup('playSceneEffect')];
                    case 6:
                        _a.sent();
                        this.dispatchEvent(Event.PROGRESS, 0.9);
                        return [4, RES_1.RES.loadGroup('playSceneNum')];
                    case 7:
                        _a.sent();
                        this.dispatchEvent(Event.PROGRESS, 1);
                        return [2];
                }
            });
        });
    };
    LoadingScene.prototype.progressEvent = function (e) {
        var _this = this;
        var pro = e.data;
        Tween.get(this.progressBar, null, null, true)
            .to({ value: pro }, 2000)
            .call(function () {
            if (pro >= 1) {
                _this.removeEventListener(FYGE.Event.PROGRESS, _this.progressEvent, _this);
                ctrls_1.changeScene(MapScene_1.MapScene, { from: "loading" });
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openMusic, { isOn: true });
            }
        });
    };
    LoadingScene.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        Tween.removeTweens(this.shoes);
        Tween.removeTweens(this.line_L1);
        Tween.removeTweens(this.line_L2);
        Tween.removeTweens(this.line_R);
    };
    return LoadingScene;
}(Scene_1.Scene));
exports.LoadingScene = LoadingScene;


/***/ }),

/***/ "./src/scene/PlayScene.ts":
/*!********************************!*\
  !*** ./src/scene/PlayScene.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlayScene = exports.effectBaseTimes = exports.baseScore = void 0;
var BonusShootAni_1 = __webpack_require__(/*! ../something/anis/BonusShootAni */ "./src/something/anis/BonusShootAni.ts");
var BoomAni_1 = __webpack_require__(/*! ../something/anis/BoomAni */ "./src/something/anis/BoomAni.ts");
var CrossAni_1 = __webpack_require__(/*! ../something/anis/CrossAni */ "./src/something/anis/CrossAni.ts");
var EleDisAni_1 = __webpack_require__(/*! ../something/anis/EleDisAni */ "./src/something/anis/EleDisAni.ts");
var FlyTargetAni_1 = __webpack_require__(/*! ../something/anis/FlyTargetAni */ "./src/something/anis/FlyTargetAni.ts");
var HorizontalAni_1 = __webpack_require__(/*! ../something/anis/HorizontalAni */ "./src/something/anis/HorizontalAni.ts");
var IceAni_1 = __webpack_require__(/*! ../something/anis/IceAni */ "./src/something/anis/IceAni.ts");
var MagicLionAni_1 = __webpack_require__(/*! ../something/anis/MagicLionAni */ "./src/something/anis/MagicLionAni.ts");
var MagicRotateAni_1 = __webpack_require__(/*! ../something/anis/MagicRotateAni */ "./src/something/anis/MagicRotateAni.ts");
var RockAni_1 = __webpack_require__(/*! ../something/anis/RockAni */ "./src/something/anis/RockAni.ts");
var ScoreAni_1 = __webpack_require__(/*! ../something/anis/ScoreAni */ "./src/something/anis/ScoreAni.ts");
var ThreeCrossAni_1 = __webpack_require__(/*! ../something/anis/ThreeCrossAni */ "./src/something/anis/ThreeCrossAni.ts");
var VerticalAni_1 = __webpack_require__(/*! ../something/anis/VerticalAni */ "./src/something/anis/VerticalAni.ts");
var Element_1 = __webpack_require__(/*! ../something/class/Element */ "./src/something/class/Element.ts");
var Ice_1 = __webpack_require__(/*! ../something/class/Ice */ "./src/something/class/Ice.ts");
var Lattice_1 = __webpack_require__(/*! ../something/class/Lattice */ "./src/something/class/Lattice.ts");
var EffectType_1 = __webpack_require__(/*! ../something/enum/EffectType */ "./src/something/enum/EffectType.ts");
var ElementType_1 = __webpack_require__(/*! ../something/enum/ElementType */ "./src/something/enum/ElementType.ts");
var PassType_1 = __webpack_require__(/*! ../something/enum/PassType */ "./src/something/enum/PassType.ts");
var RecoverName_1 = __webpack_require__(/*! ../something/enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var aaa_1 = __webpack_require__(/*! ../something/logic/aaa */ "./src/something/logic/aaa.ts");
var Pool_1 = __webpack_require__(/*! ../something/Pool */ "./src/something/Pool.ts");
var Tool_1 = __webpack_require__(/*! ../something/Tool */ "./src/something/Tool.ts");
var ElementTargets_1 = __webpack_require__(/*! ../something/uis/ElementTargets */ "./src/something/uis/ElementTargets.ts");
var PropGuide_1 = __webpack_require__(/*! ../something/uis/PropGuide */ "./src/something/uis/PropGuide.ts");
var ScoreProgress_1 = __webpack_require__(/*! ../something/uis/ScoreProgress */ "./src/something/uis/ScoreProgress.ts");
var StepAni_1 = __webpack_require__(/*! ../something/anis/StepAni */ "./src/something/anis/StepAni.ts");
var AiControl_1 = __webpack_require__(/*! ../something/logic/AiControl */ "./src/something/logic/AiControl.ts");
var JellyDisAni_1 = __webpack_require__(/*! ../something/anis/JellyDisAni */ "./src/something/anis/JellyDisAni.ts");
var EggBrokenAni_1 = __webpack_require__(/*! ../something/anis/EggBrokenAni */ "./src/something/anis/EggBrokenAni.ts");
var FallAniData_1 = __webpack_require__(/*! ../something/interface/FallAniData */ "./src/something/interface/FallAniData.ts");
var EleMaskAni_1 = __webpack_require__(/*! ../something/anis/EleMaskAni */ "./src/something/anis/EleMaskAni.ts");
var getChapter_1 = __webpack_require__(/*! ../something/chapters/getChapter */ "./src/something/chapters/getChapter.ts");
var StateType_1 = __webpack_require__(/*! ../something/enum/StateType */ "./src/something/enum/StateType.ts");
var HairballGreyDisAni_1 = __webpack_require__(/*! ../something/anis/HairballGreyDisAni */ "./src/something/anis/HairballGreyDisAni.ts");
var EleDownAni_1 = __webpack_require__(/*! ../something/anis/EleDownAni */ "./src/something/anis/EleDownAni.ts");
var GameGuide_1 = __webpack_require__(/*! ../something/uis/GameGuide */ "./src/something/uis/GameGuide.ts");
var PropBtnCon_1 = __webpack_require__(/*! ../something/uis/PropBtnCon */ "./src/something/uis/PropBtnCon.ts");
var FestivalTarget_1 = __webpack_require__(/*! ../something/uis/FestivalTarget */ "./src/something/uis/FestivalTarget.ts");
var FesRedBombShowAni_1 = __webpack_require__(/*! ../something/anisCall/FesRedBombShowAni */ "./src/something/anisCall/FesRedBombShowAni.ts");
var RectsWaveAni_1 = __webpack_require__(/*! ../something/anisCall/RectsWaveAni */ "./src/something/anisCall/RectsWaveAni.ts");
var Door_1 = __webpack_require__(/*! ../something/class/Door */ "./src/something/class/Door.ts");
var Scene_1 = __webpack_require__(/*! ../../module/views/Scene */ "./module/views/Scene.ts");
var GTool_1 = __webpack_require__(/*! ../../module/tools/GTool */ "./module/tools/GTool.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var PropType_1 = __webpack_require__(/*! ../something/enum/PropType */ "./src/something/enum/PropType.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var layers_1 = __webpack_require__(/*! ../../module/views/layers */ "./module/views/layers.ts");
var GameToast_1 = __webpack_require__(/*! ../something/uis/GameToast */ "./src/something/uis/GameToast.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var MapScene_1 = __webpack_require__(/*! ./map/MapScene */ "./src/scene/map/MapScene.ts");
var NoStepPanel_1 = __webpack_require__(/*! ../panels/NoStepPanel */ "./src/panels/NoStepPanel.ts");
var FirstPropGift_1 = __webpack_require__(/*! ../something/uis/FirstPropGift */ "./src/something/uis/FirstPropGift.ts");
var Main_1 = __webpack_require__(/*! ../Main */ "./src/Main.ts");
var G_EVENT_1 = __webpack_require__(/*! ../common/G_EVENT */ "./src/common/G_EVENT.ts");
var UseStep_1 = __webpack_require__(/*! ../panels/UseStep */ "./src/panels/UseStep.ts");
var BonusTime_1 = __webpack_require__(/*! ../lotties/BonusTime */ "./src/lotties/BonusTime.ts");
var aniClass = {
    "BoomAni": BoomAni_1.BoomAni,
    "IceAni": IceAni_1.IceAni,
    "RockAni": RockAni_1.RockAni,
    "HorizontalAni": HorizontalAni_1.HorizontalAni,
    "VerticalAni": VerticalAni_1.VerticalAni,
    "CrossAni": CrossAni_1.CrossAni,
    "ThreeCrossAni": ThreeCrossAni_1.ThreeCrossAni,
    "MagicLionAni": MagicLionAni_1.MagicLionAni,
    "StepAni": StepAni_1.StepAni,
    "JellyDisAni": JellyDisAni_1.JellyDisAni,
    "EggBrokenAni": EggBrokenAni_1.EggBrokenAni,
    "HairballGreyDisAni": HairballGreyDisAni_1.HairballGreyDisAni,
};
exports.baseScore = 20;
exports.effectBaseTimes = {
    0: 2.5,
    1: 2.5,
    2: 5,
    3: 15,
    LL: 10,
    EL: 20,
    EE: 25,
    MM: 50
};
var svgaParser;
var movieClips = {
    wonderful: null,
    amazing: null,
    great: null,
    good: null,
    bonusTime: null
};
var redBombPanelName = "RedBombAlert";
var fesChapterData = [];
var festivalIndex = 40;
var topY = 30;
var PlayScene = (function (_super) {
    __extends(PlayScene, _super);
    function PlayScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.emptys = [];
        _this.eliminatedElements = [];
        _this.noActionCount = 0;
        _this.isShowWarning = false;
        _this.magicRotateData = [];
        _this.commonContinuityTimes = 0;
        _this.effectContinuityTimes = 0;
        _this.lollipopCount = 0;
        _this.hasPassed = false;
        _this.isCountingTime = false;
        _this.festivalTargetNum = AiControl_1.fesELeSmallNum;
        _this.scoreAnis = [];
        _this.connectState = 2;
        _this.addedStepWarning = false;
        _this.recordOnce = {
            boom: false,
            hammer: false,
            step: false,
            failStep: false
        };
        return _this;
    }
    Object.defineProperty(PlayScene.prototype, "groupNames", {
        get: function () {
            return ["playScene", "fiveVerHorDis", "playSceneEffect", "playSceneGuide", "playSceneNum", "BonusTime"];
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(PlayScene.prototype, "steps", {
        get: function () {
            return this._steps;
        },
        set: function (value) {
            if (value == this._steps)
                return;
            this._steps = value;
            this.stepNumber.text = "" + value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(PlayScene.prototype, "score", {
        get: function () {
            return this._score;
        },
        set: function (value) {
            if (value == this._score)
                return;
            this._score = value;
            FYGE.Tween.removeTweens(this.scoreProgress);
            FYGE.Tween.get(this.scoreProgress, {}, null, true)
                .to({ score: value }, 300);
        },
        enumerable: false,
        configurable: true
    });
    PlayScene.prototype.initUi = function () {
        this.addChild(FYGE.Sprite.fromFrame("playBg.jpg")).position.set(0, -layers_1.layers.stageOffsetY);
        this.addChild(FYGE.Sprite.fromFrame("topBg.png")).position.set(25, topY);
        var commonTextArr = {};
        for (var i = 0; i < 10; i++)
            commonTextArr[i] = RES_1.RES.getRes("scoreNum" + i + ".png");
        commonTextArr["当"] = RES_1.RES.getRes("scoreNum当.png");
        this.targetScoreTxt = this.addChild(new FYGE.BitmapText(commonTextArr));
        this.targetScoreTxt.position.set(118, topY + 176);
        this.musicBtn = this.addChild(new MusicBtn());
        this.musicBtn.position.set(616, topY + 13);
        this.addChild(FYGE.Sprite.fromFrame("闪闪.png")).position.set(288, topY + 145);
    };
    PlayScene.prototype.start = function (data) {
        var _this = this;
        _super.prototype.start.call(this);
        this.chapter = (data && data.chapter != null && data.chapter != undefined) ? data.chapter : 1;
        this.chapterData = getChapter_1.getChapterData(this.chapter);
        this.initTarget();
        Tool_1.Tool.init(Tool_1.Tool.getColOddEven(this.chapterData.map.lattices), !!(this.passElements && this.passElements[ElementType_1.ElementType.LOLLIPOP]));
        this.initScene();
        this.enableMouseEvt(false);
        this.initLattices();
        this.initRecycle();
        this.initElement();
        this.initBaseElement();
        if (!this.initFestivalEle()) {
            if (this.threeMatch()) {
                this.eliminate();
            }
            else {
                this.warningCop = Tool_1.Tool.dieMapCheck(this.lattices);
                if (!this.warningCop) {
                    this.upsetElement();
                }
                else {
                    this.enableMouseEvt(true);
                    if (this.chapter == 1 && Tools_1.Tools.globalData.isNewUser) {
                        this.addChild(new FirstPropGift_1.FirstPropGift())
                            .once(FYGE.MouseEvent.CLICK, function (e) {
                            Tools_1.Tools.globalData.isNewUser = false;
                            _this.removeChild(e.target);
                            _this.initGuide();
                        }, this);
                    }
                    else {
                        this.initGuide();
                    }
                }
            }
        }
        this.initSvgas();
        AiControl_1.AiControl.ins.init(this.lattices);
    };
    PlayScene.prototype.initSvgas = function () {
        return __awaiter(this, void 0, void 0, function () {
            var bonusTime;
            return __generator(this, function (_a) {
                bonusTime = new FYGE.Lottie(BonusTime_1.BonusTime);
                bonusTime.position.set((750 - bonusTime.videoWidth) / 2, (1624 - bonusTime.videoHeight) / 2 - layers_1.layers.stageOffsetY - 200);
                movieClips.bonusTime = bonusTime;
                ["great", "wonderful", "amazing", "good"].forEach(function (e) {
                    var g = new GameToast_1.GameToast(e + ".png");
                    g.position.set(375, 1624 / 2 - layers_1.layers.stageOffsetY);
                    movieClips[e] = g;
                });
                return [2];
            });
        });
    };
    PlayScene.prototype.initScene = function () {
        var chapterTex = Tools_1.Tools.getNumTextures("chapterNum");
        ["第", "关"].forEach(function (e) { chapterTex[e] = RES_1.RES.getRes("chapterNum" + e + ".png"); });
        var chapterTxt = this.addChild(new FYGE.BitmapText(chapterTex));
        chapterTxt.text = "第" + (this.chapter >> 0) + "关";
        chapterTxt.position.set(620, topY + 122);
        this.stepNumber = this.addChild(new FYGE.BitmapText(Tools_1.Tools.getNumTextures("stepNum")));
        this.stepNumber.position.set(104, topY + 106);
        this.steps = this.chapterData.stepCount;
        this.scoreProgress = this.addChild(new ScoreProgress_1.ScoreProgress(this.chapterData.starScores));
        this.scoreProgress.position.set(83, topY + 165);
        this.score = 0;
        var path = aaa_1.generateMapBg(this.chapterData.map.lattices);
        var bg = aaa_1.drawBg(path, this.chapterData.map.lattices);
        this.addChild(bg);
        this.map = bg;
        this.elementContainer = new FYGE.Container();
        this.addChild(this.elementContainer);
        var mask = aaa_1.drawShape(path);
        this.elementContainer.mask = mask;
        mask.updateShape();
        this.addChild(mask);
        this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.mouseDownE, this);
        this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_MOVE, this.mouseMoveE, this);
        this.propBtnCon = new PropBtnCon_1.PropBtnCon();
        this.propBtnCon.y = 238 + Tool_1.Tool.gameAreaHeight + 10;
        this.addChild(this.propBtnCon);
        this.propBtnCon.boomBtn.addEventListener(FYGE.MouseEvent.CLICK, this.onTap_boomBtn, this);
        this.propBtnCon.hammerBtn.addEventListener(FYGE.MouseEvent.CLICK, this.onTap_hammerBtn, this);
        this.propBtnCon.stepBtn.addEventListener(FYGE.MouseEvent.CLICK, this.onTap_stepBtn, this);
        this.updateScene();
        var textureChoosed = RES_1.RES.getRes("chooseRect.png");
        this.choosed = new FYGE.Sprite(textureChoosed);
        this.choosed.anchorTexture.set(0.5, 0.5);
        this.propGuide = new PropGuide_1.PropGuide(this.propBtnCon.y - 20);
    };
    PlayScene.prototype.initTarget = function () {
        if (this.chapterData.passTarget.type == PassType_1.PassType.ELEMENT_TARGET) {
            this.hasEliminatedElements = [];
            this.passElements = [];
            for (var m = 0; m < this.chapterData.passTarget.elements.length; m++) {
                var element = this.chapterData.passTarget.elements[m];
                this.passElements[element.type] = element.count;
                this.hasEliminatedElements[element.type] = 0;
            }
            this.elementTargets = new ElementTargets_1.ElementTargets(this.passElements);
            this.elementTargets.x = 369;
            this.elementTargets.y = topY + 63;
            this.addChild(this.elementTargets);
            this.targetScoreTxt.visible = false;
        }
        else {
            this.passElements = null;
            this.targetScoreTxt.visible = true;
            this.targetScoreTxt.text = "当" + this.chapterData.passTarget.score;
        }
    };
    PlayScene.prototype.initRecycle = function () {
        this.recycleIndexs = [];
        if (this.passElements && this.passElements[ElementType_1.ElementType.LOLLIPOP]) {
            var recycles = this.chapterData.map.recycles;
            if (!recycles || !recycles.length) {
                var endRowNumHash = {}, endRowNum = 0;
                for (var i = 0; i < this.chapterData.map.lattices.length; i++) {
                    var d = this.chapterData.map.lattices[i];
                    if (!d)
                        continue;
                    var rc = Tool_1.Tool.indexToRc(i);
                    var row = rc[0], col = rc[1];
                    if (!endRowNumHash[col]) {
                        endRowNumHash[col] = { row: row, index: i };
                    }
                    if (row > endRowNumHash[col].row) {
                        endRowNumHash[col] = { row: row, index: i };
                    }
                    endRowNum = Math.max(rc[0], endRowNum);
                }
                this.recycleIndexs = [];
                for (var key in endRowNumHash) {
                    var _a = endRowNumHash[key], index = _a.index, row = _a.row;
                    if (endRowNum == row)
                        this.recycleIndexs.push(index);
                }
            }
            else {
                this.recycleIndexs = recycles.slice();
            }
            var texture = RES_1.RES.getRes('main_mapbottom.png');
            var imgs = new FYGE.Container;
            for (var m = 0; m < this.recycleIndexs.length; m++) {
                var p = Tool_1.Tool.getPositionByIndex(this.recycleIndexs[m]);
                var img = new FYGE.Sprite(texture);
                img.x = p[0];
                img.y = p[1];
                imgs.addChild(img);
            }
            imgs.x = -texture.width / 2;
            imgs.y = Tool_1.Tool.height / 2 - 10;
            this.map.addChildAt(imgs, 0);
        }
    };
    PlayScene.prototype.initLattices = function () {
        var latticesD = this.chapterData.map.lattices;
        this.lattices = [];
        for (var i = 0; i < latticesD.length; i++) {
            if (!latticesD[i])
                continue;
            this.lattices[i] = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.LATTICE);
            if (!this.lattices[i]) {
                this.lattices[i] = new Lattice_1.Lattice(i);
            }
            else {
                this.lattices[i].reset(i);
            }
            var p = Tool_1.Tool.getPositionByIndex(i);
            var dooreData = [4, 5, 6, 51, 61];
            if (dooreData.indexOf(latticesD[i]) >= 0) {
                var door = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.DOOR);
                var closed = (latticesD[i] + "").length == 2 ? false : true;
                if (!door) {
                    door = new Door_1.Door(closed);
                }
                else {
                    door.reset(closed);
                }
                this.map.addChild(door);
                this.lattices[i].door = door;
                door.x = p[0];
                door.y = p[1];
            }
            var iceData = [2, 3, 5, 6, 51, 61];
            if (iceData.indexOf(latticesD[i]) >= 0) {
                var iceCount = (function (n) {
                    if (n == 2 || n == 3)
                        return n - 1;
                    if (n == 5 || n == 6)
                        return n - 4;
                    return parseInt((n + "").split("")[0]) - 4;
                })(latticesD[i]);
                var ice = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.ICE);
                if (!ice) {
                    ice = new Ice_1.Ice(iceCount);
                }
                else {
                    ice.reset(iceCount);
                }
                this.map.addChild(ice);
                this.lattices[i].ice = ice;
                ice.x = p[0];
                ice.y = p[1];
                if (latticesD[i] != 2 && latticesD[i] != 3 && (latticesD[i] + "").length == 1) {
                    ice.visible = false;
                }
            }
        }
        var genLatDatas = this.chapterData.map.generateLats || [];
        this.generateIndexs = Tool_1.Tool.setGenerateLats(this.lattices, genLatDatas);
        var downMax = 0;
        var upMax = 0;
        var hasSmallToBig;
        var hasBigToSmall;
        var connectedLats = this.chapterData.map.connectedLats || [];
        for (var i = 0; i < connectedLats.length; i++) {
            var connectedLat = connectedLats[i];
            if (!connectedLat || !connectedLat.length)
                continue;
            this.lattices[connectedLat[0]].down = connectedLat[1];
            this.lattices[connectedLat[1]].up = connectedLat[0];
            var colUp = Tool_1.Tool.indexToRc(connectedLat[0])[1];
            var colDown = Tool_1.Tool.indexToRc(connectedLat[1])[1];
            downMax = Math.max(downMax, colDown);
            upMax = Math.max(upMax, colUp);
            if (colUp > colDown)
                hasBigToSmall = true;
            else if (colUp < colDown)
                hasSmallToBig = true;
        }
        if (hasBigToSmall && hasSmallToBig) {
            if (downMax > upMax) {
                this.connectState = 3;
            }
            else {
                this.connectState = 4;
            }
        }
        else if (hasBigToSmall) {
            this.connectState = 2;
        }
        else if (hasSmallToBig) {
            this.connectState = 1;
        }
    };
    PlayScene.prototype.initElement = function () {
        var elements = this.chapterData.map.elements || Tool_1.Tool.setNumber01(this.chapterData.map.lattices.slice());
        for (var i = 0; i < elements.length; i++) {
            if (!this.lattices[i])
                continue;
            var ele = void 0;
            switch (elements[i]) {
                case 0:
                    this.emptys.push(i);
                    break;
                case 1:
                case 4:
                case 7:
                case 8:
                case 9:
                case 10:
                    var type = Tool_1.Tool.returnType(i, this.lattices, this.chapterData.baseElementTypes);
                    ele = Tool_1.Tool.getElement(type);
                    if (elements[i] == 4) {
                        ele.setState(StateType_1.StateType.LOCK, true);
                    }
                    else if (elements[i] == 7) {
                        ele.setState(StateType_1.StateType.BUBBLE, true, type);
                    }
                    else if (elements[i] == 8) {
                        ele.setState(StateType_1.StateType.HAIRBALLGREY, true);
                    }
                    else if (elements[i] == 9) {
                        ele.setState(StateType_1.StateType.HAIRBALLBROWN, true);
                    }
                    else if (elements[i] == 10) {
                        ele.setState(StateType_1.StateType.HAIRBALLBLACK, true);
                    }
                    break;
                case 3:
                    this.lollipopCount++;
                    ele = Tool_1.Tool.getElement(ElementType_1.ElementType.LOLLIPOP);
                    break;
                case 2:
                    ele = Tool_1.Tool.getElement(ElementType_1.ElementType.ROCK);
                    break;
                case 5:
                    ele = Tool_1.Tool.getElement(ElementType_1.ElementType.JELLY);
                    break;
                case 6:
                    ele = Tool_1.Tool.getElement(ElementType_1.ElementType.CHICKEN_EGG);
                    break;
                default:
                    this.emptys.push(i);
                    break;
            }
            if (ele) {
                var p = Tool_1.Tool.getPositionByIndex(i);
                ele.x = p[0];
                ele.y = p[1];
                this.elementContainer.addChild(ele);
                this.lattices[i].element = ele;
            }
            if (this.lattices[i].doorClosed) {
                if (this.lattices[i].element) {
                    this.lattices[i].element.visible = false;
                }
                else {
                    Tool_1.Tool.removeEle(i, this.emptys);
                }
            }
        }
        if (this.passElements &&
            this.passElements[ElementType_1.ElementType.LOLLIPOP] &&
            !this.lollipopCount) {
            this.lollipopMark = true;
        }
    };
    PlayScene.prototype.initBaseElement = function () {
        var elements = this.chapterData.map.baseElements;
        if (!elements || !elements.length)
            return;
        for (var i = 0; i < elements.length; i++) {
            if (!Tool_1.Tool.judgeBaseEle(this.lattices[i]))
                continue;
            if (!elements[i])
                continue;
            var arr = Tool_1.Tool.returnTO(elements[i]);
            var baseType = arr[1] ? arr[1] - 1 : null;
            if (ElementType_1.FiveBaseElementTypes.indexOf(baseType) == -1 && baseType != null)
                continue;
            var ele = this.lattices[i].element;
            if (ElementType_1.FiveBaseElementTypes.indexOf(ele.type) == -1)
                continue;
            if (baseType != null)
                ele.resetType(baseType);
            if (!ele.hasState(StateType_1.StateType.BUBBLE))
                ele.effectType = arr[0] ? arr[0] - 1 : null;
        }
    };
    PlayScene.prototype.initGuide = function () {
        var gameGuideChapterNum = [1, 2, 3, 5, 8, 9, 10, 12, 17, 25, 41, 61, 101, 121];
        if (gameGuideChapterNum.indexOf(this.chapter >> 0) > -1) {
            if (!GTool_1.GTool.readCache(Tools_1.Tools.cacheKey + this.chapter)) {
                this.gameGuide = new GameGuide_1.GameGuide(this);
                this.addChild(this.gameGuide);
                this.gameGuide.show();
            }
        }
    };
    PlayScene.prototype.initFestivalEle = function () {
        var _this = this;
        if (fesChapterData.indexOf(this.chapter >> 0) > -1 &&
            Math.random() > 0.5 &&
            this.lattices[festivalIndex] &&
            (Tool_1.Tool.judgeSetFesEle(this.lattices[festivalIndex]) || !this.lattices[festivalIndex].element)) {
            var p = Tool_1.Tool.getPositionByIndex(festivalIndex);
            this.festivalTarget = new FestivalTarget_1.FestivalTarget(this.festivalTargetNum);
            this.festivalTarget.x = 580;
            this.festivalTarget.y = 115;
            this.addChildAt(this.festivalTarget, 1);
            if (this.lattices[festivalIndex].element) {
                this.lattices[festivalIndex].element.reset(ElementType_1.ElementType.FESTIVALELE_BIG);
            }
            else {
                var ele = Tool_1.Tool.getElement(ElementType_1.ElementType.FESTIVALELE_BIG);
                ele.x = p[0];
                ele.y = p[1];
                this.elementContainer.addChild(ele);
                this.lattices[festivalIndex].element = ele;
                Tool_1.Tool.removeEle(festivalIndex, this.emptys);
            }
            var ani = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.FESREDBOMBSHOW_ANI);
            if (!ani)
                ani = new FesRedBombShowAni_1.FesRedBombShowAni();
            this.addChild(ani);
            this.lattices[festivalIndex].element.visible = false;
            ani.play(p, function () {
                _this.lattices[festivalIndex].element.visible = true;
                RectsWaveAni_1.RectsWaveAni(_this.lattices, _this.map);
                if (_this.threeMatch()) {
                    _this.eliminate();
                }
                else {
                    _this.warningCop = Tool_1.Tool.dieMapCheck(_this.lattices);
                    if (!_this.warningCop) {
                        _this.upsetElement();
                    }
                    else {
                        _this.enableMouseEvt(true);
                    }
                }
            });
            return true;
        }
        return false;
    };
    PlayScene.prototype.updateScene = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.propBtnCon.boomCount = Tools_1.Tools.gameData.tools.booms;
                this.propBtnCon.hammerCount = Tools_1.Tools.gameData.tools.hammers;
                this.propBtnCon.stepCount = Tools_1.Tools.gameData.tools.steps;
                return [2];
            });
        });
    };
    PlayScene.prototype.initEvents = function () {
        this.addEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame, this);
    };
    PlayScene.prototype.removeEvents = function () {
        this.removeEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame, this);
        this.propBtnCon.boomBtn.removeEventListener(FYGE.MouseEvent.CLICK, this.onTap_boomBtn, this);
        this.propBtnCon.hammerBtn.removeEventListener(FYGE.MouseEvent.CLICK, this.onTap_hammerBtn, this);
        this.propBtnCon.stepBtn.removeEventListener(FYGE.MouseEvent.CLICK, this.onTap_stepBtn, this);
        this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.mouseDownE, this);
        this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_MOVE, this.mouseMoveE, this);
    };
    PlayScene.prototype.onEnterFrame = function () {
        if (this.mouseEnable && !this.gameGuide) {
            this.noActionCount++;
        }
        else {
            this.noActionCount = 0;
        }
        if (this.noActionCount >= 6 * 60 && !this.isShowWarning) {
            this.noActionCount = 0;
            this.isShowWarning = true;
            this.warningAni();
        }
    };
    PlayScene.prototype.warningAni = function () {
        var a = this.warningCop[0];
        var b = this.warningCop[1];
        var ax = a.x;
        var ay = a.y;
        var bx = b.x;
        var by = b.y;
        FYGE.Tween.get(a, { loop: true })
            .to({ x: (bx - ax) / 10 + ax, y: (by - ay) / 10 + ay }, 100)
            .to({ x: ax, y: ay }, 100)
            .wait(200)
            .to({ x: (bx - ax) / 10 + ax, y: (by - ay) / 10 + ay }, 100)
            .to({ x: ax, y: ay }, 100)
            .wait(400);
        FYGE.Tween.get(b, { loop: true })
            .to({ x: (ax - bx) / 10 + bx, y: (ay - by) / 10 + by }, 100)
            .to({ x: bx, y: by }, 100)
            .wait(200)
            .to({ x: (ax - bx) / 10 + bx, y: (ay - by) / 10 + by }, 100)
            .to({ x: bx, y: by }, 100)
            .wait(400);
    };
    PlayScene.prototype.resetWarning = function () {
        if (!this.warningCop)
            return;
        FYGE.Tween.removeTweens(this.warningCop[0]);
        FYGE.Tween.removeTweens(this.warningCop[1]);
        var a = this.warningCop[0];
        var b = this.warningCop[1];
        var aIndex = a.index;
        var bIndex = b.index;
        var ap = Tool_1.Tool.getPositionByIndex(aIndex);
        var bp = Tool_1.Tool.getPositionByIndex(bIndex);
        a.x = ap[0];
        a.y = ap[1];
        b.x = bp[0];
        b.y = bp[1];
    };
    PlayScene.prototype.onTap_boomBtn = function () {
        this.propBtnCon.boomCount ? this.useProp(PropType_1.PropType.BOOMS) : ctrls_1.showToast("道具不足");
    };
    PlayScene.prototype.onTap_hammerBtn = function () {
        this.propBtnCon.hammerCount ? this.useProp(PropType_1.PropType.HAMMERS) : ctrls_1.showToast("道具不足");
    };
    PlayScene.prototype.onTap_stepBtn = function () {
        this.propBtnCon.stepCount ? this.useProp(PropType_1.PropType.STEPS) : ctrls_1.showToast("道具不足");
    };
    PlayScene.prototype.useProp = function (prop) {
        var _this = this;
        this.removeEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame, this);
        if (this.isShowWarning) {
            this.isShowWarning = false;
            this.resetWarning();
        }
        if (prop == PropType_1.PropType.STEPS) {
            ctrls_1.showPanel(UseStep_1.UseStep, {
                cancel: function () { return _this.addEventListener(FYGE.Event.ENTER_FRAME, _this.onEnterFrame, _this); },
                ok: function () { return _this.sendPropUse(PropType_1.PropType.STEPS); }
            });
            return;
        }
        this.addChild(this.propGuide);
        this.propGuide.init(prop);
        if (prop == PropType_1.PropType.BOOMS || prop == PropType_1.PropType.HAMMERS) {
            this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.mouseDownE, this);
            this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_MOVE, this.mouseMoveE, this);
            if (this.SELECTED && this.choosed.parent) {
                this.choosed.parent.removeChild(this.choosed);
            }
            var fun_1;
            this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, fun_1 = function (e) {
                var ele = e.currentTarget.parent.parent;
                if (ele instanceof Element_1.Element &&
                    ele.type != ElementType_1.ElementType.LOLLIPOP) {
                    this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_DOWN, fun_1, this);
                    var index = ele.index;
                    this.sendPropUse(prop, index);
                }
            }, this);
            this.propGuide.once(FYGE.MouseEvent.CLICK, function () {
                _this.removeChild(_this.propGuide);
                _this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_DOWN, fun_1, _this);
                _this.addEventListener(FYGE.Event.ENTER_FRAME, _this.onEnterFrame, _this);
                _this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, _this.mouseDownE, _this);
                _this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_MOVE, _this.mouseMoveE, _this);
            }, this);
        }
        else {
            if (!this.stepCircle) {
                this.stepCircle = new FYGE.Graphics()
                    .beginFill(0xff0000)
                    .drawCircle(BonusShootAni_1.stepPosition[0], BonusShootAni_1.stepPosition[1], BonusShootAni_1.stepPosition[2])
                    .endFill()
                    .addEventListener(FYGE.MouseEvent.CLICK, function () {
                    _this.sendPropUse(PropType_1.PropType.STEPS);
                }, this);
                this.stepCircle.alpha = 0;
            }
            this.addChild(this.stepCircle);
            this.propGuide.once(FYGE.MouseEvent.CLICK, function () {
                _this.removeChild(_this.propGuide);
                _this.addEventListener(FYGE.Event.ENTER_FRAME, _this.onEnterFrame, _this);
                if (_this.stepCircle.parent)
                    _this.removeChild(_this.stepCircle);
            }, this);
        }
    };
    PlayScene.prototype.sendPropUse = function (prop, index) {
        return __awaiter(this, void 0, void 0, function () {
            var s, rc, p, i, lat;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.propGuide.removeAllEventListener();
                        this.removeChild(this.propGuide);
                        ctrls_1.showWaiting();
                        return [4, Tools_1.Tools.consumerTools(prop)];
                    case 1:
                        s = _a.sent();
                        ctrls_1.hideWaiting();
                        this.addEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame, this);
                        if (prop == PropType_1.PropType.BOOMS || prop == PropType_1.PropType.HAMMERS) {
                            this.enableMouseEvt(false);
                            this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.mouseDownE, this);
                            this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_MOVE, this.mouseMoveE, this);
                        }
                        else {
                            this.removeChild(this.stepCircle);
                        }
                        if (s) {
                            switch (prop) {
                                case PropType_1.PropType.BOOMS:
                                    rc = Tool_1.Tool.indexToRc(index);
                                    p = Tool_1.Tool.getPositionByIndex(index);
                                    this.playAni(RecoverName_1.RecoverName.CROSS_ANI, p);
                                    for (i = 0; i < this.lattices.length; i++) {
                                        lat = this.lattices[i];
                                        if (Tool_1.Tool.judgeEliminate(lat) && (lat.row == rc[0] || lat.column == rc[1])) {
                                            if (this.eliminatedElements.indexOf(i) == -1) {
                                                this.eliminatedElements.push(i);
                                                if (Tool_1.Tool.judgeHasScore(lat.element)) {
                                                    this.pushScoreAni(exports.baseScore * 1 * exports.effectBaseTimes.LL, Tool_1.Tool.getPositionByIndex(i));
                                                }
                                            }
                                        }
                                    }
                                    setTimeout(function () {
                                        _this.eliminate();
                                    }, 200);
                                    this.isMouseAction = true;
                                    break;
                                case PropType_1.PropType.HAMMERS:
                                    this.eliminatedElements.push(index);
                                    if (Tool_1.Tool.judgeHasScore(this.lattices[index].element)) {
                                        this.pushScoreAni(exports.baseScore * 1 * (exports.effectBaseTimes[this.lattices[index].element.effectType] || 1), Tool_1.Tool.getPositionByIndex(index));
                                    }
                                    this.eliminate();
                                    this.isMouseAction = true;
                                    break;
                                case PropType_1.PropType.STEPS:
                                    ctrls_1.showToast("\u9053\u5177\u4F7F\u7528\u6210\u529F\uFF0C\u6B65\u6570+" + Tools_1.Tools.addSteps + "\uFF01");
                                    this.playAni(RecoverName_1.RecoverName.STEP_ANI, [BonusShootAni_1.stepPosition[0] - 40, BonusShootAni_1.stepPosition[1] + 20]);
                                    setTimeout(function () {
                                        _this.steps += 5;
                                    }, 333);
                                    break;
                            }
                            this.updateScene();
                        }
                        else {
                            this.enableMouseEvt(true);
                        }
                        return [2];
                }
            });
        });
    };
    PlayScene.prototype.mouseDownE = function (e) {
        var ele = e.currentTarget.parent.parent;
        var self = this;
        if (ele && ele instanceof Element_1.Element) {
            this.isShowWarning = false;
            this.noActionCount = 0;
            this.resetWarning();
            if (!Tool_1.Tool.judgeChosen(ele))
                return;
            if (self.SELECTED && Tool_1.Tool.checkNeb(ele, self.SELECTED)) {
                self.exchangeElementAni(self.SELECTED, ele, self.callbackEx);
                self.SELECTED.removeChild(self.choosed);
                self.SELECTED = null;
            }
            else {
                self.SELECTED = ele;
                if (self.SELECTED.effectType == EffectType_1.EffectType.MAGICLION) {
                    self.elementContainer.addChildAt(self.SELECTED, 0);
                }
                else {
                    self.elementContainer.addChild(self.SELECTED);
                }
                self.SELECTED.addChild(self.choosed);
            }
        }
    };
    PlayScene.prototype.mouseMoveE = function (e) {
        if (this.SELECTED && e.currentTarget.parent.parent instanceof Element_1.Element) {
            var ele = e.currentTarget.parent.parent;
            if (!Tool_1.Tool.judgeChosen(ele))
                return;
            if (Tool_1.Tool.checkNeb(ele, this.SELECTED)) {
                this.exchangeElementAni(this.SELECTED, ele, this.callbackEx);
                this.SELECTED.removeChild(this.choosed);
                this.SELECTED = null;
            }
        }
    };
    PlayScene.prototype.callbackEx = function (s, o) {
        this.exchangeData(s, o);
        if (this.simpleMatch(s, o)) {
            this.isMouseAction = true;
            if (this.gameGuide)
                this.gameGuide.hideSelf();
            this.steps--;
            this.oneStepScore = 0;
            this.eliminate();
            var aarr = [s, o];
            for (var i = 0; i < aarr.length; i++) {
                var ele = aarr[i];
                if (ele.type == ElementType_1.ElementType.LOLLIPOP && this.recycleIndexs.indexOf(ele.index) > -1) {
                    this.recoverEle(ele.index);
                    this.lollipopCount--;
                    if (this.passElements &&
                        this.passElements[ElementType_1.ElementType.LOLLIPOP] &&
                        this.lollipopCount < this.passElements[ElementType_1.ElementType.LOLLIPOP]) {
                        this.lollipopMark = true;
                    }
                }
            }
        }
        else {
            this.exchangeData(s, o);
            this.exchangeElementAni(s, o);
        }
    };
    PlayScene.prototype.exchangeElementAni = function (s, o, callback) {
        var _this = this;
        this.enableMouseEvt(false);
        FYGE.Tween.get(s)
            .to({ x: o.x, y: o.y }, 166)
            .call(function () {
            if (callback) {
                callback.bind(_this)(s, o);
            }
            else {
                _this.enableMouseEvt(true);
            }
        });
        FYGE.Tween.get(o)
            .to({ x: s.x, y: s.y }, 166);
    };
    PlayScene.prototype.exchangeData = function (a, b) {
        var latA = this.lattices[a.index];
        var latB = this.lattices[b.index];
        latA.element = b;
        latB.element = a;
    };
    PlayScene.prototype.fall = function (callback) {
        var _this = this;
        Tool_1.Tool.removeReapty(this.emptys);
        if (Tool_1.Tool.judgeOutOne(this.emptys, this.lattices)) {
            var anis = this.fallVerticalEx();
            if (!anis.length) {
                anis = this.fallSkewEx();
                if (!anis.length) {
                    callback();
                }
                else {
                    this.fallAniSuper(anis, function () {
                        _this.fall(callback);
                    });
                }
            }
            else {
                this.fallAniSuper(anis, function () {
                    _this.fall(callback);
                }, true);
            }
        }
        else {
            var anis = this.fallVertical();
            anis = anis.concat(this.fallSkewEx());
            if (!anis.length) {
                callback();
            }
            else {
                this.fallAniSuper(anis, function () {
                    _this.fall(callback);
                });
            }
        }
    };
    PlayScene.prototype.fallVertical = function () {
        var anis = [];
        for (var m = 0; m < Tool_1.Tool.colNum; m++) {
            for (var n = Tool_1.Tool.rowNum - 1; n >= 0; n--) {
                var index = Tool_1.Tool.rcToIndex(n, m);
                var lat = this.lattices[index];
                if (Tool_1.Tool.judgeFall(lat)) {
                    var latDown, indexDown, connects = [];
                    if (lat.down != null) {
                        latDown = this.lattices[lat.down];
                        indexDown = lat.down;
                        connects.push({ index: indexDown, type: FallAniData_1.FallType.THROUGH });
                    }
                    else {
                        latDown = this.lattices[index + Tool_1.Tool.colNum];
                        indexDown = index + Tool_1.Tool.colNum;
                        connects.push({ index: indexDown, type: FallAniData_1.FallType.STRIGHT });
                    }
                    var emptyIndex = this.emptys.indexOf(indexDown);
                    if (emptyIndex > -1) {
                        anis.push({ ele: lat.element, indexs: connects });
                        this.emptys.splice(emptyIndex, 1);
                        this.emptys.push(index);
                        lat.element = null;
                    }
                }
                else {
                    if (lat &&
                        !lat.element &&
                        lat.isGenerate &&
                        !Tool_1.Tool.judgeFall(this.lattices[index - Tool_1.Tool.colNum])) {
                        anis.push({ ele: null, indexs: [{ index: index, type: FallAniData_1.FallType.STRIGHT }] });
                        Tool_1.Tool.removeEle(index, this.emptys);
                    }
                }
            }
        }
        return anis;
    };
    PlayScene.prototype.fallVerticalEx = function () {
        var _this = this;
        var anis = [];
        var operation = function (m) {
            for (var n = Tool_1.Tool.rowNum - 1; n >= 0; n--) {
                var index = Tool_1.Tool.rcToIndex(n, m);
                var lat = _this.lattices[index];
                if (Tool_1.Tool.judgeFall(lat)) {
                    var indexs = Tool_1.Tool.findBottom(lat, _this.emptys, _this.lattices);
                    if (indexs != null) {
                        var downIndex = indexs[indexs.length - 1].index;
                        anis.push({ ele: lat.element, indexs: indexs });
                        Tool_1.Tool.removeEle(downIndex, _this.emptys);
                        _this.emptys.push(index);
                        lat.element = null;
                    }
                }
                else {
                }
            }
            if (_this.generateIndexs[m]) {
                for (var aaa = 0; aaa < _this.generateIndexs[m].length; aaa++) {
                    var index = _this.generateIndexs[m][aaa].index;
                    var lat = _this.lattices[index];
                    if (lat && !lat.element && lat.isGenerate) {
                        var downIndex_1 = index;
                        var type = FallAniData_1.FallType.STRIGHT;
                        var connects = [];
                        var anisOther = [];
                        while (_this.emptys.indexOf(downIndex_1) > -1) {
                            connects.push({
                                index: downIndex_1,
                                type: type,
                            });
                            anis.push({
                                ele: null,
                                indexs: connects.slice()
                            });
                            Tool_1.Tool.removeEle(downIndex_1, _this.emptys);
                            if (_this.lattices[downIndex_1].down != null) {
                                downIndex_1 = _this.lattices[downIndex_1].down;
                                type = FallAniData_1.FallType.THROUGH;
                            }
                            else {
                                downIndex_1 += Tool_1.Tool.colNum;
                                type = FallAniData_1.FallType.STRIGHT;
                            }
                        }
                        var len = anis.length;
                        for (var i = len - 1; i >= len - connects.length; i--) {
                            anis[i].wait = (len - 1 - i) * Tool_1.Tool.latDeltaTime * 2 / 3;
                        }
                    }
                }
            }
        };
        if (this.connectState == 1) {
            for (var m = Tool_1.Tool.colNum; m >= 0; m--)
                operation(m);
        }
        else if (this.connectState == 2) {
            for (var m = 0; m < Tool_1.Tool.colNum; m++)
                operation(m);
        }
        else if (this.connectState == 3) {
            for (var m = Tool_1.Tool.colNum; m >= 0; m--)
                operation(m);
            for (var m = 0; m < Tool_1.Tool.colNum; m++)
                operation(m);
        }
        else if (this.connectState == 4) {
            for (var m = 0; m < Tool_1.Tool.colNum; m++)
                operation(m);
            for (var m = Tool_1.Tool.colNum; m >= 0; m--)
                operation(m);
        }
        return anis;
    };
    PlayScene.prototype.fallSkewEx = function () {
        var _this = this;
        var anis = [];
        var emptys = this.emptys;
        emptys.sort(function (a, b) {
            return a < b ? 1 : -1;
        });
        var _loop_1 = function () {
            var indexMy = emptys[i];
            lat = this_1.lattices[indexMy];
            var latFall;
            var indexFall;
            var type = FallAniData_1.FallType.STRIGHT;
            if (lat.up) {
                latUnUp = this_1.lattices[lat.up];
                if (Tool_1.Tool.judgeFall(latUnUp)) {
                    latFall = latUnUp;
                    indexFall = lat.up;
                    type = FallAniData_1.FallType.THROUGH;
                }
            }
            if (!latFall && Tool_1.Tool.indexToRc(indexMy)[0] != 0) {
                latUp = this_1.lattices[indexMy - Tool_1.Tool.colNum];
                if (Tool_1.Tool.judgeFall(latUp)) {
                    latFall = latUp;
                    indexFall = indexMy - Tool_1.Tool.colNum;
                }
            }
            var findLeft = function () {
                if (!latFall && Tool_1.Tool.indexToRc(indexMy)[1] != 0) {
                    var latLeftUp = _this.lattices[indexMy - Tool_1.Tool.colNum - 1];
                    if (Tool_1.Tool.judgeFall(latLeftUp)) {
                        latFall = latLeftUp;
                        indexFall = indexMy - Tool_1.Tool.colNum - 1;
                    }
                }
            };
            var findRight = function () {
                if (!latFall && Tool_1.Tool.indexToRc(indexMy)[1] != Tool_1.Tool.colNum - 1) {
                    var latRightUp = _this.lattices[indexMy - Tool_1.Tool.colNum + 1];
                    if (Tool_1.Tool.judgeFall(latRightUp)) {
                        latFall = latRightUp;
                        indexFall = indexMy - Tool_1.Tool.colNum + 1;
                    }
                }
            };
            if (Math.random() > 0.5) {
                findLeft();
                findRight();
            }
            else {
                findRight();
                findLeft();
            }
            if (latFall) {
                anis.push({ ele: latFall.element, indexs: [{ index: indexMy, type: type }] });
                emptys.splice(i, 1);
                emptys.splice(i + 1, 0, indexFall);
                latFall.element = null;
                i--;
            }
            else {
                if (lat.isGenerate) {
                    anis.push({ ele: null, indexs: [{ index: indexMy, type: FallAniData_1.FallType.STRIGHT }] });
                    emptys.splice(i, 1);
                    i--;
                    return "continue";
                }
            }
        };
        var this_1 = this, lat, latUnUp, latUp;
        for (var i = 0; i < emptys.length; i++) {
            _loop_1();
        }
        return anis;
    };
    PlayScene.prototype.fallAniSuper = function (anis, callback, isVertical) {
        var _this = this;
        if (isVertical === void 0) { isVertical = false; }
        var deltaTime = Tool_1.Tool.latDeltaTime;
        if (isVertical) {
            deltaTime = Tool_1.Tool.latDeltaTime * 2 / 3;
        }
        var count = 0;
        var countAll = anis.length;
        var _loop_2 = function (i) {
            var ani = anis[i];
            var ele = ani.ele;
            var wait_1 = ani.wait || 0;
            var indexs = ani.indexs;
            var oriRow = void 0;
            var oriCol = void 0;
            var endIndex = indexs[indexs.length - 1].index;
            var tween = void 0;
            if (!ele) {
                var firstIndex = indexs.shift();
                ele = this_2.createELement(firstIndex.index);
                this_2.elementContainer.addChild(ele);
                oriRow = Tool_1.Tool.indexToRc(firstIndex.index)[0];
                var fp = Tool_1.Tool.getPositionByIndex(firstIndex.index);
                ele.x = fp[0];
                ele.y = fp[1] - Tool_1.Tool.height;
                tween = FYGE.Tween.get(ele);
                if (wait_1)
                    tween.wait(wait_1);
                if (this_2.lattices[firstIndex.index - Tool_1.Tool.colNum]) {
                    var mask_1 = Tool_1.Tool.getRectMask();
                    mask_1.x = fp[0];
                    mask_1.y = fp[1];
                    this_2.elementContainer.addChild(mask_1);
                    ele.mask = mask_1;
                    tween.to({ x: fp[0], y: fp[1] }, deltaTime)
                        .call(function () {
                        ele.mask = null;
                        mask_1.recover();
                    });
                }
                else {
                    tween.to({ x: fp[0], y: fp[1] }, deltaTime);
                }
                wait_1 += deltaTime;
            }
            else {
                oriRow = ele.row;
                tween = FYGE.Tween.get(ele);
            }
            var lastX = void 0, lastY = void 0;
            for (var j = 0; j < indexs.length; j++) {
                var index = indexs[j].index;
                var type = indexs[j].type;
                var p = Tool_1.Tool.getPositionByIndex(index);
                if (type == FallAniData_1.FallType.THROUGH) {
                    var indexUp = this_2.lattices[index].up;
                    var downPos = Tool_1.Tool.getPositionByIndex(index);
                    var upPos = Tool_1.Tool.getPositionByIndex(indexUp);
                    if (this_2.lattices[indexUp + Tool_1.Tool.colNum]) {
                        EleMaskAni_1.EleMaskAni(ele, upPos, wait_1, this_2.elementContainer, true, deltaTime);
                        tween.set({ alpha: 0 })
                            .wait(deltaTime)
                            .set({ alpha: 1 });
                    }
                    else {
                        tween.to({ x: upPos[0], y: upPos[1] + Tool_1.Tool.height }, deltaTime);
                    }
                    if (this_2.lattices[index - Tool_1.Tool.colNum]) {
                        EleMaskAni_1.EleMaskAni(ele, downPos, wait_1, this_2.elementContainer, false, deltaTime);
                    }
                    else {
                        EleDownAni_1.EleDownAni(ele, downPos, wait_1, this_2.elementContainer, false, deltaTime);
                    }
                    oriRow = Tool_1.Tool.indexToRc(index)[0];
                    lastX = downPos[0];
                    lastY = downPos[1];
                    wait_1 += deltaTime;
                }
                else {
                    delta = Tool_1.Tool.indexToRc(index)[0] - oriRow;
                    if (delta > 0) {
                        oriRow = Tool_1.Tool.indexToRc(index)[0];
                        if (lastX != null) {
                            tween.set({ x: lastX, y: lastY });
                        }
                        tween.to({ x: p[0], y: p[1] }, delta * deltaTime);
                        wait_1 += delta * deltaTime;
                        lastX = null;
                    }
                }
            }
            var showFallAni = (function () {
                return false;
            })();
            lat = this_2.lattices[endIndex];
            lat.element = ele;
            tween.call(function () {
                var endP = Tool_1.Tool.getPositionByIndex(endIndex);
                ele.x = endP[0];
                ele.y = endP[1];
                if (ele.type == ElementType_1.ElementType.LOLLIPOP && _this.recycleIndexs.indexOf(endIndex) > -1) {
                    _this.recoverEle(endIndex);
                    _this.lollipopCount--;
                    if (_this.passElements &&
                        _this.passElements[ElementType_1.ElementType.LOLLIPOP] &&
                        _this.lollipopCount < _this.passElements[ElementType_1.ElementType.LOLLIPOP]) {
                        _this.lollipopMark = true;
                    }
                }
                else if (showFallAni) {
                    ele.fallAni();
                }
                if (++count == countAll)
                    callback();
            });
        };
        var this_2 = this, delta, lat;
        for (var i = anis.length - 1; i >= 0; i--) {
            _loop_2(i);
        }
    };
    PlayScene.prototype.createELement = function (index) {
        var type;
        var effectType = null;
        if (this.lollipopMark) {
            this.lollipopMark = false;
            type = ElementType_1.ElementType.LOLLIPOP;
            this.lollipopCount++;
        }
        else {
            var baseElementTypes = this.chapterData.baseElementTypes.slice();
            var col = Tool_1.Tool.indexToRc(index)[1];
            var data = this.generateIndexs[col].filter(function (d) {
                return d.index == index;
            })[0];
            if (data) {
                var one = data.cus.shift();
                if (one) {
                    var oneData = Tool_1.Tool.praseEleNumber(one);
                    type = oneData[0] === null ? Tool_1.Tool.randomT(baseElementTypes) : oneData[0];
                    effectType = oneData[1];
                }
                else {
                    if (!data.type || !data.type.length) {
                        type = Tool_1.Tool.randomT(baseElementTypes);
                    }
                    else {
                        var code = Tool_1.Tool.randomT(data.type);
                        if (code) {
                            var codeData = Tool_1.Tool.praseEleNumber(code);
                            type = codeData[0] === null ? Tool_1.Tool.randomT(baseElementTypes) : codeData[0];
                            effectType = codeData[1];
                        }
                        else {
                            type = Tool_1.Tool.randomT(baseElementTypes);
                        }
                    }
                }
            }
            else {
                type = Tool_1.Tool.randomT(baseElementTypes);
            }
        }
        var ele = Tool_1.Tool.getElement(type);
        if (!this.hasPassed)
            ele.effectType = effectType;
        if (type != ElementType_1.ElementType.LOLLIPOP &&
            effectType == null &&
            this.chapterData.bubbleProbability &&
            Math.random() < this.chapterData.bubbleProbability) {
            ele.setState(StateType_1.StateType.BUBBLE, true, type);
        }
        return ele;
    };
    PlayScene.prototype.simpleMatch = function (s, o) {
        if (s.effectType != null && o.effectType != null) {
            this.isManual = true;
            this.eliminatedElements.push(s.index, o.index);
            this.effectContinuityTimes++;
            return true;
        }
        if (s.effectType == EffectType_1.EffectType.MAGICLION || o.effectType == EffectType_1.EffectType.MAGICLION) {
            if (s.type == ElementType_1.ElementType.LOLLIPOP || o.type == ElementType_1.ElementType.LOLLIPOP) {
                return false;
            }
            else {
                this.isManual = true;
                this.eliminatedElements.push(s.index, o.index);
                this.effectContinuityTimes++;
                return true;
            }
        }
        return this.threeMatch(s, o);
    };
    PlayScene.prototype.threeMatch = function (s, o) {
        for (var i = 0; i < Tool_1.Tool.rowNum; i++) {
            var arr = [];
            for (var g = 0; g < Tool_1.Tool.colNum; g++) {
                arr.push(i * Tool_1.Tool.colNum + g);
            }
            var re = Tool_1.Tool.fn(arr, this.lattices);
            for (var j = 0; j < re.length; j++) {
                var len = re[j].length;
                if (len >= 3) {
                    for (var k = 0; k < len; k++) {
                        var ele = this.lattices[re[j][k]].element;
                        this.eliminatedElements.push(re[j][k]);
                        if (len >= 5) {
                            if (k == 2) {
                                ele.temEffectType = EffectType_1.EffectType.MAGICLION;
                                this.elementContainer.addChildAt(ele, 0);
                            }
                        }
                        else if (len == 4) {
                            if ([s, o].indexOf(ele) > -1) {
                                ele.temEffectType = EffectType_1.EffectType.VERTICAL;
                            }
                            else if (!s && k == 2) {
                                ele.temEffectType = EffectType_1.EffectType.VERTICAL;
                            }
                        }
                    }
                }
            }
        }
        for (var m = 0; m < Tool_1.Tool.colNum; m++) {
            var arr = [];
            for (var g = 0; g < Tool_1.Tool.rowNum; g++) {
                arr.push(Tool_1.Tool.colNum * g + m);
            }
            var re = Tool_1.Tool.fn(arr, this.lattices);
            for (var j = 0; j < re.length; j++) {
                var len = re[j].length;
                if (len >= 3) {
                    for (var k = 0; k < len; k++) {
                        var ele = this.lattices[re[j][k]].element;
                        if (len >= 5) {
                            if (k == 2) {
                                if (ele.temEffectType != EffectType_1.EffectType.MAGICLION) {
                                    ele.temEffectType = EffectType_1.EffectType.MAGICLION;
                                    this.elementContainer.addChildAt(ele, 0);
                                    if (this.eliminatedElements.indexOf(re[j][k]) == -1) {
                                        this.eliminatedElements.push(re[j][k]);
                                    }
                                }
                            }
                            else {
                                if (this.eliminatedElements.indexOf(re[j][k]) == -1) {
                                    this.eliminatedElements.push(re[j][k]);
                                }
                                else {
                                    if (ele.temEffectType != EffectType_1.EffectType.MAGICLION)
                                        ele.temEffectType = EffectType_1.EffectType.EXPLOSIVE;
                                }
                            }
                        }
                        else if (len == 4) {
                            if ([s, o].indexOf(ele) > -1) {
                                ele.temEffectType = EffectType_1.EffectType.HORIZONTAL;
                            }
                            else if (!s && k == 2) {
                                ele.temEffectType = EffectType_1.EffectType.HORIZONTAL;
                            }
                            if (this.eliminatedElements.indexOf(re[j][k]) == -1) {
                                this.eliminatedElements.push(re[j][k]);
                            }
                            else {
                                if (ele.temEffectType != EffectType_1.EffectType.MAGICLION)
                                    ele.temEffectType = EffectType_1.EffectType.EXPLOSIVE;
                            }
                        }
                        else {
                            if (this.eliminatedElements.indexOf(re[j][k]) == -1) {
                                this.eliminatedElements.push(re[j][k]);
                            }
                            else {
                                if (ele.temEffectType != EffectType_1.EffectType.MAGICLION)
                                    ele.temEffectType = EffectType_1.EffectType.EXPLOSIVE;
                            }
                        }
                    }
                }
            }
        }
        if (this.eliminatedElements.length && !this.hasPassed)
            this.commonContinuityTimes++;
        for (var aa = 0; aa < this.eliminatedElements.length; aa++) {
            var index = this.eliminatedElements[aa];
            if (Tool_1.Tool.judgeHasScore(this.lattices[index].element)) {
                this.pushScoreAni(exports.baseScore * this.commonContinuityTimes, Tool_1.Tool.getPositionByIndex(index));
            }
        }
        return this.eliminatedElements.length > 0;
    };
    PlayScene.prototype.eliminate = function () {
        var _this = this;
        if (this.isManual) {
            this.isManual = false;
            this.effectCombination();
        }
        else {
            this.rotateEliminate();
            var effectIndexs = this.commonEliminate();
            var scoreAll = 0;
            for (var i = 0; i < this.scoreAnis.length; i++) {
                var scoreAni = this.scoreAnis[i];
                scoreAll += scoreAni.score;
            }
            this.scoreAnis.length = 0;
            this.score += scoreAll;
            this.oneStepScore += scoreAll;
            this.effectEliminate(effectIndexs);
        }
        if (this.eliminatedElements.length) {
            setTimeout(function () {
                _this.eliminate();
            }, 200);
        }
        else {
            setTimeout(function () {
                _this.fall(function () {
                    _this.fallCallback();
                });
            }, 200);
        }
    };
    PlayScene.prototype.fallCallback = function () {
        var _this = this;
        if (this.threeMatch()) {
            this.eliminate();
            return;
        }
        AiControl_1.AiControl.ins.doorMotion(this, function () {
            AiControl_1.AiControl.ins.eggMotion(_this, function () {
                AiControl_1.AiControl.ins.hairballMotion(_this, function () {
                    AiControl_1.AiControl.ins.fesEleMotion(_this, function () {
                        if (_this.hasPassed) {
                            if (!_this.isCountingTime) {
                                _this.terminateSteps();
                            }
                            else {
                                _this.submit();
                            }
                            return;
                        }
                        _this.hasPassed = _this.judgePass();
                        if (_this.hasPassed) {
                            _this.commonContinuityTimes = 1;
                            _this.effectContinuityTimes = 1;
                            var rect_1 = _this.addChild(Tools_1.Tools.getRect(_this.width, _this.height, 0x000000, 0.7));
                            _this.addChild(movieClips.bonusTime);
                            movieClips.bonusTime.play(1, function () {
                                _this.removeChild(rect_1);
                                _this.removeChild(movieClips.bonusTime);
                                RectsWaveAni_1.RectsWaveAni(_this.lattices, _this.map, function () {
                                    _this.terminateSteps();
                                });
                            });
                            return;
                        }
                        _this.oneStepScoreToast();
                        _this.commonContinuityTimes = 0;
                        _this.effectContinuityTimes = 0;
                        if (_this.steps == 0) {
                            if (!_this.addedStepWarning && Tools_1.Tools.gameData.tools.steps > 0) {
                                _this.addedStepWarning = true;
                                ctrls_1.showPanel(NoStepPanel_1.NoStepPanel, {
                                    reviveFun: function () { return __awaiter(_this, void 0, void 0, function () {
                                        var s, count_1, countAll_1;
                                        var _this = this;
                                        return __generator(this, function (_a) {
                                            switch (_a.label) {
                                                case 0:
                                                    ctrls_1.showWaiting();
                                                    return [4, Tools_1.Tools.consumerTools(PropType_1.PropType.STEPS)];
                                                case 1:
                                                    s = _a.sent();
                                                    ctrls_1.hideWaiting();
                                                    if (!s) {
                                                        this.submit(false);
                                                    }
                                                    else {
                                                        count_1 = 0;
                                                        countAll_1 = 2;
                                                        AiControl_1.AiControl.ins.jellyMotion(this, function () {
                                                            if (++count_1 === countAll_1)
                                                                _this.aiMotionCheckDieMap();
                                                        });
                                                        AiControl_1.AiControl.ins.bubbleMotion(this, function () {
                                                            if (++count_1 === countAll_1)
                                                                _this.aiMotionCheckDieMap();
                                                        });
                                                        this.playAni(RecoverName_1.RecoverName.STEP_ANI, [BonusShootAni_1.stepPosition[0] - 40, BonusShootAni_1.stepPosition[1] + 20]);
                                                        setTimeout(function () { _this.steps += Tools_1.Tools.addSteps; }, 333);
                                                        this.updateScene();
                                                    }
                                                    return [2];
                                            }
                                        });
                                    }); }
                                });
                            }
                            else {
                                _this.submit(false);
                            }
                            return;
                        }
                        var count = 0;
                        var countAll = 2;
                        AiControl_1.AiControl.ins.jellyMotion(_this, function () {
                            if (++count === countAll)
                                _this.aiMotionCheckDieMap();
                        });
                        AiControl_1.AiControl.ins.bubbleMotion(_this, function () {
                            if (++count === countAll)
                                _this.aiMotionCheckDieMap();
                        });
                    });
                });
            });
        });
    };
    PlayScene.prototype.aiMotionCheckDieMap = function () {
        var _this = this;
        this.warningCop = Tool_1.Tool.dieMapCheck(this.lattices);
        if (!this.warningCop) {
            if (Tool_1.Tool.alreadyDie(this.lattices)) {
                ctrls_1.showToast("元素已无法消除");
                setTimeout(function () {
                    _this.submit(false);
                }, 1000);
            }
            else {
                ctrls_1.showToast("没有可以消除的元素");
                setTimeout(function () {
                    _this.upsetElement();
                }, 1000);
            }
        }
        else {
            if (this.gameGuide) {
                this.addChild(this.gameGuide);
                this.gameGuide.show();
            }
            ;
            this.enableMouseEvt(true);
            this.openRedBombPanel();
        }
    };
    PlayScene.prototype.effectCombination = function () {
        var one = this.eliminatedElements[0];
        var two = this.eliminatedElements[1];
        var lat1 = this.lattices[one];
        var lat2 = this.lattices[two];
        var ele1 = this.lattices[one].element;
        var ele2 = this.lattices[two].element;
        this.eliminatedElements = [];
        if (ele1.effectType == EffectType_1.EffectType.MAGICLION &&
            ele2.effectType == EffectType_1.EffectType.MAGICLION) {
            this.playAni(RecoverName_1.RecoverName.MAGICLION_ANI, Tool_1.Tool.getPositionByIndex(one));
            this.playAni(RecoverName_1.RecoverName.MAGICLION_ANI, Tool_1.Tool.getPositionByIndex(two));
            this.recoverEle(one);
            this.recoverEle(two);
            for (var i = 0; i < this.lattices.length; i++) {
                var lat = this.lattices[i];
                if (Tool_1.Tool.judgeEliminate(lat)) {
                    if (this.eliminatedElements.indexOf(i) == -1)
                        this.eliminatedElements.push(i);
                    if (Tool_1.Tool.judgeHasScore(lat.element)) {
                        this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes.MM, Tool_1.Tool.getPositionByIndex(i));
                    }
                }
            }
        }
        else if ((ele1.effectType == EffectType_1.EffectType.MAGICLION || ele2.effectType == EffectType_1.EffectType.MAGICLION)) {
            var magic = void 0, other = void 0;
            var magicIndex;
            if (ele1.effectType == EffectType_1.EffectType.MAGICLION) {
                magic = ele1;
                other = ele2;
                magicIndex = one;
            }
            else {
                magic = ele2;
                other = ele1;
                magicIndex = two;
            }
            this.playAni(RecoverName_1.RecoverName.MAGICLION_ANI, Tool_1.Tool.getPositionByIndex(magicIndex));
            this.recoverEle(magicIndex);
            var rotateData = {
                p: Tool_1.Tool.getPositionByIndex(magicIndex),
                elementsIndex: [],
                type: other.type,
            };
            this.magicRotateData = [rotateData];
            for (var i = 0; i < this.lattices.length; i++) {
                var lat = this.lattices[i];
                if (Tool_1.Tool.judgeMagicEliminate(lat) &&
                    lat.element.type == other.type) {
                    if (this.eliminatedElements.indexOf(i) == -1)
                        this.eliminatedElements.push(i);
                    if (other.effectType != null) {
                        if (other.effectType == EffectType_1.EffectType.EXPLOSIVE) {
                            lat.element.effectType = EffectType_1.EffectType.EXPLOSIVE;
                        }
                        else {
                            lat.element.effectType = Math.random() > 0.5 ? EffectType_1.EffectType.HORIZONTAL : EffectType_1.EffectType.VERTICAL;
                        }
                    }
                    else {
                        if (Tool_1.Tool.judgeMagicRotate(lat.element)) {
                            rotateData.elementsIndex.push(i);
                        }
                    }
                    if (Tool_1.Tool.judgeHasScore(lat.element)) {
                        this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes["3"], Tool_1.Tool.getPositionByIndex(i));
                    }
                }
            }
        }
        else if (ele1.effectType < 2 && ele2.effectType < 2) {
            var p = Tool_1.Tool.getPositionByIndex(one);
            this.playAni(RecoverName_1.RecoverName.CROSS_ANI, p);
            this.recoverEle(one);
            this.recoverEle(two);
            for (var i = 0; i < this.lattices.length; i++) {
                var lat = this.lattices[i];
                if (Tool_1.Tool.judgeEliminate(lat) && (lat.row == lat1.row || lat.column == lat1.column)) {
                    if (this.eliminatedElements.indexOf(i) == -1)
                        this.eliminatedElements.push(i);
                    if (Tool_1.Tool.judgeHasScore(lat.element)) {
                        this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes.LL, Tool_1.Tool.getPositionByIndex(i));
                    }
                }
            }
        }
        else if ((ele1.effectType < 2 || ele2.effectType < 2) &&
            (ele1.effectType == EffectType_1.EffectType.EXPLOSIVE || ele2.effectType == EffectType_1.EffectType.EXPLOSIVE)) {
            var p = Tool_1.Tool.getPositionByIndex(one);
            this.playAni(RecoverName_1.RecoverName.THREECROSS_ANI, p);
            this.recoverEle(one);
            this.recoverEle(two);
            for (var i = 0; i < this.lattices.length; i++) {
                var lat = this.lattices[i];
                if (Tool_1.Tool.judgeEliminate(lat) &&
                    (Math.abs(lat.row - lat1.row) < 2 || Math.abs(lat.column - lat1.column) < 2)) {
                    if (this.eliminatedElements.indexOf(i) == -1)
                        this.eliminatedElements.push(i);
                    if (Tool_1.Tool.judgeHasScore(lat.element)) {
                        this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes.EL, Tool_1.Tool.getPositionByIndex(i));
                    }
                }
            }
        }
        else if (ele1.effectType == EffectType_1.EffectType.EXPLOSIVE && ele2.effectType == EffectType_1.EffectType.EXPLOSIVE) {
            var p = Tool_1.Tool.getPositionByIndex(one);
            var boomAni = this.playAni(RecoverName_1.RecoverName.BOOM_ANI, p);
            boomAni.scaleX = boomAni.scaleY = 2;
            this.recoverEle(one);
            this.recoverEle(two);
            for (var i = 0; i < this.lattices.length; i++) {
                var lat = this.lattices[i];
                if (Tool_1.Tool.judgeEliminate(lat) &&
                    (Math.abs(lat.row - lat1.row) < 3 && Math.abs(lat.column - lat1.column) < 3)) {
                    if (this.eliminatedElements.indexOf(i) == -1)
                        this.eliminatedElements.push(i);
                    if (Tool_1.Tool.judgeHasScore(lat.element)) {
                        this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes.EE, Tool_1.Tool.getPositionByIndex(i));
                    }
                }
            }
        }
    };
    PlayScene.prototype.rotateEliminate = function () {
        for (var m = 0; m < this.magicRotateData.length; m++) {
            var indexs = this.magicRotateData[m].elementsIndex;
            var position = this.magicRotateData[m].p;
            for (var n = 0; n < indexs.length; n++) {
                var roIndex = indexs[n];
                var roEle = this.lattices[roIndex].element;
                if (this.lattices[roIndex].element.temEffectType != null)
                    continue;
                MagicRotateAni_1.MagicRotateAni(roEle, position, this);
                this.recoverEle(roIndex);
                Tool_1.Tool.removeEle(roIndex, this.eliminatedElements);
            }
        }
        this.magicRotateData.length = 0;
    };
    PlayScene.prototype.commonEliminate = function () {
        var effectIndexs = [];
        for (var i = this.eliminatedElements.length - 1; i >= 0; i--) {
            var index = this.eliminatedElements[i];
            var lat = this.lattices[index];
            var ele = lat.element;
            var p = Tool_1.Tool.getPositionByIndex(index);
            if (!ele) {
            }
            else if (ele.hasState(StateType_1.StateType.LOCK)) {
                ele.setState(StateType_1.StateType.LOCK, false);
            }
            else if (ele.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
                var hairballBrownState = ele.getState(StateType_1.StateType.HAIRBALLBROWN);
                hairballBrownState.isActive = true;
            }
            else if (ele.hasState(StateType_1.StateType.HAIRBALLGREY)) {
                this.playAni(RecoverName_1.RecoverName.HAIRBALLGREYDIS_ANI, p);
                ele.setState(StateType_1.StateType.HAIRBALLGREY, false);
                this.goElementTarget(ElementType_1.ElementType.HAIRBALLGREY, [ele.x, ele.y]);
            }
            else if (ele.hasState(StateType_1.StateType.HAIRBALLGREY)) {
                var blackballBrownState = ele.getState(StateType_1.StateType.HAIRBALLBLACK);
                if (blackballBrownState.isAwake) {
                    blackballBrownState.isAwake = false;
                }
                else {
                    this.playAni(RecoverName_1.RecoverName.HAIRBALLBLACKDIS_ANI, p);
                    ele.setState(StateType_1.StateType.HAIRBALLBLACK, false);
                    this.goElementTarget(ElementType_1.ElementType.HAIRBALLBLACK, [ele.x, ele.y]);
                }
            }
            else if (ele.effectType != null) {
                effectIndexs.push(index);
            }
            else {
                if (ele.temEffectType != null) {
                    ele.effectType = ele.temEffectType;
                    ele.temEffectType = null;
                    if (ele.hasState(StateType_1.StateType.BUBBLE)) {
                        ele.setState(StateType_1.StateType.BUBBLE, false);
                    }
                    this.goElementTarget(ele.type, [ele.x, ele.y]);
                    this.checkNebAll(this.lattices[index]);
                }
                else {
                    if (ElementType_1.FiveBaseElementTypes.indexOf(ele.type) >= 0) {
                        this.addChild(EleDisAni_1.EleDisAni(ele.type)).position.set(ele.x, ele.y);
                        this.recoverEle(index);
                    }
                    else if (ele.type == ElementType_1.ElementType.ROCK) {
                        this.removeRock(index);
                        this.goElementTarget(ele.type, [ele.x, ele.y]);
                    }
                    else if (ele.type == ElementType_1.ElementType.JELLY) {
                        this.removeJelly(index);
                        this.goElementTarget(ele.type, [ele.x, ele.y]);
                    }
                    else if (ele.type == ElementType_1.ElementType.CHICKEN_EGG) {
                        ele.chickenEgg.statusNum--;
                        ele.chickenEgg.shakeAni();
                        this.playAni(RecoverName_1.RecoverName.EGGBROKEN_ANI, p);
                    }
                    else if (ele.type == ElementType_1.ElementType.FESTIVALELE_BIG) {
                        ele.festivalEle.statusNum--;
                    }
                    else if (ele.type == ElementType_1.ElementType.FESTIVALELE_SMALL) {
                        this.removeFestivalEleSmall(index);
                    }
                }
            }
            this.eliminatedElements.splice(i, 1);
        }
        return effectIndexs;
    };
    PlayScene.prototype.effectEliminate = function (effectIndexs) {
        var _this = this;
        if (effectIndexs.length && !this.hasPassed)
            this.effectContinuityTimes++;
        var judgeExclude = function (i) {
            return _this.eliminatedElements.indexOf(i) < 0 && effectIndexs.indexOf(i) < 0;
        };
        for (var j = 0; j < effectIndexs.length; j++) {
            var index = effectIndexs[j];
            var lat = this.lattices[index];
            var ele = lat.element;
            var p = Tool_1.Tool.getPositionByIndex(index);
            switch (ele.effectType) {
                case EffectType_1.EffectType.MAGICLION:
                    this.playAni(RecoverName_1.RecoverName.MAGICLION_ANI, p);
                    this.recoverEle(index);
                    var types = this.chapterData.baseElementTypes.slice();
                    for (var iii = 0; iii < this.magicRotateData.length; iii++) {
                        Tool_1.Tool.removeEle(this.magicRotateData[iii].type, types);
                    }
                    var type = types.length ? Tool_1.Tool.randomT(types) : Tool_1.Tool.randomT(this.chapterData.baseElementTypes);
                    var rotateData = {
                        p: Tool_1.Tool.getPositionByIndex(index),
                        elementsIndex: [],
                        type: type,
                    };
                    this.magicRotateData.push(rotateData);
                    for (var i = 0; i < this.lattices.length; i++) {
                        if (Tool_1.Tool.judgeMagicEliminate(this.lattices[i]) &&
                            this.lattices[i].element.type == type &&
                            judgeExclude(i)) {
                            this.eliminatedElements.push(i);
                            if (Tool_1.Tool.judgeMagicRotate(this.lattices[i].element)) {
                                rotateData.elementsIndex.push(i);
                            }
                            if (Tool_1.Tool.judgeHasScore(this.lattices[i].element)) {
                                this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes["3"], Tool_1.Tool.getPositionByIndex(i));
                            }
                        }
                    }
                    break;
                case EffectType_1.EffectType.EXPLOSIVE:
                    var boomAni = this.playAni(RecoverName_1.RecoverName.BOOM_ANI, p);
                    boomAni.scaleX = boomAni.scaleY = 1;
                    this.recoverEle(index);
                    Tool_1.Tool.getExplosiveIndexes(lat, this.lattices).forEach(function (i) {
                        if (judgeExclude(i)) {
                            _this.eliminatedElements.push(i);
                            if (Tool_1.Tool.judgeHasScore(_this.lattices[i].element)) {
                                _this.pushScoreAni(exports.baseScore * _this.effectContinuityTimes * exports.effectBaseTimes["2"], Tool_1.Tool.getPositionByIndex(i));
                            }
                        }
                    });
                    break;
                case EffectType_1.EffectType.HORIZONTAL:
                    var row = lat.row;
                    this.playAni(RecoverName_1.RecoverName.HORIZONTAL_ANI, p);
                    this.recoverEle(index);
                    for (var i = 0; i < Tool_1.Tool.colNum; i++) {
                        var ein = Tool_1.Tool.rcToIndex(row, i);
                        if (Tool_1.Tool.judgeEliminate(this.lattices[ein]) &&
                            judgeExclude(ein)) {
                            this.eliminatedElements.push(ein);
                            if (Tool_1.Tool.judgeHasScore(this.lattices[ein].element)) {
                                this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes["0"], Tool_1.Tool.getPositionByIndex(ein));
                            }
                        }
                    }
                    break;
                case EffectType_1.EffectType.VERTICAL:
                    var col = lat.column;
                    this.playAni(RecoverName_1.RecoverName.VERTICAL_ANI, p);
                    this.recoverEle(index);
                    for (var i = 0; i < Tool_1.Tool.rowNum; i++) {
                        var ein = Tool_1.Tool.rcToIndex(i, col);
                        if (Tool_1.Tool.judgeEliminate(this.lattices[ein]) &&
                            judgeExclude(ein)) {
                            this.eliminatedElements.push(ein);
                            if (Tool_1.Tool.judgeHasScore(this.lattices[ein].element)) {
                                this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes["1"], Tool_1.Tool.getPositionByIndex(ein));
                            }
                        }
                    }
                    break;
            }
        }
    };
    PlayScene.prototype.judgePass = function () {
        if (this.passElements) {
            for (var i = 0; i < this.passElements.length; i++) {
                if (this.passElements[i]) {
                    return false;
                }
            }
            return true;
        }
        else {
            if (this.score > this.chapterData.passTarget.score) {
                return true;
            }
            else {
                return false;
            }
        }
    };
    PlayScene.prototype.terminateSteps = function () {
        var _this = this;
        var effectElements = [], elements = [];
        for (var i = Tool_1.Tool.colNum * Tool_1.Tool.rowNum - 1; i >= 0; i--) {
            var lat = this.lattices[i];
            if (Tool_1.Tool.judgeBaseEle(lat)) {
                if (lat.element.effectType != null) {
                    effectElements.push(i);
                }
                else {
                    elements.push(lat.element);
                }
            }
        }
        if (effectElements.length) {
            Array.prototype.push.apply(this.eliminatedElements, effectElements);
            this.eliminate();
        }
        else {
            if (this.steps == 0 || elements.length == 0) {
                this.score += 1000 * this.steps;
                this.steps = 0;
                this.submit();
                return;
            }
            this.isCountingTime = true;
            var countAll_2 = Math.min(this.steps, elements.length);
            var count_2 = 0;
            var deltaCount = 0;
            var _loop_3 = function () {
                rand = Math.floor(Math.random() * elements.length);
                var ele = elements.splice(rand, 1)[0];
                if (!ele)
                    return "break";
                deltaCount++;
                var bonusShootAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.BONUSSHOOT_ANI);
                if (!bonusShootAni) {
                    bonusShootAni = new BonusShootAni_1.BonusShootAni();
                }
                setTimeout(function () {
                    _this.steps--;
                    _this.score += 1000;
                    _this.addChild(bonusShootAni);
                    bonusShootAni.play([ele.x, ele.y], function () {
                        ele.effectType = Math.random() > 0.5 ? EffectType_1.EffectType.HORIZONTAL : EffectType_1.EffectType.VERTICAL;
                        ele.removeAllState();
                        _this.eliminatedElements.push(ele.index);
                        _this.pushScoreAni(exports.baseScore * 1 * 1.5, [ele.x, ele.y]);
                        if (++count_2 == countAll_2) {
                            _this.eliminate();
                            if (_this.steps) {
                                _this.score += 1000 * _this.steps;
                                _this.steps = 0;
                            }
                        }
                    });
                }, 150 * deltaCount);
            };
            var rand;
            while (deltaCount < countAll_2) {
                var state_1 = _loop_3();
                if (state_1 === "break")
                    break;
            }
        }
    };
    PlayScene.prototype.pushScoreAni = function (score, p) {
        var scoreAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.SCORE_ANI);
        if (!scoreAni) {
            scoreAni = new ScoreAni_1.ScoreAni();
        }
        scoreAni.score = score;
        scoreAni.x = p[0];
        scoreAni.y = p[1];
        this.scoreAnis.push(scoreAni);
    };
    PlayScene.prototype.oneStepScoreToast = function () {
        var _this = this;
        var sv;
        if (this.oneStepScore > 5000) {
            sv = "wonderful";
        }
        else if (this.oneStepScore > 3500) {
            sv = "amazing";
        }
        else if (this.oneStepScore > 2000) {
            sv = "great";
        }
        else if (this.oneStepScore > 1000) {
            sv = "good";
        }
        if (sv && movieClips[sv]) {
            this.addChild(movieClips[sv]);
            movieClips[sv].play(1, function () {
                _this.removeChild(movieClips[sv]);
            });
        }
        this.oneStepScore = 0;
    };
    PlayScene.prototype.upsetElement = function () {
        var _this = this;
        var lats = [];
        var anis = [];
        for (var i = 0; i < this.lattices.length; i++) {
            var lat = this.lattices[i];
            if (Tool_1.Tool.judgeUpsetMove(lat))
                lats.push(lat);
        }
        var latsCopy = lats.slice();
        for (var i = 0; i < lats.length; i++) {
            var ele = lats[i].element;
            var rand = Math.floor(Math.random() * latsCopy.length);
            var lat_1 = latsCopy.splice(rand, 1)[0];
            anis.push([ele, lat_1.index]);
        }
        var count = 0;
        var countAll = anis.length;
        for (var i = 0; i < countAll; i++) {
            var ele = anis[i][0];
            var index = anis[i][1];
            var p = Tool_1.Tool.getPositionByIndex(index);
            var lat = this.lattices[index];
            lat.element = ele;
            FYGE.Tween.get(ele)
                .to({ x: p[0], y: p[1] }, 500)
                .call(function () {
                if (++count == countAll) {
                    if (_this.threeMatch()) {
                        _this.eliminate();
                    }
                    else {
                        _this.warningCop = Tool_1.Tool.dieMapCheck(_this.lattices);
                        if (!_this.warningCop) {
                            _this.upsetElement();
                        }
                        else {
                            _this.enableMouseEvt(true);
                            _this.openRedBombPanel();
                        }
                    }
                }
            });
        }
    };
    PlayScene.prototype.recoverEle = function (index) {
        var ele = this.removeOperation(index);
        if (ele.type != ElementType_1.ElementType.LOLLIPOP)
            this.checkNebAll(this.lattices[index]);
        this.goElementTarget(ele.type, [ele.x, ele.y]);
    };
    PlayScene.prototype.getSubmitJson = function () {
        var json = {};
        return JSON.stringify(json);
    };
    PlayScene.prototype.submit = function (suc) {
        var _this = this;
        if (suc === void 0) { suc = true; }
        var params = {
            level: this.data.chapter,
            score: this.score,
            stars: this.scoreProgress.starCount,
            isVisitSuccess: suc,
        };
        ctrls_1.showWaiting();
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.gameOver, params, function (s, res) {
            ctrls_1.hideWaiting();
            if (s) {
                Tools_1.Tools.gameOver(Object.assign(res.data || {}, params));
            }
            else {
                if (res.data) {
                    ctrls_1.showToast("网络开小差了\n再次连接中");
                    ctrls_1.wait(function () { _this.submit(suc); }, 1300);
                }
                else {
                    ctrls_1.showToast(res.message || "活动太火爆了\n请稍后再来");
                    ctrls_1.wait(function () { ctrls_1.changeScene(MapScene_1.MapScene); }, 1300);
                }
            }
        }, true);
    };
    PlayScene.prototype.openRedBombPanel = function () {
        if (this.redBombPanelMark) {
            this.redBombPanelMark = false;
        }
    };
    PlayScene.prototype.returnPanels = function (panelName, data) {
        var panels = [], params = [];
        if (this.redBombPanelMark) {
            panels.push(redBombPanelName);
            params.push(null);
            this.redBombPanelMark = false;
        }
        panels.push(panelName);
        params.push(data);
        return [panels, params];
    };
    PlayScene.prototype.playAni = function (name, p) {
        var ani = Pool_1.Pool.takeOut(name);
        if (!ani) {
            ani = new aniClass[name]();
        }
        ani.x = p[0];
        ani.y = p[1];
        ani.play();
        if (name == RecoverName_1.RecoverName.MAGICLION_ANI) {
            this.addChildAt(ani, this.getChildIndex(this.map) + 1);
        }
        else {
            this.addChild(ani);
        }
        return ani;
    };
    PlayScene.prototype.iceBroken = function (lat) {
        if (lat && lat.ice) {
            var ice = lat.ice;
            ice.countNum--;
            if (ice.countNum == 0) {
                this.map.removeChild(ice);
                Pool_1.Pool.recover(RecoverName_1.RecoverName.ICE, ice);
                lat.ice = null;
                this.goElementTarget(ElementType_1.ElementType.ICE, [ice.x, ice.y]);
            }
            else {
                ice.alpha = 0.75;
            }
            var p = Tool_1.Tool.getPositionByIndex(lat.index);
            this.playAni(RecoverName_1.RecoverName.ICE_ANI, p);
        }
    };
    PlayScene.prototype.goElementTarget = function (type, fromP) {
        var _this = this;
        if (!this.passElements)
            return;
        if (this.passElements[type] != undefined) {
            if (this.passElements[type] != 0) {
                this.passElements[type]--;
                var p = this.elementTargets.targets[type].localToGlobal({ x: 40 * 0.8, y: 40 * 0.8 });
                this.addChild(FlyTargetAni_1.FlyTargetAni(type, fromP, [p.x, p.y - layers_1.layers.stageOffsetY], function () {
                    _this.elementTargets.targets[type].count--;
                }));
            }
            this.hasEliminatedElements[type]++;
        }
    };
    PlayScene.prototype.checkNebEle = function (lat, checkFun) {
        var indexMy = lat.index;
        var indexs = [
            indexMy - Tool_1.Tool.colNum,
            indexMy + Tool_1.Tool.colNum,
        ];
        if (lat.column > 0) {
            indexs.push(indexMy - 1);
        }
        if (lat.column < Tool_1.Tool.colNum - 1) {
            indexs.push(indexMy + 1);
        }
        for (var i = 0; i < indexs.length; i++) {
            var index = indexs[i];
            var lat_2 = this.lattices[index];
            if (lat_2 && lat_2.element && !lat_2.doorClosed && checkFun(lat_2)) {
                if (this.eliminatedElements.indexOf(index) == -1)
                    this.eliminatedElements.push(index);
            }
        }
    };
    PlayScene.prototype.checkNebAll = function (latttice) {
        this.iceBroken(latttice);
        this.checkNebEle(latttice, function (lat) {
            return lat.element.type == ElementType_1.ElementType.ROCK;
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.type == ElementType_1.ElementType.JELLY;
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.type == ElementType_1.ElementType.CHICKEN_EGG;
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.hasState(StateType_1.StateType.HAIRBALLGREY);
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.hasState(StateType_1.StateType.HAIRBALLBLACK);
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.type == ElementType_1.ElementType.FESTIVALELE_BIG;
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.type == ElementType_1.ElementType.FESTIVALELE_SMALL;
        });
    };
    PlayScene.prototype.removeRock = function (index) {
        this.removeOperation(index);
        this.playAni(RecoverName_1.RecoverName.ROCK_ANI, Tool_1.Tool.getPositionByIndex(index));
    };
    PlayScene.prototype.removeJelly = function (index) {
        this.jellyBrokenMark = true;
        this.removeOperation(index);
        this.playAni(RecoverName_1.RecoverName.JELLYDIS_ANI, Tool_1.Tool.getPositionByIndex(index));
    };
    PlayScene.prototype.removeFestivalEleSmall = function (index) {
        var _this = this;
        var ele = this.removeOperation(index);
        if (this.festivalTargetNum) {
            this.festivalTargetNum--;
            var p = this.festivalTarget.localToGlobal({ x: 40 * 0.8, y: 40 * 0.8 });
            this.addChild(FlyTargetAni_1.FlyTargetAni(ElementType_1.ElementType.FESTIVALELE_SMALL, [ele.x, ele.y], [p.x, p.y], function () {
                _this.festivalTarget.count--;
            }));
            if (!this.festivalTargetNum) {
            }
        }
    };
    PlayScene.prototype.removeOperation = function (index) {
        if (!this.lattices[index] || !this.lattices[index].element)
            return null;
        var ele = this.lattices[index].element;
        this.emptys.push(index);
        this.elementContainer.removeChild(ele);
        Pool_1.Pool.recover(RecoverName_1.RecoverName.ELEMENT, ele);
        this.lattices[index].element = null;
        return ele;
    };
    PlayScene.prototype.redBombLightAni = function (index, callback) {
        callback();
    };
    return PlayScene;
}(Scene_1.Scene));
exports.PlayScene = PlayScene;
var MusicBtn = (function (_super) {
    __extends(MusicBtn, _super);
    function MusicBtn() {
        var _this = this;
        var t = RES_1.RES.getRes(Tools_1.Tools.musicOn ? "musicOn.png" : "musicOff.png");
        _this = _super.call(this, t) || this;
        _this.addEventListener(FYGE.MouseEvent.CLICK, function () {
            Tools_1.Tools.musicOn = !Tools_1.Tools.musicOn;
            _this.texture = RES_1.RES.getRes(Tools_1.Tools.musicOn ? "musicOn.png" : "musicOff.png");
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openMusic, { isOn: Tools_1.Tools.musicOn });
        }, _this);
        Main_1.GDispatcher.addEventListener(G_EVENT_1.G_EVENT.ON_SHOW, _this.onShow, _this);
        return _this;
    }
    MusicBtn.prototype.onShow = function () {
        if (Tools_1.Tools.musicOn)
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openMusic, { isOn: true });
    };
    MusicBtn.prototype.destroy = function () {
        Main_1.GDispatcher.removeEventListener(G_EVENT_1.G_EVENT.ON_SHOW, this.onShow, this);
        _super.prototype.destroy.call(this);
    };
    return MusicBtn;
}(FYGE.Sprite));


/***/ }),

/***/ "./src/scene/map/CheckBtn.ts":
/*!***********************************!*\
  !*** ./src/scene/map/CheckBtn.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.CHECK_TYPE = void 0;
var Button = FYGE.Button;
var Container = FYGE.Container;
var MouseEvent = FYGE.MouseEvent;
var Point = FYGE.Point;
var Sprite = FYGE.Sprite;
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var ctrls_1 = __webpack_require__(/*! ../../../module/ctrls */ "./module/ctrls/index.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var StartPanel_1 = __webpack_require__(/*! ../../panels/StartPanel */ "./src/panels/StartPanel.ts");
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var CHECK_TYPE;
(function (CHECK_TYPE) {
    CHECK_TYPE[CHECK_TYPE["COM"] = 0] = "COM";
    CHECK_TYPE[CHECK_TYPE["CUR"] = 1] = "CUR";
})(CHECK_TYPE = exports.CHECK_TYPE || (exports.CHECK_TYPE = {}));
var CheckBtn = (function (_super) {
    __extends(CheckBtn, _super);
    function CheckBtn(data) {
        var _this = _super.call(this) || this;
        _this.checkData = {
            level: 1,
            scores: 0,
            stars: 0,
            isPrizeLevel: false,
            isVisitSuccess: false,
            isPlayed: false,
        };
        _this.btn = null;
        _this.checkTxt = null;
        _this.star = null;
        _this.checkNum = null;
        _this._data = null;
        _this._starCount = 0;
        _this._enabled = true;
        _this._type = CHECK_TYPE.COM;
        _this.initUi(data);
        return _this;
    }
    Object.defineProperty(CheckBtn.prototype, "data", {
        set: function (data) {
            this._data = data;
            this.checkData.isPlayed = true;
            if (!data)
                return;
            if (!data.isVisitSuccess)
                return;
            this.enabled = data.isVisitSuccess;
            this.starCount = data.stars;
            this.checkData = data;
            this.checkData.isPlayed = true;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CheckBtn.prototype, "starCount", {
        get: function () {
            return this._starCount;
        },
        set: function (count) {
            if (count > 3) {
                count = 3;
            }
            else if (count < 1) {
                count = 1;
            }
            if (this._starCount == count)
                return;
            this._starCount = count;
            this.star.forEach(function (value, index) {
                value.enabled = (index < count);
            });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CheckBtn.prototype, "enabled", {
        set: function (enabled) {
            if (this._enabled == enabled)
                return;
            this._enabled = enabled;
            this.btn.enabled = enabled;
            this.star.forEach(function (v) { return v.visible = enabled; });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CheckBtn.prototype, "type", {
        set: function (type) {
            if (this._type == type)
                return;
            this._type = type;
            switch (type) {
                case CHECK_TYPE.COM:
                    break;
                case CHECK_TYPE.CUR:
                    this.addChild(Tools_1.Tools.getSprite("checkTip1.png", -48, -72));
                    break;
            }
        },
        enumerable: false,
        configurable: true
    });
    CheckBtn.prototype.update = function () {
        _super.prototype.update.call(this);
        var up = this.localToGlobal(new Point(), new Point());
        var bp = this.localToGlobal(new Point(0, 120), new Point());
        this.alpha = +(this.stage.viewRect.isPointIn(up) || this.stage.viewRect.isPointIn(bp));
    };
    CheckBtn.prototype.initUi = function (data) {
        this.btn = this.addChild(new Button(RES_1.RES.getRes("mce" + data.check % 3 + ".png"), RES_1.RES.getRes("mce" + data.check % 3 + ".png"), RES_1.RES.getRes("mcd" + data.check % 3 + ".png")));
        var star1 = this.addChild(new CheckStar());
        star1.position.set(7, 125);
        star1.rotation = 10;
        var star2 = this.addChild(new CheckStar());
        star2.position.set(54, 130);
        var star3 = this.addChild(new CheckStar());
        star3.position.set(99, 125);
        star3.rotation = -10;
        this.star = [star1, star2, star3];
        this.checkNum = data.check;
        this.checkData.level = data.check;
        this.checkTxt = this.btn.addChild(Tools_1.Tools.getText(data.check + '', 45, "#f9f9f5", TEXT_ALIGN.CENTER, 164, 0, 18));
        this.checkTxt.bold = true;
        this.enabled = false;
        this.btn.addEventListener(MouseEvent.CLICK, this.clickStart, this);
    };
    CheckBtn.prototype.clickStart = function () {
        console.log("\u5173\u5361:" + this.checkNum);
        console.log(this.checkData);
        ctrls_1.showPanel(StartPanel_1.StartPanel, this.checkData);
    };
    return CheckBtn;
}(Container));
exports.default = CheckBtn;
var CheckStar = (function (_super) {
    __extends(CheckStar, _super);
    function CheckStar() {
        var _this = _super.call(this, RES_1.RES.getRes('map_star_disable.png')) || this;
        _this._enabled = false;
        CheckStar.starDisableTexture = RES_1.RES.getRes('map_star_disable.png');
        CheckStar.starEnableTexture = RES_1.RES.getRes('map_star_enable.png');
        _this.anchor.set(23, 21);
        return _this;
    }
    Object.defineProperty(CheckStar.prototype, "enabled", {
        set: function (enabled) {
            this._enabled = enabled;
            this.texture = enabled ? CheckStar.starEnableTexture : CheckStar.starDisableTexture;
        },
        enumerable: false,
        configurable: true
    });
    CheckStar.starEnableTexture = null;
    CheckStar.starDisableTexture = null;
    return CheckStar;
}(Sprite));


/***/ }),

/***/ "./src/scene/map/MapBottom.ts":
/*!************************************!*\
  !*** ./src/scene/map/MapBottom.ts ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MapPart_1 = __webpack_require__(/*! ./MapPart */ "./src/scene/map/MapPart.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Point = FYGE.Point;
var MapBottom = (function (_super) {
    __extends(MapBottom, _super);
    function MapBottom(data) {
        var _this = _super.call(this, data) || this;
        _this.btnPos = [
            [215, 386],
            [404, 79],
        ];
        _this.data = data;
        _this.bg.texture = RES_1.RES.getRes('map_bg1.jpg');
        _this.initIcon();
        _this.initEffect();
        return _this;
    }
    MapBottom.prototype.initEffect = function () {
    };
    MapBottom.prototype.update = function () {
        _super.prototype.update.call(this);
        var up = this.localToGlobal(new Point(0, -10), new Point());
        var bp = this.localToGlobal(new Point(0, MapBottom.HEIGHT + 10), new Point());
        var ucp = this.localToGlobal(new Point(0, MapBottom.HEIGHT / 4), new Point());
        var bcp = this.localToGlobal(new Point(0, MapBottom.HEIGHT / 4 * 3), new Point());
        this.alpha = +(this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp));
    };
    MapBottom.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    MapBottom.HEIGHT = 856;
    MapBottom.totalCount = 2;
    return MapBottom;
}(MapPart_1.default));
exports.default = MapBottom;


/***/ }),

/***/ "./src/scene/map/MapMid.ts":
/*!*********************************!*\
  !*** ./src/scene/map/MapMid.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MapPart_1 = __webpack_require__(/*! ./MapPart */ "./src/scene/map/MapPart.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Point = FYGE.Point;
var MapMid = (function (_super) {
    __extends(MapMid, _super);
    function MapMid(data) {
        var _this = _super.call(this, data) || this;
        _this.btnPos = [
            [496, 1074],
            [363, 784],
            [201, 560],
            [152, 281],
            [256, 63],
        ];
        _this.data = data;
        _this.bg.texture = RES_1.RES.getRes('map_bg2.jpg');
        _this.initIcon();
        _this.initEffect();
        return _this;
    }
    MapMid.prototype.initEffect = function () {
    };
    MapMid.prototype.update = function () {
        _super.prototype.update.call(this);
        var up = this.localToGlobal(new Point(0, -10), new Point());
        var bp = this.localToGlobal(new Point(0, MapMid.HEIGHT + 10), new Point());
        var ucp = this.localToGlobal(new Point(0, MapMid.HEIGHT / 4), new Point());
        var bcp = this.localToGlobal(new Point(0, MapMid.HEIGHT / 4 * 3), new Point());
        this.alpha = +(this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp));
    };
    MapMid.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    MapMid.HEIGHT = 1290;
    MapMid.totalCount = 5;
    return MapMid;
}(MapPart_1.default));
exports.default = MapMid;


/***/ }),

/***/ "./src/scene/map/MapPart.ts":
/*!**********************************!*\
  !*** ./src/scene/map/MapPart.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Sprite = FYGE.Sprite;
var CheckBtn_1 = __webpack_require__(/*! ./CheckBtn */ "./src/scene/map/CheckBtn.ts");
var MapScene_1 = __webpack_require__(/*! ./MapScene */ "./src/scene/map/MapScene.ts");
var Container = FYGE.Container;
var MapPart = (function (_super) {
    __extends(MapPart, _super);
    function MapPart(data) {
        var _this = _super.call(this) || this;
        _this.data = null;
        _this.btnPos = [];
        _this.bg = null;
        _this.bg = _this.addChild(new Sprite());
        _this.data = data;
        return _this;
    }
    MapPart.prototype.update = function () {
        _super.prototype.update.call(this);
    };
    MapPart.prototype.initIcon = function () {
        for (var i = this.data.length - 1; i >= 0; i--) {
            var value = this.data[i];
            var nBtn = this.addChild(new CheckBtn_1.default(value));
            nBtn.position.set(this.btnPos[i][0], this.btnPos[i][1]);
            MapScene_1.MapScene.checkArr[value.check] = nBtn;
        }
    };
    MapPart.totalCount = 0;
    return MapPart;
}(Container));
exports.default = MapPart;


/***/ }),

/***/ "./src/scene/map/MapScene.ts":
/*!***********************************!*\
  !*** ./src/scene/map/MapScene.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MapScene = void 0;
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Scene_1 = __webpack_require__(/*! ../../../module/views/Scene */ "./module/views/Scene.ts");
var MapBottom_1 = __webpack_require__(/*! ./MapBottom */ "./src/scene/map/MapBottom.ts");
var MapTop_1 = __webpack_require__(/*! ./MapTop */ "./src/scene/map/MapTop.ts");
var MapUI_1 = __webpack_require__(/*! ./MapUI */ "./src/scene/map/MapUI.ts");
var MapMid_1 = __webpack_require__(/*! ./MapMid */ "./src/scene/map/MapMid.ts");
var CheckBtn_1 = __webpack_require__(/*! ./CheckBtn */ "./src/scene/map/CheckBtn.ts");
var layers_1 = __webpack_require__(/*! ../../../module/views/layers */ "./module/views/layers.ts");
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var ctrls_1 = __webpack_require__(/*! ../../../module/ctrls */ "./module/ctrls/index.ts");
var FreePowerPanel_1 = __webpack_require__(/*! ../../panels/FreePowerPanel */ "./src/panels/FreePowerPanel.ts");
var Main_1 = __webpack_require__(/*! ../../Main */ "./src/Main.ts");
var HelpPanel_1 = __webpack_require__(/*! ../../panels/HelpPanel */ "./src/panels/HelpPanel.ts");
var ScrollPage = FYGE.ScrollPage;
var Container = FYGE.Container;
var Graphics = FYGE.Graphics;
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var MapScene = (function (_super) {
    __extends(MapScene, _super);
    function MapScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.mapContainer = null;
        _this.scrollPage = null;
        _this.uiLayer = null;
        return _this;
    }
    MapScene.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    Object.defineProperty(MapScene.prototype, "groupNames", {
        get: function () {
            return [
                'map',
            ];
        },
        enumerable: false,
        configurable: true
    });
    MapScene.prototype.initUi = function () {
        _super.prototype.initUi.call(this);
        this.scrollPage = this.addChild(new ScrollPage(750, layers_1.layers.stageHeight, 888, true, true));
        this.mapContainer = this.scrollPage.view.addChild(new Container());
        this.initMap();
        this.updateMapCheck();
        if (!Tools_1.Tools.globalData.isNewUser && Tools_1.Tools.globalData.loginAddPower > 0) {
            ctrls_1.showPanel(FreePowerPanel_1.FreePowerPanel, {
                loginAddPower: Tools_1.Tools.globalData.loginAddPower
            });
        }
        Tools_1.Tools.globalData.loginAddPower = 0;
        if (Tools_1.Tools.globalData.inviteId) {
            ctrls_1.showPanel(HelpPanel_1.HelpPanel);
        }
    };
    MapScene.prototype.updateMapCheck = function () {
        var _this = this;
        if (this.data && this.data.from == 'loading') {
            this.uiLayer = this.addChild(new MapUI_1.default());
            this.initMapByData(Tools_1.Tools.gameData);
            this.uiLayer.updateUI();
            if (Tools_1.Tools.globalData.isNewUser) {
                this.initGuide();
            }
        }
        else {
            Tools_1.Tools.getGameInfo().then(function (success) {
                if (success) {
                    _this.uiLayer = _this.addChild(new MapUI_1.default());
                    _this.initMapByData(Tools_1.Tools.gameData);
                    _this.uiLayer.updateUI();
                }
            });
        }
    };
    MapScene.prototype.initGuide = function () {
        var _this = this;
        setTimeout(function () { return _this.scrollPage.scrollTo(0, 0); });
        var guide = this.addChild(new Container());
        var g = guide.addChild(new Graphics());
        g.beginFill(0, 0.6);
        g.drawRect(0, 0, layers_1.layers.stageWidth, layers_1.layers.stageHeight);
        g.endFill();
        var guide_check = guide.addChild(new CheckBtn_1.default({ check: 1 }));
        guide_check.enabled = true;
        guide_check.type = CheckBtn_1.CHECK_TYPE.CUR;
        var checkY = MapScene.checkArr[1].y;
        guide_check.position.set(MapScene.checkArr[1].x, checkY);
        var guide_light = guide.addChild(Tools_1.Tools.getSprite('guide_light.png'));
        guide_light.anchorTexture.set(0.5, 0.5);
        guide_light.position.set(guide_check.x + 130, guide_check.y + 82);
        guide_light.mouseEnable = guide_light.mouseChildren = false;
        var guide_hand = guide.addChild(Tools_1.Tools.getSprite('guide_hand.png'));
        guide_hand.position.set(guide_check.x + 120, guide_check.y + 70);
        guide_hand.mouseEnable = guide_hand.mouseChildren = false;
        var guide_fox = guide.addChild(Tools_1.Tools.getSprite('guide_fox.png'));
        guide_fox.position.set(45, guide_check.y + 415);
        guide_fox.alpha = 0;
        var guide_tip = guide.addChild(Tools_1.Tools.getSprite('guide_tip.png'));
        guide_tip.anchorTexture.set(0.2, 1);
        guide_tip.position.set(200, guide_check.y + 480);
        guide_tip.scale.set(0, 0);
        guide.alpha = 0;
        Tween.get(guide)
            .to({ alpha: 1 }, 600, Ease.quadInOut);
        Tween.get(guide_tip)
            .wait(300)
            .to({ scaleX: 1, scaleY: 1 }, 300, Ease.quadInOut);
    };
    MapScene.prototype.initMapByData = function (data) {
        var currentLevel = data.currentLevel;
        for (var i = 1; i < currentLevel; i++) {
            MapScene.checkArr[i].type = CheckBtn_1.CHECK_TYPE.COM;
            MapScene.checkArr[i].enabled = true;
        }
        if (currentLevel < 100 && currentLevel > 0) {
            MapScene.checkArr[currentLevel].type = CheckBtn_1.CHECK_TYPE.CUR;
            MapScene.checkArr[currentLevel].enabled = true;
        }
        for (var i = currentLevel + 1; i < 100; i++) {
            MapScene.checkArr[i].type = CheckBtn_1.CHECK_TYPE.COM;
            MapScene.checkArr[i].enabled = false;
        }
        data.records.forEach(function (v) {
            MapScene.checkArr[v.level].data = v;
        });
        if (this.data && this.data.level) {
            this.scrollToCheck(this.data.level);
            MapScene.checkArr[this.data.level].clickStart();
        }
        else {
            this.scrollToCheck(currentLevel);
        }
    };
    MapScene.prototype.initMap = function () {
        var arr = new Array(Tools_1.Tools.maxLevel);
        for (var i = 0; i < Tools_1.Tools.maxLevel; i++) {
            arr[i] = {
                check: i + 1
            };
        }
        arr.reverse();
        var topData = arr.splice(Tools_1.Tools.maxLevel - MapTop_1.default.totalCount, MapTop_1.default.totalCount);
        var bottomData = arr.splice(0, MapBottom_1.default.totalCount);
        var midData = arr;
        var maxHeight = MapTop_1.default.HEIGHT;
        this.mapContainer.addChild(new MapTop_1.default(topData));
        for (var i = midData.length / MapMid_1.default.totalCount - 1; i >= 0; i--) {
            var data = midData.splice(i * MapMid_1.default.totalCount, MapMid_1.default.totalCount);
            var nMid = new MapMid_1.default(data);
            this.mapContainer.addChild(nMid);
            nMid.y = maxHeight;
            maxHeight += MapMid_1.default.HEIGHT;
        }
        var bottom = new MapBottom_1.default(bottomData);
        this.mapContainer.addChild(bottom);
        bottom.y = maxHeight;
        maxHeight += MapBottom_1.default.HEIGHT;
        this.scrollPage.maxDistance = maxHeight;
    };
    MapScene.prototype.scrollToCheck = function (checkNum, time) {
        if (time === void 0) { time = 0; }
        if (checkNum < 1) {
            checkNum = 1;
        }
        else if (checkNum > Tools_1.Tools.maxLevel) {
            checkNum = Tools_1.Tools.maxLevel;
        }
        var check = MapScene.checkArr[checkNum];
        var checkY = check.y + check.parent.y - layers_1.layers.stageHeight / 2 + 50;
        this.scrollPage.scrollTo(checkY, time);
    };
    MapScene.prototype.updateScene = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _super.prototype.updateScene.call(this);
                        return [4, Tools_1.Tools.updatePower()];
                    case 1:
                        _a.sent();
                        this.uiLayer.updateUI();
                        return [2];
                }
            });
        });
    };
    MapScene.prototype.start = function (data) {
        _super.prototype.start.call(this, data);
        var duration = 1500;
        Tween.get(FYGE)
            .wait(500)
            .call(function () { return RES_1.RES.loadGroup('playScene'); })
            .wait(duration)
            .call(function () { return RES_1.RES.loadGroup('playSceneGuide'); })
            .wait(duration)
            .call(function () { return RES_1.RES.loadGroup('fiveVerHorDis'); });
    };
    MapScene.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        Main_1.GDispatcher.addEventListener('UpdateScene', this.updateScene, this);
    };
    MapScene.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        Main_1.GDispatcher.removeEventListener('UpdateScene', this.updateScene, this);
    };
    MapScene.checkArr = [];
    return MapScene;
}(Scene_1.Scene));
exports.MapScene = MapScene;


/***/ }),

/***/ "./src/scene/map/MapTop.ts":
/*!*********************************!*\
  !*** ./src/scene/map/MapTop.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MapPart_1 = __webpack_require__(/*! ./MapPart */ "./src/scene/map/MapPart.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Point = FYGE.Point;
var MapTop = (function (_super) {
    __extends(MapTop, _super);
    function MapTop(data) {
        var _this = _super.call(this, data) || this;
        _this.btnPos = [
            [416, 902],
            [202, 653],
        ];
        _this.data = data;
        _this.bg.texture = RES_1.RES.getRes('map_bg3.jpg');
        _this.initIcon();
        return _this;
    }
    MapTop.prototype.update = function () {
        _super.prototype.update.call(this);
        var up = this.localToGlobal(new Point(0, -10), new Point());
        var bp = this.localToGlobal(new Point(0, MapTop.HEIGHT + 10), new Point());
        var ucp = this.localToGlobal(new Point(0, MapTop.HEIGHT / 4), new Point());
        var bcp = this.localToGlobal(new Point(0, MapTop.HEIGHT / 4 * 3), new Point());
        this.alpha = +(this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp));
    };
    MapTop.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    MapTop.HEIGHT = 1102;
    MapTop.totalCount = 2;
    return MapTop;
}(MapPart_1.default));
exports.default = MapTop;


/***/ }),

/***/ "./src/scene/map/MapUI.ts":
/*!********************************!*\
  !*** ./src/scene/map/MapUI.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Container = FYGE.Container;
var Button = FYGE.Button;
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var MouseEvent = FYGE.MouseEvent;
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var ctrls_1 = __webpack_require__(/*! ../../../module/ctrls */ "./module/ctrls/index.ts");
var RulePanel_1 = __webpack_require__(/*! ../../panels/RulePanel */ "./src/panels/RulePanel.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../../TaoBaoNet */ "./src/TaoBaoNet.ts");
var layers_1 = __webpack_require__(/*! ../../../module/views/layers */ "./module/views/layers.ts");
var LotteryPanel_1 = __webpack_require__(/*! ../../panels/LotteryPanel */ "./src/panels/LotteryPanel.ts");
var MapUI = (function (_super) {
    __extends(MapUI, _super);
    function MapUI() {
        var _this = _super.call(this) || this;
        _this.energyBox = null;
        _this.myPrizeBtn = null;
        _this.ruleBtn = null;
        _this.taskBtn = null;
        _this.clearanceBtn = null;
        _this.initUi();
        _this.initEvent();
        return _this;
    }
    MapUI.prototype.initEvent = function () {
        this.ruleBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.myPrizeBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.taskBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.clearanceBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
    };
    MapUI.prototype.removeEvent = function () {
        this.ruleBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.myPrizeBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.taskBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.clearanceBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
    };
    MapUI.prototype.clickBtn = function (e) {
        var _this = this;
        switch (e.target) {
            case this.ruleBtn:
                ctrls_1.showPanel(RulePanel_1.RulePanel);
                break;
            case this.myPrizeBtn:
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.navigateTo, { url: '/pages/myprize/myprize' }, function () {
                }, true);
                break;
            case this.taskBtn:
                if (Tools_1.Tools.actEnd) {
                    ctrls_1.showToast("活动已结束");
                    return;
                }
                Tools_1.Tools.openTask();
                break;
            case this.clearanceBtn:
                ctrls_1.showPanel(LotteryPanel_1.LotteryPanel, { callFun: function () { return _this.updateUI(); } });
                break;
        }
    };
    MapUI.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.removeEvent();
    };
    MapUI.prototype.initUi = function () {
        var _y = layers_1.layers.stageHeight * 0.1311576354679803;
        this.myPrizeBtn = this.addChild(new Button(RES_1.RES.getRes('map_prizeBtn.png')));
        this.myPrizeBtn.position.set(617, _y);
        this.myPrizeBtn.anchorX = 133;
        this.ruleBtn = this.addChild(new Button(RES_1.RES.getRes('map_ruleBtn.png')));
        this.ruleBtn.position.set(0, _y);
        this.ruleBtn.anchorX = 0;
        this.taskBtn = this.addChild(new Button(RES_1.RES.getRes('map_taskBtn.png')));
        this.taskBtn.position.set(643, _y + 65);
        this.energyBox = this.addChild(new EnergyBox());
        this.energyBox.position.set(8, _y + 65);
        this.clearanceBtn = this.addChild(new Button(RES_1.RES.getRes('clearanceBtn.png')));
        this.clearanceBtn.position.set(0, _y + 174);
        this.clearanceBtn.visible = false;
    };
    MapUI.prototype.updateUI = function () {
        this.energyBox.count = Tools_1.Tools.gameData.power;
        var _a = Tools_1.Tools.gameData, topLevelVisitSuccess = _a.topLevelVisitSuccess, isDrawTopLevelPrize = _a.isDrawTopLevelPrize;
        this.clearanceBtn.visible = topLevelVisitSuccess && !isDrawTopLevelPrize;
    };
    return MapUI;
}(Container));
exports.default = MapUI;
var EnergyBox = (function (_super) {
    __extends(EnergyBox, _super);
    function EnergyBox() {
        var _this = _super.call(this) || this;
        _this.countLabel = null;
        _this._count = 0;
        _this.initUi();
        return _this;
    }
    Object.defineProperty(EnergyBox.prototype, "count", {
        set: function (count) {
            this._count = count;
            this.countLabel.text = '' + count;
        },
        enumerable: false,
        configurable: true
    });
    EnergyBox.prototype.initUi = function () {
        this.addChild(Tools_1.Tools.getSprite('map_energyBg.png'));
        this.countLabel = this.addChild(Tools_1.Tools.getText('0', 33, '#ffffff', TEXT_ALIGN.CENTER, 80, 110, 40));
    };
    EnergyBox.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    return EnergyBox;
}(Container));


/***/ }),

/***/ "./src/something/Pool.ts":
/*!*******************************!*\
  !*** ./src/something/Pool.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Pool = void 0;
var Pool = (function () {
    function Pool() {
    }
    Pool.takeOut = function (name) {
        if (this.pool[name] && this.pool[name].length) {
            return this.pool[name].shift();
        }
        return null;
    };
    Pool.recover = function (name, obj) {
        if (!this.pool[name]) {
            this.pool[name] = [];
        }
        this.pool[name].push(obj);
    };
    Pool.pool = {};
    return Pool;
}());
exports.Pool = Pool;


/***/ }),

/***/ "./src/something/Tool.ts":
/*!*******************************!*\
  !*** ./src/something/Tool.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Tool = void 0;
var Element_1 = __webpack_require__(/*! ./class/Element */ "./src/something/class/Element.ts");
var ElementType_1 = __webpack_require__(/*! ./enum/ElementType */ "./src/something/enum/ElementType.ts");
var EffectType_1 = __webpack_require__(/*! ./enum/EffectType */ "./src/something/enum/EffectType.ts");
var Pool_1 = __webpack_require__(/*! ./Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ./enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RectMask_1 = __webpack_require__(/*! ./class/RectMask */ "./src/something/class/RectMask.ts");
var FallAniData_1 = __webpack_require__(/*! ./interface/FallAniData */ "./src/something/interface/FallAniData.ts");
var StateType_1 = __webpack_require__(/*! ./enum/StateType */ "./src/something/enum/StateType.ts");
var offsetYTwo = [];
var gameAreaHeightTwo = [];
function initClientScale() {
    var sysInfo;
    if (my)
        sysInfo = my.getSystemInfoSync();
    var stageHeight = sysInfo ? sysInfo.windowHeight / sysInfo.windowWidth * 750 :
        document.body.clientHeight / document.body.clientWidth * 750;
    var middleHeight = 80 * 9;
    var topHeight = 238;
    var botHeight = 140 + 20;
    var smallestHeight = topHeight + middleHeight + botHeight;
    if (stageHeight < smallestHeight) {
        offsetYTwo[0] = topHeight;
        offsetYTwo[1] = topHeight;
        gameAreaHeightTwo[0] = middleHeight;
        gameAreaHeightTwo[1] = middleHeight + 45;
    }
    else {
        offsetYTwo[0] = topHeight + (stageHeight - smallestHeight) / 2;
        offsetYTwo[1] = topHeight + (stageHeight - smallestHeight - 45) / 2;
        gameAreaHeightTwo[0] = stageHeight - topHeight - botHeight;
        ;
        gameAreaHeightTwo[1] = stageHeight - topHeight - botHeight;
    }
}
var Tool = (function () {
    function Tool() {
    }
    Tool.init = function (isTwo, hasLollipop) {
        if (isTwo === void 0) { isTwo = false; }
        if (hasLollipop === void 0) { hasLollipop = false; }
        if (!offsetYTwo.length)
            initClientScale();
        var ooox = isTwo ? 55 : 15;
        var oooy = hasLollipop ? offsetYTwo[1] : offsetYTwo[0];
        this.gameAreaHeight = hasLollipop ? gameAreaHeightTwo[1] : gameAreaHeightTwo[0];
        if (this.offsetX == ooox && this.offsetY == oooy)
            return;
        this.offsetX = ooox;
        this.offsetY = oooy;
        var spaceX = this.width, spaceY = this.height, offsetX = this.offsetX + this.width / 2, offsetY = this.offsetY + this.height / 2;
        for (var i = 0; i < this.rowNum; i++) {
            for (var j = 0; j < this.colNum; j++) {
                this.rcToIndexMap["" + i + j] = i * this.colNum + j;
                this.indexToRcMap[i * this.colNum + j] = [i, j];
                this.rowColPositions["" + i + j] = [offsetX + j * spaceX, offsetY + i * spaceY];
                this.indexPositions[i * this.colNum + j] = [offsetX + j * spaceX, offsetY + i * spaceY];
            }
        }
        var rowNum = Tool.rowNum + 1;
        var colNum = Tool.colNum + 1;
        var offsetX = Tool.offsetX;
        var offsetY = Tool.offsetY;
        for (var i = 0; i < rowNum; i++) {
            for (var j = 0; j < colNum; j++) {
                this.indexToRcMap10[i * colNum + j] = [i, j];
                this.indexPositions10[i * colNum + j] = [offsetX + j * Tool.width, offsetY + i * Tool.height];
            }
        }
    };
    Tool.rcToIndex = function (row, col) {
        var key = "" + row + col;
        return this.rcToIndexMap[key];
    };
    Tool.indexToRc = function (index) {
        return this.indexToRcMap[index];
    };
    Tool.getPositionByRc = function (row, col) {
        var key = "" + row + col;
        return this.rowColPositions[key];
    };
    Tool.getPositionByIndex = function (index) {
        return this.indexPositions[index];
    };
    Tool.indexToRc10 = function (index) {
        return this.indexToRcMap10[index];
    };
    Tool.getPositionByIndex10 = function (index) {
        return this.indexPositions10[index];
    };
    Tool.getColOddEven = function (lattices) {
        var left = 0;
        for (var i = 0; i < Tool.colNum; i++) {
            var mark = false;
            for (var j = 0; j < Tool.rowNum; j++) {
                if (lattices[j * this.colNum + i]) {
                    mark = true;
                    break;
                }
            }
            if (mark) {
                break;
            }
            else {
                left++;
            }
        }
        var right = 0;
        for (var i = Tool.colNum - 1; i >= 0; i--) {
            var mark = false;
            for (var j = 0; j < Tool.rowNum; j++) {
                if (lattices[j * this.colNum + i]) {
                    mark = true;
                    break;
                }
            }
            if (mark) {
                break;
            }
            else {
                right++;
            }
        }
        return (left + right) % 2 != 0;
    };
    Tool.checkNeb = function (a, b) {
        if (Math.abs(a.row - b.row) == 1 && Math.abs(a.column - b.column) == 0) {
            return true;
        }
        else if (Math.abs(a.row - b.row) == 0 && Math.abs(a.column - b.column) == 1) {
            return true;
        }
        return false;
    };
    Tool.insert = function (num, arr) {
        for (var i = arr.length - 1; i >= 0; i--) {
            if (num > arr[i]) {
                arr.splice(i + 1, 0, num);
                break;
            }
        }
    };
    Tool.insertEX = function (num, arr) {
        for (var i = 0; i < arr.length; i++) {
            if (num > arr[i]) {
                arr.splice(i, 0, num);
                return;
            }
        }
        arr.push(num);
    };
    Tool.judgeFall = function (lat) {
        if (!lat || !lat.element) {
            return false;
        }
        else if (lat.element.type == ElementType_1.ElementType.ROCK ||
            lat.element.hasState(StateType_1.StateType.LOCK) ||
            lat.element.type == ElementType_1.ElementType.JELLY ||
            lat.element.type == ElementType_1.ElementType.CHICKEN_EGG ||
            lat.element.type == ElementType_1.ElementType.FESTIVALELE_BIG ||
            lat.doorClosed) {
            return false;
        }
        else {
            return true;
        }
    };
    Tool.judgeMove = function (lat) {
        if (this.judgeFall(lat) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBLACK) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLGREY) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBROWN) &&
            lat.element.type != ElementType_1.ElementType.FESTIVALELE_SMALL) {
            return true;
        }
        return false;
    };
    Tool.judgeMatch = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.doorClosed &&
            lat.element.effectType != EffectType_1.EffectType.MAGICLION &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLGREY) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBLACK) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
            return true;
        }
        return false;
    };
    Tool.judgeEliminate = function (lat) {
        if (!lat || !lat.element) {
            return false;
        }
        else if (lat.element.type == ElementType_1.ElementType.LOLLIPOP ||
            lat.doorClosed) {
            return false;
        }
        else {
            return true;
        }
    };
    Tool.judgeBaseEle = function (lat) {
        if (lat &&
            lat.element &&
            ElementType_1.FiveBaseElementTypes.indexOf(lat.element.type) >= 0) {
            return true;
        }
        return false;
    };
    Tool.judgeUpsetMove = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.doorClosed &&
            !lat.element.hasState(StateType_1.StateType.LOCK) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLGREY) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBLACK) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
            return true;
        }
        return false;
    };
    Tool.judgeSetFesEle = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.doorClosed &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLGREY) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBLACK) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
            return true;
        }
        return false;
    };
    Tool.judgeSetChicken = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.element.hasAnyState() &&
            lat.element.type !== ElementType_1.ElementType.CHICKEN &&
            !lat.doorClosed) {
            return true;
        }
        return false;
    };
    Tool.judgeMagicEliminate = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.doorClosed &&
            lat.element.effectType != EffectType_1.EffectType.MAGICLION) {
            return true;
        }
        return false;
    };
    Tool.judgeAiActionDirection = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.element.hasAnyState() &&
            !lat.doorClosed) {
            return true;
        }
        return false;
    };
    Tool.judgeChosen = function (ele) {
        if (!ele ||
            ele.type == ElementType_1.ElementType.ROCK ||
            ele.hasState(StateType_1.StateType.LOCK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLGREY) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBLACK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBROWN) ||
            ele.type == ElementType_1.ElementType.JELLY ||
            ele.type == ElementType_1.ElementType.CHICKEN_EGG ||
            ele.type == ElementType_1.ElementType.FESTIVALELE_BIG ||
            ele.type == ElementType_1.ElementType.FESTIVALELE_SMALL) {
            return false;
        }
        return true;
    };
    Tool.judgeHasScore = function (ele) {
        if (!ele ||
            ele.type == ElementType_1.ElementType.ROCK ||
            ele.type == ElementType_1.ElementType.JELLY ||
            ele.type == ElementType_1.ElementType.CHICKEN_EGG ||
            ele.type == ElementType_1.ElementType.LOLLIPOP ||
            ele.type == ElementType_1.ElementType.FESTIVALELE_BIG ||
            ele.type == ElementType_1.ElementType.FESTIVALELE_SMALL ||
            ele.hasState(StateType_1.StateType.LOCK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLGREY) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBLACK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
            return false;
        }
        return true;
    };
    Tool.judgeMagicRotate = function (ele) {
        if (!ele ||
            ele.effectType != null ||
            ele.hasState(StateType_1.StateType.LOCK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLGREY) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBLACK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
            return false;
        }
        return true;
    };
    Tool.getExplosiveIndexes = function (curLat, lats) {
        var arr = [];
        Tool.ExplosiveMatchArr.forEach(function (e) {
            var col = curLat.column + e[0];
            var row = curLat.row + e[1];
            var index = Tool.rcToIndex(row, col);
            if (Tool.judgeEliminate(lats[index]))
                arr.push(index);
        });
        return arr;
    };
    Tool.dieMapCheck = function (lattices) {
        var judgeMatch = Tool.judgeMatch;
        var effectElements = [];
        var lat2, lat3;
        for (var i = Tool.colNum * Tool.rowNum - 1; i >= 0; i--) {
            var rc = Tool.indexToRc(i);
            var row = rc[0];
            var col = rc[1];
            var lat = lattices[i];
            if (!this.judgeMove(lat))
                continue;
            if (lat.element.effectType != null) {
                effectElements.push(lat.element);
            }
            var latDown = lattices[i + Tool.colNum];
            if (this.judgeMove(latDown) && lat.element.type != latDown.element.type) {
                lat2 = lattices[i + Tool.colNum * 2];
                lat3 = lattices[i + Tool.colNum * 3];
                if (judgeMatch(lat2) &&
                    judgeMatch(lat3) &&
                    lat.element.type == lat2.element.type &&
                    lat.element.type == lat3.element.type) {
                    return [lat.element, latDown.element];
                }
                lat2 = lattices[i - Tool.colNum];
                lat3 = lattices[i - Tool.colNum * 2];
                if (judgeMatch(lat2) &&
                    judgeMatch(lat3) &&
                    latDown.element.type == lat2.element.type &&
                    latDown.element.type == lat3.element.type) {
                    return [lat.element, latDown.element];
                }
                if (col > 1) {
                    lat2 = lattices[i + Tool.colNum - 1];
                    lat3 = lattices[i + Tool.colNum - 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
                if (col < Tool.colNum - 2) {
                    lat2 = lattices[i + Tool.colNum + 1];
                    lat3 = lattices[i + Tool.colNum + 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
                if (col > 0 && col < Tool.colNum - 1) {
                    lat2 = lattices[i + Tool.colNum + 1];
                    lat3 = lattices[i + Tool.colNum - 1];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
                if (col > 1) {
                    lat2 = lattices[i - 1];
                    lat3 = lattices[i - 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latDown.element.type == lat2.element.type &&
                        latDown.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
                if (col < Tool.colNum - 2) {
                    lat2 = lattices[i + 1];
                    lat3 = lattices[i + 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latDown.element.type == lat2.element.type &&
                        latDown.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
                if (col > 0 && col < Tool.colNum - 1) {
                    lat2 = lattices[i + 1];
                    lat3 = lattices[i - 1];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latDown.element.type == lat2.element.type &&
                        latDown.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
            }
            if (col != Tool.colNum - 1) {
                var latRight = lattices[i + 1];
                if (this.judgeMove(latRight) && lat.element.type != latRight.element.type) {
                    if (col < Tool.colNum - 3) {
                        lat2 = lattices[i + 2];
                        lat3 = lattices[i + 3];
                        if (judgeMatch(lat2) &&
                            judgeMatch(lat3) &&
                            lat.element.type == lat2.element.type &&
                            lat.element.type == lat3.element.type) {
                            return [lat.element, latRight.element];
                        }
                    }
                    if (col > 1) {
                        lat2 = lattices[i - 1];
                        lat3 = lattices[i - 2];
                        if (judgeMatch(lat2) &&
                            judgeMatch(lat3) &&
                            latRight.element.type == lat2.element.type &&
                            latRight.element.type == lat3.element.type) {
                            return [lat.element, latRight.element];
                        }
                    }
                    lat2 = lattices[i + Tool.colNum * 1 + 1];
                    lat3 = lattices[i + Tool.colNum * 2 + 1];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                    lat2 = lattices[i - Tool.colNum * 1 + 1];
                    lat3 = lattices[i - Tool.colNum * 2 + 1];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                    lat2 = lattices[i + Tool.colNum + 1];
                    lat3 = lattices[i - Tool.colNum + 1];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                    lat2 = lattices[i + Tool.colNum * 1];
                    lat3 = lattices[i + Tool.colNum * 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latRight.element.type == lat2.element.type &&
                        latRight.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                    lat2 = lattices[i - Tool.colNum * 1];
                    lat3 = lattices[i - Tool.colNum * 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latRight.element.type == lat2.element.type &&
                        latRight.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                    lat2 = lattices[i + Tool.colNum];
                    lat3 = lattices[i - Tool.colNum];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latRight.element.type == lat2.element.type &&
                        latRight.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                }
            }
        }
        for (var i = 0; i < effectElements.length; i++) {
            var effectElement = effectElements[i];
            if (effectElement.effectType == EffectType_1.EffectType.MAGICLION) {
                var up = lattices[effectElement.index - Tool.colNum];
                if (this.judgeMove(up) && up.element.type != ElementType_1.ElementType.LOLLIPOP)
                    return [effectElement, up.element];
                var down = lattices[effectElement.index + Tool.colNum];
                if (this.judgeMove(down) && down.element.type != ElementType_1.ElementType.LOLLIPOP)
                    return [effectElement, down.element];
                var col = Tool.indexToRc(effectElement.index)[1];
                if (col != 0) {
                    var left = lattices[effectElement.index - 1];
                    if (this.judgeMove(left) && left.element.type != ElementType_1.ElementType.LOLLIPOP)
                        return [effectElement, left.element];
                }
                if (col != Tool.colNum - 1) {
                    var right = lattices[effectElement.index + 1];
                    if (this.judgeMove(right) && right.element.type != ElementType_1.ElementType.LOLLIPOP)
                        return [effectElement, right.element];
                }
                continue;
            }
            var up = lattices[effectElement.index - Tool.colNum];
            if (this.judgeMove(up) && up.element.effectType != null)
                return [effectElement, up.element];
            var down = lattices[effectElement.index + Tool.colNum];
            if (this.judgeMove(down) && down.element.effectType != null)
                return [effectElement, down.element];
            var col = Tool.indexToRc(effectElement.index)[1];
            if (col != 0) {
                var left = lattices[effectElement.index - 1];
                if (this.judgeMove(left) && left.element.effectType != null)
                    return [effectElement, left.element];
            }
            if (col != Tool.colNum) {
                var right = lattices[effectElement.index + 1];
                if (this.judgeMove(right) && right.element.effectType != null)
                    return [effectElement, right.element];
            }
        }
        return null;
    };
    Tool.alreadyDie = function (lattices) {
        var arr = {};
        var hasEffect = false;
        var effectCount = 0;
        var hasTwo = false;
        var hasThree = false;
        for (var i = 0; i < lattices.length; i++) {
            if (this.judgeBaseEle(lattices[i]) &&
                !lattices[i].element.hasState(StateType_1.StateType.LOCK) &&
                !lattices[i].element.hasState(StateType_1.StateType.HAIRBALLGREY) &&
                !lattices[i].element.hasState(StateType_1.StateType.HAIRBALLBLACK) &&
                !lattices[i].element.hasState(StateType_1.StateType.HAIRBALLGREY)) {
                var type = lattices[i].element.type;
                if (!arr[type])
                    arr[type] = 0;
                arr[type]++;
                var ele = lattices[i].element;
                if (ele.effectType == EffectType_1.EffectType.MAGICLION) {
                    hasEffect = true;
                }
                if (ele.effectType != null) {
                    effectCount++;
                    if (effectCount >= 2) {
                        hasEffect = true;
                    }
                }
                var rc = Tool.indexToRc(i);
                if (rc[1] < Tool.colNum - 1) {
                    var latRight1 = lattices[i + 1];
                    if (Tool.judgeMove(latRight1) && latRight1.element.type != ElementType_1.ElementType.LOLLIPOP) {
                        hasTwo = true;
                    }
                    if (rc[1] < Tool.colNum - 2) {
                        var latRight2 = lattices[i + 2];
                        if (Tool.judgeMove(latRight1) &&
                            latRight1.element.type != ElementType_1.ElementType.LOLLIPOP &&
                            Tool.judgeMove(latRight2) &&
                            latRight2.element.type != ElementType_1.ElementType.LOLLIPOP) {
                            hasThree = true;
                        }
                    }
                }
                var latDown1 = lattices[i + Tool.colNum];
                if (Tool.judgeMove(latDown1) && latDown1.element.type != ElementType_1.ElementType.LOLLIPOP) {
                    hasTwo = true;
                }
                if (hasTwo && hasEffect)
                    return false;
                var latDown2 = lattices[i + Tool.colNum * 2];
                if (Tool.judgeMove(latDown1) &&
                    latDown1.element.type != ElementType_1.ElementType.LOLLIPOP &&
                    Tool.judgeMove(latDown2) &&
                    latDown2.element.type != ElementType_1.ElementType.LOLLIPOP) {
                    hasThree = true;
                }
                if (hasThree) {
                    for (var a in arr) {
                        if (arr[a] >= 3) {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    };
    Tool.fn = function (arr, lattices) {
        var result = [], i = 0;
        result[i] = [arr[0]];
        arr.reduce(function (prev, cur) {
            var latP = lattices[prev];
            var latC = lattices[cur];
            if (Tool.judgeMatch(latP) &&
                Tool.judgeMatch(latC) &&
                latP.element.type == latC.element.type) {
                result[i].push(cur);
            }
            else {
                result[++i] = [cur];
            }
            return cur;
        });
        return result;
    };
    Tool.returnType = function (index, lattices, baseElementTypes) {
        var rc = Tool.indexToRc(index);
        var arr = baseElementTypes.slice();
        if (rc[1] > 1) {
            var lat1 = lattices[index - 1];
            var lat2 = lattices[index - 2];
            if (Tool.judgeMatch(lat1) &&
                Tool.judgeMatch(lat2) &&
                lat1.element.type == lat2.element.type) {
                Tool.removeEle(lat1.element.type, arr);
            }
        }
        var lat1 = lattices[index - Tool.colNum];
        var lat2 = lattices[index - Tool.colNum * 2];
        if (Tool.judgeMatch(lat1) &&
            Tool.judgeMatch(lat2) &&
            lat1.element.type == lat2.element.type) {
            Tool.removeEle(lat1.element.type, arr);
        }
        return Tool.randomT(arr);
    };
    Tool.setGenerateLats = function (lattices, generateLats) {
        var arr = [];
        for (var i = 0; i < generateLats.length; i++) {
            var generateLat = generateLats[i];
            generateLat.cus = generateLat.cus || [];
            var index = generateLat.index;
            if (!lattices[index])
                continue;
            lattices[index].isGenerate = true;
            var rc = this.indexToRc(index);
            var col = rc[1];
            if (!arr[col])
                arr[col] = [];
            arr[col].push({
                index: generateLat.index,
                type: generateLat.type || [],
                cus: generateLat.cus.slice(),
            });
        }
        for (var j = 0; j < arr.length; j++) {
            if (arr[j])
                arr[j].sort(function (a, b) { return a.index > b.index ? 1 : -1; });
        }
        return arr;
    };
    Tool.setNumber01 = function (nums) {
        var arr = [];
        for (var i = 0; i < nums.length; i++) {
            if (nums[i]) {
                arr[i] = 1;
            }
            else {
                arr[i] = 0;
            }
        }
        return arr;
    };
    Tool.findBottom = function (lattice, emptys, lattices) {
        var indexDown, lat;
        var connects = [];
        var isThrough = false;
        if (lattice.down != null) {
            indexDown = lattice.down;
            isThrough = true;
        }
        else {
            indexDown = lattice.index + this.colNum;
        }
        var lastEmptyIndex;
        var emptyIndex = emptys.indexOf(indexDown);
        while (emptyIndex > -1) {
            if (isThrough)
                connects.push({ index: indexDown, type: FallAniData_1.FallType.THROUGH });
            lastEmptyIndex = emptyIndex;
            lat = lattices[indexDown];
            if (lat.down != null) {
                if (!isThrough)
                    connects.push({ index: indexDown, type: FallAniData_1.FallType.STRIGHT });
                isThrough = true;
                indexDown = lat.down;
            }
            else {
                isThrough = false;
                indexDown = lat.index + this.colNum;
            }
            emptyIndex = emptys.indexOf(indexDown);
        }
        if (lastEmptyIndex != undefined) {
            if (isThrough) {
                return connects;
            }
            else {
                connects.push({ index: emptys[lastEmptyIndex], type: FallAniData_1.FallType.STRIGHT });
                return connects;
            }
        }
        else {
            return null;
        }
    };
    Tool.judgeOutOne = function (emptys, lattices) {
        for (var m = 0; m < Tool.colNum; m++) {
            for (var n = Tool.rowNum - 1; n >= 0; n--) {
                var index = Tool.rcToIndex(n, m);
                var lat = lattices[index];
                if (Tool.judgeFall(lat)) {
                    var indexs = Tool.findBottom(lat, emptys, lattices);
                    if (indexs != null) {
                        if (indexs.length > 1) {
                            return true;
                        }
                        else {
                            var downIndex = indexs[0].index;
                            var type = indexs[0].type;
                            if (type == FallAniData_1.FallType.STRIGHT && (downIndex - index) / Tool.colNum > 1) {
                                return true;
                            }
                        }
                    }
                }
                else {
                    if (lat && !lat.element && lat.isGenerate) {
                        var arr = [];
                        var downIndex = index;
                        while (emptys.indexOf(downIndex) > -1) {
                            arr.push(downIndex);
                            if (lat.down != null) {
                                downIndex = lat.down;
                            }
                            else {
                                downIndex = lat.index + this.colNum;
                            }
                            lat = lattices[downIndex];
                        }
                        if (arr.length > 1)
                            return true;
                    }
                }
            }
        }
        return false;
    };
    Tool.praseEleNumber = function (num) {
        var arr = this.returnTO(num);
        var baseType = arr[1] ? arr[1] - 1 : null;
        if (ElementType_1.FiveBaseElementTypes.indexOf(baseType) == -1)
            baseType = null;
        var effectType = arr[0] ? arr[0] - 1 : null;
        return [baseType, effectType];
    };
    Tool.removeEle = function (e, arr) {
        var index = arr.indexOf(e);
        if (index >= 0) {
            arr.splice(index, 1);
        }
    };
    Tool.randomT = function (e, n) {
        return e && "number" == typeof e.length && e.length ? e[Math.floor(Math.random() * e.length)] : ("number" != typeof n && (n = e || 1, e = 0), e + Math.random() * (n - e));
    };
    Tool.removeReapty = function (arr) {
        var obj = {};
        for (var i = arr.length - 1; i >= 0; i--) {
            if (obj[arr[i]]) {
                arr.splice(i, 1);
            }
            else {
                obj[arr[i]] = true;
            }
        }
    };
    Tool.getElement = function (type) {
        var obj = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.ELEMENT);
        if (!obj) {
            obj = new Element_1.Element(type);
        }
        else {
            obj.reset(type);
        }
        return obj;
    };
    Tool.getRectMask = function () {
        var rect = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.RECT_MASK);
        if (!rect)
            rect = new RectMask_1.RectMask();
        return rect;
    };
    Tool.returnTO = function (num) {
        var length = num.toString().length;
        var arr = [];
        var a;
        for (var i = 0; i < length; i++) {
            a = (num % Math.pow(10, i + 1)) / Math.pow(10, i);
            arr.push(parseInt(a));
        }
        return arr;
    };
    Tool.getForwardRotation = function (fromPoint, toPoint) {
        var deltaX = toPoint[0] - fromPoint[0];
        var deltaY = toPoint[1] - fromPoint[1];
        var vec1 = [1, 0];
        var vec2 = [deltaX, deltaY];
        var a = Math.sqrt(vec1[0] * vec1[0] + vec1[1] * vec1[1]);
        var b = Math.sqrt(vec2[0] * vec2[0] + vec2[1] * vec2[1]);
        var ab = vec1[0] * vec2[0] + vec1[1] * vec2[1];
        var cos = ab / (a * b);
        var r = Math.acos(cos);
        if (deltaY < 0) {
            r = Math.PI * 2 - r;
        }
        return r;
    };
    Tool.getRandomArrayElements = function (arr, count) {
        var shuffled = arr.slice(0), i = arr.length, min = i - count, temp, index;
        if (min <= 0)
            return shuffled;
        while (i-- > min) {
            index = Math.floor((i + 1) * Math.random());
            temp = shuffled[index];
            shuffled[index] = shuffled[i];
            shuffled[i] = temp;
        }
        return shuffled.slice(min);
    };
    Tool.getRandomArrayElementsEx = function (arr, count) {
        if (arr.length <= count)
            return arr.slice();
        if (count <= 0)
            return [];
        var arrCopy = arr.slice();
        var outArr = [];
        while (count--) {
            var rand = Math.floor(Math.random() * arrCopy.length);
            var ele = arrCopy.splice(rand, 1)[0];
            outArr.push(ele);
        }
        return outArr;
    };
    Tool.latDeltaTime = 90;
    Tool.rowNum = 9;
    Tool.colNum = 9;
    Tool.width = 80;
    Tool.height = 80;
    Tool.radius = 10;
    Tool.rcToIndexMap = {};
    Tool.indexToRcMap = [];
    Tool.rowColPositions = {};
    Tool.indexPositions = [];
    Tool.indexToRcMap10 = [];
    Tool.indexPositions10 = [];
    Tool.ExplosiveMatchArr = [
        [-1, -1], [0, -1], [1, -1],
        [-1, 0], [1, 0],
        [-1, 1], [0, 1], [1, 1],
    ];
    return Tool;
}());
exports.Tool = Tool;


/***/ }),

/***/ "./src/something/anis/BonusShootAni.ts":
/*!*********************************************!*\
  !*** ./src/something/anis/BonusShootAni.ts ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.BonusShootAni = exports.stepPosition = void 0;
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
exports.stepPosition = [100, 120, 100];
var BonusShootAni = (function (_super) {
    __extends(BonusShootAni, _super);
    function BonusShootAni() {
        var _this = _super.call(this) || this;
        var texture = RES_1.RES.getRes("bonusShoot.png");
        _this.shoot = new FYGE.Sprite(texture);
        _this.shoot.anchorTexture.set(78 / 95, 0.5);
        _this.addChild(_this.shoot);
        var arr = [];
        for (var i = 0; i <= 11; i++)
            arr.push(RES_1.RES.getRes("bonusFra" + i + ".png"));
        _this.imageAni = new FYGE.FrameAni(arr);
        _this.addChild(_this.imageAni);
        _this.imageAni.visible = false;
        return _this;
    }
    BonusShootAni.prototype.reset = function () {
        this.shoot.visible = true;
        this.imageAni.visible = false;
        this.x = exports.stepPosition[0];
        this.y = exports.stepPosition[1];
    };
    BonusShootAni.prototype.play = function (p, callback) {
        var _this = this;
        this.reset();
        this.shoot.rotation = Tool_1.Tool.getForwardRotation(exports.stepPosition, p) * 180 / Math.PI;
        FYGE.Tween.get(this)
            .to({ x: p[0], y: p[1] }, 300)
            .call(function () {
            callback();
            _this.shoot.visible = false;
            _this.imageAni.visible = true;
            _this.imageAni.play(1, function () {
                if (_this.parent) {
                    _this.parent.removeChild(_this);
                }
                ;
                Pool_1.Pool.recover(RecoverName_1.RecoverName.BONUSSHOOT_ANI, _this);
            });
        });
    };
    return BonusShootAni;
}(FYGE.Container));
exports.BonusShootAni = BonusShootAni;


/***/ }),

/***/ "./src/something/anis/BoomAni.ts":
/*!***************************************!*\
  !*** ./src/something/anis/BoomAni.ts ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.BoomAni = void 0;
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var BoomAni = (function (_super) {
    __extends(BoomAni, _super);
    function BoomAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.BOOM_ANI;
        var arr = [];
        for (var i = 0; i <= 29; i++) {
            arr.push(RES_1.RES.getRes("boom" + i + ".png"));
        }
        _this.showImage = new FYGE.FrameAni(arr);
        _this.addChild(_this.showImage);
        return _this;
    }
    BoomAni.prototype.play = function () {
        var _this = this;
        this.showImage.reset(0);
        this.showImage.play(1, function () {
            _this.recover();
        });
    };
    return BoomAni;
}(Ani_1.Ani));
exports.BoomAni = BoomAni;


/***/ }),

/***/ "./src/something/anis/BubbleAni.ts":
/*!*****************************************!*\
  !*** ./src/something/anis/BubbleAni.ts ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.BubbleAni = void 0;
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var baseEleWidth = 80;
var baseEleHeight = 80;
var time = 300;
var BubbleAni = (function (_super) {
    __extends(BubbleAni, _super);
    function BubbleAni() {
        var _this = _super.call(this) || this;
        _this.eleFrom = new FYGE.Sprite();
        _this.eleFrom.x = -baseEleWidth / 2;
        _this.eleFrom.y = -baseEleHeight / 2;
        _this.eleFrom.visible = false;
        _this.addChild(_this.eleFrom);
        _this.eleTarget = new FYGE.Sprite();
        _this.eleTarget.x = -baseEleWidth / 2;
        _this.eleTarget.y = -baseEleHeight / 2;
        _this.eleTarget.visible = false;
        _this.addChild(_this.eleTarget);
        var arr = [null];
        for (var i = 1; i <= 59; i++) {
            arr.push(RES_1.RES.getRes("bubbleStar" + i + ".png"));
        }
        _this.bubbleAni = new FYGE.FrameAni(arr);
        _this.bubbleAni.visible = false;
        _this.addChild(_this.bubbleAni);
        return _this;
    }
    BubbleAni.prototype.play = function (fromType, targetType, callback) {
        var _this = this;
        this.eleFrom.texture = RES_1.RES.getRes("bubleEle" + fromType + ".png");
        this.eleFrom.visible = true;
        this.eleFrom.alpha = 1;
        this.eleTarget.texture = RES_1.RES.getRes("bubleEle" + targetType + ".png");
        this.eleTarget.visible = true;
        this.eleTarget.alpha = 0;
        FYGE.Tween.get(this)
            .to({ scaleX: 0.96, scaleY: 1.02 }, 100)
            .to({ scaleX: 1.02, scaleY: 0.98 }, 100)
            .to({ scaleX: 0.98, scaleY: 1.02 }, 100)
            .to({ scaleX: 1, scaleY: 1 }, 100)
            .call(function () {
            _this.bubbleAni.visible = true;
            _this.bubbleAni.play(1, function () {
                _this.bubbleAni.visible = false;
            });
            FYGE.Tween.get(_this.eleTarget)
                .to({ alpha: 1 }, 600)
                .call(function () {
                FYGE.Tween.get(_this.eleFrom)
                    .to({ alpha: 0 }, 100)
                    .call(function () {
                    if (_this.parent) {
                        _this.parent.removeChild(_this);
                    }
                    ;
                    Pool_1.Pool.recover(RecoverName_1.RecoverName.BUBBLE_ANI, _this);
                    callback();
                });
            });
        });
    };
    return BubbleAni;
}(FYGE.Container));
exports.BubbleAni = BubbleAni;


/***/ }),

/***/ "./src/something/anis/CrossAni.ts":
/*!****************************************!*\
  !*** ./src/something/anis/CrossAni.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.CrossAni = void 0;
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var CrossAni = (function (_super) {
    __extends(CrossAni, _super);
    function CrossAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.CROSS_ANI;
        _this.showImage = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
        _this.addChild(_this.showImage);
        _this.showImage.anchorTexture.set(0.5, 0.5);
        _this.showImage.scaleY = 0.1;
        _this.showImage2 = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
        _this.addChild(_this.showImage2);
        _this.showImage2.anchorTexture.set(0.5, 0.5);
        _this.showImage2.scaleY = 0.1;
        _this.showImage2.rotation = 90;
        return _this;
    }
    CrossAni.prototype.play = function () {
        var _this = this;
        this.showImage.scaleY = 0.1;
        this.showImage.alpha = 1;
        this.showImage2.scaleY = 0.1;
        this.showImage2.alpha = 1;
        FYGE.Tween.get(this.showImage)
            .to({ scaleY: 1.2 }, 300)
            .to({ alpha: 0 }, 100);
        FYGE.Tween.get(this.showImage2)
            .to({ scaleY: 1.2 }, 300)
            .to({ alpha: 0 }, 100)
            .call(function () {
            _this.recover();
        });
    };
    return CrossAni;
}(Ani_1.Ani));
exports.CrossAni = CrossAni;


/***/ }),

/***/ "./src/something/anis/EggBrokenAni.ts":
/*!********************************************!*\
  !*** ./src/something/anis/EggBrokenAni.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.EggBrokenAni = void 0;
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var offsetX = 91 / 2;
var offsetY = 62 / 2;
var EggBrokenAni = (function (_super) {
    __extends(EggBrokenAni, _super);
    function EggBrokenAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.EGGBROKEN_ANI;
        var arr = ["yellowCircleDown.png", "yellowCircleUp.png", "eggPiece1.png", "eggPiece2.png", "eggPiece3.png", "eggPiece4.png", "eggPiece5.png"];
        var objs = ["downCircle", "upCircle", "eggPiece1", "eggPiece2", "eggPiece3", "eggPiece4", "eggPiece5"];
        for (var i = 0; i < arr.length; i++) {
            var texture = RES_1.RES.getRes(arr[i]);
            var obj = new FYGE.Sprite(texture);
            _this.addChild(obj);
            obj.anchorTexture.set(0.5, 0.5);
            _this[objs[i]] = obj;
        }
        return _this;
    }
    EggBrokenAni.prototype.play = function () {
        var _this = this;
        this.alpha = 1;
        FYGE.Tween.get(this.downCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .to({ scaleX: 0.6, scaleY: 0.6 }, 300, FYGE.Ease.cubicOut);
        FYGE.Tween.get(this.downCircle)
            .set({ alpha: 1 })
            .wait(140)
            .to({ alpha: 0 }, 160);
        FYGE.Tween.get(this.upCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .wait(70)
            .to({ scaleX: 1, scaleY: 1 }, 160, FYGE.Ease.cubicOut);
        FYGE.Tween.get(this.upCircle)
            .set({ alpha: 1 })
            .wait(170)
            .to({ alpha: 0 }, 100);
        FYGE.Tween.get(this.eggPiece1)
            .set({ rotation: 0, x: 37 - offsetX, y: 22 - offsetY })
            .to({ rotation: 60, x: 37 - offsetX - 30, y: 22 - offsetY - 34 }, 400);
        FYGE.Tween.get(this.eggPiece2)
            .set({ rotation: 0, x: 48 - offsetX, y: 20 - offsetY })
            .to({ rotation: 60, x: 48 - offsetX + 36, y: 20 - offsetY - 28 }, 400);
        FYGE.Tween.get(this.eggPiece3)
            .set({ rotation: 0, x: 52 - offsetX, y: 32 - offsetY })
            .to({ rotation: 60, x: 52 - offsetX + 30, y: 32 - offsetY + 10 }, 400);
        FYGE.Tween.get(this.eggPiece4)
            .set({ rotation: 0, x: 45 - offsetX, y: 44 - offsetY })
            .to({ rotation: 60, x: 45 - offsetX + 32, y: 44 - offsetY + 38 }, 400);
        FYGE.Tween.get(this.eggPiece5)
            .set({ rotation: 0, x: 34 - offsetX, y: 34 - offsetY })
            .to({ rotation: 60, x: 34 - offsetX - 20, y: 34 - offsetY + 14 }, 400);
        FYGE.Tween.get(this)
            .wait(250)
            .to({ alpha: 0 }, 150)
            .call(function () {
            _this.recover();
        });
    };
    return EggBrokenAni;
}(Ani_1.Ani));
exports.EggBrokenAni = EggBrokenAni;


/***/ }),

/***/ "./src/something/anis/EleDisAni.ts":
/*!*****************************************!*\
  !*** ./src/something/anis/EleDisAni.ts ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.EleDisAni = void 0;
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
function EleDisAni(type) {
    var arr = [];
    for (var i = 0; i <= 21; i++) {
        arr.push(RES_1.RES.getRes("dis_ele_" + i + ".png"));
    }
    var frameAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.FRAME_ANI);
    if (!frameAni) {
        frameAni = new FYGE.FrameAni(arr);
    }
    else {
        frameAni.resetTexturesAll(arr);
    }
    frameAni.play(1, function () {
        if (frameAni.parent) {
            frameAni.parent.removeChild(frameAni);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.FRAME_ANI, frameAni);
        }
    });
    return frameAni;
}
exports.EleDisAni = EleDisAni;


/***/ }),

/***/ "./src/something/anis/EleDownAni.ts":
/*!******************************************!*\
  !*** ./src/something/anis/EleDownAni.ts ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.EleDownAni = void 0;
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
function EleDownAni(eleC, p, wait, con, isUp, deltaTime, callback) {
    if (isUp === void 0) { isUp = false; }
    var ele = Tool_1.Tool.getElement(eleC.type);
    ele.effectType = eleC.effectType;
    ele.x = p[0];
    ele.y = p[1] - Tool_1.Tool.height * (isUp ? 0 : 1);
    FYGE.Tween.get(ele)
        .wait(wait)
        .call(function () {
        con.addChild(ele);
    })
        .to({ x: p[0], y: p[1] + Tool_1.Tool.height * (isUp ? 1 : 0) }, deltaTime)
        .call(function () {
        con.removeChild(ele);
        Pool_1.Pool.recover(RecoverName_1.RecoverName.ELEMENT, ele);
        callback && callback();
    });
}
exports.EleDownAni = EleDownAni;


/***/ }),

/***/ "./src/something/anis/EleMaskAni.ts":
/*!******************************************!*\
  !*** ./src/something/anis/EleMaskAni.ts ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.EleMaskAni = void 0;
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
function EleMaskAni(eleC, p, wait, con, isUp, deltaTime, callback) {
    if (isUp === void 0) { isUp = false; }
    var ele = Tool_1.Tool.getElement(eleC.type);
    ele.effectType = eleC.effectType;
    ele.x = p[0];
    ele.y = p[1] - Tool_1.Tool.height * (isUp ? 0 : 1);
    var mask = Tool_1.Tool.getRectMask();
    mask.x = p[0];
    mask.y = p[1];
    ele.mask = mask;
    con.addChild(mask);
    FYGE.Tween.get(ele)
        .wait(wait)
        .call(function () {
        con.addChild(ele);
    })
        .to({ x: p[0], y: p[1] + Tool_1.Tool.height * (isUp ? 1 : 0) }, deltaTime)
        .call(function () {
        con.removeChild(ele);
        Pool_1.Pool.recover(RecoverName_1.RecoverName.ELEMENT, ele);
        ele.mask = null;
        mask.recover();
        callback && callback();
    });
}
exports.EleMaskAni = EleMaskAni;


/***/ }),

/***/ "./src/something/anis/FlyTargetAni.ts":
/*!********************************************!*\
  !*** ./src/something/anis/FlyTargetAni.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.FlyTargetAni = void 0;
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var BitmapRecycle_1 = __webpack_require__(/*! ../class/BitmapRecycle */ "./src/something/class/BitmapRecycle.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
function FlyTargetAni(type, fromP, targetP, callback) {
    var texture = RES_1.RES.getRes("ele" + type + ".png");
    var eleC = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.BITMAPRECYCLE);
    if (!eleC) {
        eleC = new BitmapRecycle_1.BitmapRecycle(texture);
    }
    else {
        eleC.reset(texture);
    }
    eleC.x = fromP[0];
    eleC.y = fromP[1];
    FYGE.Tween.get(eleC)
        .to({ x: targetP[0], y: targetP[1], scaleX: 0.7, scaleY: 0.7 }, 500 + (Math.random() * 100) >> 0)
        .call(function () {
        if (eleC.parent) {
            eleC.parent.removeChild(eleC);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.BITMAPRECYCLE, eleC);
        }
        callback();
    });
    return eleC;
}
exports.FlyTargetAni = FlyTargetAni;


/***/ }),

/***/ "./src/something/anis/HairballBrownDivideAni.ts":
/*!******************************************************!*\
  !*** ./src/something/anis/HairballBrownDivideAni.ts ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.HairballBrownDivideAni = void 0;
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var offsetX = 80 / 2;
var offsetY = 80 / 2;
var HairballBrownDivideAni = (function (_super) {
    __extends(HairballBrownDivideAni, _super);
    function HairballBrownDivideAni() {
        var _this = _super.call(this) || this;
        _this.startHairball = new Hairball();
        _this.startHairball.brownFace.visible = false;
        _this.startHairball.x = -offsetX;
        _this.startHairball.y = -offsetY;
        _this.addChild(_this.startHairball);
        _this.endHairball = new Hairball();
        _this.endHairball.x = -offsetX;
        _this.endHairball.y = -offsetY;
        _this.addChild(_this.endHairball);
        return _this;
    }
    HairballBrownDivideAni.prototype.reset = function () {
        this.startHairball.eyesDown.scaleY = 1.5;
        this.startHairball.visible = false;
        this.endHairball.x = -offsetX;
        this.endHairball.y = -offsetY;
        this.endHairball.brownFace.visible = true;
        this.endHairball.greyFace.alpha = 0;
    };
    HairballBrownDivideAni.prototype.play = function (startP, endP, callback) {
        var _this = this;
        this.reset();
        var oriEyeX = 23;
        var oriEyeY = 33;
        var obj = { x: -offsetX, y: -offsetY };
        var eyeObj = { x: oriEyeX, y: oriEyeY };
        if (Math.abs(endP[0] - startP[0]) <= 0.001 && Math.abs(endP[1] - startP[1]) <= 0.001) {
        }
        else if (Math.abs(endP[0] - startP[0]) <= 0.001) {
            if (endP[1] - startP[1] > 0) {
                obj.y += Tool_1.Tool.height;
                eyeObj.y += 4;
            }
            else {
                obj.y -= Tool_1.Tool.height;
                eyeObj.y -= 4;
            }
        }
        else {
            if (endP[0] - startP[0] > 0) {
                obj.x += Tool_1.Tool.width;
                eyeObj.x += 4;
            }
            else {
                obj.x -= Tool_1.Tool.width;
                eyeObj.x -= 4;
            }
        }
        this.x = startP[0];
        this.y = startP[1];
        var tweenPosAll = FYGE.Tween.get(this.endHairball);
        for (var i = 0; i < 5; i++) {
            tweenPosAll.to({ x: -offsetX - 1 }, 20)
                .to({ x: -offsetX + 2 }, 20)
                .to({ x: -offsetX }, 20);
        }
        tweenPosAll.call(function () {
            _this.startHairball.visible = true;
        });
        tweenPosAll.to(obj, 200);
        FYGE.Tween.get(this.endHairball.greyFace)
            .wait(100)
            .to({ alpha: 1 }, 100)
            .call(function () {
            _this.endHairball.brownFace.visible = false;
        });
        FYGE.Tween.get(this.endHairball.eyesDown)
            .wait(50)
            .to({ scaleY: 1.5 }, 50)
            .wait(420)
            .to({ scaleY: 1 }, 30);
        FYGE.Tween.get(this.startHairball.eyesDown)
            .wait(520)
            .to({ scaleY: 1 }, 30);
        FYGE.Tween.get(this.endHairball.eyes)
            .wait(200)
            .to(eyeObj, 30)
            .wait(290)
            .to({ x: oriEyeX, y: oriEyeY }, 30)
            .call(function () {
            if (_this.parent)
                _this.parent.removeChild(_this);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.HAIRBALLBROWNDIVIDE_ANI, _this);
            callback();
        });
    };
    return HairballBrownDivideAni;
}(FYGE.Container));
exports.HairballBrownDivideAni = HairballBrownDivideAni;
var Hairball = (function (_super) {
    __extends(Hairball, _super);
    function Hairball() {
        var _this = _super.call(this) || this;
        _this.brownFace = new FYGE.Sprite(RES_1.RES.getRes("brownBallFace.png"));
        _this.addChild(_this.brownFace);
        _this.greyFace = new FYGE.Sprite(RES_1.RES.getRes("greyBallFace.png"));
        _this.addChild(_this.greyFace);
        _this.eyesDown = new EyesDown();
        _this.eyesDown.x = 16;
        _this.eyesDown.y = 29 + 29 / 2;
        _this.addChild(_this.eyesDown);
        _this.eyes = new Eyes();
        _this.eyes.x = 23;
        _this.eyes.y = 33;
        _this.addChild(_this.eyes);
        return _this;
    }
    return Hairball;
}(FYGE.Container));
var Eyes = (function (_super) {
    __extends(Eyes, _super);
    function Eyes() {
        var _this = _super.call(this) || this;
        var texture = RES_1.RES.getRes("eyeSingle.png");
        _this.left = new FYGE.Sprite(texture);
        _this.addChild(_this.left);
        _this.right = new FYGE.Sprite(texture);
        _this.right.x = 23;
        _this.addChild(_this.right);
        return _this;
    }
    return Eyes;
}(FYGE.Container));
var EyesDown = (function (_super) {
    __extends(EyesDown, _super);
    function EyesDown() {
        var _this = _super.call(this) || this;
        _this.left = new FYGE.Sprite(RES_1.RES.getRes("eyeDownLeft.png"));
        _this.left.y = -29 / 2;
        _this.addChild(_this.left);
        _this.right = new FYGE.Sprite(RES_1.RES.getRes("eyeDownRight.png"));
        _this.right.x = 45 - 16;
        _this.right.y = -29 / 2;
        _this.addChild(_this.right);
        return _this;
    }
    return EyesDown;
}(FYGE.Container));


/***/ }),

/***/ "./src/something/anis/HairballGreyDisAni.ts":
/*!**************************************************!*\
  !*** ./src/something/anis/HairballGreyDisAni.ts ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.HairballGreyDisAni = void 0;
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var offsetX = 120 / 2;
var offsetY = 120 / 2;
var config = [
    {
        "name": "hairballPiece1",
        "x": 57,
        "y": 70,
    },
    {
        "name": "hairballPiece2",
        "x": 23,
        "y": 71,
    },
    {
        "name": "hairballPiece3",
        "x": 61,
        "y": 63,
    },
    {
        "name": "hairballPiece4",
        "x": 22,
        "y": 64,
    },
    {
        "name": "hairballPiece5",
        "x": 71,
        "y": 49,
    },
    {
        "name": "hairballPiece6",
        "x": 42,
        "y": 55,
    },
    {
        "name": "hairballPiece7",
        "x": 23,
        "y": 44,
    },
    {
        "name": "hairballPiece8",
        "x": 59,
        "y": 26,
    },
    {
        "name": "hairballPiece9",
        "x": 23,
        "y": 26,
    },
];
var HairballGreyDisAni = (function (_super) {
    __extends(HairballGreyDisAni, _super);
    function HairballGreyDisAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.HAIRBALLGREYDIS_ANI;
        _this.pieces = [];
        for (var i = 0; i < config.length; i++) {
            var bitmap = _this.addChild(new FYGE.Sprite(RES_1.RES.getRes(config[i].name + ".png")));
            _this.pieces.push(bitmap);
        }
        _this.upBg = _this.addChild(new FYGE.Sprite(RES_1.RES.getRes("hairballDisBg.png")));
        _this.upBg.anchorTexture.set(0.5, 0.5);
        _this.reset();
        return _this;
    }
    HairballGreyDisAni.prototype.reset = function () {
        for (var i = 0; i < config.length; i++) {
            this.pieces[i].x = config[i].x - offsetX;
            this.pieces[i].y = config[i].y - offsetY;
            this.pieces[i].alpha = 1;
        }
        this.upBg.scaleX = this.upBg.scaleY = 1;
        this.upBg.alpha = 1;
    };
    HairballGreyDisAni.prototype.play = function () {
        var _this = this;
        this.reset();
        FYGE.Tween.get(this.upBg)
            .to({ scaleX: 1.4, scaleY: 1.4 }, 170)
            .to({ scaleX: 1, scaleY: 1, alpha: 0 }, 160)
            .call(function () {
            var _loop_1 = function (i) {
                var p = _this.pieces[i];
                var y = config[i].y;
                FYGE.Tween.get(p)
                    .wait(i * 30)
                    .to({ y: y + 6 }, 170);
                FYGE.Tween.get(p)
                    .wait(i * 30 + 100)
                    .to({ alpha: 0 }, 50)
                    .call(function () {
                    if (i == config.length - 1) {
                        _this.recover();
                    }
                });
            };
            for (var i = 0; i < config.length; i++) {
                _loop_1(i);
            }
        });
    };
    return HairballGreyDisAni;
}(Ani_1.Ani));
exports.HairballGreyDisAni = HairballGreyDisAni;


/***/ }),

/***/ "./src/something/anis/HairballJumpAni.ts":
/*!***********************************************!*\
  !*** ./src/something/anis/HairballJumpAni.ts ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.HairballJumpAni = void 0;
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var StateType_1 = __webpack_require__(/*! ../enum/StateType */ "./src/something/enum/StateType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var HairballJumpAni = (function (_super) {
    __extends(HairballJumpAni, _super);
    function HairballJumpAni() {
        return _super.call(this) || this;
    }
    HairballJumpAni.prototype.play = function (type, startP, endP, callback) {
        var _this = this;
        var source;
        switch (type) {
            case StateType_1.StateType.HAIRBALLBLACK:
                source = "ele" + ElementType_1.ElementType.HAIRBALLBLACK + ".png";
                break;
            case StateType_1.StateType.HAIRBALLGREY:
                source = "ele" + ElementType_1.ElementType.HAIRBALLGREY + ".png";
                break;
            case StateType_1.StateType.HAIRBALLBROWN:
                source = "ele" + ElementType_1.ElementType.HAIRBALLBROWN + ".png";
                break;
            default:
                source = "ele" + ElementType_1.ElementType.HAIRBALLGREY + ".png";
                break;
        }
        var texture = RES_1.RES.getRes(source);
        this.texture = texture;
        this.anchorTexture.set(0.5, 1);
        this.x = startP[0];
        this.y = startP[1] + texture.height / 2;
        FYGE.Tween.get(this)
            .to({ scaleX: 1.2, scaleY: 0.8 }, 50)
            .to({ scaleX: 0.8, scaleY: 1.2 }, 50)
            .to({ scaleX: 1, scaleY: 1 }, 50)
            .to({ scaleX: 1.2, scaleY: 0.8 }, 50)
            .to({ scaleX: 0.8, scaleY: 1.2 }, 50)
            .to({ scaleX: 1, scaleY: 1 }, 50)
            .call(function () {
            if (_this.parent)
                _this.parent.removeChild(_this);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.HAIRBALLJUMP_ANI, _this);
            callback();
        });
        FYGE.Tween.get(this)
            .to({ x: endP[0], y: endP[1] + texture.height / 2 }, 300, FYGE.Ease.sineInOut);
    };
    return HairballJumpAni;
}(FYGE.Sprite));
exports.HairballJumpAni = HairballJumpAni;


/***/ }),

/***/ "./src/something/anis/HatchAni.ts":
/*!****************************************!*\
  !*** ./src/something/anis/HatchAni.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.HatchAni = void 0;
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var BitmapRecycle_1 = __webpack_require__(/*! ../class/BitmapRecycle */ "./src/something/class/BitmapRecycle.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
function HatchAni(startIndex, endIndexs, thisObj, callback) {
    var countAll = endIndexs.length;
    var count = 0;
    var startP = Tool_1.Tool.getPositionByIndex(startIndex);
    var _loop_1 = function (i) {
        var endIndex = endIndexs[i];
        var endP = Tool_1.Tool.getPositionByIndex(endIndex);
        texture = RES_1.RES.getRes("ele" + ElementType_1.ElementType.CHICKEN + ".png");
        var eleC = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.BITMAPRECYCLE);
        if (!eleC) {
            eleC = new BitmapRecycle_1.BitmapRecycle(texture);
        }
        else {
            eleC.reset(texture);
        }
        eleC.x = startP[0];
        eleC.y = startP[1];
        eleC.scaleX = eleC.scaleY = 0.7;
        thisObj.addChild(eleC);
        paraCurveAni(eleC, startP, endP, function () {
            thisObj.removeChild(eleC);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.BITMAPRECYCLE, eleC);
            thisObj.lattices[endIndex].element.reset(ElementType_1.ElementType.CHICKEN);
            if (++count == countAll)
                callback();
        });
    };
    var texture;
    for (var i = 0; i < endIndexs.length; i++) {
        _loop_1(i);
    }
}
exports.HatchAni = HatchAni;
var deltaTime = 500;
var gravity = 0.003;
function paraCurveAni(ele, startP, endP, callback) {
    var deltaX = endP[0] - startP[0];
    var deltaY = endP[1] - startP[1];
    var vy0 = deltaY / deltaTime - gravity * deltaTime / 2;
    var a = { t: 0 };
    FYGE.Tween.get(a, {
        onChange: function () {
            ele.x = deltaX * a.t / deltaTime + startP[0];
            ele.y = vy0 * a.t + gravity * a.t * a.t / 2 + startP[1];
        }
    })
        .to({ t: deltaTime }, deltaTime)
        .call(function () {
        callback();
    });
    var rotation;
    if (deltaX > 0) {
        rotation = 360;
    }
    else if (deltaX < 0) {
        rotation = -360;
    }
    else {
        rotation = 0;
    }
    FYGE.Tween.get(ele)
        .set({ scaleX: 0.3, scaleY: 0.3, rotation: 0 })
        .to({ scaleX: 1, scaleY: 1, rotation: rotation }, deltaTime);
}


/***/ }),

/***/ "./src/something/anis/HorizontalAni.ts":
/*!*********************************************!*\
  !*** ./src/something/anis/HorizontalAni.ts ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.HorizontalAni = void 0;
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var HorizontalAni = (function (_super) {
    __extends(HorizontalAni, _super);
    function HorizontalAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.HORIZONTAL_ANI;
        _this.showImage = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
        _this.addChild(_this.showImage);
        _this.showImage.anchorTexture.set(0.5, 0.5);
        _this.showImage.scaleY = 0.1;
        _this.showImage.rotation = 90;
        return _this;
    }
    HorizontalAni.prototype.play = function () {
        var _this = this;
        this.showImage.scaleY = 0.1;
        this.showImage.alpha = 1;
        FYGE.Tween.get(this.showImage)
            .to({ scaleY: 1.2 }, 300)
            .to({ alpha: 0 }, 100)
            .call(function () {
            _this.recover();
        });
    };
    return HorizontalAni;
}(Ani_1.Ani));
exports.HorizontalAni = HorizontalAni;


/***/ }),

/***/ "./src/something/anis/IceAni.ts":
/*!**************************************!*\
  !*** ./src/something/anis/IceAni.ts ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.IceAni = void 0;
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var IceAni = (function (_super) {
    __extends(IceAni, _super);
    function IceAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.ICE_ANI;
        var arr = [];
        arr.push(RES_1.RES.getRes("ele" + ElementType_1.ElementType.ICE + ".png"));
        for (var i = 2; i <= 6; i++)
            arr.push(RES_1.RES.getRes("ice" + i + ".png"));
        _this.showImage = new FYGE.FrameAni(arr);
        _this.addChild(_this.showImage);
        return _this;
    }
    IceAni.prototype.play = function () {
        var _this = this;
        this.showImage.reset(0);
        this.showImage.play(1, function () {
            _this.recover();
        });
    };
    return IceAni;
}(Ani_1.Ani));
exports.IceAni = IceAni;


/***/ }),

/***/ "./src/something/anis/JellyDisAni.ts":
/*!*******************************************!*\
  !*** ./src/something/anis/JellyDisAni.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.JellyDisAni = void 0;
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var JellyDisAni = (function (_super) {
    __extends(JellyDisAni, _super);
    function JellyDisAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.JELLYDIS_ANI;
        var arr = ["ele" + ElementType_1.ElementType.JELLY + ".png", "greenCircleDown.png", "greenCircleUp.png"];
        var objs = ["showImage", "downCircle", "upCircle"];
        for (var i = 0; i < arr.length; i++) {
            var texture = RES_1.RES.getRes(arr[i]);
            var obj = new FYGE.Sprite(texture);
            _this.addChild(obj);
            obj.anchorTexture.set(0.5, 0.5);
            _this[objs[i]] = obj;
        }
        return _this;
    }
    JellyDisAni.prototype.play = function () {
        var _this = this;
        FYGE.Tween.get(this.showImage)
            .set({ alpha: 1 })
            .to({ alpha: 0 }, 250 * 1.5);
        FYGE.Tween.get(this.downCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .to({ scaleX: 0.6, scaleY: 0.6 }, 300 * 1.5, FYGE.Ease.cubicOut)
            .call(function () {
            _this.recover();
        });
        FYGE.Tween.get(this.downCircle)
            .set({ alpha: 1 })
            .wait(140 * 1.5)
            .to({ alpha: 0 }, 160 * 1.5);
        FYGE.Tween.get(this.upCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .wait(70 * 1.5)
            .to({ scaleX: 1, scaleY: 1 }, 160 * 1.5, FYGE.Ease.cubicOut);
        FYGE.Tween.get(this.upCircle)
            .set({ alpha: 1 })
            .wait(170 * 1.5)
            .to({ alpha: 0 }, 100 * 1.5);
    };
    return JellyDisAni;
}(Ani_1.Ani));
exports.JellyDisAni = JellyDisAni;


/***/ }),

/***/ "./src/something/anis/JellySpreadAni.ts":
/*!**********************************************!*\
  !*** ./src/something/anis/JellySpreadAni.ts ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.JellySpreadAni = void 0;
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var JellySpreadAni = (function (_super) {
    __extends(JellySpreadAni, _super);
    function JellySpreadAni() {
        var _this = _super.call(this) || this;
        var texture = RES_1.RES.getRes("ele" + ElementType_1.ElementType.JELLY + ".png");
        _this.targetImage = new FYGE.Sprite(texture);
        _this.targetImage.anchorTexture.set(0.5, 0.5);
        _this.addChild(_this.targetImage);
        _this.oriImage = new FYGE.Sprite(texture);
        _this.oriImage.anchorTexture.set(0.5, 0.5);
        _this.addChild(_this.oriImage);
        _this.shoot = new FYGE.Sprite(RES_1.RES.getRes("jellyArrow.png"));
        _this.shoot.anchorTexture.set(0, 0.5);
        _this.addChild(_this.shoot);
        return _this;
    }
    JellySpreadAni.prototype.play = function (startP, cloneEle, callback) {
        var _this = this;
        this.x = startP[0];
        this.y = startP[1];
        var endP = [cloneEle.x, cloneEle.y];
        this.addChildAt(cloneEle, 0);
        this.shoot.visible = true;
        this.shoot.x = 0;
        this.shoot.y = 0;
        this.shoot.scaleX = this.shoot.scaleY = 0.01;
        this.targetImage.visible = false;
        var obj = { scaleX: 0.01, scaleY: 0.01, x: 0, y: 0 };
        if (Math.abs(endP[0] - startP[0]) <= 0.001) {
            if (endP[1] - startP[1] > 0) {
                this.shoot.rotation = 90;
                this.targetImage.x = 0;
                this.targetImage.y = Tool_1.Tool.height;
                obj.y = Tool_1.Tool.height;
            }
            else {
                this.shoot.rotation = 270;
                this.targetImage.x = 0;
                this.targetImage.y = -Tool_1.Tool.height;
                obj.y = -Tool_1.Tool.height;
            }
        }
        else {
            if (endP[0] - startP[0] > 0) {
                this.shoot.rotation = 0;
                this.targetImage.x = Tool_1.Tool.width;
                this.targetImage.y = 0;
                obj.x = Tool_1.Tool.width;
            }
            else {
                this.shoot.rotation = 180;
                this.targetImage.x = -Tool_1.Tool.width;
                this.targetImage.y = 0;
                obj.x = -Tool_1.Tool.width;
            }
        }
        cloneEle.x = this.targetImage.x;
        cloneEle.y = this.targetImage.y;
        FYGE.Tween.get(this.oriImage)
            .to({ scaleX: 1.07, scaleY: 0.89 }, 150)
            .to({ scaleX: 0.91, scaleY: 1.07 }, 150)
            .to({ scaleX: 1.07, scaleY: 0.89 }, 100)
            .to({ scaleX: 0.93, scaleY: 1.06 }, 100)
            .to({ scaleX: 1.07, scaleY: 0.93 }, 100)
            .to({ scaleX: 1, scaleY: 1 }, 100);
        FYGE.Tween.get(this.shoot)
            .to({ scaleX: 2, scaleY: 1 }, 230)
            .to(obj, 50)
            .call(function () {
            _this.removeChild(cloneEle);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.ELEMENT, cloneEle);
            callback();
            _this.shoot.visible = false;
            _this.targetImage.visible = true;
            FYGE.Tween.get(_this.targetImage)
                .to({ scaleX: 1.07, scaleY: 0.89 }, 150)
                .to({ scaleX: 0.91, scaleY: 1.07 }, 150)
                .to({ scaleX: 1.07, scaleY: 0.89 }, 100)
                .to({ scaleX: 0.93, scaleY: 1.06 }, 100)
                .to({ scaleX: 1.07, scaleY: 0.93 }, 100)
                .to({ scaleX: 1, scaleY: 1 }, 100)
                .call(function () {
                if (_this.parent) {
                    _this.parent.removeChild(_this);
                }
                ;
                Pool_1.Pool.recover(RecoverName_1.RecoverName.JELLYSPREAD_ANI, _this);
            });
        });
    };
    return JellySpreadAni;
}(FYGE.Container));
exports.JellySpreadAni = JellySpreadAni;


/***/ }),

/***/ "./src/something/anis/MagicLionAni.ts":
/*!********************************************!*\
  !*** ./src/something/anis/MagicLionAni.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.MagicLionAni = void 0;
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var MagicLionAni = (function (_super) {
    __extends(MagicLionAni, _super);
    function MagicLionAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.MAGICLION_ANI;
        _this.downImage = new FYGE.Container();
        _this.addChild(_this.downImage);
        var texture = RES_1.RES.getRes("magicLionBg.png");
        var one = new FYGE.Sprite(texture);
        one.anchorTexture.set(0.5, 0.5);
        _this.downImage.addChild(one);
        _this.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            one.rotation -= 5;
        }, _this);
        var other = new FYGE.Sprite(texture);
        other.anchorTexture.set(0.5, 0.5);
        _this.downImage.addChild(other);
        _this.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            other.rotation -= 5;
        }, _this);
        var texture = RES_1.RES.getRes("magicLion.png");
        _this.upImage = new FYGE.Sprite(texture);
        _this.upImage.anchorTexture.set(0.5, 0.5);
        _this.addChild(_this.upImage);
        _this.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            _this.upImage.rotation += 2;
        }, _this);
        return _this;
    }
    MagicLionAni.prototype.play = function () {
        var _this = this;
        this.downImage.scaleX = this.downImage.scaleY = 0.7;
        this.downImage.alpha = 1;
        this.upImage.scaleX = this.upImage.scaleY = 1;
        this.upImage.alpha = 1;
        FYGE.Tween.get(this.downImage)
            .to({ scaleX: 2, scaleY: 2 }, 300)
            .to({ scaleX: 1.2, scaleY: 1.2 }, 200)
            .wait(150)
            .to({ alpha: 0, scaleX: 0.2, scaleY: 0.2 }, 100)
            .call(function () {
            _this.recover();
        });
        FYGE.Tween.get(this.upImage)
            .to({ scaleX: 1, scaleY: 1 }, 300)
            .to({ scaleX: 0, scaleY: 0, alpha: 0 }, 200);
    };
    return MagicLionAni;
}(Ani_1.Ani));
exports.MagicLionAni = MagicLionAni;


/***/ }),

/***/ "./src/something/anis/MagicRotateAni.ts":
/*!**********************************************!*\
  !*** ./src/something/anis/MagicRotateAni.ts ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getRotByTwoVectors = exports.MagicRotateAni = void 0;
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var BitmapRecycle_1 = __webpack_require__(/*! ../class/BitmapRecycle */ "./src/something/class/BitmapRecycle.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var pi = Math.PI;
var pi2 = pi * 2;
function MagicRotateAni(ele, p, con) {
    var eleC = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.BITMAPRECYCLE);
    var texture = RES_1.RES.getRes("ele" + ele.type + ".png");
    if (!eleC) {
        eleC = new BitmapRecycle_1.BitmapRecycle(texture);
    }
    else {
        eleC.reset(texture);
    }
    eleC.x = ele.x;
    eleC.y = ele.y;
    con.addChild(eleC);
    var tAll = 60;
    var deltaX = eleC.x - p[0];
    var deltaY = eleC.y - p[1];
    var dis = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    var vec0 = [1, 0];
    var vec1 = [deltaX, deltaY];
    var rotation = getRotByTwoVectors(vec0, vec1);
    if (deltaY > 0) {
        rotation = pi2 - rotation;
    }
    var a = { t: 0 };
    FYGE.Tween.get(a, {
        onChange: function () {
            var r = dis * (1 - a.t / tAll);
            var theta = a.t / tAll * pi;
            var x = r * Math.cos(theta);
            var y = r * Math.sin(theta);
            var xy = rotationAcodPoint([x, y], rotation);
            eleC.x = xy[0] + p[0];
            eleC.y = xy[1] + p[1];
            eleC.alpha = eleC.scaleX = eleC.scaleY = 1 - a.t / tAll;
        }
    })
        .to({ t: 60 }, 800, FYGE.Ease.quadIn)
        .call(function () {
        con.removeChild(eleC);
        Pool_1.Pool.recover(RecoverName_1.RecoverName.BITMAPRECYCLE, eleC);
    });
}
exports.MagicRotateAni = MagicRotateAni;
function rotationAcodPoint(p, rotation, point) {
    if (point === void 0) { point = [0, 0]; }
    var xp = p[0] - point[0];
    var yp = p[1] - point[1];
    var x = xp * Math.cos(rotation) + yp * Math.sin(rotation);
    var y = yp * Math.cos(rotation) - xp * Math.sin(rotation);
    return [x, y];
}
function getRotByTwoVectors(vec1, vec2) {
    var a = Math.sqrt(vec1[0] * vec1[0] + vec1[1] * vec1[1]);
    var b = Math.sqrt(vec2[0] * vec2[0] + vec2[1] * vec2[1]);
    var ab = vec1[0] * vec2[0] + vec1[1] * vec2[1];
    var cos = ab / (a * b);
    return Math.acos(cos);
}
exports.getRotByTwoVectors = getRotByTwoVectors;


/***/ }),

/***/ "./src/something/anis/PieceToEggAni.ts":
/*!*********************************************!*\
  !*** ./src/something/anis/PieceToEggAni.ts ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.PieceToEggAni = void 0;
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var offsetX = 91 / 2;
var offsetY = 62 / 2;
var PieceToEggAni = (function (_super) {
    __extends(PieceToEggAni, _super);
    function PieceToEggAni() {
        var _this = _super.call(this) || this;
        var arr = ["ele" + ElementType_1.ElementType.CHICKEN_EGG + ".png", "eggPiece1.png", "eggPiece2.png", "eggPiece3.png", "eggPiece4.png", "eggPiece5.png"];
        var objs = ["showImage", "eggPiece1", "eggPiece2", "eggPiece3", "eggPiece4", "eggPiece5"];
        for (var i = 0; i < arr.length; i++) {
            var texture = RES_1.RES.getRes(arr[i]);
            var obj = new FYGE.Sprite(texture);
            _this.addChild(obj);
            obj.anchorTexture.set(0.5, 0.5);
            _this[objs[i]] = obj;
        }
        return _this;
    }
    PieceToEggAni.prototype.play = function (p, callback) {
        var _this = this;
        this.x = p[0];
        this.y = p[1];
        this.showImage.alpha = 0;
        FYGE.Tween.get(this.showImage)
            .wait(250)
            .to({ alpha: 1 }, 150);
        this.alpha = 0;
        FYGE.Tween.get(this)
            .to({ alpha: 1 }, 150);
        FYGE.Tween.get(this.eggPiece1)
            .set({ rotation: 60, x: 37 - offsetX - 30, y: 22 - offsetY - 34 })
            .to({ rotation: 0, x: 37 - offsetX, y: 22 - offsetY }, 400);
        FYGE.Tween.get(this.eggPiece2)
            .set({ rotation: 60, x: 48 - offsetX + 36, y: 20 - offsetY - 28 })
            .to({ rotation: 0, x: 48 - offsetX, y: 20 - offsetY }, 400);
        FYGE.Tween.get(this.eggPiece3)
            .set({ rotation: 60, x: 52 - offsetX + 30, y: 32 - offsetY + 10 })
            .to({ rotation: 0, x: 52 - offsetX, y: 32 - offsetY }, 400);
        FYGE.Tween.get(this.eggPiece4)
            .set({ rotation: 60, x: 45 - offsetX + 32, y: 44 - offsetY + 38 })
            .to({ rotation: 0, x: 45 - offsetX, y: 44 - offsetY }, 400);
        FYGE.Tween.get(this.eggPiece5)
            .set({ rotation: 60, x: 34 - offsetX - 20, y: 34 - offsetY + 14 })
            .to({ rotation: 0, x: 34 - offsetX, y: 34 - offsetY }, 400)
            .call(function () {
            callback();
            if (_this.parent) {
                _this.parent.removeChild(_this);
            }
            ;
            Pool_1.Pool.recover(RecoverName_1.RecoverName.PIECETOEGG_ANI, _this);
        });
    };
    return PieceToEggAni;
}(FYGE.Container));
exports.PieceToEggAni = PieceToEggAni;


/***/ }),

/***/ "./src/something/anis/RockAni.ts":
/*!***************************************!*\
  !*** ./src/something/anis/RockAni.ts ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.RockAni = void 0;
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RockAni = (function (_super) {
    __extends(RockAni, _super);
    function RockAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.ROCK_ANI;
        var arr = [];
        arr.push(RES_1.RES.getRes("ele" + ElementType_1.ElementType.ROCK + ".png"));
        for (var i = 2; i <= 6; i++)
            arr.push(RES_1.RES.getRes("rock" + i + ".png"));
        _this.showImage = new FYGE.FrameAni(arr);
        _this.addChild(_this.showImage);
        return _this;
    }
    RockAni.prototype.play = function () {
        var _this = this;
        this.showImage.reset(0);
        this.showImage.play(1, function () {
            _this.recover();
        });
    };
    return RockAni;
}(Ani_1.Ani));
exports.RockAni = RockAni;


/***/ }),

/***/ "./src/something/anis/ScoreAni.ts":
/*!****************************************!*\
  !*** ./src/something/anis/ScoreAni.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScoreAni = void 0;
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var ScoreAni = (function (_super) {
    __extends(ScoreAni, _super);
    function ScoreAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.SCORE_ANI;
        _this.scoreNumber = new FYGE.BitmapText({});
        _this.addChild(_this.scoreNumber);
        return _this;
    }
    Object.defineProperty(ScoreAni.prototype, "score", {
        get: function () {
            return this._score;
        },
        set: function (value) {
            if (this._score == value)
                return;
            this._score = value;
            this.scoreNumber.text = "" + value;
        },
        enumerable: false,
        configurable: true
    });
    ScoreAni.prototype.play = function () {
        var _this = this;
        this.scoreNumber.y = 0;
        this.scoreNumber.alpha = 1;
        FYGE.Tween.get(this.scoreNumber)
            .to({ y: -50, alpha: 0 }, 1000)
            .call(function () {
            _this.recover();
        });
    };
    return ScoreAni;
}(Ani_1.Ani));
exports.ScoreAni = ScoreAni;


/***/ }),

/***/ "./src/something/anis/StepAni.ts":
/*!***************************************!*\
  !*** ./src/something/anis/StepAni.ts ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepAni = void 0;
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var StepAni = (function (_super) {
    __extends(StepAni, _super);
    function StepAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.STEP_ANI;
        var arr = [];
        for (var i = 1; i <= 11; i++) {
            arr.push(RES_1.RES.getRes("stepAni" + i + ".png"));
        }
        _this.showImage = new FYGE.FrameAni(arr);
        _this.addChild(_this.showImage);
        return _this;
    }
    StepAni.prototype.play = function () {
        var _this = this;
        this.showImage.reset(0);
        this.showImage.play(1, function () {
            _this.recover();
        });
    };
    return StepAni;
}(Ani_1.Ani));
exports.StepAni = StepAni;


/***/ }),

/***/ "./src/something/anis/ThreeCrossAni.ts":
/*!*********************************************!*\
  !*** ./src/something/anis/ThreeCrossAni.ts ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThreeCrossAni = void 0;
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var ThreeCrossAni = (function (_super) {
    __extends(ThreeCrossAni, _super);
    function ThreeCrossAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.THREECROSS_ANI;
        for (var i = 1; i < 4; i++) {
            var showImage = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
            _this.addChild(showImage);
            showImage.anchorTexture.set(0.5, 0.5);
            showImage.x = (i - 2) * Tool_1.Tool.height;
            showImage.scaleY = 0.1;
            _this["showImage" + i] = showImage;
        }
        for (var i = 4; i < 7; i++) {
            var showImage = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
            _this.addChild(showImage);
            showImage.anchorTexture.set(0.5, 0.5);
            showImage.y = (i - 5) * Tool_1.Tool.width;
            showImage.scaleY = 0.1;
            showImage.rotation = 90;
            _this["showImage" + i] = showImage;
        }
        return _this;
    }
    ThreeCrossAni.prototype.play = function () {
        var _this = this;
        for (var i = 1; i < 7; i++) {
            this["showImage" + i].scaleY = 0.1;
            this["showImage" + i].alpha = 1;
            if (i == 6) {
                FYGE.Tween.get(this["showImage" + i])
                    .to({ scaleY: 1.2 }, 300)
                    .to({ alpha: 0 }, 100)
                    .call(function () {
                    _this.recover();
                });
            }
            else {
                FYGE.Tween.get(this["showImage" + i])
                    .to({ scaleY: 1.2 }, 300)
                    .to({ alpha: 0 }, 100);
            }
        }
    };
    return ThreeCrossAni;
}(Ani_1.Ani));
exports.ThreeCrossAni = ThreeCrossAni;


/***/ }),

/***/ "./src/something/anis/VerticalAni.ts":
/*!*******************************************!*\
  !*** ./src/something/anis/VerticalAni.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.VerticalAni = void 0;
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var VerticalAni = (function (_super) {
    __extends(VerticalAni, _super);
    function VerticalAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.VERTICAL_ANI;
        _this.showImage = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
        _this.addChild(_this.showImage);
        _this.showImage.anchorTexture.set(0.5, 0.5);
        _this.showImage.scaleY = 0.1;
        return _this;
    }
    VerticalAni.prototype.play = function () {
        var _this = this;
        this.showImage.scaleY = 0.1;
        this.showImage.alpha = 1;
        FYGE.Tween.get(this.showImage)
            .to({ scaleY: 1.2 }, 300)
            .to({ alpha: 0 }, 100)
            .call(function () {
            _this.recover();
        });
    };
    return VerticalAni;
}(Ani_1.Ani));
exports.VerticalAni = VerticalAni;


/***/ }),

/***/ "./src/something/anisCall/DoorChangeAni.ts":
/*!*************************************************!*\
  !*** ./src/something/anisCall/DoorChangeAni.ts ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.DoorChangeAni = void 0;
var Door_1 = __webpack_require__(/*! ../class/Door */ "./src/something/class/Door.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var DoorChangeAni = (function (_super) {
    __extends(DoorChangeAni, _super);
    function DoorChangeAni(lat) {
        var _this = _super.call(this) || this;
        var door = lat.door;
        if (!door) { }
        var textureBg = RES_1.RES.getRes(Door_1.doorBgImages[door.statusNum]);
        _this.doorBg = new FYGE.Sprite(textureBg);
        _this.doorBg.x = -textureBg.width / 2;
        _this.doorBg.y = -textureBg.height / 2;
        _this.addChild(_this.doorBg);
        var textureDoor = RES_1.RES.getRes(Door_1.doorImages[door.closed ? 0 : 1]);
        _this.door = new FYGE.Sprite(textureDoor);
        _this.door.x = -textureDoor.width / 2;
        _this.door.y = -textureDoor.height / 2;
        _this.addChild(_this.door);
        _this.addIce(lat.ice);
        _this.addEle(lat.element);
        return _this;
    }
    DoorChangeAni.prototype.reset = function (lat) {
        this.resetDoor(lat.door);
        this.addIce(lat.ice);
        this.addEle(lat.element);
    };
    DoorChangeAni.prototype.play = function (lat, callback) {
        var _this = this;
        var isClosed = lat.door.closed;
        this.reset(lat);
        var p = Tool_1.Tool.getPositionByIndex(lat.index);
        this.x = p[0];
        this.y = p[1];
        if (this.ice)
            this.ice.visible = isClosed ? false : true;
        if (this.ele)
            this.ele.visible = isClosed ? false : true;
        FYGE.Tween.get(this)
            .to({ scaleX: 0 }, 300)
            .call(function () {
            _this.door.texture = RES_1.RES.getRes(Door_1.doorImages[isClosed ? 1 : 0]);
            if (_this.ice)
                _this.ice.visible = isClosed ? true : false;
            if (_this.ele)
                _this.ele.visible = isClosed ? true : false;
            FYGE.Tween.get(_this)
                .to({ scaleX: 1 }, 300)
                .call(function () {
                callback();
                if (_this.parent) {
                    _this.parent.removeChild(_this);
                }
                ;
                Pool_1.Pool.recover(RecoverName_1.RecoverName.DOORCHANGE_ANI, _this);
            });
        });
    };
    DoorChangeAni.prototype.resetDoor = function (door) {
        this.doorBg.texture = RES_1.RES.getRes(Door_1.doorBgImages[door.statusNum]);
        this.door.texture = RES_1.RES.getRes(Door_1.doorImages[door.closed ? 0 : 1]);
    };
    DoorChangeAni.prototype.addIce = function (ice) {
        if (ice) {
            if (!this.ice) {
                var textureIce = RES_1.RES.getRes("ele" + ElementType_1.ElementType.ICE + ".png");
                this.ice = new FYGE.Sprite(textureIce);
                this.ice.x = -textureIce.width / 2;
                this.ice.y = -textureIce.height / 2;
                this.addChildAt(this.ice, 2);
            }
            this.ice.alpha = ice.countNum == 2 ? 1 : 0.75;
        }
        else if (this.ice) {
            this.removeChild(this.ice);
            this.ice = null;
        }
    };
    DoorChangeAni.prototype.addEle = function (ele) {
        if (ele) {
            if (!this.ele) {
                this.ele = Tool_1.Tool.getElement(ele.type);
                this.ele.x = 0;
                this.ele.y = 0;
                this.addChild(this.ele);
            }
            this.ele.copy(ele);
        }
        else if (this.ele) {
            this.removeChild(this.ele);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.ELEMENT, this.ele);
            this.ele = null;
        }
    };
    return DoorChangeAni;
}(FYGE.Container));
exports.DoorChangeAni = DoorChangeAni;


/***/ }),

/***/ "./src/something/anisCall/FesRedBombShowAni.ts":
/*!*****************************************************!*\
  !*** ./src/something/anisCall/FesRedBombShowAni.ts ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.FesRedBombShowAni = void 0;
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var FesRedBombShowAni = (function (_super) {
    __extends(FesRedBombShowAni, _super);
    function FesRedBombShowAni() {
        var _this = _super.call(this) || this;
        var textureDown = RES_1.RES.getRes("fesRedBombSta1.png");
        var down = new FYGE.Sprite(textureDown);
        down.x = -textureDown.width / 2;
        down.y = -textureDown.height / 2;
        _this.addChild(down);
        var textureUp = RES_1.RES.getRes("xingxingbi.png");
        var up = new FYGE.Sprite(textureUp);
        up.x = -textureUp.width / 2;
        up.y = -100;
        _this.addChild(up);
        return _this;
    }
    FesRedBombShowAni.prototype.play = function (position, callback) {
        var _this = this;
        this.scaleX = this.scaleY = 0.29;
        this.x = position[0];
        this.y = position[1];
        FYGE.Tween.get(this)
            .wait(200)
            .to({ scaleX: 1, scaleY: 1 }, 500, FYGE.Ease.backOut)
            .wait(500)
            .to({ scaleX: 0.29, scaleY: 0.29 }, 500, FYGE.Ease.backInOut)
            .call(function () {
            if (_this.parent)
                _this.parent.removeChild(_this);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.FESREDBOMBSHOW_ANI, _this);
            callback();
        });
    };
    return FesRedBombShowAni;
}(FYGE.Container));
exports.FesRedBombShowAni = FesRedBombShowAni;


/***/ }),

/***/ "./src/something/anisCall/FesRedShootAni.ts":
/*!**************************************************!*\
  !*** ./src/something/anisCall/FesRedShootAni.ts ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.FesRedShootAni = void 0;
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var FesRedShootAni = (function (_super) {
    __extends(FesRedShootAni, _super);
    function FesRedShootAni() {
        var _this = _super.call(this) || this;
        _this.light = new LightingAni();
        _this.addChild(_this.light);
        var arr = [];
        for (var i = 1; i <= 10; i++) {
            arr.push(RES_1.RES.getRes("fesEleSmallDis" + i + ".png"));
        }
        _this.imageAniCon = new FYGE.Container();
        _this.imageAni = new FYGE.FrameAni(arr);
        _this.imageAniCon.addChild(_this.imageAni);
        _this.addChild(_this.imageAniCon);
        _this.imageAni.visible = false;
        return _this;
    }
    FesRedShootAni.prototype.reset = function () {
        this.light.visible = true;
        this.imageAni.visible = false;
        this.light.scaleX = 0.2;
    };
    FesRedShootAni.prototype.play = function (startP, ele, callback) {
        var _this = this;
        this.reset();
        var r = Tool_1.Tool.getForwardRotation(startP, [ele.x, ele.y]);
        this.light.rotation = r * 180 / Math.PI;
        this.light.x = startP[0];
        this.light.y = startP[1];
        this.imageAniCon.x = ele.x;
        this.imageAniCon.y = ele.y;
        var dis = Math.sqrt((startP[0] - ele.x) * (startP[0] - ele.x) +
            (startP[1] - ele.y) * (startP[1] - ele.y));
        var scaleX = dis / 247;
        FYGE.Tween.get(this.light)
            .to({ scaleX: scaleX, }, 400)
            .call(function () {
            ele.reset(ElementType_1.ElementType.FESTIVALELE_SMALL);
            ele.scaleX = ele.scaleY = 0.1;
            FYGE.Tween.get(ele)
                .to({ scaleX: 1, scaleY: 1 }, 500, FYGE.Ease.backOut);
            callback();
            _this.imageAni.visible = true;
            _this.imageAni.play(1, function () {
                if (_this.parent) {
                    _this.parent.removeChild(_this);
                }
                ;
                Pool_1.Pool.recover(RecoverName_1.RecoverName.FESREDSHOOT_ANI, _this);
            });
            setTimeout(function () {
                _this.light.visible = false;
            }, 200);
        });
    };
    return FesRedShootAni;
}(FYGE.Container));
exports.FesRedShootAni = FesRedShootAni;
var LightingAni = (function (_super) {
    __extends(LightingAni, _super);
    function LightingAni() {
        var _this = _super.call(this) || this;
        var arr = [];
        for (var i = 1; i <= 13; i++) {
            arr.push(RES_1.RES.getRes("lineLight" + i + ".png"));
        }
        _this.anchorTexture.set(23 / 293, 27 / 58);
        _this.sourceAll = arr;
        _this.texture = RES_1.RES.getRes(_this.sourceAll[0]);
        _this.currentFrame = 0;
        _this.totalFrames = arr.length;
        _this.addEventListener(FYGE.Event.ENTER_FRAME, _this.onEnterFrame, _this);
        _this.startTime = Date.now();
        _this.allTime = _this.sourceAll.length / 30 * 1000;
        return _this;
    }
    LightingAni.prototype.onEnterFrame = function () {
        if (!this.stage)
            return;
        var dataNow = Date.now();
        var deltaTime = dataNow - this.startTime;
        var scale = deltaTime / this.allTime;
        if (scale >= 1) {
            this.startTime = Date.now();
            this.currentFrame = 0;
        }
        else {
            this.currentFrame = (scale * this.sourceAll.length) >> 0;
        }
        this.texture = RES_1.RES.getRes(this.sourceAll[this.currentFrame]);
    };
    return LightingAni;
}(FYGE.Sprite));


/***/ }),

/***/ "./src/something/anisCall/RectsWaveAni.ts":
/*!************************************************!*\
  !*** ./src/something/anisCall/RectsWaveAni.ts ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.RectsWaveAni = void 0;
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var whiteRectPool = [];
function RectsWaveAni(lattices, container, callback, centerIndex) {
    if (centerIndex === void 0) { centerIndex = 40; }
    var loops = [];
    var rc = Tool_1.Tool.indexToRc(centerIndex);
    var num = 0;
    var maxNum = Math.max(rc[0], rc[1], Tool_1.Tool.rowNum - rc[0] - 1, Tool_1.Tool.colNum - rc[1] - 1);
    while (num <= maxNum) {
        var indexs = [];
        if (num) {
            var rowMax = rc[0] + num;
            var rowMin = rc[0] - num;
            var colMax = rc[1] + num;
            var colMin = rc[1] - num;
            var colIndexs = rangeIndexs(colMin >= 0 ? colMin : 0, colMax < Tool_1.Tool.colNum ? colMax : Tool_1.Tool.colNum - 1);
            var rowIndexs = rangeIndexs(rowMin >= 0 ? rowMin : 0, rowMax < Tool_1.Tool.rowNum ? rowMax : Tool_1.Tool.rowNum - 1, false);
            if (rowMin >= 0) {
                for (var i = 0; i < colIndexs.length; i++) {
                    var index = Tool_1.Tool.rcToIndex(rowMin, colIndexs[i]);
                    if (lattices[index])
                        indexs.push(index);
                }
            }
            if (rowMax < Tool_1.Tool.rowNum) {
                for (var i = 0; i < colIndexs.length; i++) {
                    var index = Tool_1.Tool.rcToIndex(rowMax, colIndexs[i]);
                    if (lattices[index])
                        indexs.push(index);
                }
            }
            if (colMin >= 0) {
                for (var i = 0; i < rowIndexs.length; i++) {
                    var index = Tool_1.Tool.rcToIndex(rowIndexs[i], colMin);
                    if (lattices[index])
                        indexs.push(index);
                }
            }
            if (colMax < Tool_1.Tool.colNum) {
                for (var i = 0; i < rowIndexs.length; i++) {
                    var index = Tool_1.Tool.rcToIndex(rowIndexs[i], colMax);
                    if (lattices[index])
                        indexs.push(index);
                }
            }
        }
        else {
            indexs.push(centerIndex);
        }
        var loop = [];
        for (var i = 0; i < indexs.length; i++) {
            var index = indexs[i];
            var p = Tool_1.Tool.getPositionByIndex(index);
            var rect = whiteRectPool.shift();
            if (!rect)
                rect = new WhiteRect();
            rect.alpha = 0;
            rect.x = p[0];
            rect.y = p[1];
            container.addChild(rect);
            loop.push(rect);
        }
        loops.push(loop);
        num++;
    }
    for (var m = loops.length - 1; m >= 0; m--) {
        if (!loops[m].length) {
            loops.pop();
        }
        else {
            break;
        }
    }
    var loopsLen = loops.length;
    var _loop_1 = function (m) {
        var loop_1 = loops[m];
        var wait = m * 100;
        var loopLen = loop_1.length;
        var _loop_2 = function (n) {
            var rect = loop_1[n];
            FYGE.Tween.get(rect)
                .wait(wait)
                .to({ alpha: 1 }, 150)
                .to({ alpha: 0 }, 150)
                .call(function () {
                if (rect.parent) {
                    rect.parent.removeChild(rect);
                    whiteRectPool.push(rect);
                }
                if (m == loopsLen - 1 && n == loopLen - 1 && callback)
                    callback();
            });
        };
        for (var n = 0; n < loop_1.length; n++) {
            _loop_2(n);
        }
    };
    for (var m = 0; m < loops.length; m++) {
        _loop_1(m);
    }
}
exports.RectsWaveAni = RectsWaveAni;
var WhiteRect = (function (_super) {
    __extends(WhiteRect, _super);
    function WhiteRect() {
        var _this = _super.call(this) || this;
        var texture = RES_1.RES.getRes("rectLatWhite.png");
        _this.texture = texture;
        _this.anchorTexture.set(0.5, 0.5);
        return _this;
    }
    return WhiteRect;
}(FYGE.Sprite));
function rangeIndexs(min, max, include) {
    if (include === void 0) { include = true; }
    var nums = [];
    if (include)
        nums.push(min);
    var num = min;
    while (++num < max)
        nums.push(num);
    if (include)
        nums.push(max);
    return nums;
}


/***/ }),

/***/ "./src/something/chapters/Chapter1.ts":
/*!********************************************!*\
  !*** ./src/something/chapters/Chapter1.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Chapters1 = void 0;
var PassType_1 = __webpack_require__(/*! ../enum/PassType */ "./src/something/enum/PassType.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
exports.Chapters1 = [
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 1,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 111,
                },
            ],
        },
        starScores: [1000, 5000, 10000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 1, 0, 0, 0, 1, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 11, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 1, 0, 0, 0, 1, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 20, 0, 0, 0, 20, 0, 0,
                0, 20, 10, 20, 0, 20, 10, 20, 0,
                20, 10, 20, 10, 20, 10, 20, 10, 20,
                20, 10, 20, 20, 10, 20, 20, 10, 20,
                0, 20, 10, 20, 10, 20, 10, 20, 0,
                0, 0, 20, 10, 20, 10, 20, 0, 0,
                0, 0, 0, 20, 10, 20, 0, 0, 0,
                0, 0, 0, 0, 20, 0, 0, 0, 0,
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 45,
                },
            ],
        },
        starScores: [1000, 5000, 10000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 1, 0, 0, 0, 1, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 11, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 1, 0, 0, 0, 1, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 20, 0, 0, 0, 20, 0, 0,
                0, 20, 10, 20, 0, 20, 10, 20, 0,
                20, 10, 20, 10, 20, 10, 20, 10, 20,
                20, 10, 20, 20, 10, 20, 20, 10, 20,
                0, 20, 10, 20, 10, 20, 10, 20, 0,
                0, 0, 20, 10, 20, 10, 20, 0, 0,
                0, 0, 0, 20, 10, 20, 0, 0, 0,
                0, 0, 0, 0, 20, 0, 0, 0, 0,
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 6,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 26,
                },
            ],
        },
        starScores: [100, 500, 950],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                2, 2, 2, 2, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 2, 2, 0, 0, 0, 1, 1, 0,
                1, 2, 2, 1, 0, 1, 2, 2, 1,
                0, 2, 2, 0, 0, 0, 2, 2, 0,
                2, 2, 2, 2, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 10, 10, 0, 0, 0, 10, 20, 0,
                20, 20, 10, 20, 0, 10, 20, 10, 20,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 40, 30, 0, 0, 0, 10, 30, 0,
                10, 30, 40, 20, 0, 20, 30, 40, 10,
                0, 40, 30, 0, 0, 0, 40, 30, 0,
                20, 20, 10, 10, 0, 20, 40, 20, 10,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 20,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ROCK,
                    count: 19
                }
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            elements: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
                0, 0, 2, 1, 2, 1, 2, 0, 0,
                0, 0, 1, 2, 1, 2, 1, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 10, 10, 20, 10, 10, 0, 0,
                0, 0, 30, 40, 10, 40, 40, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 10, 2, 2, 0, 0,
                0, 0, 2, 10, 2, 10, 2, 0, 0,
                0, 0, 10, 2, 10, 2, 10, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 24
                }
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
            ],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.RABBIT,
                    count: 35
                },
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 35
                }
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            baseElements: [
                0, 10, 20, 10, 20, 10, 20, 10, 0,
                0, 20, 10, 20, 30, 20, 10, 20, 0,
                0, 10, 0, 10, 20, 30, 0, 10, 0,
                0, 20, 10, 20, 30, 1, 1, 1, 0,
                40, 50, 40, 50, 30, 40, 50, 40, 50,
                0, 20, 10, 20, 10, 30, 10, 20, 0,
                0, 10, 0, 10, 30, 10, 0, 10, 0,
                0, 20, 10, 20, 10, 20, 10, 20, 0,
                0, 10, 20, 10, 20, 10, 20, 10, 0,
            ],
            generateLats: [
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [10, 20, 30, 40] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 17
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                0, 1, 3, 3, 1, 3, 3, 1, 0,
                0, 1, 3, 3, 1, 3, 3, 1, 0,
                0, 0, 1, 1, 3, 1, 1, 0, 0,
                0, 1, 3, 3, 1, 3, 3, 1, 0,
                0, 1, 3, 3, 1, 3, 3, 1, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 10, 20, 20, 0, 30, 30, 50, 0,
                0, 40, 30, 30, 40, 10, 10, 30, 0,
                0, 10, 30, 30, 40, 10, 10, 50, 0,
                0, 0, 40, 40, 50, 40, 40, 0, 0,
                0, 30, 20, 20, 40, 50, 50, 20, 0,
                0, 30, 20, 20, 40, 50, 50, 10, 0,
                0, 40, 40, 50, 0, 20, 40, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 24
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 20, 20, 30, 30, 20, 20,
                10, 20, 0, 20, 20, 30, 30, 20, 20,
                10, 20, 0, 10, 10, 40, 40, 10, 10,
                20, 10, 0, 10, 10, 40, 40, 10, 10,
                10, 20, 0, 20, 20, 30, 30, 20, 20,
                20, 10, 0, 20, 20, 30, 30, 20, 20,
                20, 10, 0, 40, 40, 10, 10, 40, 40,
                0, 0, 0, 40, 40, 10, 10, 40, 40,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 9, type: [10, 20], cus: [] },
                { index: 10, type: [10, 20], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [10, 20, 30, 40] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 18
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 0, 0, 0, 0, 1, 0,
                0, 2, 2, 2, 0, 0, 1, 1, 1,
                1, 2, 2, 2, 1, 0, 0, 1, 0,
                0, 2, 2, 2, 1, 1, 0, 1, 0,
                0, 0, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 2, 2, 2, 1,
                0, 1, 0, 0, 1, 2, 2, 2, 1,
                1, 1, 1, 1, 1, 2, 2, 2, 1,
                0, 1, 0, 0, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 1, 0, 0, 0, 0, 1, 0,
                0, 1, 1, 1, 0, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 0, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 0, 1, 0,
                0, 0, 1, 1, 0, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 0, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                0, 0, 10, 0, 0, 0, 0, 10, 0,
                0, 20, 10, 20, 0, 0, 10, 30, 10,
                10, 10, 20, 10, 40, 0, 0, 10, 0,
                0, 10, 20, 10, 40, 40, 0, 10, 0,
                0, 0, 10, 40, 0, 40, 10, 20, 20,
                0, 0, 0, 40, 40, 30, 10, 10, 20,
                0, 10, 0, 0, 40, 10, 20, 10, 10,
                10, 30, 10, 10, 20, 10, 20, 30, 30,
                0, 10, 0, 0, 20, 20, 10, 30, 30,
            ],
            generateLats: [
                { index: 2, type: [0], cus: [40, 40] },
                { index: 7, type: [0], cus: [] },
                { index: 10, type: [0], cus: [30] },
                { index: 12, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 17, type: [0], cus: [] },
                { index: 18, type: [0], cus: [] },
                { index: 22, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },
                { index: 55, type: [0], cus: [] },
                { index: 63, type: [0], cus: [] },
                { index: 65, type: [0], cus: [] },
                { index: 66, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 36
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                2, 2, 0, 1, 1, 0, 0, 1, 1,
                2, 2, 0, 2, 2, 1, 1, 2, 2,
                2, 2, 0, 2, 2, 1, 1, 2, 2,
                2, 2, 0, 1, 1, 1, 1, 1, 1,
                2, 2, 0, 1, 1, 1, 1, 1, 1,
                2, 2, 0, 1, 2, 2, 2, 2, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 2, 2, 0, 2, 2, 0, 2,
                2, 0, 2, 2, 0, 2, 2, 0, 2,
            ],
            elements: [
                1, 1, 0, 1, 1, 0, 0, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 0, 1, 1, 0, 1, 1, 0, 1,
                1, 0, 1, 1, 0, 1, 1, 0, 1,
            ],
            baseElements: [
                10, 10, 0, 50, 50, 0, 0, 50, 50,
                10, 10, 0, 40, 40, 30, 30, 20, 20,
                20, 20, 0, 40, 40, 30, 30, 20, 20,
                20, 20, 0, 20, 20, 10, 10, 40, 40,
                30, 30, 0, 20, 20, 10, 10, 40, 40,
                30, 30, 0, 40, 40, 20, 20, 30, 30,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                21, 0, 10, 10, 0, 20, 20, 0, 30,
                33, 0, 10, 10, 0, 20, 20, 0, 30,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
                { index: 63, type: [0], cus: [] },
                { index: 65, type: [0], cus: [] },
                { index: 66, type: [0], cus: [] },
                { index: 68, type: [0], cus: [] },
                { index: 69, type: [0], cus: [] },
                { index: 71, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 35
                },
                {
                    type: ElementType_1.ElementType.CATTLE,
                    count: 35
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 0, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                0, 0, 0, 30, 20, 30, 20, 30, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 30, 20, 30, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 20, 0, 30, 30, 20, 20, 10, 10,
                0, 20, 0, 30, 30, 20, 20, 10, 10,
                20, 30, 0, 40, 40, 30, 30, 20, 20,
                0, 20, 0, 40, 40, 30, 30, 20, 20,
                0, 20, 0, 10, 10, 20, 20, 10, 10,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 40, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 43, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },
            ],
            connectedLats: [[3, 21], [4, 22], [5, 23], [6, 24], [7, 25]]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 37
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                2, 0, 0, 0, 2, 2, 2, 2, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 3, 3, 3, 3, 3, 3,
                2, 2, 0, 3, 3, 3, 3, 3, 3,
                0, 0, 0, 3, 3, 3, 3, 3, 3,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                1, 0, 0, 0, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                11, 0, 0, 0, 20, 20, 30, 30, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 10, 10, 20, 20, 10, 10,
                0, 0, 0, 40, 40, 50, 50, 40, 40,
                0, 0, 0, 20, 20, 30, 30, 20, 20,
                0, 0, 0, 40, 40, 10, 10, 40, 40,
                11, 13, 0, 50, 50, 30, 30, 50, 50,
                0, 0, 0, 40, 40, 20, 20, 40, 40,
                0, 0, 0, 30, 30, 10, 10, 30, 30,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 5, type: [0], cus: [14, 11, 14] },
                { index: 6, type: [0], cus: [11, 14, 11] },
                { index: 72, type: [0], cus: [] },
                { index: 73, type: [0], cus: [] },
                { index: 21, type: [0], cus: [] },
                { index: 22, type: [0], cus: [] },
                { index: 23, type: [0], cus: [] },
                { index: 24, type: [0], cus: [] },
                { index: 25, type: [0], cus: [] },
                { index: 26, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 35
                },
                {
                    type: ElementType_1.ElementType.CATTLE,
                    count: 35
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 14, 20, 0, 0, 0,
                0, 0, 0, 0, 21, 0, 0, 0, 0,
                10, 10, 20, 20, 50, 30, 30, 40, 40,
                10, 10, 20, 20, 50, 30, 30, 40, 40,
                40, 40, 30, 30, 40, 10, 10, 50, 50,
                40, 40, 30, 20, 30, 10, 10, 50, 50,
                0, 0, 0, 0, 30, 0, 0, 0, 0,
                0, 0, 10, 20, 10, 20, 10, 0, 0,
            ],
            generateLats: [
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 27, type: [0], cus: [] },
                { index: 28, type: [0], cus: [] },
                { index: 29, type: [0], cus: [] },
                { index: 30, type: [0], cus: [] },
                { index: 32, type: [0], cus: [] },
                { index: 33, type: [0], cus: [] },
                { index: 34, type: [0], cus: [] },
                { index: 35, type: [0], cus: [] },
                { index: 74, type: [0], cus: [] },
                { index: 75, type: [0], cus: [] },
                { index: 77, type: [0], cus: [] },
                { index: 78, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 27
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 1, 2, 2, 2, 1, 2, 2, 2,
                2, 1, 1, 1, 2, 1, 1, 1, 2,
                2, 1, 2, 2, 2, 1, 2, 2, 2,
                2, 1, 2, 1, 1, 1, 1, 1, 2,
                2, 1, 2, 2, 2, 1, 2, 2, 2,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 1, 1, 1, 1,
                1, 1, 2, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 9, type: [0], cus: [] },
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
                { index: 17, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ROCK,
                    count: 39
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
            ],
            baseElements: [
                0, 0, 0, 10, 20, 10, 0, 0, 0,
                0, 0, 0, 20, 10, 20, 0, 0, 0,
                0, 0, 0, 10, 20, 10, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 27, type: [0], cus: [] },
                { index: 28, type: [0], cus: [] },
                { index: 29, type: [0], cus: [] },
                { index: 35, type: [0], cus: [] },
                { index: 34, type: [0], cus: [] },
                { index: 33, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 18
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 3, 3, 3, 1, 3, 3, 3, 0,
                0, 3, 3, 3, 1, 3, 3, 3, 0,
                0, 3, 3, 3, 1, 3, 3, 3, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 2, 1, 1, 1, 0,
                0, 1, 1, 1, 2, 1, 1, 1, 0,
                0, 1, 1, 1, 2, 1, 1, 1, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 10, 20, 10, 2, 20, 10, 20, 0,
                0, 20, 10, 20, 2, 10, 20, 10, 0,
                0, 10, 20, 10, 2, 20, 10, 20, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 27
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 1, 2, 2, 2, 1, 0, 0,
                0, 1, 1, 2, 2, 2, 1, 1, 0,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                0, 1, 1, 2, 2, 2, 1, 1, 0,
                0, 0, 1, 2, 2, 2, 1, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 0, 12, 0, 0, 0, 0,
                0, 0, 0, 12, 20, 12, 0, 0, 0,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.LOLLIPOP,
                    count: 4
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            elements: [
                0, 1, 3, 1, 3, 1, 3, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 2, 2, 2, 3, 2, 2, 2, 0,
                0, 2, 2, 2, 1, 2, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 2, 1, 2, 2, 2, 0,
                0, 2, 2, 2, 1, 2, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
            ],
            baseElements: [
                0, 10, 3, 10, 3, 10, 3, 10, 0,
                0, 20, 30, 20, 30, 20, 30, 20, 0,
                0, 2, 2, 2, 3, 2, 2, 2, 0,
                0, 2, 2, 2, 20, 2, 2, 2, 0,
                0, 2, 2, 20, 30, 40, 2, 2, 0,
                0, 2, 2, 2, 20, 2, 2, 2, 0,
                0, 2, 2, 2, 30, 2, 2, 2, 0,
                0, 2, 2, 40, 20, 30, 2, 2, 0,
                0, 0, 2, 2, 30, 2, 2, 0, 0,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
            ],
            recycles: [74, 75, 76, 77, 78, 70, 64]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.LOLLIPOP,
                    count: 4
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 0, 1, 0, 0, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                0, 0, 1, 3, 1, 3, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
                1, 1, 0, 0, 1, 0, 0, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
            ],
            recycles: [54, 62, 73, 74, 75, 76, 77, 78, 79],
            connectedLats: [[29, 47], [30, 48], [32, 50], [33, 51]]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 33
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 2, 1, 3, 3, 3, 1, 2, 1,
                1, 2, 1, 3, 3, 3, 1, 2, 1,
                1, 2, 1, 3, 3, 3, 1, 2, 1,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 2, 2, 1, 1,
                1, 1, 2, 0, 0, 0, 2, 1, 1,
                1, 1, 2, 0, 0, 0, 2, 1, 1,
                1, 1, 2, 0, 0, 0, 2, 1, 1,
                1, 1, 2, 2, 2, 2, 2, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0,
        stepCount: 32,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.LOLLIPOP,
                    count: 4
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 1, 0, 1, 0, 1, 0, 0, 0,
                1, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 1, 0, 1, 0, 1, 0, 0, 0,
                1, 0, 1, 0, 1, 0, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 0, 1,
            ],
            elements: [
                0, 3, 0, 3, 0, 3, 0, 0, 0,
                2, 0, 2, 0, 2, 0, 2, 0, 0,
                0, 2, 0, 2, 0, 2, 0, 0, 0,
                2, 0, 2, 0, 2, 0, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 1, 2, 1, 2, 1, 2, 0, 1,
                1, 2, 1, 2, 1, 2, 1, 0, 1,
            ],
            baseElements: [
                0, 3, 0, 3, 0, 3, 0, 0, 0,
                2, 0, 2, 0, 2, 0, 2, 0, 0,
                0, 2, 0, 2, 0, 2, 0, 0, 0,
                2, 0, 2, 0, 2, 0, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 22, 2, 22, 2, 22, 2, 0, 13,
                22, 2, 22, 2, 22, 2, 22, 0, 11,
            ],
            generateLats: [
                { index: 1, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 71, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
            ],
            recycles: [72, 73, 74, 77, 75, 76, 78]
        },
    },
];


/***/ }),

/***/ "./src/something/chapters/Chapter2.ts":
/*!********************************************!*\
  !*** ./src/something/chapters/Chapter2.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Chapters2 = void 0;
var PassType_1 = __webpack_require__(/*! ../enum/PassType */ "./src/something/enum/PassType.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
exports.Chapters2 = [
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 56
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 1, 0, 0, 0, 1, 1, 1,
            ],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ROCK,
                    count: 40
                },
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 50
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                2, 2, 1, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 1, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 1, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 1, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 1, 2, 2
            ],
            baseElements: [
                0, 0, 31, 0, 24, 0, 31, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 31, 20, 0, 0, 0,
                0, 0, 0, 0, 20, 0, 0, 0, 0,
                2, 2, 30, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 30, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 30, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 30, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 30, 2, 2
            ],
            generateLats: [
                { index: 2, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 36, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 38, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 43, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },
            ],
            connectedLats: [[2, 21], [4, 22], [6, 23]]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 22,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.LOLLIPOP,
                    count: 12
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                0, 0, 3, 0, 3, 0, 3, 0, 0,
                0, 0, 3, 0, 3, 0, 3, 0, 0,
                0, 1, 2, 1, 2, 1, 2, 1, 0,
                0, 1, 2, 1, 2, 1, 2, 1, 0,
                0, 1, 2, 1, 2, 1, 2, 1, 0,
                0, 1, 2, 1, 2, 1, 2, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            baseElements: [
                0, 0, 3, 0, 3, 0, 3, 0, 0,
                0, 0, 3, 0, 3, 0, 3, 0, 0,
                0, 10, 2, 30, 2, 20, 2, 10, 0,
                0, 30, 2, 30, 2, 20, 2, 10, 0,
                0, 20, 2, 20, 2, 10, 2, 30, 0,
                0, 10, 2, 20, 2, 10, 2, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                40, 40, 50, 40, 50, 40, 50, 40, 40,
                0, 50, 40, 50, 40, 50, 40, 50, 0,
            ],
            generateLats: [
                { index: 2, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 63, type: [0], cus: [] },
                { index: 64, type: [0], cus: [] },
                { index: 65, type: [0], cus: [] },
                { index: 66, type: [0], cus: [] },
                { index: 67, type: [0], cus: [] },
                { index: 68, type: [0], cus: [] },
                { index: 69, type: [0], cus: [] },
                { index: 70, type: [0], cus: [] },
                { index: 71, type: [0], cus: [] },
            ],
            recycles: [46, 47, 48, 49, 50, 51, 52]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: 1,
            elements: [
                {
                    type: 9,
                    count: 31
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                2, 0, 2, 2, 1, 0, 3, 3, 3,
                2, 0, 0, 0, 0, 0, 3, 3, 3,
                0, 0, 0, 0, 0, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
            ],
            elements: [
                1, 0, 2, 2, 2, 0, 2, 0, 2,
                1, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 0, 2, 0,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
            ],
            baseElements: [
                11, 0, 2, 2, 2, 0, 2, 0, 2,
                23, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 0, 2, 0,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 2, type: [0], cus: [33] },
                { index: 3, type: [0], cus: [21] },
                { index: 4, type: [0], cus: [] },
            ],
            connectedLats: [[2, 29], [3, 30], [4, 31], [74, 6], [75, 7], [76, 8]]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.RABBIT,
                    count: 42
                },
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 42
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                4, 4, 1, 1, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                4, 4, 0, 4, 4, 4, 4, 4, 4,
                4, 4, 0, 4, 4, 4, 4, 4, 4,
                4, 4, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
            ],
            baseElements: [
                12, 13, 20, 10, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 30, 20, 30, 20, 30, 20,
                33, 32, 0, 10, 20, 10, 20, 10, 20,
                32, 41, 0, 20, 10, 20, 10, 20, 10,
                42, 23, 0, 10, 20, 10, 20, 10, 20,
                0, 0, 0, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 30, 20, 30, 20, 30, 20,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 36, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 21, type: [0], cus: [] },
                { index: 22, type: [0], cus: [] },
                { index: 23, type: [0], cus: [] },
                { index: 24, type: [0], cus: [] },
                { index: 25, type: [0], cus: [] },
                { index: 26, type: [0], cus: [] },
                { index: 30, type: [0], cus: [] },
                { index: 31, type: [0], cus: [] },
                { index: 32, type: [0], cus: [] },
                { index: 33, type: [0], cus: [] },
                { index: 34, type: [0], cus: [] },
                { index: 35, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 40, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 43, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },
                { index: 48, type: [0], cus: [] },
                { index: 49, type: [0], cus: [] },
                { index: 50, type: [0], cus: [] },
                { index: 51, type: [0], cus: [] },
                { index: 52, type: [0], cus: [] },
                { index: 53, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: 5,
                    count: 8
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            elements: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 1, 1, 4, 1, 1, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 4, 1, 4, 1, 4, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 4, 1, 4, 1, 4, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 14, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 31, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 4, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 48
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 0, 1, 1, 0, 0,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                1, 1, 3, 3, 1, 3, 3, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
            ],
            elements: [
                0, 0, 2, 2, 0, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 1, 0, 0, 1, 0, 0, 1, 2,
                1, 2, 1, 0, 1, 0, 1, 2, 1,
            ],
            baseElements: [
                0, 0, 2, 2, 0, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 0, 0, 0, 2, 3, 0, 0, 2,
                2, 32, 0, 0, 22, 0, 0, 32, 2,
                32, 2, 32, 0, 23, 0, 32, 2, 32,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
                { index: 45, type: [0], cus: [] },
                { index: 53, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 25
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 4, 4, 4, 4, 4, 4, 4, 0,
                0, 0, 0, 0, 4, 0, 0, 0, 0,
                0, 0, 0, 0, 4, 0, 0, 0, 0,
                0, 0, 0, 0, 4, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 2, 2, 0, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 0, 0, 0, 2, 3, 0, 0, 2,
                2, 32, 0, 0, 22, 0, 0, 32, 2,
                32, 2, 32, 0, 23, 0, 32, 2, 32,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 24,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 21
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 3, 3, 3, 1, 2, 2, 2, 1,
                1, 1, 1, 3, 1, 2, 1, 2, 1,
                1, 3, 3, 3, 1, 2, 2, 2, 1,
                1, 3, 1, 1, 1, 1, 1, 2, 1,
                1, 3, 3, 3, 1, 1, 1, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 4, 4, 4, 1,
                1, 1, 1, 1, 1, 4, 1, 4, 1,
                1, 1, 1, 1, 1, 4, 4, 4, 1,
                1, 1, 1, 1, 1, 1, 1, 4, 1,
                1, 1, 1, 1, 1, 1, 1, 4, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 42, 0, 32, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 23, 0, 12, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
                { index: 9, type: [0], cus: [] },
                { index: 17, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: 6,
                    count: 7
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 0, 1, 0, 1, 0, 0, 0, 0,
                0, 1, 0, 1, 0, 1, 0, 0, 0,
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                3, 0, 3, 0, 3, 0, 0, 0, 0,
                0, 1, 0, 1, 0, 1, 0, 0, 0,
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 27, type: [0], cus: [] },
            ],
            recycles: [72, 73, 74, 75, 76, 77, 78, 79]
        },
    },
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 24
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                1, 0, 1, 1, 1, 1, 1, 0, 1,
                1, 0, 1, 1, 1, 1, 1, 0, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
            ],
            elements: [
                4, 4, 4, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 0, 4, 4, 4, 4, 4, 0, 0,
                0, 0, 4, 4, 1, 4, 4, 0, 0,
                0, 2, 2, 2, 4, 2, 2, 2, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
            ],
            baseElements: [
                30, 20, 30, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 0, 50, 50, 40, 50, 50, 0, 0,
                0, 0, 40, 40, 50, 40, 40, 0, 0,
                0, 2, 2, 2, 50, 2, 2, 2, 1,
                1, 1, 2, 2, 40, 2, 2, 1, 1,
                1, 1, 2, 2, 44, 2, 2, 1, 1,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 24,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 66
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                2, 2, 0, 2, 2, 2, 2, 2, 2,
                2, 2, 0, 2, 2, 2, 2, 2, 2,
                2, 2, 0, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
            ],
            elements: [
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                4, 4, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 0, 1, 0, 1, 0, 1, 0,
            ],
            baseElements: [
                0, 0, 0, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 30, 20, 30, 20, 30, 20,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                50, 50, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                53, 42, 0, 32, 0, 32, 0, 32, 0,
            ],
            generateLats: [
                { index: 36, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 24,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: 6,
                    count: 6
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 1, 1, 1, 0,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 1, 1, 1, 1
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 1, 1, 1,
                0, 0, 0, 0, 4, 4, 4, 4, 4,
                0, 0, 0, 0, 4, 4, 4, 4, 4,
                3, 3, 3, 0, 4, 4, 4, 4, 4,
                4, 4, 4, 0, 1, 4, 4, 4, 4,
                4, 4, 4, 0, 1, 4, 4, 4, 4
            ],
            baseElements: [
                0, 0, 0, 0, 0, 1, 1, 1, 0,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 20, 30, 50, 50, 20,
                0, 0, 0, 0, 30, 20, 30, 20, 30,
                3, 3, 3, 0, 20, 30, 20, 30, 20,
                21, 31, 42, 0, 52, 20, 30, 20, 30,
                20, 31, 41, 0, 51, 30, 20, 30, 20
            ],
            generateLats: [
                { index: 54, type: [0], cus: [] },
                { index: 55, type: [0], cus: [] },
                { index: 56, type: [0], cus: [] },
                { index: 63, type: [0], cus: [] },
                { index: 64, type: [0], cus: [] },
                { index: 65, type: [0], cus: [] },
                { index: 72, type: [0], cus: [] },
                { index: 73, type: [0], cus: [] },
                { index: 74, type: [0], cus: [] },
            ],
            recycles: [80, 76, 77, 78, 79],
            connectedLats: [[72, 5], [73, 6], [74, 7]]
        },
    },
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 32,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 64
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                3, 3, 0, 0, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 0, 0, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 0, 0, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 0, 0, 3, 3, 3, 3, 1,
            ],
            elements: [
                2, 2, 0, 0, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 0, 0, 2, 2, 2, 2, 4,
                1, 1, 4, 1, 2, 2, 2, 2, 4,
                4, 1, 0, 0, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 0, 0, 2, 2, 2, 2, 4,
            ],
            baseElements: [
                2, 2, 0, 0, 2, 2, 2, 2, 0,
                2, 2, 51, 52, 2, 2, 2, 2, 0,
                2, 2, 51, 52, 2, 2, 2, 2, 0,
                2, 2, 0, 0, 2, 2, 2, 2, 0,
                40, 30, 41, 23, 2, 2, 2, 2, 0,
                4, 40, 0, 0, 2, 2, 2, 2, 0,
                2, 2, 52, 51, 2, 2, 2, 2, 0,
                2, 2, 52, 51, 2, 2, 2, 2, 0,
                2, 2, 0, 0, 2, 2, 2, 2, 0,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 38, type: [0], cus: [] },
                { index: 46, type: [0], cus: [] },
                { index: 47, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 27,
        passTarget: {
            type: 1,
            elements: [{ type: 9, count: 70 }]
        },
        starScores: [6000, 12000, 25000],
        map: {
            lattices: [
                2, 2, 2, 2, 3, 3, 3, 3, 3,
                2, 2, 2, 2, 3, 3, 3, 3, 3,
                2, 3, 2, 2, 3, 3, 3, 3, 3,
                2, 2, 2, 2, 3, 3, 3, 3, 3,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                1, 2, 2, 2, 2, 2, 2, 2, 1
            ],
            connectedLats: [[31, 49], [32, 50], [33, 51], [34, 52], [35, 53]],
            elements: [
                1, 1, 1, 1, 4, 4, 4, 4, 4,
                1, 1, 1, 1, 2, 4, 2, 4, 2,
                1, 1, 1, 1, 4, 2, 4, 2, 4,
                1, 1, 1, 1, 2, 4, 2, 4, 2,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 0, 0, 0, 0, 0
            ],
            baseElements: [
                20, 11, 30, 30, 22, 52, 51, 41, 12,
                20, 11, 30, 30, 0, 10, 0, 20, 0,
                11, 40, 0, 0, 30, 0, 30, 0, 30,
                40, 11, 0, 0, 0, 10, 0, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 56, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
                { index: 45, type: [0], cus: [] },
                { index: 46, type: [0], cus: [] },
                { index: 47, type: [0], cus: [] },
                { index: 48, type: [0], cus: [] },
            ],
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: 1,
            elements: [{ type: 6, count: 16 }],
        },
        starScores: [6000, 12000, 25000],
        map: {
            lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0],
            connectedLats: [[29, 47], [33, 51], [39, 46], [41, 52], [28, 57], [34, 59]],
            elements: [
                1, 4, 2, 3, 3, 3, 2, 4, 4,
                1, 4, 2, 3, 3, 3, 2, 4, 2,
                1, 4, 2, 3, 1, 3, 2, 4, 4,
                1, 4, 2, 1, 3, 1, 2, 4, 2,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            baseElements: [20, 0, 30, 30, 22, 52, 51, 0, 12, 20, 0, 30, 30, 0, 10, 0, 0, 0, 11, 0, 0, 0, 10, 0, 30, 0, 30, 40, 0, 0, 10, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            recycles: [73, 74, 75, 76, 77, 78, 79],
            generateLats: [
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null }
            ]
        }
    },
    {
        baseElementTypes: [2, 1, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: 1,
            elements: [{ type: 6, count: 22 }],
        },
        starScores: [6000, 12000, 25000],
        map: {
            lattices: [
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1
            ],
            connectedLats: [[80, 3], [79, 2], [78, 1], [77, 0]],
            elements: [
                3, 3, 3, 3, 0, 0, 0, 0, 0,
                3, 3, 3, 3, 0, 0, 2, 2, 0,
                4, 4, 4, 4, 0, 0, 2, 2, 1,
                4, 4, 4, 4, 0, 0, 2, 2, 1,
                3, 3, 3, 3, 0, 2, 2, 2, 2,
                3, 3, 3, 3, 0, 2, 2, 2, 4,
                4, 4, 4, 4, 0, 2, 2, 2, 4,
                4, 4, 4, 4, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 0, 2, 2, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                30, 20, 30, 20, 0, 0, 0, 0, 11,
                20, 30, 20, 30, 0, 0, 0, 0, 12,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 41,
                10, 40, 40, 10, 0, 0, 0, 0, 43,
                30, 50, 50, 30, 0, 0, 0, 0, 41,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [63, 64, 65, 66],
            generateLats: [{ index: 15, type: 0 }, { index: 16, type: 0 }]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: 1,
            elements: [{ type: 5, count: 12 }]
        },
        starScores: [6000, 12000, 24000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1
            ],
            connectedLats: [[32, 50], [33, 51], [34, 52], [35, 53]],
            elements: [
                0, 0, 0, 2, 2, 4, 4, 4, 4,
                0, 0, 0, 0, 2, 4, 4, 4, 4,
                0, 0, 0, 0, 2, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                4, 4, 4, 4, 0, 1, 1, 1, 1,
                2, 2, 2, 2, 0, 1, 1, 1, 1,
                4, 4, 4, 4, 0, 1, 1, 1, 1,
                2, 2, 2, 2, 0, 1, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 30, 50, 20, 30,
                0, 0, 0, 0, 0, 30, 20, 30, 20,
                0, 0, 0, 0, 0, 20, 50, 20, 50,
                0, 0, 0, 0, 0, 12, 30, 12, 30,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                20, 20, 50, 50, 0, 10, 50, 10, 50,
                0, 0, 0, 0, 0, 20, 30, 30, 10,
                10, 10, 20, 20, 0, 10, 20, 20, 10,
                0, 0, 0, 0, 0, 30, 20, 30, 30
            ],
            recycles: [],
            generateLats: [
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [3, 2, 1, 0, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: 1,
            elements: [{ type: 9, count: 56 }]
        },
        starScores: [6000, 14000, 25000],
        map: {
            lattices: [2, 0, 2, 0, 2, 2, 0, 2, 0, 0, 3, 3, 3, 3, 0, 0, 0, 0, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 0, 2],
            connectedLats: [],
            elements: [
                1, 0, 2, 0, 2, 1, 0, 1, 0,
                0, 2, 0, 2, 0, 0, 0, 0, 0,
                0, 0, 2, 0, 2, 4, 4, 4, 4,
                0, 2, 0, 2, 0, 4, 4, 4, 1,
                0, 0, 2, 0, 2, 4, 4, 4, 1,
                0, 2, 0, 2, 0, 4, 4, 4, 1,
                0, 0, 2, 0, 2, 4, 4, 4, 1,
                0, 2, 0, 2, 0, 0, 0, 0, 0,
                1, 0, 0, 0, 0, 0, 1, 0, 1
            ],
            baseElements: [
                41, 0, 0, 0, 0, 42, 0, 42, 0,
                0, 0, 40, 0, 40, 0, 0, 0, 0,
                0, 40, 0, 40, 0, 10, 10, 20, 20, 0, 0, 40, 0, 40, 50, 30, 30, 42, 0, 41, 0, 40, 0, 20, 20, 30, 10, 0, 0, 40, 0, 0, 30, 50, 50, 40, 0, 40, 0, 40, 0, 30, 50, 50, 40, 0, 0, 40, 0, 40, 0, 0, 0, 0, 42, 0, 0, 0, 0, 0, 42, 0, 41
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 2, type: 0, cus: [14] },
                { index: 4, type: 0, cus: [14] },
                { index: 5, type: 0 },
                { index: 7, type: 0 },
                { index: 26, type: 0 },
                { index: 25, type: 0 },
                { index: 24, type: 0 },
                { index: 72, type: 0 },
                { index: 78, type: 0 },
                { index: 80, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: 1,
            elements: [{ type: 9, count: 54 }]
        },
        starScores: [6000, 15000, 23000],
        map: {
            lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 3, 3, 0, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0],
            connectedLats: [],
            elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 2, 0, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 4, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 2, 4, 4, 4, 4, 0, 4, 4, 4, 4, 4, 4, 4, 0],
            baseElements: [11, 22, 12, 22, 12, 22, 12, 22, 11, 12, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 10, 10, 40, 0, 0, 0, 0, 0, 40, 10, 20, 40, 50, 0, 0, 0, 50, 40, 20, 20, 30, 50, 10, 0, 10, 50, 30, 20, 0, 30, 30, 10, 20, 10, 30, 30, 0],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 1, type: 0 },
                { index: 2, type: 0 },
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 },
                { index: 20, type: 0, cus: [14, 14, 14, 14] },
                { index: 21, type: 0, cus: [14, 14, 14, 14, 14] },
                { index: 23, type: 0, cus: [14, 14, 14, 14, 14] },
                { index: 24, type: 0, cus: [14, 14, 14, 14] },
                { index: 28, type: 0, cus: [14, 14] },
                { index: 31, type: 0, cus: [14, 14, 14, 14, 14] },
                { index: 34, type: 0, cus: [14, 14] },
                { index: 36, type: 0 },
                { index: 44, type: 0 }
            ]
        }
    },
];


/***/ }),

/***/ "./src/something/chapters/Chapter3.ts":
/*!********************************************!*\
  !*** ./src/something/chapters/Chapter3.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Chapters3 = void 0;
var PassType_1 = __webpack_require__(/*! ../enum/PassType */ "./src/something/enum/PassType.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
exports.Chapters3 = [
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 20,
        passTarget: { type: 1, elements: [{ type: 9, count: 27 }] },
        starScores: [5000, 12000, 25000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 2, 2, 2, 2, 2, 1, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 2, 2, 5, 2, 2, 0, 0,
                0, 0, 5, 1, 1, 1, 5, 0, 0,
                0, 2, 2, 2, 5, 2, 2, 2, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 10, 0, 0, 0, 0,
                0, 0, 0, 40, 20, 40, 0, 0, 0,
                0, 0, 20, 20, 30, 40, 20, 0, 0,
                0, 20, 40, 30, 20, 30, 30, 10, 0,
                0, 0, 10, 20, 10, 20, 30, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 40, 40, 20, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 13, type: 0 },
                { index: 21, type: 0 },
                { index: 23, type: 0 },
                { index: 29, type: 0 },
                { index: 33, type: 0 },
                { index: 37, type: 0 },
                { index: 43, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 4, 3],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 57 }] },
        starScores: [6000, 15000, 21000],
        map: {
            lattices: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0
            ],
            connectedLats: [],
            elements: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 5, 5, 5, 2, 0, 0,
                0, 2, 5, 2, 2, 2, 5, 2, 0,
                2, 5, 2, 1, 1, 1, 2, 5, 2,
                2, 5, 2, 1, 1, 1, 2, 5, 2,
                2, 5, 2, 1, 1, 1, 2, 5, 2,
                0, 2, 5, 2, 2, 2, 5, 2, 0,
                0, 0, 2, 5, 5, 5, 2, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0
            ],
            baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 10, 20, 0, 0, 0, 0, 0, 0, 20, 30, 10, 0, 0, 0, 0, 0, 0, 20, 20, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            recycles: [],
            generateLats: [
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 11, type: 0 },
                { index: 12, type: 0 },
                { index: 13, type: 0 },
                { index: 14, type: 0 },
                { index: 15, type: 0 },
                { index: 19, type: 0 },
                { index: 20, type: 0 },
                { index: 21, type: 0 },
                { index: 22, type: 0 },
                { index: 23, type: 0 },
                { index: 24, type: 0 },
                { index: 25, type: 0 },
                { index: 27, type: 0 },
                { index: 28, type: 0 },
                { index: 29, type: 0 },
                { index: 33, type: 0 },
                { index: 34, type: 0 },
                { index: 35, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 22, passTarget: { type: 1, elements: [{ type: 9, count: 41 }] }, starScores: [5000, 15000, 22000], map: { lattices: [0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0], connectedLats: [], elements: [0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 4, 1, 1, 0, 0, 0, 1, 1, 4, 5, 4, 1, 1, 0, 1, 1, 4, 5, 5, 5, 4, 1, 1, 0, 1, 1, 4, 5, 4, 1, 1, 0, 0, 0, 1, 1, 4, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 4, type: 0 }, { index: 12, type: 0 }, { index: 14, type: 0 }, { index: 20, type: 0 }, { index: 24, type: 0 }, { index: 28, type: 0 }, { index: 34, type: 0 }, { index: 36, type: 0 }, { index: 44, type: 0 }] }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: { type: 1, elements: [{ type: 9, count: 39 }] },
        starScores: [8000, 15000, 31000],
        map: {
            lattices: [
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                3, 3, 3, 0, 0, 0, 3, 3, 3,
                3, 3, 3, 0, 1, 0, 3, 3, 3,
                3, 3, 3, 0, 1, 0, 3, 3, 3,
                3, 3, 3, 0, 1, 0, 3, 3, 3,
                3, 3, 3, 0, 1, 0, 3, 2, 3,
                1, 1, 1, 0, 0, 0, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                5, 5, 5, 4, 4, 4, 5, 5, 5,
                5, 5, 5, 4, 4, 4, 5, 5, 5,
                5, 5, 5, 4, 4, 4, 5, 5, 5,
                4, 4, 4, 0, 0, 0, 4, 4, 4,
                4, 4, 4, 0, 1, 0, 4, 4, 4,
                4, 4, 4, 0, 1, 0, 4, 4, 4,
                4, 4, 4, 0, 1, 0, 4, 4, 4,
                4, 4, 4, 0, 1, 0, 4, 4, 4,
                4, 4, 4, 0, 0, 0, 4, 4, 4
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 13, 0, 0, 0, 0,
                0, 0, 0, 0, 12, 0, 0, 0, 0,
                0, 0, 0, 0, 23, 0, 0, 0, 0,
                0, 0, 0, 0, 22, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 1, type: 0 },
                { index: 2, type: 0 },
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 },
                { index: 40, type: [13, 12, 11, 23, 22, 21] }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 26,
        passTarget: { type: 1, elements: [{ type: 5, count: 39 }] },
        starScores: [6000, 14000, 24000],
        map: {
            lattices: [1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
            connectedLats: [],
            elements: [4, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 0, 0, 4, 0, 0, 0, 4, 0, 0, 0, 4, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 2],
            baseElements: [
                40, 0, 0, 0, 0, 0, 0, 0, 40,
                0, 40, 0, 0, 0, 0, 0, 40, 0,
                0, 0, 40, 0, 0, 0, 40, 0, 0,
                0, 0, 0, 40, 0, 40, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                43, 0, 0, 0, 0, 0, 0, 0, 43,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                43, 0, 0, 0, 40, 0, 0, 0, 43,
                0, 0, 0, 0, 24, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 8, type: 0 },
                { index: 36, type: 0 },
                { index: 37, type: 0 },
                { index: 38, type: 0 },
                { index: 39, type: 0 },
                { index: 40, type: 0 },
                { index: 41, type: 0 },
                { index: 42, type: 0 },
                { index: 43, type: 0 },
                { index: 44, type: 0 },
                { index: 48, type: 0 },
                { index: 49, type: 0 },
                { index: 50, type: 0 },
                { index: 57, type: 0 },
                { index: 58, type: 0, cus: [40, 44] },
                { index: 59, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 32, passTarget: { type: 1, elements: [{ type: 9, count: 50 }] }, starScores: [6000, 14000, 25000], map: { lattices: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1], connectedLats: [], elements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 2, 0, 0, 0, 0, 0, 1, 2, 1, 2, 2, 0, 0, 0, 1, 1, 2, 2, 2, 2, 1, 0, 0, 1, 1, 2, 2, 2, 2, 1, 0, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 4, 4, 4, 4, 4, 2, 1, 2, 2, 4, 4, 4, 4, 4, 2, 2, 2, 2, 4, 4, 4, 4, 4, 2, 2], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 12, type: 0 }, { index: 13, type: 0 }, { index: 14, type: 0 }, { index: 20, type: 0 }, { index: 24, type: 0 }, { index: 28, type: 0 }, { index: 34, type: 0 }, { index: 45, type: 0 }, { index: 53, type: 0 }] }
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 6, count: 23 }] },
        starScores: [6000, 12000, 18000],
        map: {
            lattices: [0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            connectedLats: [[63, 14], [64, 15], [65, 16], [66, 17]],
            elements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 3, 3, 5, 0, 1, 1, 1, 1, 5, 5, 5, 5, 0, 1, 1, 1, 1, 5, 5, 5, 5, 0, 1, 1, 1, 1, 3, 3, 3, 3, 0, 1, 1, 1, 1, 3, 3, 3, 3, 0, 1, 1, 1, 1, 3, 3, 3, 3, 0, 1, 1, 1, 1, 5, 5, 5, 5, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            baseElements: [
                0, 0, 0, 0, 0, 10, 40, 40, 30,
                0, 0, 0, 0, 0, 20, 20, 40, 40,
                0, 0, 0, 0, 0, 10, 10, 30, 30,
                0, 0, 0, 0, 0, 20, 20, 40, 40,
                0, 0, 0, 0, 0, 30, 30, 10, 10,
                0, 0, 0, 0, 0, 40, 40, 20, 20,
                0, 0, 0, 0, 0, 20, 30, 40, 30,
                0, 0, 0, 0, 0, 11, 12, 21, 22,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [68, 69, 70, 71],
            generateLats: [
                { index: 9, type: 0 },
                { index: 10, type: 0 },
                { index: 11, type: 0 },
                { index: 12, type: 0 },
                { index: 27, type: 0 },
                { index: 28, type: 0 },
                { index: 29, type: 0 },
                { index: 30, type: 0 },
                { index: 36, type: 0 },
                { index: 37, type: 0 },
                { index: 38, type: 0 },
                { index: 39, type: 0 },
                { index: 45, type: 0 },
                { index: 46, type: 0 },
                { index: 47, type: 0 },
                { index: 48, type: 0 },
                { index: 54, type: 0 },
                { index: 55, type: 0 },
                { index: 56, type: 0 },
                { index: 57, type: 0 },
                { index: 63, type: 0 },
                { index: 64, type: 0 },
                { index: 65, type: 0 },
                { index: 66, type: 0 },
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 33,
        passTarget: { type: 1, elements: [{ type: 5, count: 34 }, { type: 9, count: 7 }] }, starScores: [5000, 12000, 24000], map: {
            lattices: [1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 2, 2, 1, 1, 0, 0, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 2], connectedLats: [],
            elements: [1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 2, 2, 2, 2, 2, 0, 0, 1, 1, 2, 5, 5, 2, 2, 0, 0, 1, 1, 2, 5, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 5, 5, 2, 2, 1, 1, 2, 2, 2, 5, 2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 2, 5], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: 0 }, { index: 1, type: 0 }, { index: 2, type: 0 }, { index: 3, type: 0 }, { index: 4, type: 0 }, { index: 5, type: 0 }, { index: 6, type: 0 }, { index: 43, type: 0 }, { index: 44, type: 0 }]
        }
    },
    {
        baseElementTypes: [1, 2, 0, 4], bubbleProbability: 0, stepCount: 28, passTarget: { type: 1, elements: [{ type: 5, count: 16 }] }, starScores: [6000, 12000, 20000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                1, 1, 1, 1, 0, 4, 4, 4, 4,
                0, 0, 0, 0, 0, 5, 5, 5, 5,
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 0, 0, 0, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                12, 31, 12, 31, 0, 12, 30, 30, 12,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                30, 10, 30, 10, 0, 0, 0, 0, 0,
                10, 30, 10, 30, 0, 0, 0, 0, 0,
                30, 10, 30, 10, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 },
                { index: 14, type: 0 },
                { index: 15, type: 0 },
                { index: 16, type: 0 },
                { index: 17, type: 0 },
                { index: 23, type: 0 },
                { index: 24, type: 0 },
                { index: 25, type: 0 },
                { index: 26, type: 0 },
                { index: 32, type: 0 },
                { index: 33, type: 0 },
                { index: 34, type: 0 },
                { index: 35, type: 0 },
                { index: 41, type: 0 },
                { index: 42, type: 0 },
                { index: 43, type: 0 },
                { index: 44, type: 0 },
                { index: 36, type: 0 },
                { index: 37, type: 0 },
                { index: 38, type: 0 },
                { index: 39, type: 0 },
                { index: 54, type: 0 },
                { index: 55, type: 0 },
                { index: 56, type: 0 },
                { index: 57, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: { type: 1, elements: [{ type: 9, count: 28 }] },
        starScores: [5000, 14000, 23000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                2, 2, 0, 1, 1, 1, 0, 2, 2,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                2, 2, 1, 0, 0, 0, 1, 2, 2,
                2, 2, 1, 0, 1, 0, 1, 2, 2
            ],
            connectedLats: [[11, 29], [15, 33]],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
                4, 4, 0, 2, 2, 2, 0, 4, 4,
                2, 5, 4, 2, 2, 2, 4, 5, 2,
                5, 2, 4, 1, 1, 1, 4, 2, 5,
                2, 5, 4, 1, 1, 1, 4, 5, 2,
                5, 2, 4, 1, 1, 1, 4, 2, 5,
                2, 5, 4, 0, 0, 0, 4, 5, 2,
                4, 4, 1, 0, 1, 0, 1, 4, 4
            ],
            baseElements: [
                0, 30, 50, 30, 40, 30, 50, 30, 0,
                0, 0, 0, 0, 33, 0, 0, 0, 0,
                20, 30, 0, 0, 0, 0, 0, 30, 20,
                0, 0, 20, 0, 0, 0, 20, 0, 0,
                0, 0, 20, 30, 42, 30, 20, 0, 0,
                0, 0, 30, 40, 50, 40, 30, 0, 0,
                0, 0, 20, 30, 40, 30, 20, 0, 0,
                0, 0, 20, 0, 0, 0, 20, 0, 0,
                20, 30, 30, 0, 21, 0, 30, 30, 20
            ],
            recycles: [],
            generateLats: [
                { index: 1, type: 0 },
                { index: 2, type: 0 },
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 18, type: 0 },
                { index: 19, type: 0 },
                { index: 25, type: 0 },
                { index: 26, type: 0 },
                { index: 39, type: 0 },
                { index: 40, type: 0 },
                { index: 41, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 38,
        passTarget: { type: 1, elements: [{ type: 9, count: 14 }] },
        starScores: [8000, 12000, 24000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                2, 1, 3, 3, 3, 3, 3, 1, 2,
                1, 1, 3, 3, 3, 3, 3, 1, 1,
                2, 1, 1, 1, 1, 1, 1, 1, 2
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                0, 2, 5, 5, 5, 5, 5, 2, 0,
                0, 5, 0, 0, 0, 0, 0, 5, 0,
                5, 5, 0, 0, 0, 0, 0, 5, 5,
                0, 5, 5, 5, 5, 5, 5, 5, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            ], recycles: [], generateLats: [{ index: 0, type: 0 }, { index: 1, type: 0 }, { index: 2, type: 0 }, { index: 3, type: 0 }, { index: 4, type: 0 }, { index: 5, type: 0 }, { index: 6, type: 0 }, { index: 7, type: 0 }, { index: 8, type: 0 }]
        }
    },
    { baseElementTypes: [0, 1, 2, 4, 3], bubbleProbability: 0, stepCount: 43, passTarget: { type: 1, elements: [{ type: 6, count: 4 }] }, starScores: [6000, 12000, 21000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [], elements: [1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 5, 1, 1, 1, 5, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: 0 }, { index: 1, type: 0 }, { index: 2, type: 0 }, { index: 3, type: 0 }, { index: 4, type: 0 }, { index: 5, type: 0 }, { index: 6, type: 0 }, { index: 7, type: 0 }, { index: 8, type: 0 }] } },
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 30, passTarget: { type: 1, elements: [{ type: 9, count: 34 }] }, starScores: [6000, 14000, 24000], map: { lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1], connectedLats: [], elements: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 4, 2, 1, 1, 1, 1, 1, 2, 4, 2, 4, 2, 1, 1, 1, 2, 4, 2, 0, 2, 4, 2, 1, 2, 4, 2, 0, 0, 0, 2, 4, 2, 4, 2, 0, 0, 0, 0, 0, 2, 4, 2, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: 0 }, { index: 3, type: 0 }, { index: 4, type: 0 }, { index: 5, type: 0 }, { index: 6, type: 0 }, { index: 10, type: 0 }, { index: 16, type: 0 }, { index: 18, type: 0 }, { index: 26, type: 0 }] }
    },
    {
        baseElementTypes: [1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 26,
        passTarget: { type: 1, elements: [{ type: 9, count: 28 }] },
        starScores: [5000, 12000, 20000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 0, 1, 1, 1, 1, 1, 0, 1,
                1, 0, 1, 0, 1, 0, 1, 0, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                1, 0, 3, 3, 3, 3, 3, 0, 1,
                1, 0, 3, 3, 3, 3, 3, 0, 1,
                0, 0, 1, 0, 0, 0, 1, 0, 0,
                0, 0, 1, 0, 0, 0, 1, 0, 0
            ],
            connectedLats: [[14, 32], [12, 30], [57, 9], [59, 17]],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 11, type: 0 }, { index: 12, type: 0 }, { index: 13, type: 0 }, { index: 14, type: 0 }, { index: 15, type: 0 }]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 28, passTarget: { type: 1, elements: [{ type: 9, count: 15 }] }, starScores: [6000, 14000, 25000], map: {
            lattices: [1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 2, 2, 2, 1, 1, 1, 0, 0, 0, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 0, 0, 0, 1, 1, 1, 2, 2, 2, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1],
            connectedLats: [[18, 36], [19, 37], [11, 38], [63, 16], [64, 17], [56, 24], [42, 69], [43, 61], [44, 62]], elements: [1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 2, 2, 2, 1, 1, 1, 0, 0, 0, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 0, 0, 0, 1, 1, 1, 2, 2, 2, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 1, type: 0 },
                { index: 2, type: 0 },
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
            ]
        }
    },
    { baseElementTypes: [0, 1, 3, 2, 4], bubbleProbability: 0, stepCount: 32, passTarget: { type: 1, elements: [{ type: 9, count: 39 }] }, starScores: [6000, 14000, 25000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 4, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 5, 5, 5, 2, 2, 1, 2, 4, 2, 5, 4, 5, 2, 4, 2, 1, 2, 2, 5, 5, 5, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 4, 2, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] } },
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0.8,
        stepCount: 27,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 15
                },
            ]
        },
        starScores: [4000, 8000, 18000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                1, 0, 0, 0, 0, 0, 0, 0, 1,
                1, 1, 2, 2, 2, 2, 2, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
            ],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                7, 0, 0, 0, 0, 0, 0, 0, 7,
                7, 7, 2, 2, 2, 2, 2, 7, 7,
                7, 7, 7, 7, 2, 7, 7, 7, 7,
                7, 7, 7, 7, 2, 7, 7, 7, 7,
                7, 7, 7, 7, 2, 7, 7, 7, 7,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
                { index: 27, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 35, type: [0], cus: [] },
                { index: 43, type: [0], cus: [] },
            ],
            connectedLats: [[20, 38], [21, 39], [22, 40], [23, 41], [24, 42]],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 6, count: 4 }] },
        starScores: [5000, 8000, 15000],
        map: {
            lattices: [
                1, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 0, 0, 0, 0, 0, 1,
                1, 1, 1, 1, 0, 0, 0, 1, 1,
                1, 1, 1, 1, 1, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 0, 1, 1, 1
            ],
            connectedLats: [[79, 10], [80, 20], [78, 0]],
            elements: [
                3, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 0, 0, 0, 0, 0, 3,
                1, 1, 1, 1, 0, 0, 0, 1, 1,
                1, 1, 1, 1, 1, 0, 1, 1, 1,
                1, 1, 1, 1, 2, 0, 2, 1, 1,
                1, 1, 1, 1, 2, 0, 2, 1, 1,
                1, 1, 1, 1, 2, 0, 2, 2, 2,
                1, 2, 2, 2, 2, 0, 2, 2, 2
            ],
            baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            recycles: [72, 73, 74, 75, 76],
            generateLats: [
                { index: 26, type: null },
                { index: 30, type: null },
                { index: 34, type: null },
                { index: 40, type: null },
                { index: 42, type: null }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 4, 3],
        bubbleProbability: 0.1,
        stepCount: 31,
        passTarget: { type: 1, elements: [{ type: 9, count: 30 }] },
        starScores: [5000, 12000, 18000],
        map: {
            lattices: [
                3, 3, 1, 1, 1, 1, 3, 3, 0,
                3, 3, 1, 1, 1, 1, 3, 3, 0,
                3, 3, 1, 1, 1, 1, 3, 3, 0,
                3, 3, 1, 1, 1, 1, 3, 3, 0,
                3, 3, 3, 1, 1, 3, 3, 3, 0,
                3, 1, 1, 1, 1, 1, 1, 3, 0,
                1, 3, 1, 3, 3, 1, 3, 1, 0,
                0, 1, 3, 1, 1, 3, 1, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            connectedLats: [],
            elements: [
                2, 2, 1, 1, 1, 1, 2, 2, 0,
                2, 2, 1, 1, 1, 1, 2, 2, 0,
                2, 2, 1, 1, 1, 1, 2, 2, 0,
                2, 2, 2, 1, 1, 2, 2, 2, 0,
                2, 1, 1, 1, 1, 1, 1, 2, 0,
                2, 2, 1, 2, 2, 1, 2, 2, 0,
                1, 2, 2, 1, 1, 2, 2, 1, 0,
                0, 1, 2, 2, 2, 2, 1, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 12, 13, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0.1,
        stepCount: 33,
        passTarget: { type: 1, elements: [{ type: 9, count: 27 }] },
        starScores: [5000, 12000, 18000],
        map: {
            lattices: [
                3, 3, 1, 1, 1, 1, 3, 3, 0,
                3, 3, 1, 1, 1, 1, 3, 3, 0,
                3, 3, 1, 1, 1, 1, 3, 3, 0,
                0, 3, 1, 1, 2, 1, 3, 0, 0,
                0, 3, 3, 1, 1, 3, 3, 0, 0,
                3, 1, 1, 1, 1, 1, 1, 3, 0,
                1, 3, 1, 3, 3, 1, 3, 1, 0,
                1, 1, 3, 1, 1, 3, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            connectedLats: [],
            elements: [
                1, 2, 2, 2, 2, 2, 2, 4, 0,
                2, 1, 2, 2, 2, 2, 4, 2, 0,
                2, 2, 1, 2, 2, 4, 2, 2, 0,
                0, 2, 2, 1, 4, 2, 2, 0, 0,
                0, 2, 2, 4, 1, 2, 2, 0, 0,
                4, 2, 7, 2, 2, 1, 2, 1, 0,
                2, 1, 2, 2, 2, 2, 1, 2, 0,
                4, 2, 4, 2, 2, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            baseElements: [
                20, 0, 0, 0, 0, 0, 0, 40, 0,
                0, 20, 0, 0, 0, 0, 40, 0, 0,
                0, 0, 14, 0, 0, 40, 0, 0, 0,
                0, 0, 0, 20, 40, 0, 0, 0, 0,
                0, 0, 0, 40, 22, 0, 0, 0, 0,
                40, 0, 40, 0, 0, 20, 0, 20, 0,
                0, 40, 0, 12, 13, 0, 20, 0, 0,
                40, 0, 40, 0, 0, 20, 14, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
            ]
        }
    },
];


/***/ }),

/***/ "./src/something/chapters/Chapter4.ts":
/*!********************************************!*\
  !*** ./src/something/chapters/Chapter4.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Chapters4 = void 0;
exports.Chapters4 = [
    {
        baseElementTypes: [0, 4, 2, 3],
        bubbleProbability: 0,
        stepCount: 37,
        passTarget: { type: 1, elements: [{ type: 1, count: 30 }] },
        starScores: [8000, 15000, 22000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0
            ],
            connectedLats: [],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 6, 1, 1, 1, 6, 1, 1,
                1, 1, 6, 1, 1, 1, 6, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 10, 50, 30, 0, 0, 0,
                0, 0, 40, 40, 30, 50, 50, 0, 0,
                0, 30, 30, 50, 50, 40, 40, 10, 0,
                50, 40, 0, 10, 20, 30, 0, 10, 20,
                50, 40, 0, 10, 20, 50, 0, 30, 20,
                0, 50, 40, 20, 40, 30, 30, 50, 0,
                0, 0, 20, 10, 40, 10, 10, 0, 0,
                0, 0, 0, 50, 30, 30, 0, 0, 0,
            ],
            recycles: [],
            generateLats: [
                { index: 12, type: null },
                { index: 13, type: null },
                { index: 14, type: null },
                { index: 20, type: null },
                { index: 24, type: null },
                { index: 28, type: null },
                { index: 34, type: null },
                { index: 36, type: null },
                { index: 44, type: null }
            ]
        }
    },
    {
        baseElementTypes: [2, 3, 4, 0],
        bubbleProbability: 0,
        stepCount: 34,
        passTarget: { type: 1, elements: [{ type: 1, count: 50 }, { type: 0, count: 30 }, { type: 2, count: 30 }] },
        starScores: [5000, 12000, 18000],
        map: {
            lattices: [1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1], connectedLats: [], elements: [1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }]
        }
    },
    {
        baseElementTypes: [2, 3, 4, 0],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 1, count: 40 }, { type: 0, count: 30 }, { type: 2, count: 30 }] }, starScores: [5000, 12000, 18000], map: { lattices: [1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1], connectedLats: [[72, 5], [73, 6], [74, 7], [75, 8]], elements: [1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 6, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 6, 1, 1, 1, 1, 0, 1, 1, 1, 1, 2, 2, 2, 2, 0, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 6, count: 2 }] },
        starScores: [5000, 12000, 18000],
        map: { lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0], connectedLats: [], elements: [0, 3, 1, 1, 1, 1, 1, 3, 0, 0, 4, 1, 1, 1, 1, 1, 4, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 4, 1, 1, 1, 1, 1, 4, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }] }
    },
    {
        baseElementTypes: [0, 2, 3, 4], bubbleProbability: 0, stepCount: 37, passTarget: { type: 1, elements: [{ type: 1, count: 36 }] }, starScores: [5000, 12000, 17000], map: { lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0], connectedLats: [], elements: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 6, 1, 1, 1, 6, 1, 1, 1, 1, 6, 1, 1, 1, 6, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0], baseElements: [0, 0, 10, 10, 30, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: [10, 30] }, { index: 3, type: [10, 30] }, { index: 4, type: [10, 30] }, { index: 5, type: [10, 30] }, { index: 6, type: [10, 30] }, { index: 20, type: null }, { index: 21, type: null }, { index: 22, type: null }, { index: 23, type: null }, { index: 24, type: null }] }
    },
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 34,
        passTarget: {
            type: 1, elements: [
                { type: 1, count: 60 },
                { type: 0, count: 50 },
                { type: 2, count: 50 }
            ]
        },
        starScores: [6000, 12000, 24000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                6, 1, 1, 1, 1, 1, 1, 1, 6,
                6, 1, 1, 1, 1, 1, 1, 1, 6,
                6, 1, 1, 1, 1, 1, 1, 1, 6,
                0, 1, 1, 4, 4, 4, 1, 1, 0,
                0, 1, 1, 4, 6, 4, 1, 1, 0,
                6, 1, 1, 4, 4, 4, 1, 1, 6,
                6, 1, 1, 1, 1, 1, 1, 1, 6,
                6, 1, 1, 1, 1, 1, 1, 1, 6
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 3, 2, 4],
        bubbleProbability: 0.2,
        stepCount: 32,
        passTarget: { type: 1, elements: [{ type: 9, count: 28 }] },
        starScores: [6000, 12000, 24000],
        map: {
            lattices: [
                0, 0, 1, 2, 1, 2, 1, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 1, 0, 1, 0, 0, 0
            ],
            connectedLats: [],
            elements: [
                0, 0, 1, 2, 1, 2, 1, 0, 0,
                0, 7, 2, 7, 2, 7, 2, 7, 0,
                4, 2, 4, 2, 4, 2, 4, 2, 4,
                2, 1, 2, 1, 2, 1, 2, 1, 2,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 1, 0, 1, 0, 0, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 10, type: null },
                { index: 11, type: null },
                { index: 12, type: null },
                { index: 13, type: null },
                { index: 14, type: null },
                { index: 15, type: null },
                { index: 16, type: null },
                { index: 18, type: null },
                { index: 19, type: null },
                { index: 20, type: null },
                { index: 21, type: null },
                { index: 22, type: null },
                { index: 23, type: null },
                { index: 24, type: null },
                { index: 25, type: null },
                { index: 26, type: null },
                { index: 27, type: null },
                { index: 28, type: null },
                { index: 29, type: null },
                { index: 30, type: null },
                { index: 31, type: null },
                { index: 32, type: null },
                { index: 33, type: null },
                { index: 34, type: null },
                { index: 35, type: null },
                { index: 36, type: null },
                { index: 37, type: null },
                { index: 38, type: null },
                { index: 39, type: null },
                { index: 40, type: null },
                { index: 41, type: null },
                { index: 42, type: null },
                { index: 43, type: null },
                { index: 44, type: null }
            ]
        }
    },
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: 1,
            elements: [
                { type: 1, count: 45 },
                { type: 0, count: 28 },
                { type: 2, count: 28 }
            ]
        }, starScores: [5000, 12000, 18000], map: { lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0], connectedLats: [], elements: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 2, 1, 1, 1, 0, 1, 1, 1, 2, 4, 2, 1, 1, 1, 1, 1, 2, 4, 6, 4, 2, 1, 1, 1, 2, 4, 6, 1, 6, 4, 2, 1, 1, 1, 2, 4, 6, 4, 2, 1, 1, 1, 1, 1, 2, 4, 2, 1, 1, 1, 0, 1, 1, 1, 2, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 10, 0, 30, 0, 0, 0, 0, 0, 30, 0, 14, 0, 10, 0, 0, 0, 0, 0, 10, 0, 40, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 10, type: null }, { index: 16, type: null }, { index: 18, type: null }, { index: 26, type: null }] }
    },
    {
        baseElementTypes: [0, 2, 1, 3, 4], bubbleProbability: 0, stepCount: 29, passTarget: { type: 1, elements: [{ type: 9, count: 68 }] }, starScores: [8000, 15000, 22200], map: { lattices: [1, 0, 1, 0, 1, 0, 1, 0, 1, 2, 0, 2, 0, 2, 0, 2, 0, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2], connectedLats: [], elements: [1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 5, 2, 5, 2, 5, 2, 5, 2, 2, 4, 2, 4, 2, 4, 2, 4, 2, 1, 4, 2, 4, 2, 4, 2, 4, 2], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 0, 13, 0, 13, 0, 23, 0, 0, 13, 0, 21, 0, 31, 0, 11, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 2, type: null }, { index: 4, type: null }, { index: 6, type: null }, { index: 8, type: null }] }
    },
    {
        baseElementTypes: [1, 0, 2, 3],
        bubbleProbability: 0,
        stepCount: 20,
        passTarget: { type: 1, elements: [{ type: 1, count: 90 }] },
        starScores: [5000, 11000, 20000],
        map: {
            lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], connectedLats: [[11, 29], [12, 30], [13, 31], [14, 32], [15, 33]], elements: [0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 7, 7, 0, 0, 0, 7, 7, 7, 7, 7, 7, 7, 0, 0, 6, 7, 7, 7, 7, 7, 6, 0, 0, 2, 7, 7, 7, 7, 7, 2, 0, 0, 0, 2, 6, 2, 6, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 11, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }, { index: 15, type: null }]
        }
    },
    {
        baseElementTypes: [1, 2, 3, 4], bubbleProbability: 0, stepCount: 25, passTarget: { type: 1, elements: [{ type: 9, count: 45 }] }, starScores: [6000, 13000, 25000], map: { lattices: [0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 0, 1, 3, 3, 3, 3, 3, 0, 0, 0, 0, 1, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 2, 3, 3, 3, 3, 1, 0, 0, 3, 3, 3, 3, 3, 1, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 0], connectedLats: [], elements: [0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 6, 1, 1, 1, 1, 1, 0, 0, 0, 0, 6, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 6, 0, 0, 1, 1, 1, 1, 1, 6, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 10, type: null }, { index: 11, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }] }
    },
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: 1, elements: [
                { type: 2, count: 58 },
                { type: 1, count: 48 },
                { type: 5, count: 14 }
            ]
        },
        starScores: [6000, 12000, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 0, 1, 1, 1, 1, 0, 1, 0,
                0, 0, 1, 1, 1, 1, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 0, 2, 2, 2, 2, 0, 1, 0,
                0, 0, 2, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 2, 0,
                2, 0, 0, 6, 6, 0, 0, 2, 0,
                2, 0, 0, 0, 0, 0, 0, 2, 0,
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: { type: 1, elements: [{ type: 9, count: 37 }] },
        starScores: [6000, 11000, 22000],
        map: {
            lattices: [
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2
            ],
            connectedLats: [],
            elements: [
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 5, 0, 5, 2, 2, 1,
                1, 2, 2, 0, 5, 0, 2, 2, 1,
                1, 2, 2, 5, 5, 5, 2, 2, 1,
                1, 1, 2, 2, 5, 2, 2, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null },
                { index: 72, type: null },
                { index: 73, type: null },
                { index: 79, type: null },
                { index: 80, type: null },
            ]
        }
    },
    {
        baseElementTypes: [1, 2, 3, 4], bubbleProbability: 0, stepCount: 25, passTarget: { type: 1, elements: [{ type: 9, count: 18 }] }, starScores: [5000, 12000, 18000], map: { lattices: [0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 0, 1, 1, 1, 1, 1, 3, 3, 3, 0, 1, 1, 1, 1, 1, 3, 3, 3, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 3, 3, 3, 0, 1, 1, 1, 1, 1, 3, 3, 3, 0, 1, 1, 1, 1, 1, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], connectedLats: [[27, 45], [28, 46], [29, 47]], elements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 6, 1, 1, 1, 6, 0, 0, 0, 0, 6, 1, 1, 1, 6, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 40, 20, 0, 0, 0, 0, 0, 0, 40, 20, 30, 0, 0, 0, 0, 0, 0, 20, 30, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, 20, 40, 0, 0, 0, 0, 0, 0, 20, 50, 20, 0, 0, 0, 0, 0, 0, 50, 20, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 9, type: null }, { index: 10, type: null }, { index: 11, type: null }, { index: 13, type: null }, { index: 14, type: null }, { index: 15, type: null }, { index: 16, type: null }, { index: 17, type: null }] }
    },
    {
        baseElementTypes: [0, 2, 3, 4], bubbleProbability: 0.1, stepCount: 29, passTarget: { type: 1, elements: [{ type: 1, count: 32 }, { type: 3, count: 35 }, { type: 4, count: 35 }] }, starScores: [6000, 12000, 21000], map: { lattices: [0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0], connectedLats: [], elements: [0, 0, 0, 7, 7, 7, 0, 0, 0, 0, 0, 4, 1, 1, 1, 4, 0, 0, 0, 0, 4, 1, 1, 1, 4, 0, 0, 6, 0, 4, 1, 1, 1, 4, 0, 6, 6, 0, 4, 1, 1, 1, 4, 0, 6, 0, 0, 7, 1, 1, 1, 7, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 6, 6, 6, 1, 1, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 11, type: null }, { index: 15, type: null }, { index: 73, type: null }, { index: 79, type: null }] }
    },
    {
        baseElementTypes: [0, 3, 4, 2],
        bubbleProbability: 0,
        stepCount: 22,
        passTarget: { type: 1, elements: [{ type: 1, count: 40 }] },
        starScores: [5000, 11111, 23000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 0, 0, 1, 1, 1, 4, 6, 1,
                1, 0, 0, 1, 1, 1, 4, 6, 1,
                1, 1, 1, 1, 1, 1, 4, 4, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 4, 4, 1, 1, 1, 1, 1, 1,
                1, 2, 4, 1, 1, 1, 0, 0, 1,
                1, 2, 4, 1, 1, 1, 0, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 3, 2],
        bubbleProbability: 0.2,
        stepCount: 20,
        passTarget: { type: 1, elements: [{ type: 6, count: 3 }] },
        starScores: [5000, 12000, 18000],
        map: {
            lattices: [1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0],
            connectedLats: [[45, 2], [53, 6]],
            elements: [1, 0, 1, 0, 1, 0, 1, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [55, 61, 65, 69, 75, 76, 77], generateLats: [{ index: 0, type: null }, { index: 4, type: null }, { index: 8, type: null }, { index: 10, type: null }, { index: 12, type: null }, { index: 14, type: null }, { index: 16, type: null }]
        }
    },
    {
        baseElementTypes: [0, 1, 3, 2, 4],
        bubbleProbability: 0,
        stepCount: 35,
        passTarget: { type: 1, elements: [{ type: 9, count: 12 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                3, 0, 1, 1, 1, 1, 1, 0, 3,
                3, 3, 1, 1, 1, 1, 1, 3, 3,
                3, 0, 1, 1, 1, 1, 1, 0, 3,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 0, 3, 0, 1, 1, 1,
                1, 1, 0, 3, 3, 3, 0, 1, 1
            ],
            connectedLats: [],
            elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 4, 1, 0, 1, 4, 1, 0, 2, 4], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }]
        }
    },
    {
        baseElementTypes: [0, 2, 1, 4, 3], bubbleProbability: 0, stepCount: 35, passTarget: { type: 1, elements: [{ type: 9, count: 32 }] }, starScores: [6000, 11000, 21000], map: { lattices: [1, 3, 3, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 3, 3, 1], connectedLats: [], elements: [1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1], baseElements: [0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }, { index: 10, type: null }, { index: 11, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }, { index: 15, type: null }, { index: 16, type: null }, { index: 18, type: null }, { index: 19, type: null }, { index: 20, type: null }, { index: 21, type: null }, { index: 22, type: null }, { index: 23, type: null }, { index: 24, type: null }, { index: 25, type: null }] }
    },
    {
        baseElementTypes: [0, 2, 1, 3, 4],
        bubbleProbability: 0,
        stepCount: 23,
        passTarget: { type: 1, elements: [{ type: 1, count: 50 }, { type: 5, count: 26 }] },
        starScores: [5000, 11000, 19000],
        map: {
            lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
            connectedLats: [],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 7, 2, 7, 2, 7, 2, 7, 0,
                7, 7, 2, 7, 2, 7, 2, 7, 7,
                2, 7, 2, 7, 2, 7, 2, 7, 2,
                2, 7, 6, 7, 6, 7, 6, 7, 2,
                2, 7, 2, 7, 2, 7, 2, 7, 2,
                2, 7, 2, 7, 2, 7, 2, 7, 2,
                7, 7, 2, 7, 2, 7, 2, 7, 7,
                7, 7, 7, 7, 7, 7, 7, 7, 7
            ],
            baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            recycles: [],
            generateLats: [
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 18, type: null },
                { index: 26, type: null }
            ]
        }
    }
];


/***/ }),

/***/ "./src/something/chapters/Chapter5.ts":
/*!********************************************!*\
  !*** ./src/something/chapters/Chapter5.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Chapters5 = void 0;
exports.Chapters5 = [
    {
        baseElementTypes: [0, 1, 3, 2, 4], bubbleProbability: 0, stepCount: 25, passTarget: { type: 1, elements: [{ type: 1, count: 33 }, { type: 5, count: 26 }] }, starScores: [6000, 11000, 20000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0], connectedLats: [], elements: [2, 2, 2, 1, 1, 1, 1, 1, 0, 2, 2, 2, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 1, 6, 1, 1, 0, 1, 1, 2, 2, 1, 1, 1, 1, 0, 1, 1, 1, 2, 2, 1, 1, 1, 0, 1, 1, 1, 1, 2, 2, 1, 2, 0, 1, 1, 6, 1, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 2, 2, 2, 0, 1, 1, 1, 1, 1, 2, 2, 2, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 18, type: null }, { index: 19, type: null }, { index: 20, type: null }, { index: 21, type: null }, { index: 27, type: null }, { index: 28, type: null }, { index: 29, type: null }, { index: 30, type: null }, { index: 36, type: null }, { index: 37, type: null }, { index: 38, type: null }, { index: 39, type: null }] }
    },
    {
        baseElementTypes: [1, 0, 2, 3, 4], bubbleProbability: 0, stepCount: 20, passTarget: { type: 1, elements: [{ type: 9, count: 28 }] }, starScores: [7000, 12000, 22000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 3, 3, 3, 3, 3, 1, 0, 0, 1, 3, 1, 1, 1, 3, 1, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 7, 7, 7, 1, 7, 7, 7, 7, 4, 4, 4, 7, 1, 7, 4, 4, 4, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 7, 2, 7, 7, 7, 2, 7, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] }
    },
    {
        baseElementTypes: [0, 1, 2, 4, 3],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 29 }] },
        starScores: [6000, 12000, 23000],
        map: {
            lattices: [
                0, 0, 1, 1, 3, 1, 1, 0, 0,
                2, 0, 1, 3, 3, 3, 1, 0, 2,
                2, 0, 1, 3, 3, 3, 1, 0, 2,
                2, 0, 1, 3, 3, 3, 1, 0, 2,
                2, 0, 1, 3, 3, 3, 1, 0, 2,
                2, 0, 1, 3, 3, 3, 1, 0, 2,
                0, 0, 1, 3, 3, 3, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0
            ],
            connectedLats: [[65, 9], [69, 17]],
            elements: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 4, 4, 4, 4, 4, 0, 0,
                0, 0, 7, 7, 7, 7, 7, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 2, 1, 2, 0, 0, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 14, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.2,
        stepCount: 35,
        passTarget: { type: 1, elements: [{ type: 9, count: 44 }] },
        starScores: [7000, 14000, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                3, 3, 1, 1, 1, 1, 1, 3, 3,
                3, 3, 1, 1, 1, 1, 1, 3, 3,
                3, 3, 3, 1, 1, 1, 3, 3, 3,
                3, 3, 3, 1, 1, 1, 3, 3, 3,
                3, 3, 3, 1, 1, 1, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                1, 0, 0, 0, 1, 0, 0, 0, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                41, 0, 0, 0, 41, 0, 0, 0, 41
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 27 }] },
        starScores: [5000, 11000, 24000],
        map: {
            lattices: [
                1, 1, 1, 0, 2, 0, 1, 1, 1,
                1, 1, 1, 0, 2, 0, 1, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                0, 0, 3, 3, 3, 3, 3, 0, 0,
                3, 3, 3, 1, 3, 1, 3, 3, 3,
                0, 0, 3, 3, 3, 3, 3, 0, 0,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                1, 1, 1, 0, 2, 0, 1, 1, 1,
                1, 1, 1, 0, 2, 0, 1, 1, 1
            ],
            connectedLats: [[18, 36], [19, 37], [37, 55], [25, 43], [26, 44], [43, 61]],
            elements: [
                1, 1, 1, 0, 1, 0, 1, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                1, 4, 1, 7, 1, 7, 1, 4, 1,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 22, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                21, 13, 0, 0, 0, 0, 0, 43, 31,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 12, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 4, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null },
                { index: 21, type: null },
                { index: 23, type: null },
                { index: 54, type: null },
                { index: 62, type: null },
            ]
        }
    },
    {
        baseElementTypes: [0, 2, 3, 4], bubbleProbability: 0, stepCount: 23, passTarget: { type: 1, elements: [{ type: 1, count: 32 }, { type: 5, count: 12 }] }, starScores: [5000, 12000, 20000], map: { lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0], connectedLats: [], elements: [0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 6, 2, 1, 2, 6, 0, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 0, 6, 2, 1, 2, 6, 0, 1, 1, 0, 0, 1, 4, 1, 0, 0, 1, 0, 1, 1, 1, 7, 1, 1, 1, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 9, type: null }, { index: 17, type: null }, { index: 74, type: null }, { index: 78, type: null }] }
    },
    { baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0.1, stepCount: 29, passTarget: { type: 1, elements: [{ type: 6, count: 2 }] }, starScores: [5000, 12000, 21000], map: { lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0], connectedLats: [[22, 40], [65, 7], [69, 1]], elements: [1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 7, 1, 7, 7, 1, 1, 2, 1, 7, 4, 1, 4, 7, 1, 2, 1, 1, 7, 7, 1, 7, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 2, 4, 2, 4, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 9, type: null }, { index: 17, type: null }] } },
    {
        "baseElementTypes": [0, 1, 2, 3, 4],
        "bubbleProbability": 0,
        "stepCount": 25 + 10,
        "passTarget": { "type": 1, "elements": [{ "type": 9, "count": 36 }] },
        "starScores": [5000, 12000, 19000],
        "map": {
            "lattices": [
                0, 2, 0, 3, 3, 3, 0, 2, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                3, 3, 1, 0, 1, 0, 1, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                1, 0, 1, 1, 0, 1, 1, 0, 1
            ],
            "connectedLats": [],
            "elements": [
                1, 1, 1, 2, 1, 2, 1, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                2, 1, 1, 1, 1, 1, 1, 1, 2,
                4, 7, 1, 1, 1, 1, 1, 7, 4,
                2, 4, 7, 7, 1, 7, 7, 4, 2,
                2, 2, 4, 4, 1, 4, 4, 2, 2,
                2, 1, 2, 2, 1, 2, 2, 1, 2
            ],
            "baseElements": [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            "recycles": [],
            "generateLats": [
                { "index": 1 },
                { "index": 3 },
                { "index": 4 },
                { "index": 5 },
                { "index": 7 },
                { "index": 12 },
                { "index": 14 },
                { "index": 19 },
                { "index": 20 },
                { "index": 24, },
                { "index": 25 }
            ]
        }
    },
    {
        baseElementTypes: [1, 0, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 30 + 10,
        passTarget: { type: 1, elements: [{ type: 9, count: 49 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 3, 3, 1, 1, 1, 3, 3, 0,
                0, 0, 3, 3, 1, 3, 3, 0, 0,
                0, 3, 0, 3, 3, 3, 0, 3, 0,
                3, 3, 3, 0, 3, 0, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3
            ],
            connectedLats: [[19, 37], [25, 43], [29, 47], [33, 51], [39, 57], [41, 59]],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 7, 1, 1, 1, 1, 1, 7, 1,
                1, 2, 7, 1, 4, 1, 7, 2, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 1, 1, 2, 4, 2, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1
            ],
            recycles: [],
            generateLats: [
                { index: 1, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 7, type: null },
                { index: 49, type: null },
            ]
        }
    },
    {
        baseElementTypes: [1, 2, 3, 4],
        bubbleProbability: 0.2,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 2, count: 70 }, { type: 4, count: 70 }] },
        starScores: [6000, 18000, 54000], map: { lattices: [0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 4, 2, 1, 1, 1, 1, 2, 4, 1, 2, 4, 2, 7, 7, 2, 4, 2, 1, 7, 2, 4, 2, 2, 4, 2, 7, 1, 1, 7, 2, 2, 2, 2, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 9, type: null }, { index: 16, type: null }] }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: { type: 1, elements: [{ type: 9, count: 41 }] },
        starScores: [6000, 12000, 30000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                0, 3, 3, 3, 3, 3, 3, 3, 0
            ],
            connectedLats: [[27, 45], [35, 53]], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 0, 0, 0, 2, 1, 1, 1, 2, 2, 0, 0, 0, 2, 2, 1, 1, 2, 0, 0, 0, 0, 0, 2, 1, 1, 2, 0, 2, 2, 2, 0, 2, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 9, type: null }, { index: 10, type: null }, { index: 11, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }, { index: 15, type: null }, { index: 16, type: null }, { index: 17, type: null }]
        }
    },
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 24,
        passTarget: { type: 1, elements: [{ type: 5, count: 17 }, { type: 1, count: 35 }] },
        starScores: [5000, 11000, 19000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0
            ], connectedLats: [], elements: [1, 2, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 4, 2, 4, 1, 1, 1, 1, 1, 4, 6, 2, 6, 4, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 4, 6, 2, 6, 4, 1, 1, 1, 1, 1, 4, 2, 4, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 9, type: null }, { index: 10, type: null }, { index: 16, type: null }, { index: 17, type: null }, { index: 18, type: null }, { index: 26, type: null }]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 9, count: 71 }] },
        starScores: [6000, 12000, 21000],
        map: {
            lattices: [
                3, 3, 3, 3, 3, 2, 2, 2, 2,
                3, 3, 3, 3, 3, 2, 2, 2, 2,
                3, 3, 3, 3, 3, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                3, 3, 3, 3, 0, 2, 2, 2, 2,
                3, 3, 3, 3, 0, 2, 2, 2, 2,
                3, 3, 3, 3, 0, 2, 2, 2, 2,
                3, 3, 3, 3, 0, 2, 2, 2, 2,
                3, 3, 3, 3, 0, 2, 2, 2, 2
            ],
            connectedLats: [[18, 36], [19, 37], [20, 38], [21, 39]],
            elements: [
                2, 2, 2, 2, 2, 4, 4, 4, 4,
                2, 2, 2, 2, 2, 4, 4, 4, 4,
                2, 2, 2, 2, 1, 4, 4, 4, 4,
                1, 1, 1, 1, 1, 4, 4, 4, 4,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 2, 2, 2, 2,
                0, 0, 0, 0, 1, 2, 2, 2, 2,
                0, 0, 0, 0, 1, 2, 2, 2, 2
            ], baseElements: [0, 0, 0, 0, 0, 20, 10, 40, 30, 0, 0, 0, 0, 0, 20, 20, 30, 10, 0, 0, 0, 0, 11, 30, 20, 20, 40, 0, 0, 0, 0, 0, 20, 30, 40, 40, 0, 0, 0, 0, 0, 10, 10, 20, 30, 0, 0, 0, 0, 0, 30, 20, 30, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }, { index: 9, type: null }, { index: 10, type: null }, { index: 11, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }, { index: 15, type: null }, { index: 16, type: null }, { index: 17, type: null }, { index: 18, type: null }, { index: 19, type: null }, { index: 20, type: null }, { index: 21, type: null }, { index: 22, type: null }, { index: 23, type: null }, { index: 24, type: null }, { index: 25, type: null }, { index: 26, type: null }, { index: 32, type: null }, { index: 33, type: null }, { index: 34, type: null }, { index: 35, type: null }, { index: 41, type: null }, { index: 42, type: null }, { index: 43, type: null }, { index: 44, type: null }]
        }
    },
    { baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0.2, stepCount: 31, passTarget: { type: 1, elements: [{ type: 0, count: 40 }, { type: 1, count: 42 }] }, starScores: [6000, 12000, 21000], map: { lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [[30, 57], [32, 59], [38, 65], [42, 69]], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 7, 1, 1, 7, 1, 1, 7, 7, 7, 7, 4, 1, 7, 1, 4, 7, 7, 7, 7, 1, 1, 7, 1, 1, 7, 7, 7, 7, 1, 7, 2, 7, 1, 7, 7, 7, 7, 7, 7, 2, 7, 1, 7, 7, 7, 7, 7, 7, 2, 7, 1, 7, 7], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 27, type: null }, { index: 28, type: null }, { index: 34, type: null }, { index: 35, type: null }] } },
    {
        baseElementTypes: [0, 2, 1, 3], bubbleProbability: 0, stepCount: 29, passTarget: { type: 1, elements: [{ type: 6, count: 8 }] }, starScores: [4000, 8000, 18000], map: { lattices: [0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [[20, 38], [22, 40], [24, 42]], elements: [1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 4, type: null }, { index: 46, type: null }, { index: 52, type: null }, { index: 54, type: null }, { index: 62, type: null }] }
    },
    {
        baseElementTypes: [2, 3, 4, 0],
        bubbleProbability: 0,
        stepCount: 40,
        passTarget: {
            type: 1,
            elements: [
                { type: 1, count: 20 },
                { type: 5, count: 10 },
                { type: 3, count: 45 }
            ]
        },
        starScores: [5000, 25000, 70000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 6, 1, 1, 1, 1, 1, 6, 1,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 6, 1, 1, 1, 1, 1, 6, 1,
                1, 1, 7, 7, 7, 7, 7, 1, 1,
                5, 2, 4, 4, 4, 4, 4, 2, 5,
                5, 0, 0, 0, 0, 0, 0, 0, 5,
                2, 2, 2, 5, 5, 5, 2, 2, 2
            ],
            generateLats: [
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 11, type: null },
                { index: 15, type: null },
                { index: 54, type: null },
                { index: 62, type: null },
            ]
        }
    },
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 29,
        passTarget: { type: 1, elements: [{ type: 1, count: 60 }, { type: 5, count: 12 }] },
        starScores: [6000, 35000, 75000],
        map: { lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 6, 6, 6, 6, 6, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 9, type: null }, { index: 17, type: null }] }
    },
    {
        baseElementTypes: [1, 0, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 40,
        passTarget: { type: 1, elements: [{ type: 9, count: 27 }] },
        starScores: [5000, 13000, 21000],
        map: {
            lattices: [
                1, 0, 0, 0, 1, 0, 0, 0, 1,
                0, 1, 0, 1, 0, 1, 0, 1, 0,
                1, 0, 1, 0, 1, 0, 1, 0, 1,
                0, 2, 0, 2, 0, 2, 0, 2, 0,
                3, 1, 1, 1, 3, 1, 1, 1, 3,
                3, 1, 1, 1, 3, 1, 1, 1, 3,
                3, 1, 1, 1, 3, 1, 1, 1, 3,
                3, 3, 3, 1, 3, 1, 3, 3, 3,
                0, 3, 3, 3, 3, 3, 3, 3, 0
            ], connectedLats: [], elements: [7, 1, 1, 1, 7, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 4, 1, 1, 1, 4, 4, 1, 1, 1, 4, 1, 1, 1, 4, 4, 1, 1, 1, 4, 1, 1, 1, 4, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 4, type: null }, { index: 8, type: null }]
        }
    },
    { baseElementTypes: [1, 0, 4, 3], bubbleProbability: 0, stepCount: 24, passTarget: { type: 1, elements: [{ type: 9, count: 66 }] }, starScores: [5000, 13000, 21000], map: { lattices: [3, 0, 3, 3, 3, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 0, 3, 3, 0, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3], connectedLats: [], elements: [1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 4, 2, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 4, 2, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 2, 2, 2, 1, 2, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 8, type: null }] } },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 1,
        stepCount: 27,
        passTarget: {
            type: 1, elements: [
                { type: 1, count: 30 },
                { type: 3, count: 30 },
            ]
        },
        starScores: [6000, 12000, 25000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 0, 1, 1, 1, 0, 1, 1, 1,
                1, 0, 1, 0, 1, 0, 1, 0, 1,
                1, 0, 1, 1, 1, 0, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [[21, 39], [25, 43]],
            elements: [
                0, 4, 4, 4, 4, 4, 4, 4, 4,
                1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
            ], baseElements: [0, 0, 40, 40, 50, 40, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 0, 43, 0, 0, 0, 0, 0, 0, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 18, type: null, cus: [14, 14, 14] }, { index: 20, type: null, cus: [14, 14, 14] }, { index: 21, type: null, cus: [14, 14] }, { index: 22, type: null, cus: [14, 14, 14] }, { index: 24, type: null, cus: [14, 14, 14] }, { index: 25, type: null, cus: [14, 14] }, { index: 26, type: null, cus: [14, 14, 14] }, { index: 57, type: null }, { index: 58, type: null }, { index: 59, type: null }, { index: 64, type: null }, { index: 65, type: null }, { index: 69, type: null }, { index: 70, type: null }]
        }
    },
];


/***/ }),

/***/ "./src/something/chapters/Chapter6.ts":
/*!********************************************!*\
  !*** ./src/something/chapters/Chapter6.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Chapters6 = void 0;
var PassType_1 = __webpack_require__(/*! ../enum/PassType */ "./src/something/enum/PassType.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
exports.Chapters6 = [
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: { type: 1, elements: [{ type: 10, count: 13 }] },
        starScores: [6000, 23000, 55000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 8, 2, 2, 1, 2, 2, 8, 1,
                2, 2, 2, 2, 8, 2, 2, 2, 2,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                8, 2, 2, 2, 2, 2, 2, 2, 8,
                8, 2, 2, 2, 2, 2, 2, 2, 8,
                8, 8, 8, 1, 1, 1, 8, 8, 8
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 10, 20, 30, 0, 0, 0,
                0, 0, 0, 20, 30, 20, 0, 0, 0,
                0, 0, 0, 0, 40, 0, 0, 0, 0,
                0, 0, 0, 0, 40, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                20, 0, 0, 0, 0, 0, 0, 0, 20,
                20, 0, 0, 0, 0, 0, 0, 0, 20,
                30, 20, 20, 0, 0, 0, 20, 20, 30
            ],
            recycles: [],
            generateLats: [
                { index: 12, type: null },
                { index: 13, type: null },
                { index: 14, type: null },
                { index: 20, type: null },
                { index: 24, type: null },
                { index: 28, type: null },
                { index: 34, type: null },
                { index: 36, type: null },
                { index: 44, type: null }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 10, count: 6 }, { type: 5, count: 40 }] },
        starScores: [6000, 33000, 65000],
        map: {
            lattices: [
                0, 0, 1, 0, 0, 0, 1, 0, 0,
                0, 0, 0, 1, 0, 1, 0, 0, 0,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0
            ],
            connectedLats: [],
            elements: [
                1, 1, 8, 1, 1, 1, 8, 1, 1,
                1, 1, 1, 2, 1, 2, 1, 1, 1,
                1, 2, 8, 1, 1, 1, 8, 2, 1,
                2, 8, 2, 2, 1, 2, 2, 8, 2,
                8, 2, 2, 2, 2, 2, 2, 2, 8,
                2, 2, 2, 1, 1, 1, 2, 2, 2,
                2, 2, 2, 1, 1, 1, 2, 2, 2,
                2, 2, 2, 1, 2, 1, 2, 2, 2,
                1, 2, 2, 1, 0, 1, 2, 2, 1,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 22, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 30, 40, 30, 0, 0, 0,
                0, 0, 0, 40, 30, 40, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 22, 0, 22, 0, 0, 0
            ],
            recycles: [],
            generateLats: [{ index: 2, type: null }, { index: 6, type: null }, { index: 19, type: null }, { index: 25, type: null }, { index: 27, type: null }, { index: 30, type: null }, { index: 31, type: null }, { index: 32, type: null }, { index: 35, type: null }]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: { type: 1, elements: [{ type: 5, count: 12 }, { type: 9, count: 17 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 3, 1, 1, 1, 3, 1, 1,
                1, 1, 3, 1, 1, 1, 3, 1, 1,
                1, 1, 3, 1, 1, 1, 3, 1, 1,
                1, 1, 3, 1, 1, 1, 3, 1, 1,
                1, 1, 3, 1, 1, 1, 3, 1, 1,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 1, 5, 1, 1, 1, 5, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 2, 5, 2, 5, 2, 5, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 24,
        passTarget: { type: 1, elements: [{ type: 10, count: 15 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 8, 8, 8, 1, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                8, 8, 2, 0, 0, 0, 2, 8, 8,
                8, 2, 2, 0, 0, 0, 2, 2, 8,
                2, 8, 2, 2, 2, 2, 2, 8, 2,
                8, 2, 2, 2, 2, 2, 2, 2, 8,
                2, 8, 2, 2, 2, 2, 2, 8, 2
            ],
            baseElements: [
                0, 0, 0, 30, 10, 30, 0, 0, 0,
                0, 0, 0, 10, 20, 10, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 36, type: null },
                { index: 37, type: null },
                { index: 38, type: null },
                { index: 42, type: null },
                { index: 43, type: null },
                { index: 44, type: null }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 10, count: 18 }, { type: 5, count: 25 }] },
        starScores: [5000, 11000, 21000],
        map: {
            lattices: [
                1, 1, 1, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 8, 1, 8, 8, 8, 8, 8,
                1, 1, 8, 1, 8, 8, 8, 8, 8,
                1, 1, 8, 1, 8, 8, 8, 8, 8,
                1, 1, 1, 1, 4, 4, 4, 4, 4,
                2, 2, 2, 4, 1, 0, 0, 0, 0,
                2, 2, 2, 4, 1, 0, 0, 0, 0,
                2, 2, 2, 4, 1, 0, 0, 0, 0,
                2, 2, 2, 4, 2, 2, 2, 2, 2,
                2, 2, 2, 4, 2, 2, 2, 2, 2
            ],
            baseElements: [
                10, 20, 42, 0, 0, 0, 0, 0, 0,
                20, 10, 33, 0, 0, 0, 0, 0, 0,
                10, 20, 41, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 20, 10, 20, 10, 20,
                0, 0, 0, 20, 0, 0, 0, 0, 0,
                0, 0, 0, 10, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 0, 0, 0, 0, 0,
                0, 0, 0, 10, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null },
                { index: 36, type: null },
                { index: 37, type: null },
                { index: 38, type: null },
                { index: 39, type: null }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 38 }, { type: 10, count: 18 }] },
        starScores: [6000, 11000, 19000],
        map: {
            lattices: [
                2, 2, 2, 1, 1, 1, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                1, 1, 2, 2, 2, 2, 2, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                1, 1, 2, 2, 2, 2, 2, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 1, 2, 2, 2, 2, 2, 1, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 4, 4, 4, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                8, 8, 1, 1, 1, 1, 1, 8, 8,
                8, 8, 1, 8, 8, 8, 1, 8, 8,
                8, 8, 1, 8, 8, 8, 1, 8, 8,
                1, 1, 1, 4, 4, 4, 1, 1, 1,
                4, 4, 1, 1, 1, 1, 1, 4, 4,
                4, 4, 1, 1, 1, 1, 1, 4, 4,
                4, 4, 1, 1, 1, 1, 1, 4, 4
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                3, 1, 0, 2, 3, 2, 0, 1, 3,
                3, 1, 0, 2, 3, 2, 0, 1, 3,
            ],
            recycles: [],
            generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }, { index: 47, type: null }, { index: 48, type: null }, { index: 49, type: null }, { index: 50, type: null }, { index: 51, type: null }, { index: 54, type: null }, { index: 55, type: null }, { index: 61, type: null }, { index: 62, type: null }]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 5, count: 24 }, { type: 9, count: 15 }] },
        starScores: [6000, 22000, 45000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 2, 0, 0, 0, 2, 1, 1, 1, 1, 2, 0, 0, 0, 2, 1, 1, 1, 1, 7, 7, 7, 7, 7, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 5, 5, 5, 5, 5, 2, 2, 2, 2, 5, 5, 5, 5, 5, 2, 2, 2, 2, 5, 5, 5, 5, 5, 2, 2], baseElements: [10, 10, 20, 12, 14, 12, 40, 10, 10, 30, 21, 40, 0, 0, 0, 20, 41, 30, 30, 10, 20, 0, 0, 0, 40, 10, 30, 40, 40, 10, 0, 0, 0, 10, 20, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }, { index: 45, type: null }, { index: 53, type: null }, { index: 54, type: null }, { index: 62, type: null }, { index: 63, type: null }, { index: 71, type: null }, { index: 72, type: null }, { index: 80, type: null }] }
    },
    {
        baseElementTypes: [1, 0, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 10, count: 9 }] },
        starScores: [6000, 12000, 21000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 2, 2, 8, 8, 8, 2, 2, 1,
                1, 2, 2, 8, 8, 8, 2, 2, 1,
                1, 2, 2, 8, 8, 8, 2, 2, 1,
                1, 1, 1, 4, 4, 4, 1, 1, 1,
                1, 1, 4, 4, 4, 4, 4, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 10, type: null }, { index: 11, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }, { index: 15, type: null }, { index: 16, type: null }, { index: 55, type: null }, { index: 56, type: null }, { index: 57, type: null }, { index: 58, type: null }, { index: 59, type: null }, { index: 60, type: null }, { index: 61, type: null }]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 65 }] },
        starScores: [6000, 11000, 18000],
        map: {
            lattices: [
                3, 3, 3, 3, 3, 0, 0, 0, 0,
                3, 3, 3, 3, 3, 0, 0, 0, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 0, 0, 0, 0,
                3, 3, 3, 3, 3, 0, 0, 0, 0
            ],
            elements: [
                2, 7, 2, 7, 2, 1, 1, 1, 1,
                1, 2, 1, 2, 1, 1, 1, 1, 1,
                2, 7, 2, 7, 2, 2, 2, 2, 1,
                5, 5, 5, 5, 2, 2, 2, 1, 1,
                5, 5, 5, 5, 2, 1, 1, 1, 1,
                5, 5, 5, 5, 2, 2, 2, 1, 1,
                2, 7, 2, 7, 2, 2, 2, 2, 1,
                1, 2, 1, 2, 1, 1, 1, 1, 1,
                2, 2, 2, 2, 2, 1, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                20, 0, 20, 0, 20, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 10,
                0, 0, 0, 0, 0, 0, 0, 20, 10,
                0, 0, 0, 0, 0, 20, 20, 10, 20,
                0, 0, 0, 0, 0, 0, 0, 20, 10,
                0, 0, 0, 0, 0, 0, 0, 0, 10,
                20, 0, 20, 0, 20, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 23, type: null },
                { index: 24, type: null },
                { index: 25, type: null },
                { index: 26, type: null },
                { index: 27, type: null },
                { index: 28, type: null },
                { index: 29, type: null },
                { index: 30, type: null },
                { index: 31, type: null },
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0.1, stepCount: 20, passTarget: { type: 1, elements: [{ type: 9, count: 36 }] }, starScores: [6000, 12000, 21000], map: { lattices: [0, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0], connectedLats: [], elements: [2, 8, 8, 8, 8, 8, 2, 2, 2, 8, 8, 2, 2, 2, 2, 2, 2, 2, 8, 2, 2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 14, 0], recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 78, type: null }, { index: 79, type: null }] }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 45 }] },
        starScores: [6000, 24000, 48888], map: { lattices: [0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 0, 0, 0, 3, 3, 3, 0, 0, 0], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 7, 7, 1, 1, 1, 1, 1, 1, 7, 7, 7, 1, 1, 1, 1, 1, 1, 7, 7, 7, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 8, 8, 8, 2, 1, 1, 1, 1, 2, 8, 8, 8, 2, 1, 1, 1, 1, 2, 8, 8, 8, 2, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 11, type: null }, { index: 15, type: null }, { index: 18, type: null }, { index: 19, type: null }, { index: 25, type: null }, { index: 26, type: null }] }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        stepCount: 21,
        passTarget: { type: PassType_1.PassType.ELEMENT_TARGET, elements: [{ type: ElementType_1.ElementType.ICE, count: 9 }] },
        starScores: [4000, 8000, 15000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 3, 1, 1, 1, 0,
                0, 1, 1, 1, 3, 1, 1, 1, 0,
                0, 1, 1, 1, 3, 1, 1, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 1, 1, 3, 1, 1, 1, 0,
            ],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 2, 2, 2, 1, 1, 0,
                0, 1, 1, 2, 4, 2, 1, 1, 0,
                0, 1, 1, 2, 4, 2, 1, 1, 0,
                0, 2, 2, 2, 4, 2, 2, 2, 0,
                0, 2, 4, 4, 4, 4, 4, 2, 0,
                0, 2, 2, 2, 4, 2, 2, 2, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null }
            ]
        },
    },
    {
        baseElementTypes: [2, 3, 4, 0, 1],
        bubbleProbability: 0.1,
        stepCount: 40,
        passTarget: { type: 1, elements: [{ type: 9, count: 55 }] },
        starScores: [5000, 12000, 20000],
        map: {
            lattices: [
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 0, 0, 0, 0, 0, 2, 2,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 0, 2, 2, 2, 2,
                2, 2, 2, 0, 2, 0, 2, 2, 2,
                0, 2, 0, 2, 2, 2, 0, 2, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0
            ],
            connectedLats: [[73, 0], [74, 1], [75, 2], [77, 6], [78, 7], [79, 8]],
            elements: [
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                8, 8, 1, 1, 1, 1, 1, 8, 8,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 2, 1, 2, 1, 1, 1,
                2, 2, 2, 1, 1, 1, 2, 2, 2,
                1, 0, 1, 0, 0, 0, 1, 0, 1,
                1, 0, 0, 0, 8, 0, 0, 0, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 30, type: null },
                { index: 31, type: null },
                { index: 32, type: null },
                { index: 36, type: null },
                { index: 37, type: null },
                { index: 38, type: null },
                { index: 42, type: null },
                { index: 43, type: null },
                { index: 44, type: null }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0, stepCount: 37, passTarget: { type: 1, elements: [{ type: 9, count: 17 }] }, starScores: [5000, 12000, 21000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 4, 8, 4, 8, 4, 8, 4, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 4, 8, 4, 8, 4, 8, 4, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 40,
        passTarget: { type: 1, elements: [{ type: 6, count: 8 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                1, 1, 0, 0, 1, 0, 0, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0
            ],
            connectedLats: [],
            elements: [
                3, 3, 1, 1, 3, 1, 1, 3, 3,
                4, 4, 2, 2, 4, 2, 2, 4, 4,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                7, 1, 1, 1, 1, 1, 1, 1, 7,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 8, 8, 8, 1, 1, 1
            ],
            recycles: [63, 71, 73, 74, 75, 76, 77, 78, 79],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 4, type: null },
                { index: 7, type: null },
                { index: 8, type: null },
                { index: 11, type: null },
                { index: 12, type: null },
                { index: 14, type: null },
                { index: 15, type: null },
                { index: 27, type: null },
                { index: 28, type: null },
                { index: 29, type: null },
                { index: 30, type: null },
                { index: 31, type: null },
                { index: 32, type: null },
                { index: 33, type: null },
                { index: 34, type: null },
                { index: 35, type: null },
                { index: 36, type: null },
                { index: 37, type: null },
                { index: 38, type: null },
                { index: 39, type: null },
                { index: 40, type: null },
                { index: 41, type: null },
                { index: 42, type: null },
                { index: 43, type: null },
                { index: 44, type: null },
                { index: 45, type: null },
                { index: 46, type: null },
                { index: 47, type: null },
                { index: 48, type: null },
                { index: 49, type: null },
                { index: 50, type: null },
                { index: 51, type: null },
                { index: 52, type: null },
                { index: 53, type: null }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 41 }] },
        starScores: [5000, 12200, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 3, 0, 0,
                1, 1, 3, 3, 3, 3, 3, 3, 0,
                1, 1, 3, 0, 3, 3, 3, 3, 3,
                1, 1, 3, 3, 3, 3, 3, 3, 3,
                1, 1, 3, 3, 3, 0, 3, 3, 3,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 0, 3, 3, 3, 3, 3, 0, 0,
                0, 0, 0, 3, 3, 3, 0, 0, 0
            ],
            connectedLats: [[21, 39], [41, 59]],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 2, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 2, 1,
                1, 1, 1, 1, 1, 4, 4, 1, 2,
                1, 1, 1, 1, 4, 8, 2, 8, 2,
                1, 1, 1, 4, 8, 1, 7, 7, 2,
                1, 2, 1, 4, 2, 7, 7, 2, 1,
                1, 1, 2, 1, 8, 7, 2, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 15, type: null }, { index: 25, type: null }, { index: 35, type: null }]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 31,
        passTarget: { type: 1, elements: [{ type: 6, count: 6 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                2, 3, 2, 2, 2, 2, 2, 3, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 1, 1, 1, 2, 2, 2,
                2, 2, 2, 1, 1, 1, 2, 2, 2,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 4, 1, 4, 1, 4, 1, 4, 1,
                1, 4, 1, 4, 1, 4, 1, 4, 1,
                2, 2, 2, 2, 1, 2, 2, 2, 2
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [72, 73, 74, 75, 77, 78, 79, 80],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null },
                { index: 12, type: null },
                { index: 13, type: null },
                { index: 14, type: null },
                { index: 21, type: null },
                { index: 22, type: null },
                { index: 23, type: null },
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 32,
        passTarget: { type: 1, elements: [{ type: 1, count: 16 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                1, 1, 0, 1, 1, 1, 0, 1, 1,
                1, 1, 0, 1, 1, 1, 0, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                4, 4, 4, 4, 4, 4, 4, 4, 4,
                2, 2, 6, 2, 2, 2, 6, 2, 2,
                2, 8, 2, 2, 2, 2, 2, 8, 2,
                8, 1, 6, 1, 2, 1, 6, 1, 8,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 7, type: null },
                { index: 8, type: null }
            ]
        }
    },
    { baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 33, passTarget: { type: 1, elements: [{ type: 2, count: 50 }, { type: 3, count: 50 }] }, starScores: [5000, 12000, 21000], map: { lattices: [0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 4, 1, 5, 4, 4, 1, 1, 1, 4, 4, 5, 1, 1, 4, 1, 1, 1, 4, 1, 1, 1, 1, 4, 1, 1, 1, 4, 1, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 5, 8, 8, 8, 5, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 4, type: null }, { index: 6, type: null }, { index: 9, type: null }, { index: 17, type: null }] } },
    {
        baseElementTypes: [0, 2, 3, 4, 1],
        bubbleProbability: 0.1,
        stepCount: 33,
        passTarget: { type: 1, elements: [{ type: 2, count: 50 }, { type: 3, count: 50 }] },
        starScores: [6000, 15000, 24000],
        map: { lattices: [0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 2, 2, 7, 7, 1, 7, 7, 2, 2, 2, 2, 7, 1, 2, 1, 7, 2, 2, 2, 2, 7, 7, 2, 7, 7, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 5, 2, 2, 2, 5, 2, 2, 1, 2, 2, 5, 5, 5, 2, 2, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 10, type: null }, { index: 16, type: null }, { index: 18, type: null }, { index: 26, type: null }] }
    },
];


/***/ }),

/***/ "./src/something/chapters/getChapter.ts":
/*!**********************************************!*\
  !*** ./src/something/chapters/getChapter.ts ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getChapterData = void 0;
var Chapter1_1 = __webpack_require__(/*! ./Chapter1 */ "./src/something/chapters/Chapter1.ts");
var Chapter2_1 = __webpack_require__(/*! ./Chapter2 */ "./src/something/chapters/Chapter2.ts");
var Chapter3_1 = __webpack_require__(/*! ./Chapter3 */ "./src/something/chapters/Chapter3.ts");
var Chapter4_1 = __webpack_require__(/*! ./Chapter4 */ "./src/something/chapters/Chapter4.ts");
var Chapter5_1 = __webpack_require__(/*! ./Chapter5 */ "./src/something/chapters/Chapter5.ts");
var Chapter6_1 = __webpack_require__(/*! ./Chapter6 */ "./src/something/chapters/Chapter6.ts");
var chapters = [].concat(Chapter1_1.Chapters1, Chapter2_1.Chapters2, Chapter3_1.Chapters3, Chapter4_1.Chapters4, Chapter5_1.Chapters5, Chapter6_1.Chapters6);
function getChapterData(index) {
    return chapters[index] || chapters[1];
}
exports.getChapterData = getChapterData;
var a = {
    "lev": 102,
    "tar": [
        { "type": 5, "num": 40 }
    ],
    "one": 6000,
    "two": 15000,
    "three": 32000
};


/***/ }),

/***/ "./src/something/class/Ani.ts":
/*!************************************!*\
  !*** ./src/something/class/Ani.ts ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ani = void 0;
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var Ani = (function (_super) {
    __extends(Ani, _super);
    function Ani() {
        var _this = _super.call(this) || this;
        _this.mouseEnable = false;
        _this.mouseChildren = false;
        return _this;
    }
    Ani.prototype.play = function () {
    };
    Ani.prototype.recover = function () {
        if (this.parent) {
            this.parent.removeChild(this);
        }
        ;
        Pool_1.Pool.recover(this.aniName, this);
    };
    return Ani;
}(FYGE.Container));
exports.Ani = Ani;


/***/ }),

/***/ "./src/something/class/BitmapRecycle.ts":
/*!**********************************************!*\
  !*** ./src/something/class/BitmapRecycle.ts ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.BitmapRecycle = void 0;
var BitmapRecycle = (function (_super) {
    __extends(BitmapRecycle, _super);
    function BitmapRecycle(texture) {
        var _this = _super.call(this, texture) || this;
        _this.anchorTexture.set(0.5, 0.5);
        return _this;
    }
    BitmapRecycle.prototype.reset = function (texture) {
        this.texture = texture;
        this.anchorTexture.set(0.5, 0.5);
        this.alpha = this.scaleX = this.scaleY = 1;
        this.rotation = 0;
    };
    return BitmapRecycle;
}(FYGE.Sprite));
exports.BitmapRecycle = BitmapRecycle;


/***/ }),

/***/ "./src/something/class/ChickenEgg.ts":
/*!*******************************************!*\
  !*** ./src/something/class/ChickenEgg.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChickenEgg = void 0;
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var images = {
    2: "ele" + ElementType_1.ElementType.CHICKEN_EGG + ".png",
    1: "eggStatus1.png",
    0: "eggStatus0.png"
};
var ChickenEgg = (function (_super) {
    __extends(ChickenEgg, _super);
    function ChickenEgg(n) {
        if (n === void 0) { n = 2; }
        var _this = _super.call(this) || this;
        _this.showImage = new FYGE.Sprite();
        _this.addChild(_this.showImage);
        _this.changeSource(images[n]);
        _this.isActive = false;
        _this._statusNum = n;
        return _this;
    }
    Object.defineProperty(ChickenEgg.prototype, "statusNum", {
        get: function () {
            return this._statusNum;
        },
        set: function (value) {
            if (value >= 0) {
                this._statusNum = value;
                if (this.showImage.texture != RES_1.RES.getRes(images[this._statusNum])) {
                    this.changeSource(images[this._statusNum]);
                }
            }
            else {
                this._statusNum = 0;
                this.isActive = true;
            }
        },
        enumerable: false,
        configurable: true
    });
    ChickenEgg.prototype.changeSource = function (source) {
        var texture = RES_1.RES.getRes(source);
        this.showImage.texture = texture;
        this.showImage.anchorTexture.set(0.5, (texture.height / 2 + 20) / texture.height);
        this.showImage.y = 20;
    };
    ChickenEgg.prototype.shakeAni = function () {
        this.showImage.rotation = 0;
        FYGE.Tween.get(this.showImage)
            .to({ rotation: 10 }, 80)
            .to({ rotation: -8 }, 160)
            .to({ rotation: 5 }, 160)
            .to({ rotation: 0 }, 50);
    };
    ChickenEgg.prototype.reset = function (n) {
        if (n === void 0) { n = 2; }
        this.changeSource(images[n]);
        this.isActive = false;
        this._statusNum = n;
    };
    return ChickenEgg;
}(FYGE.Container));
exports.ChickenEgg = ChickenEgg;


/***/ }),

/***/ "./src/something/class/Door.ts":
/*!*************************************!*\
  !*** ./src/something/class/Door.ts ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Door = exports.doorImages = exports.doorBgImages = void 0;
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
exports.doorBgImages = [
    "redDoorBg.png",
    "yellowDoorBg.png",
    "blueDoorBg.png",
];
exports.doorImages = [
    "doorClosed.png",
    "doorOpen.png"
];
var Door = (function (_super) {
    __extends(Door, _super);
    function Door(closed) {
        if (closed === void 0) { closed = false; }
        var _this = _super.call(this) || this;
        var textureBg = RES_1.RES.getRes(exports.doorBgImages[0]);
        _this.bg = new FYGE.Sprite(textureBg);
        _this.bg.x = -textureBg.width / 2;
        _this.bg.y = -textureBg.height / 2;
        _this.addChild(_this.bg);
        _this.addEventListener(FYGE.Event.ENTER_FRAME, _this.bgAni, _this);
        var textureDoor = RES_1.RES.getRes(exports.doorImages[1]);
        _this.showImage = new FYGE.Sprite(textureDoor);
        _this.showImage.x = -textureDoor.width / 2;
        _this.showImage.y = -textureDoor.height / 2;
        _this.addChild(_this.showImage);
        _this.statusNum = 2;
        _this.closed = closed;
        return _this;
    }
    Object.defineProperty(Door.prototype, "statusNum", {
        get: function () {
            return this._statusNum;
        },
        set: function (value) {
            if (value >= 0 && value <= 2) {
                this._statusNum = value;
                this.bg.texture = RES_1.RES.getRes(exports.doorBgImages[this._statusNum]);
            }
            else {
                this._statusNum = 2;
                this.isActive = true;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Door.prototype, "closed", {
        get: function () {
            return this._closed;
        },
        set: function (value) {
            this._closed = value;
            this.showImage.texture = RES_1.RES.getRes(exports.doorImages[value ? 0 : 1]);
        },
        enumerable: false,
        configurable: true
    });
    Door.prototype.reset = function (closed) {
        if (closed === void 0) { closed = false; }
        this.statusNum = 2;
        this.closed = closed;
    };
    Door.prototype.bgAni = function () {
        if (!this.stage)
            return;
        if (this.bgDirection) {
            this.bg.alpha += 0.05;
        }
        else {
            this.bg.alpha -= 0.05;
        }
        if (this.bg.alpha < 0) {
            this.bgDirection = true;
        }
        else if (this.bg.alpha > 1) {
            this.bgDirection = false;
        }
    };
    return Door;
}(FYGE.Container));
exports.Door = Door;


/***/ }),

/***/ "./src/something/class/Element.ts":
/*!****************************************!*\
  !*** ./src/something/class/Element.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Element = void 0;
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var EffectType_1 = __webpack_require__(/*! ../enum/EffectType */ "./src/something/enum/EffectType.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var MagicLionBgAni_1 = __webpack_require__(/*! ../periodAni/MagicLionBgAni */ "./src/something/periodAni/MagicLionBgAni.ts");
var HorizontalBgAni_1 = __webpack_require__(/*! ../periodAni/HorizontalBgAni */ "./src/something/periodAni/HorizontalBgAni.ts");
var VerticalBgAni_1 = __webpack_require__(/*! ../periodAni/VerticalBgAni */ "./src/something/periodAni/VerticalBgAni.ts");
var ExplosiveBgAni_1 = __webpack_require__(/*! ../periodAni/ExplosiveBgAni */ "./src/something/periodAni/ExplosiveBgAni.ts");
var ChickenEgg_1 = __webpack_require__(/*! ./ChickenEgg */ "./src/something/class/ChickenEgg.ts");
var StateType_1 = __webpack_require__(/*! ../enum/StateType */ "./src/something/enum/StateType.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var FestivalEle_1 = __webpack_require__(/*! ./FestivalEle */ "./src/something/class/FestivalEle.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Element = (function (_super) {
    __extends(Element, _super);
    function Element(type) {
        var _this = _super.call(this) || this;
        _this.temEffectType = null;
        _this._effectType = null;
        _this.states = [];
        _this.moveCount = 0;
        _this.moveDir = 1;
        _this.moveDis = 1;
        _this.moveMaxDis = 4;
        _this.moveFrame = 0;
        _this.moveFrameSign = 6;
        _this._type = type;
        _this.changeSource();
        if (type == ElementType_1.ElementType.CHICKEN_EGG) {
            _this.chickenEgg = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.CHICKEN_EGG);
            if (!_this.chickenEgg) {
                _this.chickenEgg = new ChickenEgg_1.ChickenEgg();
            }
            else {
                _this.chickenEgg.reset();
            }
            _this.addChild(_this.chickenEgg);
        }
        else if (type == ElementType_1.ElementType.FESTIVALELE_BIG) {
            _this.festivalEle = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.FESTIVAL_ELE);
            if (!_this.festivalEle) {
                _this.festivalEle = new FestivalEle_1.FestivalEle();
            }
            else {
                _this.festivalEle.reset();
            }
            _this.addChild(_this.festivalEle);
        }
        return _this;
    }
    Object.defineProperty(Element.prototype, "type", {
        get: function () {
            return this._type;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Element.prototype, "effectType", {
        get: function () {
            return this._effectType;
        },
        set: function (value) {
            if (this._effectType == value)
                return;
            if (value != null) {
                this.removeEffectHas();
                switch (value) {
                    case EffectType_1.EffectType.MAGICLION:
                        this.magicLionBgAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.MAGICLIONBG_ANI);
                        if (!this.magicLionBgAni) {
                            this.magicLionBgAni = new MagicLionBgAni_1.MagicLionBgAni();
                        }
                        else {
                            this.magicLionBgAni.reset();
                        }
                        this.addChildAt(this.magicLionBgAni, 0);
                        break;
                    case EffectType_1.EffectType.HORIZONTAL:
                        this.horizontalBgAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.HORIZONTALBG_ANI);
                        if (!this.horizontalBgAni) {
                            this.horizontalBgAni = new HorizontalBgAni_1.HorizontalBgAni();
                        }
                        else {
                            this.horizontalBgAni.reset();
                        }
                        this.addChildAt(this.horizontalBgAni, 1);
                        break;
                    case EffectType_1.EffectType.VERTICAL:
                        this.verticalBgAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.VERTICALBG_ANI);
                        if (!this.verticalBgAni) {
                            this.verticalBgAni = new VerticalBgAni_1.VerticalBgAni();
                        }
                        else {
                            this.verticalBgAni.reset();
                        }
                        this.addChildAt(this.verticalBgAni, 1);
                        break;
                    case EffectType_1.EffectType.EXPLOSIVE:
                        this.explosiveBgAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.EXPLOSIVEBG_ANI);
                        if (!this.explosiveBgAni) {
                            this.explosiveBgAni = new ExplosiveBgAni_1.ExplosiveBgAni();
                        }
                        else {
                            this.explosiveBgAni.play(0);
                        }
                        this.addChildAt(this.explosiveBgAni, 1);
                        break;
                }
                this._effectType = value;
            }
            else {
                this.removeEffectHas();
                this._effectType = null;
            }
            this.changeSource();
        },
        enumerable: false,
        configurable: true
    });
    Element.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this._effectType == EffectType_1.EffectType.HORIZONTAL
            || this._effectType == EffectType_1.EffectType.VERTICAL) {
            this.moveFrame++;
            if (this.moveFrame > this.moveFrameSign) {
                this.moveFrame = 0;
                this.moveCount += this.moveDir * this.moveDis;
            }
            var xy = (this._effectType == EffectType_1.EffectType.HORIZONTAL) ? "x" : "y";
            this[xy] += this.moveDir * this.moveDis / this.moveFrameSign;
            if (Math.abs(this.moveCount) >= this.moveMaxDis) {
                this.moveDir *= -1;
            }
        }
    };
    Element.prototype.changeSource = function () {
        var texArr;
        if (this._effectType == null) {
            texArr = [RES_1.RES.getRes("ele" + this._type + ".png")];
        }
        else {
            if (this._effectType == EffectType_1.EffectType.EXPLOSIVE) {
                texArr = [RES_1.RES.getRes("ele" + this._type + "Exp.png")];
            }
            else if (this._effectType == EffectType_1.EffectType.MAGICLION) {
                texArr = [RES_1.RES.getRes("magicLion.png")];
            }
            else {
                texArr = [RES_1.RES.getRes("ele" + this._type + "Hor.png")];
            }
        }
        if (!this.showImage) {
            this.showImage = this.addChild(new FYGE.FrameAni(texArr));
        }
        else {
            this.showImage.resetTexturesAll(texArr);
        }
        if (this.showImage.totalFrames == 1) {
            this.showImage.reset(0);
        }
        else {
            this.showImage.play(0);
        }
        if (this._type == ElementType_1.ElementType.CHICKEN_EGG ||
            this._type == ElementType_1.ElementType.FESTIVALELE_BIG ||
            this._effectType == EffectType_1.EffectType.MAGICLION) {
            this.showImage.alpha = 0;
        }
        else {
            this.showImage.alpha = 1;
        }
        if (this._effectType == EffectType_1.EffectType.EXPLOSIVE)
            this.explosiveTween();
    };
    Element.prototype.reset = function (type) {
        this.alpha = this.scaleX = this.scaleY = 1;
        this._type = type;
        this.effectType = null;
        this.temEffectType = null;
        this.changeSource();
        this.removeAllState();
        if (type == ElementType_1.ElementType.CHICKEN_EGG) {
            this.chickenEgg = this.chickenEgg || Pool_1.Pool.takeOut(RecoverName_1.RecoverName.CHICKEN_EGG);
            if (!this.chickenEgg) {
                this.chickenEgg = new ChickenEgg_1.ChickenEgg();
            }
            else {
                this.chickenEgg.reset();
            }
            this.addChild(this.chickenEgg);
        }
        else if (this.chickenEgg) {
            this.removeChild(this.chickenEgg);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.CHICKEN_EGG, this.chickenEgg);
            this.chickenEgg = null;
        }
        if (type == ElementType_1.ElementType.FESTIVALELE_BIG) {
            this.festivalEle = this.festivalEle || Pool_1.Pool.takeOut(RecoverName_1.RecoverName.FESTIVAL_ELE);
            if (!this.festivalEle) {
                this.festivalEle = new FestivalEle_1.FestivalEle();
            }
            else {
                this.festivalEle.reset();
            }
            this.addChild(this.festivalEle);
        }
        else if (this.festivalEle) {
            this.removeChild(this.festivalEle);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.FESTIVAL_ELE, this.festivalEle);
            this.festivalEle = null;
        }
    };
    Element.prototype.resetType = function (type) {
        if (this._type == type)
            return;
        if (ElementType_1.FiveBaseElementTypes.indexOf(type) == -1 ||
            ElementType_1.FiveBaseElementTypes.indexOf(this._type) == -1) {
            this.reset(type);
        }
        else {
            this._type = type;
            this.changeSource();
            if (this.hasState(StateType_1.StateType.BUBBLE)) {
                this.getState(StateType_1.StateType.BUBBLE).reset(type);
                this.showImage.alpha = 0;
            }
        }
    };
    Element.prototype.removeEffectHas = function () {
        switch (this._effectType) {
            case EffectType_1.EffectType.MAGICLION:
                this.removeChild(this.magicLionBgAni);
                Pool_1.Pool.recover(RecoverName_1.RecoverName.MAGICLIONBG_ANI, this.magicLionBgAni);
                this.magicLionBgAni = null;
                break;
            case EffectType_1.EffectType.HORIZONTAL:
                this.removeChild(this.horizontalBgAni);
                Pool_1.Pool.recover(RecoverName_1.RecoverName.HORIZONTALBG_ANI, this.horizontalBgAni);
                this.horizontalBgAni = null;
                break;
            case EffectType_1.EffectType.VERTICAL:
                this.removeChild(this.verticalBgAni);
                Pool_1.Pool.recover(RecoverName_1.RecoverName.VERTICALBG_ANI, this.verticalBgAni);
                this.verticalBgAni = null;
                break;
            case EffectType_1.EffectType.EXPLOSIVE:
                this.removeChild(this.explosiveBgAni);
                Pool_1.Pool.recover(RecoverName_1.RecoverName.EXPLOSIVEBG_ANI, this.explosiveBgAni);
                FYGE.Tween.removeTweens(this.explosiveBgAni);
                FYGE.Tween.removeTweens(this.showImage);
                this.explosiveBgAni = null;
                break;
        }
    };
    Element.prototype.fallAni = function () {
        var oriY = this.y;
        FYGE.Tween.get(this, null, null, true)
            .to({ y: oriY + 4 }, 100)
            .to({ y: oriY }, 100);
    };
    Element.prototype.hasState = function (state) {
        return !!this.states[state];
    };
    Element.prototype.setState = function (state, set, data) {
        if (!set) {
            if (this.hasState(state)) {
                this.states[state].recover();
                this.states[state] = null;
                if (state == StateType_1.StateType.BUBBLE && this.effectType != EffectType_1.EffectType.MAGICLION)
                    this.showImage.alpha = 1;
            }
            else {
            }
        }
        else {
            if (this.hasState(state)) {
                this.states[state].reset(data);
            }
            else {
                var stateData = StateType_1.stateDatas[state];
                var recoverName = stateData.recoverName;
                var className = stateData.className;
                var stateEx = Pool_1.Pool.takeOut(recoverName);
                if (!stateEx) {
                    stateEx = new className(data);
                }
                else {
                    stateEx.reset(data);
                }
                this.states[state] = stateEx;
                this.addChild(this.states[state]);
                if (state === StateType_1.StateType.BUBBLE)
                    this.showImage.alpha = 0;
            }
        }
    };
    Element.prototype.hasAnyState = function () {
        for (var i = 0; i < this.states.length; i++) {
            if (this.states[i])
                return true;
        }
        return false;
    };
    Element.prototype.removeAllState = function () {
        for (var i = 0; i < this.states.length; i++) {
            var state = this.states[i];
            if (!state)
                continue;
            this.removeChild(state);
            Pool_1.Pool.recover(StateType_1.stateDatas[i].recoverName, state);
            this.states[i] = null;
        }
    };
    Element.prototype.getState = function (state) {
        return this.states[state];
    };
    Element.prototype.clone = function () {
        var ele = Tool_1.Tool.getElement(this.type);
        ele.effectType = this.effectType;
        for (var i = 0; i < this.states.length; i++) {
            var state = this.states[i];
            if (!state)
                continue;
            ele.setState(i, true, this.type);
        }
        ele.x = this.x;
        ele.y = this.y;
        return ele;
    };
    Element.prototype.copy = function (ele) {
        this.reset(ele.type);
        this.effectType = ele.effectType;
        for (var i = 0; i < ele.states.length; i++) {
            var state = ele.states[i];
            if (!state)
                continue;
            ele.setState(i, true, ele.type);
        }
    };
    Element.prototype.explosiveTween = function () {
        if (!this.explosiveBgAni)
            return;
        [this.explosiveBgAni, this.showImage].forEach(function (e) {
            e.y = 0;
            e.scaleY = 1;
            FYGE.Tween.get(e, { loop: true })
                .to({ y: -2 }, 100)
                .to({ y: 4 }, 200)
                .to({ y: 0 }, 200)
                .to({ y: -2 }, 100)
                .to({ y: 4 }, 200)
                .to({ y: 0 }, 200)
                .wait(1000);
            FYGE.Tween.get(e, { loop: true })
                .to({ scaleY: 0.95 }, 100)
                .to({ scaleY: 1 }, 100)
                .wait(300)
                .to({ scaleY: 0.95 }, 100)
                .to({ scaleY: 1 }, 100)
                .wait(1300);
        });
    };
    return Element;
}(FYGE.Container));
exports.Element = Element;
FYGE.FrameAni.prototype.resetTexturesAll = function (texturesAll) {
    this.texturesAll = texturesAll;
    this.currentFrame = 0;
    this.frameRate = 30;
};


/***/ }),

/***/ "./src/something/class/FestivalEle.ts":
/*!********************************************!*\
  !*** ./src/something/class/FestivalEle.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.FestivalEle = void 0;
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var FestivalEle = (function (_super) {
    __extends(FestivalEle, _super);
    function FestivalEle(n) {
        if (n === void 0) { n = 2; }
        var _this = _super.call(this) || this;
        var status3 = new Status3();
        _this.addChild(status3);
        var status2 = new Status2();
        _this.addChild(status2);
        var status1 = new Status1();
        _this.addChild(status1);
        _this.toggleStatus(n);
        _this.isActive = false;
        _this._statusNum = n;
        return _this;
    }
    Object.defineProperty(FestivalEle.prototype, "statusNum", {
        get: function () {
            return this._statusNum;
        },
        set: function (value) {
            var _this = this;
            if (value >= 0) {
                var child = this.children[this._statusNum];
                child["play"](function () {
                    _this.toggleStatus(value);
                });
                this._statusNum = value;
            }
            else {
                this._statusNum = 0;
                this.isActive = true;
            }
        },
        enumerable: false,
        configurable: true
    });
    FestivalEle.prototype.reset = function (n) {
        if (n === void 0) { n = 2; }
        this.toggleStatus(n);
        this.isActive = false;
        this._statusNum = n;
    };
    FestivalEle.prototype.toggleStatus = function (index) {
        for (var i = 0; i < this.children.length; i++) {
            var child = this.children[i];
            if (i == index) {
                child.visible = true;
                child["reset"]();
            }
            else {
                child.visible = false;
            }
        }
    };
    return FestivalEle;
}(FYGE.Container));
exports.FestivalEle = FestivalEle;
var Status1 = (function (_super) {
    __extends(Status1, _super);
    function Status1() {
        var _this = _super.call(this) || this;
        var textureDown = RES_1.RES.getRes("fesRedBombSta1.png");
        var down = new FYGE.Sprite(textureDown);
        down.x = -textureDown.width / 2;
        down.y = -textureDown.height / 2;
        _this.addChild(down);
        var textureUp = RES_1.RES.getRes("xingxingbi.png");
        var up = new FYGE.Sprite(textureUp);
        up.anchorTexture.set(0.5, 0.5);
        up.y = textureUp.height / 2 - 100;
        _this.addChild(up);
        _this.upImage = up;
        _this.scaleX = _this.scaleY = 0.29;
        return _this;
    }
    Status1.prototype.reset = function () {
        this.upImage.scaleX = this.upImage.scaleY = 1;
    };
    Status1.prototype.play = function (callback) {
        FYGE.Tween.get(this.upImage)
            .to({ scaleX: 1.8, scaleY: 1.8 }, 240)
            .call(function () {
            callback();
        });
    };
    return Status1;
}(FYGE.Container));
var status2Cfg = [
    {
        "name": "fesRedCap",
        "x": -7,
        "y": -6,
        "width": 251,
        "height": 104
    },
    {
        "name": "fesRedSmallLight",
        "x": -7,
        "y": -14,
        "width": 249,
        "height": 159
    },
    {
        "name": "fesRedUp",
        "x": -2,
        "y": 52,
        "width": 237,
        "height": 185
    },
    {
        "name": "fesRedDown",
        "x": -2,
        "y": 0,
        "width": 237,
        "height": 237
    }
];
var Status2 = (function (_super) {
    __extends(Status2, _super);
    function Status2() {
        var _this = _super.call(this) || this;
        _this.scaleX = _this.scaleY = 0.29;
        for (var i = status2Cfg.length - 1; i >= 0; i--) {
            var bitmap = new FYGE.Sprite(RES_1.RES.getRes(status2Cfg[i].name + ".png"));
            bitmap.x = status2Cfg[i].x - 237 / 2;
            bitmap.y = status2Cfg[i].y - 237 / 2;
            _this.addChild(bitmap);
            if (status2Cfg[i].name == "fesRedSmallLight") {
                _this.light = bitmap;
            }
            else if (status2Cfg[i].name == "fesRedCap") {
                _this.fesRedCap = bitmap;
            }
        }
        return _this;
    }
    Status2.prototype.reset = function () {
        this.fesRedCap.scaleY = 1;
        this.light.alpha = 1;
        FYGE.Tween.get(this.light, { loop: true })
            .to({ alpha: 0 }, 450)
            .to({ alpha: 1 }, 450);
    };
    Status2.prototype.play = function (callback) {
        this.light.alpha = 0;
        FYGE.Tween.removeTweens(this.light);
        this.fesRedCap.scaleY = 1;
        FYGE.Tween.get(this.fesRedCap)
            .to({ scaleY: 0.1 }, 180)
            .call(function () {
            callback();
        });
    };
    return Status2;
}(FYGE.Container));
var status3Cfg = [
    {
        "name": "fesRedUp",
        "x": 0,
        "y": 52,
        "width": 237,
        "height": 185
    },
    {
        "name": "tinyRedMid",
        "x": 86,
        "y": 60,
        "width": 74,
        "height": 90
    },
    {
        "name": "tinyRedLeft",
        "x": 22,
        "y": 5,
        "width": 116,
        "height": 132
    },
    {
        "name": "tinyRedRight",
        "x": 123,
        "y": 14,
        "width": 89,
        "height": 106
    },
    {
        "name": "fesRedDown",
        "x": 0,
        "y": 0,
        "width": 237,
        "height": 237
    }
];
var Status3 = (function (_super) {
    __extends(Status3, _super);
    function Status3() {
        var _this = _super.call(this) || this;
        _this.scaleX = _this.scaleY = 0.29;
        for (var i = status3Cfg.length - 1; i >= 0; i--) {
            var config = status3Cfg[i];
            var bitmap = new FYGE.Sprite(RES_1.RES.getRes(config.name + ".png"));
            bitmap.x = config.x - 237 / 2;
            bitmap.y = config.y - 237 / 2;
            _this.addChild(bitmap);
            if (config.name == "tinyRedMid") {
                _this.midRed = bitmap;
            }
            else if (config.name == "tinyRedLeft") {
                _this.leftRed = bitmap;
            }
            else if (config.name == "tinyRedRight") {
                _this.rightRed = bitmap;
            }
        }
        return _this;
    }
    Status3.prototype.reset = function () {
        var _this = this;
        FYGE.Tween.removeTweens(this.leftRed);
        FYGE.Tween.removeTweens(this.rightRed);
        FYGE.Tween.removeTweens(this.midRed);
        var offset = 237 / 2;
        this.leftRed.x = 22 + 40 - offset;
        this.leftRed.y = 5 + 100 - offset;
        FYGE.Tween.get(this.leftRed)
            .to({ x: 22 - 3 - offset, y: 5 - 8 - offset }, 150)
            .to({ x: 22 - offset, y: 5 - offset }, 50);
        this.rightRed.x = 123 - 7 - offset;
        this.rightRed.y = 14 + 100 - offset;
        FYGE.Tween.get(this.rightRed)
            .to({ x: 123 + 3 - offset, y: 14 - 8 - offset }, 150)
            .to({ x: 123 - offset, y: 14 - offset }, 50);
        this.midRed.x = 86 - 7 - offset;
        this.midRed.y = 60 + 80 - offset;
        FYGE.Tween.get(this.midRed)
            .to({ x: 86 + 3 - offset, y: 60 - 8 - offset }, 150)
            .to({ x: 86 - offset, y: 60 - offset }, 50)
            .call(function () {
            _this.leftRed.x = 22 - offset;
            _this.leftRed.y = 5 - offset;
            FYGE.Tween.get(_this.leftRed, { loop: true })
                .to({ x: 22 + 2 - offset, y: 5 + 5 - offset }, 150)
                .to({ x: 22 - 6 - offset, y: 5 - 14 - offset }, 150)
                .to({ x: 22 - offset, y: 5 - offset }, 100)
                .wait(500);
            _this.rightRed.x = 123 - offset;
            _this.rightRed.y = 14 - offset;
            FYGE.Tween.get(_this.rightRed, { loop: true })
                .to({ x: 123 - 2 - offset, y: 14 + 5 - offset }, 150)
                .to({ x: 123 + 6 - offset, y: 14 - 14 - offset }, 150)
                .to({ x: 123 - offset, y: 14 - offset }, 100)
                .wait(500);
            _this.midRed.x = 86 - offset;
            _this.midRed.y = 60 - offset;
            FYGE.Tween.get(_this.midRed, { loop: true })
                .to({ x: 86 - 2 - offset, y: 60 + 5 - offset }, 150)
                .to({ x: 86 + 6 - offset, y: 60 - 14 - offset }, 150)
                .to({ x: 86 - offset, y: 60 - offset }, 100)
                .wait(500);
        });
    };
    Status3.prototype.play = function (callback) {
    };
    return Status3;
}(FYGE.Container));


/***/ }),

/***/ "./src/something/class/Ice.ts":
/*!************************************!*\
  !*** ./src/something/class/Ice.ts ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ice = void 0;
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Ice = (function (_super) {
    __extends(Ice, _super);
    function Ice(n) {
        if (n === void 0) { n = 2; }
        var _this = _super.call(this) || this;
        var texture = RES_1.RES.getRes("ele" + ElementType_1.ElementType.ICE + ".png");
        _this.texture = texture;
        _this.anchorTexture.set(0.5, 0.5);
        if (n == 2) {
            _this.alpha = 1;
        }
        else {
            _this.alpha = 0.75;
        }
        _this._countNum = n;
        return _this;
    }
    Object.defineProperty(Ice.prototype, "countNum", {
        get: function () {
            return this._countNum;
        },
        set: function (value) {
            this._countNum = value;
            if (value == 2) {
                this.alpha = 1;
            }
            else {
                this.alpha = 0.75;
            }
        },
        enumerable: false,
        configurable: true
    });
    Ice.prototype.reset = function (n) {
        if (n === void 0) { n = 2; }
        this.scaleX = this.scaleY = 1;
        if (n == 2) {
            this.alpha = 1;
        }
        else {
            this.alpha = 0.75;
        }
        this._countNum = n;
    };
    return Ice;
}(FYGE.Sprite));
exports.Ice = Ice;


/***/ }),

/***/ "./src/something/class/Lattice.ts":
/*!****************************************!*\
  !*** ./src/something/class/Lattice.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Lattice = void 0;
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var Lattice = (function () {
    function Lattice(index) {
        this.index = index;
        var rc = Tool_1.Tool.indexToRc(index);
        this.row = rc[0];
        this.column = rc[1];
        this.ice = null;
        this.element = null;
        this.up = null;
        this.down = null;
        this.isGenerate = false;
    }
    Object.defineProperty(Lattice.prototype, "doorClosed", {
        get: function () {
            return !!(this.door && this.door.closed);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Lattice.prototype, "element", {
        get: function () {
            return this._element;
        },
        set: function (value) {
            if (value) {
                value.index = this.index;
                value.row = this.row;
                value.column = this.column;
            }
            this._element = value;
        },
        enumerable: false,
        configurable: true
    });
    Lattice.prototype.reset = function (index) {
        this.index = index;
        var rc = Tool_1.Tool.indexToRc(index);
        this.row = rc[0];
        this.column = rc[1];
        this.ice = null;
        this.door = null;
        this.element = null;
        this.up = null;
        this.down = null;
        this.isGenerate = false;
    };
    return Lattice;
}());
exports.Lattice = Lattice;


/***/ }),

/***/ "./src/something/class/RectMask.ts":
/*!*****************************************!*\
  !*** ./src/something/class/RectMask.ts ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.RectMask = void 0;
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RectMask = (function (_super) {
    __extends(RectMask, _super);
    function RectMask() {
        var _this = _super.call(this) || this;
        _this.beginFill(0xff0000, 1);
        _this.drawRect(-Tool_1.Tool.width / 2, -Tool_1.Tool.height / 2, Tool_1.Tool.width, Tool_1.Tool.height);
        _this.endFill();
        return _this;
    }
    RectMask.prototype.recover = function () {
        if (this.parent) {
            this.parent.removeChild(this);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.RECT_MASK, this);
        }
    };
    return RectMask;
}(FYGE.Shape));
exports.RectMask = RectMask;


/***/ }),

/***/ "./src/something/class/State.ts":
/*!**************************************!*\
  !*** ./src/something/class/State.ts ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.State = void 0;
var State = (function (_super) {
    __extends(State, _super);
    function State() {
        var _this = _super.call(this) || this;
        _this.mouseEnable = false;
        _this.mouseChildren = false;
        return _this;
    }
    State.prototype.reset = function (data) {
    };
    State.prototype.recover = function () {
    };
    return State;
}(FYGE.Container));
exports.State = State;


/***/ }),

/***/ "./src/something/enum/EffectType.ts":
/*!******************************************!*\
  !*** ./src/something/enum/EffectType.ts ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.EffectType = void 0;
var EffectType;
(function (EffectType) {
    EffectType[EffectType["HORIZONTAL"] = 0] = "HORIZONTAL";
    EffectType[EffectType["VERTICAL"] = 1] = "VERTICAL";
    EffectType[EffectType["EXPLOSIVE"] = 2] = "EXPLOSIVE";
    EffectType[EffectType["MAGICLION"] = 3] = "MAGICLION";
})(EffectType = exports.EffectType || (exports.EffectType = {}));


/***/ }),

/***/ "./src/something/enum/ElementType.ts":
/*!*******************************************!*\
  !*** ./src/something/enum/ElementType.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.FiveBaseElementTypes = exports.ElementType = void 0;
var ElementType;
(function (ElementType) {
    ElementType[ElementType["RABBIT"] = 0] = "RABBIT";
    ElementType[ElementType["CHICKEN"] = 1] = "CHICKEN";
    ElementType[ElementType["CATTLE"] = 2] = "CATTLE";
    ElementType[ElementType["LION"] = 3] = "LION";
    ElementType[ElementType["PIG"] = 4] = "PIG";
    ElementType[ElementType["ROCK"] = 5] = "ROCK";
    ElementType[ElementType["LOLLIPOP"] = 6] = "LOLLIPOP";
    ElementType[ElementType["JELLY"] = 7] = "JELLY";
    ElementType[ElementType["CHICKEN_EGG"] = 8] = "CHICKEN_EGG";
    ElementType[ElementType["ICE"] = 9] = "ICE";
    ElementType[ElementType["HAIRBALLGREY"] = 10] = "HAIRBALLGREY";
    ElementType[ElementType["HAIRBALLBROWN"] = 11] = "HAIRBALLBROWN";
    ElementType[ElementType["HAIRBALLBLACK"] = 12] = "HAIRBALLBLACK";
    ElementType[ElementType["FESTIVALELE_BIG"] = 13] = "FESTIVALELE_BIG";
    ElementType[ElementType["FESTIVALELE_SMALL"] = 14] = "FESTIVALELE_SMALL";
})(ElementType = exports.ElementType || (exports.ElementType = {}));
exports.FiveBaseElementTypes = [
    ElementType.RABBIT,
    ElementType.CHICKEN,
    ElementType.CATTLE,
    ElementType.LION,
    ElementType.PIG,
];


/***/ }),

/***/ "./src/something/enum/PassType.ts":
/*!****************************************!*\
  !*** ./src/something/enum/PassType.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.PassType = void 0;
var PassType;
(function (PassType) {
    PassType[PassType["SCORE_TARGET"] = 0] = "SCORE_TARGET";
    PassType[PassType["ELEMENT_TARGET"] = 1] = "ELEMENT_TARGET";
})(PassType = exports.PassType || (exports.PassType = {}));


/***/ }),

/***/ "./src/something/enum/PropType.ts":
/*!****************************************!*\
  !*** ./src/something/enum/PropType.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.PropType = void 0;
var PropType;
(function (PropType) {
    PropType["STEPS"] = "steps";
    PropType["BOOMS"] = "booms";
    PropType["HAMMERS"] = "hammers";
    PropType["POWER"] = "power";
})(PropType = exports.PropType || (exports.PropType = {}));


/***/ }),

/***/ "./src/something/enum/RecoverName.ts":
/*!*******************************************!*\
  !*** ./src/something/enum/RecoverName.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.RecoverName = void 0;
var RecoverName;
(function (RecoverName) {
    RecoverName["ELEMENT"] = "Element";
    RecoverName["LATTICE"] = "Lattice";
    RecoverName["ICE"] = "Ice";
    RecoverName["DOOR"] = "Door";
    RecoverName["BITMAP_NUMBER"] = "BitmapNumber";
    RecoverName["SCORE_NUMBER"] = "ScoreNumber";
    RecoverName["SCORE_ANI"] = "ScoreAni";
    RecoverName["BITMAPRECYCLE"] = "BitmapRecycle";
    RecoverName["FRAME_ANI"] = "FrameAni";
    RecoverName["BONUSSHOOT_ANI"] = "BonusShootAni";
    RecoverName["JELLYSPREAD_ANI"] = "JellySpreadAni";
    RecoverName["PIECETOEGG_ANI"] = "PieceToEggAni";
    RecoverName["BUBBLE_ANI"] = "BubbleAni";
    RecoverName["HAIRBALLBROWNDIVIDE_ANI"] = "HairballBrownDivideAni";
    RecoverName["HAIRBALLJUMP_ANI"] = "HairballJumpAni";
    RecoverName["FESREDBOMBSHOW_ANI"] = "FesRedBombShowAni";
    RecoverName["FESREDSHOOT_ANI"] = "FesRedShootAni";
    RecoverName["DOORCHANGE_ANI"] = "DoorChangeAni";
    RecoverName["MAGICLIONBG_ANI"] = "MagicLionBgAni";
    RecoverName["HORIZONTALBG_ANI"] = "HorizontalBgAni";
    RecoverName["VERTICALBG_ANI"] = "VerticalBgAni";
    RecoverName["EXPLOSIVEBG_ANI"] = "ExplosiveBgAni";
    RecoverName["CHICKEN_EGG"] = "ChickenEgg";
    RecoverName["FESTIVAL_ELE"] = "FestivalEle";
    RecoverName["ROCK_ANI"] = "RockAni";
    RecoverName["ICE_ANI"] = "IceAni";
    RecoverName["BOOM_ANI"] = "BoomAni";
    RecoverName["HORIZONTAL_ANI"] = "HorizontalAni";
    RecoverName["VERTICAL_ANI"] = "VerticalAni";
    RecoverName["CROSS_ANI"] = "CrossAni";
    RecoverName["THREECROSS_ANI"] = "ThreeCrossAni";
    RecoverName["MAGICLION_ANI"] = "MagicLionAni";
    RecoverName["STEP_ANI"] = "StepAni";
    RecoverName["JELLYDIS_ANI"] = "JellyDisAni";
    RecoverName["EGGBROKEN_ANI"] = "EggBrokenAni";
    RecoverName["HAIRBALLGREYDIS_ANI"] = "HairballGreyDisAni";
    RecoverName["HAIRBALLBLACKDIS_ANI"] = "HairballBlackDisAni";
    RecoverName["RECT_MASK"] = "RectMask";
    RecoverName["LOCK_STATE"] = "LockState";
    RecoverName["BUBBLE_STATE"] = "BubbleState";
    RecoverName["HAIRBALLGREY_STATE"] = "HairballGreyState";
    RecoverName["HAIRBALLBLACK_STATE"] = "HairballBlackState";
    RecoverName["HAIRBALLBROWN_STATE"] = "HairballBrownState";
})(RecoverName = exports.RecoverName || (exports.RecoverName = {}));


/***/ }),

/***/ "./src/something/enum/StateType.ts":
/*!*****************************************!*\
  !*** ./src/something/enum/StateType.ts ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.stateDatas = exports.StateType = void 0;
var RecoverName_1 = __webpack_require__(/*! ./RecoverName */ "./src/something/enum/RecoverName.ts");
var BubbleState_1 = __webpack_require__(/*! ../states/BubbleState */ "./src/something/states/BubbleState.ts");
var LockState_1 = __webpack_require__(/*! ../states/LockState */ "./src/something/states/LockState.ts");
var HairballGreyState_1 = __webpack_require__(/*! ../states/HairballGreyState */ "./src/something/states/HairballGreyState.ts");
var HairballBrownState_1 = __webpack_require__(/*! ../states/HairballBrownState */ "./src/something/states/HairballBrownState.ts");
var HairballBlackState_1 = __webpack_require__(/*! ../states/HairballBlackState */ "./src/something/states/HairballBlackState.ts");
var StateType;
(function (StateType) {
    StateType[StateType["BUBBLE"] = 0] = "BUBBLE";
    StateType[StateType["LOCK"] = 1] = "LOCK";
    StateType[StateType["HAIRBALLGREY"] = 2] = "HAIRBALLGREY";
    StateType[StateType["HAIRBALLBROWN"] = 3] = "HAIRBALLBROWN";
    StateType[StateType["HAIRBALLBLACK"] = 4] = "HAIRBALLBLACK";
})(StateType = exports.StateType || (exports.StateType = {}));
exports.stateDatas = [
    { recoverName: RecoverName_1.RecoverName.BUBBLE_STATE, className: BubbleState_1.BubbleState },
    { recoverName: RecoverName_1.RecoverName.LOCK_STATE, className: LockState_1.LockState },
    { recoverName: RecoverName_1.RecoverName.HAIRBALLGREY_STATE, className: HairballGreyState_1.HairballGreyState },
    { recoverName: RecoverName_1.RecoverName.HAIRBALLBROWN_STATE, className: HairballBrownState_1.HairballBrownState },
    { recoverName: RecoverName_1.RecoverName.HAIRBALLBLACK_STATE, className: HairballBlackState_1.HairballBlackState },
];


/***/ }),

/***/ "./src/something/interface/FallAniData.ts":
/*!************************************************!*\
  !*** ./src/something/interface/FallAniData.ts ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.FallType = void 0;
var FallType;
(function (FallType) {
    FallType[FallType["STRIGHT"] = 0] = "STRIGHT";
    FallType[FallType["THROUGH"] = 1] = "THROUGH";
})(FallType = exports.FallType || (exports.FallType = {}));


/***/ }),

/***/ "./src/something/logic/AiControl.ts":
/*!******************************************!*\
  !*** ./src/something/logic/AiControl.ts ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.AiControl = exports.fesELeSmallNum = void 0;
var JellySpreadAni_1 = __webpack_require__(/*! ../anis/JellySpreadAni */ "./src/something/anis/JellySpreadAni.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var HatchAni_1 = __webpack_require__(/*! ../anis/HatchAni */ "./src/something/anis/HatchAni.ts");
var PieceToEggAni_1 = __webpack_require__(/*! ../anis/PieceToEggAni */ "./src/something/anis/PieceToEggAni.ts");
var StateType_1 = __webpack_require__(/*! ../enum/StateType */ "./src/something/enum/StateType.ts");
var BubbleAni_1 = __webpack_require__(/*! ../anis/BubbleAni */ "./src/something/anis/BubbleAni.ts");
var HairballJumpAni_1 = __webpack_require__(/*! ../anis/HairballJumpAni */ "./src/something/anis/HairballJumpAni.ts");
var HairballBrownDivideAni_1 = __webpack_require__(/*! ../anis/HairballBrownDivideAni */ "./src/something/anis/HairballBrownDivideAni.ts");
var MagicRotateAni_1 = __webpack_require__(/*! ../anis/MagicRotateAni */ "./src/something/anis/MagicRotateAni.ts");
var FesRedShootAni_1 = __webpack_require__(/*! ../anisCall/FesRedShootAni */ "./src/something/anisCall/FesRedShootAni.ts");
var DoorChangeAni_1 = __webpack_require__(/*! ../anisCall/DoorChangeAni */ "./src/something/anisCall/DoorChangeAni.ts");
var chickenNum = 4;
exports.fesELeSmallNum = 6;
var AiControl = (function () {
    function AiControl() {
    }
    Object.defineProperty(AiControl, "ins", {
        get: function () {
            return AiControl._ins || (AiControl._ins = new AiControl());
        },
        enumerable: false,
        configurable: true
    });
    AiControl.prototype.init = function (lattices) {
        this.hasJelly = judgeJellyExist(lattices);
        this.hasHairball = judgeHairballExist(lattices);
        this.eggs = getEggs(lattices);
        this.hasFesEleBig = judgeFesEleBigExist(lattices);
        this.doors = getDoors(lattices);
    };
    AiControl.prototype.doorMotion = function (thisObj, callback) {
        if (!this.doors.length || !thisObj.isMouseAction) {
            callback();
            return;
        }
        thisObj.isMouseAction = false;
        var activeDoorIndexs = [];
        for (var i = 0; i < this.doors.length; i++) {
            var index = this.doors[i];
            var door = thisObj.lattices[index].door;
            door.statusNum--;
            if (door.isActive)
                activeDoorIndexs.push(index);
        }
        if (!activeDoorIndexs.length) {
            callback();
            return;
        }
        var count = 0;
        var countAll = activeDoorIndexs.length;
        var _loop_1 = function () {
            var index_1 = activeDoorIndexs[i];
            var lat = thisObj.lattices[index_1];
            if (!lat.element) {
                if (!lat.door.closed) {
                    Tool_1.Tool.removeEle(index_1, thisObj.emptys);
                }
                else {
                    thisObj.emptys.push(index_1);
                }
            }
            var doorChangeAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.DOORCHANGE_ANI);
            if (!doorChangeAni) {
                doorChangeAni = new DoorChangeAni_1.DoorChangeAni(lat);
            }
            thisObj.addChild(doorChangeAni);
            lat.door.visible = false;
            if (lat.ice)
                lat.ice.visible = false;
            if (lat.element)
                lat.element.visible = false;
            doorChangeAni.play(lat, function () {
                lat.door.visible = true;
                if (!lat.door.closed) {
                    if (lat.ice)
                        lat.ice.visible = true;
                    if (lat.element)
                        lat.element.visible = true;
                }
                if (++count == countAll) {
                    setTimeout(function () {
                        thisObj.fall(function () {
                            thisObj.fallCallback();
                        });
                    }, 200);
                }
            });
            lat.door.closed = !lat.door.closed;
            lat.door.isActive = false;
        };
        for (var i = 0; i < activeDoorIndexs.length; i++) {
            _loop_1();
        }
    };
    AiControl.prototype.fesEleMotion = function (thisObj, callback) {
        if (!this.hasFesEleBig) {
            callback();
            return;
        }
        var indexs = [];
        for (var i = 0; i < thisObj.lattices.length; i++) {
            var lat = thisObj.lattices[i];
            if (lat &&
                lat.element &&
                lat.element.type == ElementType_1.ElementType.FESTIVALELE_BIG) {
                indexs.push(i);
            }
        }
        if (!indexs.length) {
            this.hasFesEleBig = false;
            callback();
            return;
        }
        if (thisObj.lattices[indexs[0]].doorClosed) {
            callback();
            return;
        }
        if (!thisObj.lattices[indexs[0]].element.festivalEle.isActive) {
            callback();
            return;
        }
        var redIndexs = [];
        for (var a = 0; a < thisObj.lattices.length; a++) {
            var lat = thisObj.lattices[a];
            if (Tool_1.Tool.judgeBaseEle(lat) &&
                !lat.element.hasAnyState() &&
                !lat.doorClosed) {
                redIndexs.push(a);
            }
        }
        redIndexs.sort(function () { return (0.5 - Math.random()); });
        var six = redIndexs.splice(0, exports.fesELeSmallNum);
        if (six.length < exports.fesELeSmallNum) {
            thisObj.festivalTargetNum = exports.fesELeSmallNum;
            thisObj.festivalTarget.count = exports.fesELeSmallNum;
            if (!six.length) {
                callback();
                return;
            }
        }
        for (var i = 0; i < six.length; i++)
            six[i] = { index: six[i] };
        var index = indexs[0];
        var p = Tool_1.Tool.getPositionByIndex(index);
        var vec0 = [1, 0];
        for (var i = 0; i < six.length; i++) {
            var po = Tool_1.Tool.getPositionByIndex(six[i].index);
            var deltaX = po[0] - p[0];
            var deltaY = po[1] - p[1];
            var vec1 = [deltaX, deltaY];
            var rotation = MagicRotateAni_1.getRotByTwoVectors(vec0, vec1);
            if (deltaY > 0)
                rotation = Math.PI * 2 - rotation;
            six[i].rotation = rotation;
        }
        six.sort(function (a, b) { return b.rotation - a.rotation; });
        for (var i = 0; i < six.length; i++)
            six[i] = six[i].index;
        thisObj.redBombLightAni(index, function () {
            var count = 0;
            var countAll = six.length;
            var _loop_2 = function (a_1) {
                var endIndex = six[a_1];
                var lat_1 = thisObj.lattices[endIndex];
                var ele = lat_1.element;
                var fesRedShootAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.FESREDSHOOT_ANI);
                if (!fesRedShootAni)
                    fesRedShootAni = new FesRedShootAni_1.FesRedShootAni();
                setTimeout(function () {
                    thisObj.addChild(fesRedShootAni);
                    fesRedShootAni.play(p, ele, function () {
                        if (++count == countAll) {
                            thisObj.removeOperation(index);
                            thisObj.fall(function () {
                                thisObj.fallCallback();
                            });
                        }
                    });
                }, 100 * a_1);
            };
            for (var a_1 = 0; a_1 < six.length; a_1++) {
                _loop_2(a_1);
            }
        });
    };
    AiControl.prototype.jellyMotion = function (thisObj, callback) {
        if (!this.hasJelly || thisObj.jellyBrokenMark) {
            callback();
            thisObj.jellyBrokenMark = false;
            return;
        }
        thisObj.jellyBrokenMark = false;
        var indexs = [];
        for (var i = 0; i < thisObj.lattices.length; i++) {
            var lattice = thisObj.lattices[i];
            if (!lattice || !lattice.element || lattice.element.type != ElementType_1.ElementType.JELLY)
                continue;
            indexs.push(i);
        }
        if (!indexs.length) {
            this.hasJelly = false;
            callback();
            return;
        }
        indexs = indexs.filter(function (s) { return !thisObj.lattices[s].doorClosed; });
        var spread;
        while (indexs.length) {
            var rand = Math.floor(Math.random() * indexs.length);
            var randIndex = indexs.splice(rand, 1)[0];
            var index = judgeActionIndex(randIndex, thisObj.lattices);
            if (index != null) {
                spread = [randIndex, index];
                break;
            }
        }
        if (!spread) {
            callback();
            return;
        }
        var jellySpreadAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.JELLYSPREAD_ANI);
        if (!jellySpreadAni) {
            jellySpreadAni = new JellySpreadAni_1.JellySpreadAni();
        }
        thisObj.addChild(jellySpreadAni);
        var fromEle = thisObj.lattices[spread[0]].element;
        var endEle = thisObj.lattices[spread[1]].element;
        var cloneEle = endEle.clone();
        endEle.reset(ElementType_1.ElementType.JELLY);
        fromEle.visible = false;
        endEle.visible = false;
        jellySpreadAni.play(Tool_1.Tool.getPositionByIndex(spread[0]), cloneEle, function () {
            fromEle.visible = true;
            endEle.visible = true;
            callback();
        });
    };
    AiControl.prototype.eggMotion = function (thisObj, callback) {
        if (!this.eggs.length) {
            callback();
            return;
        }
        var activeEggIndexs = [];
        for (var i = 0; i < this.eggs.length; i++) {
            var index = this.eggs[i];
            var egg = thisObj.lattices[index].element.chickenEgg;
            if (egg.isActive && !thisObj.lattices[index].doorClosed)
                activeEggIndexs.push(index);
        }
        if (!activeEggIndexs.length) {
            callback();
            return;
        }
        var chickenIndexs = [];
        for (var a = 0; a < thisObj.lattices.length; a++) {
            var lat = thisObj.lattices[a];
            if (Tool_1.Tool.judgeSetChicken(lat))
                chickenIndexs.push(a);
        }
        if (!chickenIndexs.length) {
            callback();
            return;
        }
        chickenIndexs.sort(function () {
            return (0.5 - Math.random());
        });
        var chickenIndexsCopy = chickenIndexs.slice();
        var countAll = activeEggIndexs.length;
        var count = 0;
        var _loop_3 = function () {
            var activeEggIndex = activeEggIndexs[b];
            var four = chickenIndexsCopy.splice(0, chickenNum);
            if (four.length < chickenNum) {
                four = four.concat(Tool_1.Tool.getRandomArrayElementsEx(chickenIndexs, chickenNum - four.length));
            }
            var activeEgg = thisObj.lattices[activeEggIndex].element.chickenEgg;
            activeEgg.visible = false;
            HatchAni_1.HatchAni(activeEggIndex, four, thisObj, function () {
                var pieceToEggAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.PIECETOEGG_ANI);
                if (!pieceToEggAni) {
                    pieceToEggAni = new PieceToEggAni_1.PieceToEggAni();
                }
                thisObj.addChild(pieceToEggAni);
                pieceToEggAni.play(Tool_1.Tool.getPositionByIndex(activeEggIndex), function () {
                    activeEgg.reset();
                    activeEgg.visible = true;
                });
                if (++count == countAll) {
                    setTimeout(function () {
                        if (thisObj.threeMatch()) {
                            thisObj.eliminate();
                        }
                        else {
                            callback();
                        }
                    }, 200);
                }
            });
        };
        for (var b = 0; b < activeEggIndexs.length; b++) {
            _loop_3();
        }
    };
    AiControl.prototype.bubbleMotion = function (thisObj, callback) {
        var indexs = [];
        for (var i = 0; i < thisObj.lattices.length; i++) {
            var lat = thisObj.lattices[i];
            if (Tool_1.Tool.judgeBaseEle(lat) &&
                lat.element.hasState(StateType_1.StateType.BUBBLE) &&
                !lat.doorClosed) {
                indexs.push(i);
            }
        }
        if (!indexs.length) {
            callback();
            return;
        }
        var count = 0;
        var countAll = indexs.length;
        var _loop_4 = function () {
            var index = indexs[a];
            var lat_2 = thisObj.lattices[index];
            var ele = lat_2.element;
            var fromType = ele.type;
            var type = getBubbleType(index, thisObj.lattices, thisObj.chapterData.baseElementTypes);
            ele.resetType(type);
            ele.visible = false;
            var bubbleAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.BUBBLE_ANI);
            if (!bubbleAni) {
                bubbleAni = new BubbleAni_1.BubbleAni();
            }
            p = Tool_1.Tool.getPositionByIndex(index);
            bubbleAni.x = p[0];
            bubbleAni.y = p[1];
            thisObj.elementContainer.addChild(bubbleAni);
            bubbleAni.play(fromType, type, function () {
                ele.visible = true;
                if (++count == countAll)
                    callback();
            });
        };
        var p;
        for (var a = 0; a < countAll; a++) {
            _loop_4();
        }
    };
    AiControl.prototype.hairballMotion = function (thisObj, callback) {
        if (!this.hasHairball) {
            callback();
            return;
        }
        var jumpBallIndexs = [];
        var awakeBallIndexs = [];
        var divideBallIndexs = [];
        for (var i = 0; i < thisObj.lattices.length; i++) {
            var lat = thisObj.lattices[i];
            if (Tool_1.Tool.judgeBaseEle(lat) && !lat.doorClosed) {
                if (lat.element.hasState(StateType_1.StateType.HAIRBALLGREY)) {
                    jumpBallIndexs.push({ type: StateType_1.StateType.HAIRBALLGREY, index: i });
                }
                if (lat.element.hasState(StateType_1.StateType.HAIRBALLBLACK)) {
                    if (lat.element.getState(StateType_1.StateType.HAIRBALLBLACK).isAwake) {
                        jumpBallIndexs.push({ type: StateType_1.StateType.HAIRBALLBLACK, index: i });
                    }
                    else {
                        awakeBallIndexs.push(i);
                    }
                }
                if (lat.element.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
                    if (lat.element.getState(StateType_1.StateType.HAIRBALLBROWN).isActive) {
                        divideBallIndexs.push(i);
                    }
                    else {
                        jumpBallIndexs.push({ type: StateType_1.StateType.HAIRBALLBROWN, index: i });
                    }
                }
                ;
            }
        }
        if (!jumpBallIndexs.length && !awakeBallIndexs.length && !divideBallIndexs.length) {
            this.hasHairball = false;
            callback();
            return;
        }
        var count = 0;
        var countAll = (jumpBallIndexs.length ? 1 : 0) + (awakeBallIndexs.length ? 1 : 0) + (divideBallIndexs.length ? 1 : 0);
        var callbackOperation = function () {
            if (++count == countAll) {
                setTimeout(function () {
                    if (thisObj.threeMatch()) {
                        thisObj.eliminate();
                    }
                    else {
                        callback();
                    }
                }, 200);
            }
        };
        this.divideAni(thisObj, divideBallIndexs, callbackOperation);
        this.jumpAni(thisObj, jumpBallIndexs, callbackOperation);
        this.awakeAni(thisObj, awakeBallIndexs, callbackOperation);
    };
    AiControl.prototype.divideAni = function (thisObj, indexs, callback) {
        var count = 0;
        var countAll = indexs.length;
        var _loop_5 = function () {
            var indexFrom = indexs[a];
            var elementFrom = thisObj.lattices[indexFrom].element;
            var indexEnd = judgeActionIndex(indexFrom, thisObj.lattices);
            if (indexEnd != null) {
                elementFrom.setState(StateType_1.StateType.HAIRBALLBROWN, false);
                elementFrom.setState(StateType_1.StateType.HAIRBALLGREY, true);
                var elementEnd_1 = thisObj.lattices[indexEnd].element;
                elementEnd_1.setState(StateType_1.StateType.HAIRBALLGREY, true);
                elementFrom.getState(StateType_1.StateType.HAIRBALLGREY).visible = false;
                elementEnd_1.getState(StateType_1.StateType.HAIRBALLGREY).visible = false;
                var divideAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.HAIRBALLBROWNDIVIDE_ANI);
                if (!divideAni)
                    divideAni = new HairballBrownDivideAni_1.HairballBrownDivideAni();
                thisObj.addChild(divideAni);
                divideAni.play(Tool_1.Tool.getPositionByIndex(indexFrom), Tool_1.Tool.getPositionByIndex(indexEnd), function () {
                    elementFrom.getState(StateType_1.StateType.HAIRBALLGREY).visible = true;
                    elementEnd_1.getState(StateType_1.StateType.HAIRBALLGREY).visible = true;
                    if (++count == countAll)
                        callback();
                });
            }
            else {
                elementFrom.setState(StateType_1.StateType.HAIRBALLBROWN, false);
                elementFrom.setState(StateType_1.StateType.HAIRBALLGREY, true);
                elementFrom.getState(StateType_1.StateType.HAIRBALLGREY).visible = false;
                var divideAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.HAIRBALLBROWNDIVIDE_ANI);
                if (!divideAni)
                    divideAni = new HairballBrownDivideAni_1.HairballBrownDivideAni();
                thisObj.addChild(divideAni);
                divideAni.play(Tool_1.Tool.getPositionByIndex(indexFrom), Tool_1.Tool.getPositionByIndex(indexFrom), function () {
                    elementFrom.getState(StateType_1.StateType.HAIRBALLGREY).visible = true;
                    if (++count == countAll)
                        callback();
                });
            }
        };
        for (var a = 0; a < countAll; a++) {
            _loop_5();
        }
    };
    AiControl.prototype.jumpAni = function (thisObj, indexs, callback) {
        var count = 0;
        var countAll = indexs.length;
        var _loop_6 = function () {
            var data = indexs[a];
            var indexFrom = data.index;
            var elementFrom = thisObj.lattices[indexFrom].element;
            var stateType = data.type;
            var indexEnd = judgeActionIndex(indexFrom, thisObj.lattices);
            if (indexEnd != null) {
                elementFrom.setState(stateType, false);
                var elementEnd_2 = thisObj.lattices[indexEnd].element;
                elementEnd_2.setState(stateType, true);
                elementEnd_2.getState(stateType).visible = false;
                var jumpAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.HAIRBALLJUMP_ANI);
                if (!jumpAni)
                    jumpAni = new HairballJumpAni_1.HairballJumpAni();
                thisObj.addChild(jumpAni);
                jumpAni.play(stateType, Tool_1.Tool.getPositionByIndex(indexFrom), Tool_1.Tool.getPositionByIndex(indexEnd), function () {
                    elementEnd_2.getState(stateType).visible = true;
                    if (++count == countAll)
                        callback();
                });
            }
            else {
                if (++count == countAll)
                    callback();
            }
        };
        for (var a = 0; a < indexs.length; a++) {
            _loop_6();
        }
    };
    AiControl.prototype.awakeAni = function (thisObj, indexs, callback) {
        var count = 0;
        var countAll = indexs.length;
        for (var a = 0; a < indexs.length; a++) {
            var indexFrom = indexs[a];
            var elementFrom = thisObj.lattices[indexFrom].element;
            setTimeout(function () {
                if (++count == countAll)
                    callback();
            }, 200);
        }
    };
    return AiControl;
}());
exports.AiControl = AiControl;
function judgeJellyExist(lattices) {
    for (var i = 0; i < lattices.length; i++) {
        var lattice = lattices[i];
        if (!lattice || !lattice.element || lattice.element.type != ElementType_1.ElementType.JELLY)
            continue;
        return true;
    }
    return false;
}
function judgeHairballExist(lattices) {
    for (var i = 0; i < lattices.length; i++) {
        var lattice = lattices[i];
        if (Tool_1.Tool.judgeBaseEle(lattice) &&
            (lattice.element.hasState(StateType_1.StateType.HAIRBALLGREY) ||
                lattice.element.hasState(StateType_1.StateType.HAIRBALLBLACK) ||
                lattice.element.hasState(StateType_1.StateType.HAIRBALLBROWN)))
            return true;
    }
    return false;
}
function judgeFesEleBigExist(lattices) {
    for (var i = 0; i < lattices.length; i++) {
        var lattice = lattices[i];
        if (lattice &&
            lattice.element &&
            lattice.element.type == ElementType_1.ElementType.FESTIVALELE_BIG)
            return true;
    }
    return false;
}
function judgeBubbleExist(lattices) {
    for (var i = 0; i < lattices.length; i++) {
        var lattice = lattices[i];
        if (Tool_1.Tool.judgeBaseEle(lattice) && lattice.element.hasState(StateType_1.StateType.BUBBLE))
            return true;
    }
    return false;
}
function getEggs(lattices) {
    var arr = [];
    for (var i = 0; i < lattices.length; i++) {
        var lattice = lattices[i];
        if (lattice &&
            lattice.element &&
            lattice.element.type == ElementType_1.ElementType.CHICKEN_EGG) {
            arr.push(i);
        }
    }
    return arr;
}
function getDoors(lattices) {
    var arr = [];
    for (var i = 0; i < lattices.length; i++) {
        var lattice = lattices[i];
        if (lattice &&
            lattice.door) {
            arr.push(i);
        }
    }
    return arr;
}
function judgeActionIndex(index, lattices) {
    var arr = [index - Tool_1.Tool.colNum, index + Tool_1.Tool.colNum];
    var rc = Tool_1.Tool.indexToRc(index);
    var col = rc[1];
    if (col > 0)
        arr.push(index - 1);
    if (col < Tool_1.Tool.colNum - 1)
        arr.push(index + 1);
    while (arr.length) {
        var rand = Math.floor(Math.random() * arr.length);
        var i = arr.splice(rand, 1)[0];
        if (Tool_1.Tool.judgeAiActionDirection(lattices[i]))
            return i;
    }
    return null;
}
function getBubbleType(index, lattices, baseElementTypes) {
    var rc = Tool_1.Tool.indexToRc(index);
    var arr = baseElementTypes.slice();
    Tool_1.Tool.removeEle(lattices[index].element.type, arr);
    var operation = function (lat1, lat2) {
        if (Tool_1.Tool.judgeMatch(lat1) &&
            Tool_1.Tool.judgeMatch(lat2) &&
            lat1.element.type == lat2.element.type) {
            Tool_1.Tool.removeEle(lat1.element.type, arr);
        }
    };
    if (rc[1] > 1)
        operation(lattices[index - 1], lattices[index - 2]);
    if (rc[0] > 1)
        operation(lattices[index - Tool_1.Tool.colNum], lattices[index - Tool_1.Tool.colNum * 2]);
    if (rc[1] > 0 && rc[1] < Tool_1.Tool.colNum - 1) {
        var lat1 = lattices[index - 1];
        var lat2 = lattices[index + 1];
        if (Tool_1.Tool.judgeMatch(lat2) && !lat2.element.hasState(StateType_1.StateType.BUBBLE))
            operation(lat1, lat2);
    }
    if (rc[0] > 0 && rc[0] < Tool_1.Tool.rowNum - 1) {
        var lat1 = lattices[index - Tool_1.Tool.colNum];
        var lat2 = lattices[index + Tool_1.Tool.colNum];
        if (Tool_1.Tool.judgeMatch(lat2) && !lat2.element.hasState(StateType_1.StateType.BUBBLE))
            operation(lat1, lat2);
    }
    var operationAdd = function (lat1, lat2) {
        if (Tool_1.Tool.judgeMatch(lat1) &&
            Tool_1.Tool.judgeMatch(lat2) &&
            !lat1.element.hasState(StateType_1.StateType.BUBBLE) &&
            !lat2.element.hasState(StateType_1.StateType.BUBBLE) &&
            lat1.element.type == lat2.element.type) {
            Tool_1.Tool.removeEle(lat1.element.type, arr);
        }
    };
    if (rc[1] < Tool_1.Tool.colNum - 2)
        operationAdd(lattices[index + 1], lattices[index + 2]);
    if (rc[0] < Tool_1.Tool.colNum - 2)
        operationAdd(lattices[index + Tool_1.Tool.colNum], lattices[index + Tool_1.Tool.colNum * 2]);
    if (!arr.length)
        return lattices[index].element.type;
    return Tool_1.Tool.randomT(arr);
}


/***/ }),

/***/ "./src/something/logic/aaa.ts":
/*!************************************!*\
  !*** ./src/something/logic/aaa.ts ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.generateMapBg = exports.drawPoly = exports.drawShape = exports.drawBg = void 0;
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
function drawBg(paths, lattices) {
    var bg = drawShape(paths);
    var texture = RES_1.RES.getRes("rectLat.png");
    for (var m = 0; m < lattices.length; m++) {
        if (lattices[m]) {
            var rc = Tool_1.Tool.indexToRc(m);
            var p = Tool_1.Tool.getPositionByIndex(m);
            var img = new FYGE.Sprite(texture);
            img.x = p[0] - texture.width / 2;
            img.y = p[1] - texture.height / 2;
            img.width = 78;
            img.height = 78;
            bg.addChild(img);
        }
    }
    bg.updateShape();
    var bounds = bg.getLocalBounds();
    var w = bounds.width;
    var h = bounds.height;
    var x = bounds.x;
    var y = bounds.y;
    var _dCanvas = FYGE.createCanvas();
    _dCanvas.width = w;
    _dCanvas.height = h;
    var _dRender = new FYGE.CanvasRenderer(_dCanvas.getContext("2d"), w, h);
    bg.transform.updateLocalMatrix();
    var tempMatrix = new FYGE.Matrix();
    tempMatrix.copy(bg.transform.localMatrix);
    tempMatrix.invert();
    tempMatrix.tx -= x;
    tempMatrix.ty -= y;
    _dRender.render(bg, null, tempMatrix);
    var c = new FYGE.Container();
    c.addChild(new FYGE.Sprite(FYGE.Texture.fromCanvas(_dCanvas)))
        .position.set(x, y);
    return c;
}
exports.drawBg = drawBg;
function drawShape(paths) {
    var shape = new FYGE.Shape();
    shape.beginFill(0x111937, 1);
    for (var i = 0; i < paths.length; i++) {
        var path = paths[i];
        drawPoly(shape, path);
        for (var j = 0; j < path.holes.length; j++) {
            var hole = path.holes[j];
            drawPoly(shape, hole);
        }
        shape.endFill();
    }
    return shape;
}
exports.drawShape = drawShape;
function drawPoly(shape, path) {
    var firstFrom;
    for (var j = 0; j < path.points.length; j += 2) {
        var p = [path.points[j], path.points[j + 1]];
        var lastIndex = j == 0 ? path.points.length - 2 : j - 2;
        var pl = [path.points[lastIndex], path.points[lastIndex + 1]];
        var nextIndex = j == path.points.length - 2 ? 0 : j + 2;
        var pn = [path.points[nextIndex], path.points[nextIndex + 1]];
        var from, to;
        if (Math.abs(p[0] - pl[0]) < 0.1) {
            var d = p[1] - pl[1] < 0 ? 1 : -1;
            from = [p[0], p[1] + d * Tool_1.Tool.radius];
            var dt = p[0] - pn[0] < 0 ? 1 : -1;
            to = [p[0] + dt * Tool_1.Tool.radius, p[1]];
        }
        else {
            var d = p[0] - pl[0] < 0 ? 1 : -1;
            from = [p[0] + d * Tool_1.Tool.radius, p[1]];
            var dt = p[1] - pn[1] < 0 ? 1 : -1;
            to = [p[0], p[1] + dt * Tool_1.Tool.radius];
        }
        if (j == 0) {
            shape.moveTo(from[0], from[1]);
            shape.quadraticCurveTo(p[0], p[1], to[0], to[1]);
            firstFrom = [from[0], from[1]];
        }
        else {
            shape.lineTo(from[0], from[1]);
            shape.quadraticCurveTo(p[0], p[1], to[0], to[1]);
        }
    }
    shape.lineTo(firstFrom[0], firstFrom[1]);
}
exports.drawPoly = drawPoly;
var dis = {
    "l": -Tool_1.Tool.width / 2,
    "r": Tool_1.Tool.width / 2,
    "u": -Tool_1.Tool.height / 2,
    "d": Tool_1.Tool.height / 2,
};
function generateMapBg(lattices) {
    var vertexs = getVertexs(lattices);
    var paths = [];
    for (var i = 0; i < vertexs.length; i++) {
        if (vertexs[i].indexOf(1) > -1) {
            var p = Tool_1.Tool.getPositionByIndex10(i);
            var group = judgeInGroups(i, paths, vertexs[i]);
            if (group) {
                if (group.indexs10.indexOf(i) < 0) {
                    if (vertexs[i].indexOf(0) > -1) {
                        var hole = judgeOnGroups(i, group.holes, vertexs[i]);
                        if (hole) {
                            if (hole.indexs10.indexOf(i) < 0) {
                            }
                        }
                        else {
                            group.holes.push(beenLoop(i, vertexs));
                        }
                    }
                    else {
                    }
                }
            }
            else {
                paths.push(beenLoop(i, vertexs));
            }
        }
    }
    return paths;
}
exports.generateMapBg = generateMapBg;
function isPointIn(point, points) {
    var x = point[0];
    var y = point[1];
    var inside = false;
    var length = points.length / 2;
    for (var i = 0, j = length - 1; i < length; j = i++) {
        var xi = points[i * 2];
        var yi = points[(i * 2) + 1];
        var xj = points[j * 2];
        var yj = points[(j * 2) + 1];
        var intersect = ((yi > y) !== (yj > y)) && (x < ((xj - xi) * ((y - yi) / (yj - yi))) + xi);
        if (intersect) {
            inside = !inside;
        }
    }
    return inside;
}
function judgeInGroups(index, groups, vertex) {
    var p = Tool_1.Tool.getPositionByIndex10(index);
    for (var i = 0; i < groups.length; i++) {
        var group = groups[i];
        if (isPointIn(p, group.points)) {
            if (group.indexs10.indexOf(index) == -1) {
                return group;
            }
        }
    }
    var groupsArr = [];
    for (var i = 0; i < groups.length; i++) {
        var group = groups[i];
        if (group.indexs10.indexOf(index) > -1) {
            groupsArr.push(group);
        }
    }
    if (groupsArr.length >= 2) {
        return groupsArr[1];
    }
    else {
        for (var i = 0; i < groupsArr.length; i++) {
            var g = groupsArr[i];
            var obj = statisticalFieldNumber(g.indexs10);
            if (obj[index] >= 2) {
                return g;
            }
            else {
                if (vertex[0] && vertex[2] && !vertex[1] && !vertex[3]) {
                    return null;
                }
                else {
                    return g;
                }
            }
        }
    }
    return null;
}
function judgeOnGroups(index, groups, vertex) {
    var groupsArr = [];
    for (var i = 0; i < groups.length; i++) {
        var group = groups[i];
        if (group.indexs10.indexOf(index) > -1) {
            groupsArr.push(group);
        }
    }
    if (groupsArr.length >= 2) {
        return groupsArr[1];
    }
    else {
        for (var i = 0; i < groupsArr.length; i++) {
            var g = groupsArr[i];
            var obj = statisticalFieldNumber(g.indexs10);
            if (obj[index] >= 2) {
                return g;
            }
            else {
                if (vertex[0] && vertex[2] && !vertex[1] && !vertex[3]) {
                    return null;
                }
                else {
                    return g;
                }
            }
        }
    }
    return null;
}
function statisticalFieldNumber(arr) {
    return arr.reduce(function (prev, next) {
        prev[next] = (prev[next] + 1) || 1;
        return prev;
    }, {});
}
function beenLoop(index, vertexs) {
    var group = {
        indexs: [],
        points: [],
        holes: [],
        indexs10: []
    };
    var directionsOri = ["r", "l", "u", "d"];
    var antDirections = {
        "r": "l",
        "l": "r",
        "u": "d",
        "d": "u"
    };
    var curIndex;
    var lastDirection;
    var lastIndex;
    while (curIndex != index) {
        lastIndex = curIndex || index;
        var rc = Tool_1.Tool.indexToRc10(lastIndex);
        var directionAll = {
            "r": rc[1] < Tool_1.Tool.colNum ? lastIndex + 1 : null,
            "l": rc[1] > 0 ? lastIndex - 1 : null,
            "u": rc[0] > 0 ? lastIndex - Tool_1.Tool.colNum - 1 : null,
            "d": rc[0] < Tool_1.Tool.rowNum ? lastIndex + Tool_1.Tool.colNum + 1 : null
        };
        var directions = directionsOri.slice();
        if (lastDirection)
            Tool_1.Tool.removeEle(antDirections[lastDirection], directions);
        var direction;
        for (var i = 0; i < directions.length; i++) {
            var dIndex = directionAll[directions[i]];
            if (dIndex != null) {
                if (vertexs[dIndex].indexOf(1) > -1 && vertexs[dIndex].indexOf(0) > -1) {
                    if (getDown(lastIndex, dIndex, vertexs) &&
                        !getUp(lastIndex, dIndex, vertexs) &&
                        getCorner(lastDirection, directions[i], lastIndex, vertexs)) {
                        curIndex = dIndex;
                        direction = directions[i];
                        break;
                    }
                }
            }
        }
        if (curIndex == index) {
            group.indexs10.push(lastIndex);
            if (lastDirection != direction) {
                var point = Tool_1.Tool.getPositionByIndex10(lastIndex);
                group.points.push(point[0], point[1]);
                lastDirection = direction;
            }
            break;
        }
        else {
            group.indexs10.push(lastIndex);
            if (lastDirection == direction) {
            }
            else {
                var point = Tool_1.Tool.getPositionByIndex10(lastIndex);
                group.points.push(point[0], point[1]);
                lastDirection = direction;
            }
        }
    }
    clearGroup(group);
    return group;
}
function getLeftUp(index) {
    var rc = Tool_1.Tool.indexToRc10(index);
    if (rc[0] > 0 && rc[1] > 0) {
        return Tool_1.Tool.rcToIndex(rc[0] - 1, rc[1] - 1);
    }
    else {
        return null;
    }
}
function getRightUp(index) {
    var rc = Tool_1.Tool.indexToRc10(index);
    if (rc[0] > 0 && rc[1] < Tool_1.Tool.colNum) {
        return Tool_1.Tool.rcToIndex(rc[0] - 1, rc[1]);
    }
    else {
        return null;
    }
}
function getRightDown(index) {
    var rc = Tool_1.Tool.indexToRc10(index);
    if (rc[0] < Tool_1.Tool.rowNum && rc[1] < Tool_1.Tool.colNum) {
        return Tool_1.Tool.rcToIndex(rc[0], rc[1]);
    }
    else {
        return null;
    }
}
function getLeftDown(index) {
    var rc = Tool_1.Tool.indexToRc10(index);
    if (rc[0] < Tool_1.Tool.rowNum && rc[1] > 0) {
        return Tool_1.Tool.rcToIndex(rc[0], rc[1] - 1);
    }
    else {
        return null;
    }
}
function getDown(l, r, vertexs) {
    var rcL = Tool_1.Tool.indexToRc10(l);
    var rcR = Tool_1.Tool.indexToRc10(r);
    if (rcR[1] - rcL[1] == 1) {
        return vertexs[l][2];
    }
    if (rcR[0] - rcL[0] == 1) {
        return vertexs[l][3];
    }
    if (rcR[1] - rcL[1] == -1) {
        return vertexs[l][0];
    }
    if (rcR[0] - rcL[0] == -1) {
        return vertexs[l][1];
    }
}
function getUp(l, r, vertexs) {
    var rcL = Tool_1.Tool.indexToRc10(l);
    var rcR = Tool_1.Tool.indexToRc10(r);
    if (rcR[1] - rcL[1] == 1) {
        return vertexs[l][1];
    }
    if (rcR[0] - rcL[0] == 1) {
        return vertexs[l][2];
    }
    if (rcR[1] - rcL[1] == -1) {
        return vertexs[l][3];
    }
    if (rcR[0] - rcL[0] == -1) {
        return vertexs[l][0];
    }
}
function getCorner(lastD, curD, lastI, vertexs) {
    if (lastD == "r" && curD == "u") {
        return vertexs[lastI][2];
    }
    if (lastD == "d" && curD == "r") {
        return vertexs[lastI][3];
    }
    if (lastD == "l" && curD == "d") {
        return vertexs[lastI][0];
    }
    if (lastD == "u" && curD == "l") {
        return vertexs[lastI][1];
    }
    return true;
}
function clearGroup(group) {
    var one = group.indexs10[0];
    var two = group.indexs10[1];
    var Last = group.indexs10[group.indexs10.length - 1];
    var rc1 = Tool_1.Tool.indexToRc10(one);
    var rc2 = Tool_1.Tool.indexToRc10(two);
    var rcL = Tool_1.Tool.indexToRc10(Last);
    if ((rc1[0] == rc2[0] && rc1[0] == rcL[0]) || (rc1[1] == rc2[1] && rc1[1] == rcL[1])) {
        group.points.shift();
        group.points.shift();
    }
}
var getIndex9 = [
    getLeftUp,
    getRightUp,
    getRightDown,
    getLeftDown
];
function getVertexs(lattices) {
    var vertexs = [];
    var rowNum = Tool_1.Tool.rowNum + 1;
    var colNum = Tool_1.Tool.colNum + 1;
    for (var i = 0; i < rowNum * colNum; i++) {
        var indexs = [];
        for (var m = 0; m < 4; m++) {
            var index = getIndex9[m](i);
            if (index != null && lattices[index]) {
                indexs.push(1);
            }
            else {
                indexs.push(0);
            }
        }
        vertexs.push(indexs);
    }
    return vertexs;
}


/***/ }),

/***/ "./src/something/periodAni/ExplosiveBgAni.ts":
/*!***************************************************!*\
  !*** ./src/something/periodAni/ExplosiveBgAni.ts ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExplosiveBgAni = void 0;
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var ExplosiveBgAni = (function (_super) {
    __extends(ExplosiveBgAni, _super);
    function ExplosiveBgAni() {
        var _this = this;
        var arr = [];
        var aaa = [0, 2, 4, 6, 8, 10, 13, 15];
        for (var i = 0; i <= 60; i++) {
            if (aaa.indexOf(i) >= 0) {
                arr.push(RES_1.RES.getRes("exLighting" + i + ".png"));
            }
            else {
                arr.push(null);
            }
        }
        _this = _super.call(this, arr) || this;
        _this.play(0);
        _this.mouseEnable = false;
        _this.mouseChildren = false;
        return _this;
    }
    return ExplosiveBgAni;
}(FYGE.FrameAni));
exports.ExplosiveBgAni = ExplosiveBgAni;


/***/ }),

/***/ "./src/something/periodAni/HorizontalBgAni.ts":
/*!****************************************************!*\
  !*** ./src/something/periodAni/HorizontalBgAni.ts ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.HorizontalBgAni = void 0;
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var HorizontalBgAni = (function (_super) {
    __extends(HorizontalBgAni, _super);
    function HorizontalBgAni() {
        var _this = _super.call(this) || this;
        _this.outSpeed = 0.25;
        _this.inSpeed = 1;
        _this.direction = true;
        _this.count = 0;
        _this.mouseEnable = false;
        _this.mouseChildren = false;
        var textureL = RES_1.RES.getRes("leftArrow.png");
        _this.leftArrow = new FYGE.Sprite(textureL);
        _this.leftArrow.x = -50;
        _this.leftArrow.y = -textureL.height / 2;
        _this.addChild(_this.leftArrow);
        var textureR = RES_1.RES.getRes("rightArrow.png");
        _this.rightArrow = new FYGE.Sprite(textureR);
        var oriX = 50 - textureR.width;
        _this.rightArrow.x = oriX;
        _this.rightArrow.y = -textureR.height / 2;
        _this.addChild(_this.rightArrow);
        _this.addTweens();
        return _this;
    }
    HorizontalBgAni.prototype.reset = function () {
        FYGE.Tween.removeTweens(this.leftArrow);
        FYGE.Tween.removeTweens(this.rightArrow);
        this.addTweens();
    };
    HorizontalBgAni.prototype.addTweens = function () {
        FYGE.Tween.get(this.leftArrow, { loop: true })
            .set({ alpha: 1 })
            .wait(300)
            .to({ alpha: 0 }, 700);
        FYGE.Tween.get(this.leftArrow, { loop: true })
            .set({ x: -50 })
            .to({ x: -50 - 6 }, 1000);
        var textureR = RES_1.RES.getRes("rightArrow.png");
        var oriX = 50 - textureR.width;
        FYGE.Tween.get(this.rightArrow, { loop: true })
            .set({ alpha: 1 })
            .wait(300)
            .to({ alpha: 0 }, 700);
        FYGE.Tween.get(this.rightArrow, { loop: true })
            .set({ x: oriX })
            .to({ x: oriX + 6 }, 1000);
    };
    return HorizontalBgAni;
}(FYGE.Container));
exports.HorizontalBgAni = HorizontalBgAni;


/***/ }),

/***/ "./src/something/periodAni/MagicLionBgAni.ts":
/*!***************************************************!*\
  !*** ./src/something/periodAni/MagicLionBgAni.ts ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.MagicLionBgAni = void 0;
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var MagicLionBgAni = (function (_super) {
    __extends(MagicLionBgAni, _super);
    function MagicLionBgAni() {
        var _this = _super.call(this) || this;
        _this.mouseEnable = false;
        _this.mouseChildren = false;
        var texture = RES_1.RES.getRes("magicLionBg.png");
        _this.showImage = new FYGE.Sprite(texture);
        _this.showImage.anchorTexture.set(0.5, 0.5);
        _this.showImage.scaleX = _this.showImage.scaleY = 0.7;
        _this.addChild(_this.showImage);
        _this.addEventListener(FYGE.Event.ENTER_FRAME, _this.onEnterFrame, _this);
        var other = new FYGE.Sprite(texture);
        other.anchorTexture.set(0.5, 0.5);
        other.scaleX = other.scaleY = 0.7;
        _this.addChild(other);
        _this.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            other.rotation -= 5;
        }, _this);
        var upTexture = RES_1.RES.getRes("magicLion.png");
        var up = new FYGE.Sprite(upTexture);
        up.anchorTexture.set(0.5, 0.5);
        _this.addChild(up);
        _this.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            up.rotation += 2;
        }, _this);
        return _this;
    }
    MagicLionBgAni.prototype.onEnterFrame = function () {
        this.showImage.rotation += 5;
    };
    MagicLionBgAni.prototype.reset = function () {
    };
    return MagicLionBgAni;
}(FYGE.Container));
exports.MagicLionBgAni = MagicLionBgAni;


/***/ }),

/***/ "./src/something/periodAni/VerticalBgAni.ts":
/*!**************************************************!*\
  !*** ./src/something/periodAni/VerticalBgAni.ts ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.VerticalBgAni = void 0;
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var VerticalBgAni = (function (_super) {
    __extends(VerticalBgAni, _super);
    function VerticalBgAni() {
        var _this = _super.call(this) || this;
        _this.outSpeed = 0.25;
        _this.inSpeed = 1;
        _this.direction = true;
        _this.count = 0;
        _this.mouseEnable = false;
        _this.mouseChildren = false;
        var textureL = RES_1.RES.getRes("leftArrow.png");
        _this.upArrow = new FYGE.Sprite(textureL);
        _this.upArrow.rotation = 90;
        _this.upArrow.x = textureL.height / 2;
        _this.upArrow.y = -50;
        _this.addChild(_this.upArrow);
        var textureR = RES_1.RES.getRes("rightArrow.png");
        _this.downArrow = new FYGE.Sprite(textureR);
        _this.downArrow.rotation = 90;
        _this.downArrow.x = textureR.height / 2;
        var oriY = 50 - textureR.width;
        _this.downArrow.y = oriY;
        _this.addChild(_this.downArrow);
        _this.addTweens();
        return _this;
    }
    VerticalBgAni.prototype.reset = function () {
        FYGE.Tween.removeTweens(this.upArrow);
        FYGE.Tween.removeTweens(this.downArrow);
        this.addTweens();
    };
    VerticalBgAni.prototype.addTweens = function () {
        FYGE.Tween.get(this.upArrow, { loop: true })
            .set({ alpha: 1 })
            .wait(300)
            .to({ alpha: 0 }, 700);
        FYGE.Tween.get(this.upArrow, { loop: true })
            .set({ y: -50 })
            .to({ y: -50 - 6 }, 1000);
        var textureR = RES_1.RES.getRes("rightArrow.png");
        var oriY = 50 - textureR.width;
        FYGE.Tween.get(this.downArrow, { loop: true })
            .set({ alpha: 1 })
            .wait(300)
            .to({ alpha: 0 }, 700);
        FYGE.Tween.get(this.downArrow, { loop: true })
            .set({ y: oriY })
            .to({ y: oriY + 6 }, 1000);
    };
    return VerticalBgAni;
}(FYGE.Container));
exports.VerticalBgAni = VerticalBgAni;


/***/ }),

/***/ "./src/something/states/BubbleState.ts":
/*!*********************************************!*\
  !*** ./src/something/states/BubbleState.ts ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.BubbleState = void 0;
var State_1 = __webpack_require__(/*! ../class/State */ "./src/something/class/State.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var BubbleState = (function (_super) {
    __extends(BubbleState, _super);
    function BubbleState(type) {
        var _this = _super.call(this) || this;
        _this.showImage = new FYGE.Sprite();
        _this.changeSource("bubleEle" + type + ".png");
        _this.addChild(_this.showImage);
        return _this;
    }
    BubbleState.prototype.reset = function (type) {
        this.changeSource("bubleEle" + type + ".png");
    };
    BubbleState.prototype.recover = function () {
        if (this.parent)
            this.parent.removeChild(this);
        Pool_1.Pool.recover(RecoverName_1.RecoverName.BUBBLE_STATE, this);
    };
    BubbleState.prototype.changeSource = function (source) {
        var texture = RES_1.RES.getRes(source);
        this.showImage.texture = texture;
        this.showImage.x = -texture.width / 2;
        this.showImage.y = -texture.height / 2;
    };
    return BubbleState;
}(State_1.State));
exports.BubbleState = BubbleState;


/***/ }),

/***/ "./src/something/states/HairballBlackState.ts":
/*!****************************************************!*\
  !*** ./src/something/states/HairballBlackState.ts ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.HairballBlackState = void 0;
var State_1 = __webpack_require__(/*! ../class/State */ "./src/something/class/State.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var HairballBlackState = (function (_super) {
    __extends(HairballBlackState, _super);
    function HairballBlackState() {
        var _this = _super.call(this) || this;
        _this.showImage = new FYGE.Sprite();
        _this.addChild(_this.showImage);
        _this.changeSource("ele" + ElementType_1.ElementType.HAIRBALLBLACK + ".png");
        _this._isAwake = true;
        return _this;
    }
    Object.defineProperty(HairballBlackState.prototype, "isAwake", {
        get: function () {
            return this._isAwake;
        },
        set: function (value) {
            this._isAwake = value;
        },
        enumerable: false,
        configurable: true
    });
    HairballBlackState.prototype.reset = function () {
        this._isAwake = true;
        this.changeSource("ele" + ElementType_1.ElementType.HAIRBALLBLACK + ".png");
    };
    HairballBlackState.prototype.recover = function () {
        if (this.parent)
            this.parent.removeChild(this);
        Pool_1.Pool.recover(RecoverName_1.RecoverName.HAIRBALLBLACK_STATE, this);
    };
    HairballBlackState.prototype.changeSource = function (source) {
        var texture = RES_1.RES.getRes(source);
        this.showImage.texture = texture;
        this.showImage.x = -texture.width / 2;
        this.showImage.y = -texture.height / 2;
    };
    return HairballBlackState;
}(State_1.State));
exports.HairballBlackState = HairballBlackState;


/***/ }),

/***/ "./src/something/states/HairballBrownState.ts":
/*!****************************************************!*\
  !*** ./src/something/states/HairballBrownState.ts ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.HairballBrownState = void 0;
var State_1 = __webpack_require__(/*! ../class/State */ "./src/something/class/State.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var HairballBrownState = (function (_super) {
    __extends(HairballBrownState, _super);
    function HairballBrownState() {
        var _this = _super.call(this) || this;
        var texture = RES_1.RES.getRes("ele" + ElementType_1.ElementType.HAIRBALLBROWN + ".png");
        _this.showImage = new FYGE.Sprite(texture);
        _this.addChild(_this.showImage);
        _this.showImage.x = -texture.width / 2;
        _this.showImage.y = -texture.height / 2;
        _this.isActive = false;
        return _this;
    }
    HairballBrownState.prototype.reset = function () {
        this.isActive = false;
    };
    HairballBrownState.prototype.recover = function () {
        if (this.parent)
            this.parent.removeChild(this);
        Pool_1.Pool.recover(RecoverName_1.RecoverName.HAIRBALLBROWN_STATE, this);
    };
    HairballBrownState.prototype.changeSource = function (source) {
        var texture = RES_1.RES.getRes(source);
        this.showImage.texture = texture;
        this.showImage.x = -texture.width / 2;
        this.showImage.y = -texture.height / 2;
    };
    return HairballBrownState;
}(State_1.State));
exports.HairballBrownState = HairballBrownState;


/***/ }),

/***/ "./src/something/states/HairballGreyState.ts":
/*!***************************************************!*\
  !*** ./src/something/states/HairballGreyState.ts ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.HairballGreyState = void 0;
var State_1 = __webpack_require__(/*! ../class/State */ "./src/something/class/State.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var HairballGreyState = (function (_super) {
    __extends(HairballGreyState, _super);
    function HairballGreyState() {
        var _this = _super.call(this) || this;
        var texture = RES_1.RES.getRes("ele" + ElementType_1.ElementType.HAIRBALLGREY + ".png");
        _this.showImage = new FYGE.Sprite(texture);
        _this.addChild(_this.showImage);
        _this.showImage.x = -texture.width / 2;
        _this.showImage.y = -texture.height / 2;
        return _this;
    }
    HairballGreyState.prototype.reset = function () {
    };
    HairballGreyState.prototype.recover = function () {
        if (this.parent)
            this.parent.removeChild(this);
        Pool_1.Pool.recover(RecoverName_1.RecoverName.HAIRBALLGREY_STATE, this);
    };
    return HairballGreyState;
}(State_1.State));
exports.HairballGreyState = HairballGreyState;


/***/ }),

/***/ "./src/something/states/LockState.ts":
/*!*******************************************!*\
  !*** ./src/something/states/LockState.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.LockState = void 0;
var State_1 = __webpack_require__(/*! ../class/State */ "./src/something/class/State.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var LockState = (function (_super) {
    __extends(LockState, _super);
    function LockState() {
        var _this = _super.call(this) || this;
        var texture = RES_1.RES.getRes("lockVine.png");
        _this.showImage = new FYGE.Sprite(texture);
        _this.addChild(_this.showImage);
        _this.showImage.x = -texture.width / 2;
        _this.showImage.y = -texture.height / 2;
        return _this;
    }
    LockState.prototype.reset = function () {
        this.alpha = 1;
    };
    LockState.prototype.recover = function () {
        var _this = this;
        FYGE.Tween.get(this)
            .to({ alpha: 0 }, 750)
            .call(function () {
            if (_this.parent)
                _this.parent.removeChild(_this);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.LOCK_STATE, _this);
        });
    };
    return LockState;
}(State_1.State));
exports.LockState = LockState;


/***/ }),

/***/ "./src/something/uis/ElementTargets.ts":
/*!*********************************************!*\
  !*** ./src/something/uis/ElementTargets.ts ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElementTargets = void 0;
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var ElementTargets = (function (_super) {
    __extends(ElementTargets, _super);
    function ElementTargets(passElement) {
        var _this = _super.call(this) || this;
        _this.targets = [];
        for (var i = 0; i < passElement.length; i++) {
            if (passElement[i]) {
                var eleTar = new ElementTarget(i);
                eleTar.count = passElement[i];
                _this.addChild(eleTar);
                _this.targets[i] = eleTar;
            }
        }
 