import { generateAPI } from "./utils.js"

const API = generateAPI({
	/** 获取活动规则 */
	getRule: 'projectRule.query',
	/** 获取前端配置项 */
	getFrontVariable: 'coop_frontVariable.query',
	/** 参与接口 post请求 */
	doJoin: {
		uri: 'join.do',
		method: "post"
	},
	/** 签到 */
	doSign: {
		uri: 'checkin_1/doSign.do',
		withToken: true,  // 携带token
	},

  // cookie丢失-临时保存cookie
  tempSaveCookie: {
    uri: "/autoLogin/tempSaveCookie",
    showMsg: false,
  },
  // cookie丢失-重新设置cookie
  resetCookie: "/autoLogin/resetCookie",
  userLogin: {
    uri: "userLogin.check",
    showMsg: false,
  },
  buriedPoint: {
    uri: "home/buriedPoint.do",
    showMsg: false,
  },

})

// console.log('======', API)

export default API
