import { Scene } from "../../module/views/Scene";
import { showPanel, showWaiting, hideWaiting, showToast, changeScene } from "../../module/ctrls";
import { RulePanel } from "./RulePanel";
import { Tools } from "../Tools";
import { sendTbNet, TbNetName } from "../TaoBaoNet";
import { layers } from "../../module/views/layers";

import { RankPanel } from "./RankPanel";
import { TaskPanel } from "./TaskPanel";

import { GDispatcher } from "../Main";
import { G_EVENT } from "../common/G_EVENT";
import { HelpPanel } from "./HelpPanel";
import { RankNoPrizePanel } from "./RankNoPrizePanel";
import { RankPrizePanel } from "./RankPrizePanel";
import { PlayScene } from "./PlayScene";
import { LotteryScroll } from "../games/LotteryScroll";
export class StartScene extends Scene {
    get groupNames() { return ["StartScene"] }
    get skinName() { return "StartScene" }
    taskBtn: FYGE.Button;
    lotBtn: FYGE.Button;
    rankBtn: FYGE.Button;
    timesTxt: FYGE.TextField;
    startBtn: FYGE.Button;
    ruleBtn: FYGE.Button;
    recordBtn: FYGE.Button;

    initUi() {
        // this.y -= layers.stageOffsetY;
        //次数文案居中
        Tools.changeTextAlign(this.timesTxt, FYGE.TEXT_ALIGN.CENTER, 300);

        //加滚动
        if (layers.stageHeight < 1624) {
            var scroll = new FYGE.ScrollPage(750, layers.stageHeight, 1624 - layers.stageOffsetY, true, true)
            // 所有内容加入滚动
            // this.children.forEach((c)=>{ //这种方式有问题，因为子级的索引
            // 	scroll.view.addChild(c);
            // })
            scroll.view.addChildren(...this.removeChildren());
            // scroll.view.addChildren.apply(scroll.view,this.removeChildren())
            // //滚动加入加入父级
            this.addChild(scroll);
        }
//         this.addChild(Tools.getCircle(10)).position.set(100,600)
//        var a =  this.addChild(new LotteryScroll())
//        a .position.set(100,600)
// a.lot()
    }

    async start(data) {
        super.start()
        //次数文案修改
        this.updateScene();

        if (this.data) {//简单判断，只有首次进来才调用
            //TODO邀请人数弹框
            // showPanel()
            //如果又邀请id，并且不是自己的，弹助力弹框  TODO
            if (Tools.globalData.inviteId && Tools.globalData.inviteId != Tools.globalData.openId) {
                showPanel(HelpPanel);//里面执行
            }

            showWaiting();
            var rankPrizePopData = await sendTbNet(TbNetName.rankPrizePop, { activityId: Tools.globalData.activityId })
            hideWaiting();

            if (rankPrizePopData.success) {
                if (rankPrizePopData.data.needPop) {//需要弹窗
                    console.log("需要弹窗")
                    if (!rankPrizePopData.data.prize) {//没中奖
                        showPanel(RankNoPrizePanel, { rank: rankPrizePopData.data.rank });
                    } else {
                        showPanel(RankPrizePanel, {
                            rank: rankPrizePopData.data.rank,
                            ...rankPrizePopData.data.prize
                        });
                    }
                }
            } else {
                console.log("请求失败")
            }
        }
    }

	/**
	 * 更新次数方法
	 */
    updateScene() {
        this.timesTxt.text = "剩余次数：" + Tools.gameInfo.gameCounts + "次";
    }

    initEvents() {
        super.initEvents();
        //开始游戏
        this.startBtn.addEventListener(FYGE.MouseEvent.CLICK, async () => {
            if (!this.actOver()) {
                showWaiting();
                var res = await sendTbNet(TbNetName.startGame)
                hideWaiting();
                if (res.success) {
                    changeScene(PlayScene, { ...res.data });
                } else {
                    //TODO会员信息啥的反馈，code确定
                }
            }
        }, this)
        //规则按钮
        this.ruleBtn.addEventListener(FYGE.MouseEvent.CLICK, () => {
            showPanel(RulePanel)
        }, this)
        //我的奖品按钮
        this.recordBtn.addEventListener(FYGE.MouseEvent.CLICK, () => {
            //弄个延时
            Tools.btnDelay(this.recordBtn)
            //跳转，链接待定
            sendTbNet(
                TbNetName.navigateTo,
                { url: '/pages/myprize/myprize' },
                () => { },
                true
            );
        }, this)
        //排行榜按钮
        this.rankBtn.addEventListener(FYGE.MouseEvent.CLICK, () => {
            showPanel(RankPanel)
        }, this)
        //任务弹框
        this.taskBtn.addEventListener(FYGE.MouseEvent.CLICK, () => {
            if (!this.actOver()) showPanel(TaskPanel)
        }, this)

        //监听下次数修改
        GDispatcher.addEventListener(G_EVENT.UPDATE_SCENE, this.updateScene, this);
    }
    removeEvents() {
        super.removeEvents();
        //移除次数监听
        GDispatcher.removeEventListener(G_EVENT.UPDATE_SCENE, this.updateScene, this);
        //其他的按钮事件不写了，没存引用，反正destroy会把挂在场景上的所有显示对象的事件都清除
    }
    //判断活动是否已结束，并提示toast
    actOver() {
        if (0) {
            showToast("活动已结束")
            return true;
        }
        return false;
    }
}
