import { Panel } from "../../module/views/Panel";
import { sendTbNet, TbNetName } from "../TaoBaoNet";
import { showToast, showPanel } from "../../module/ctrls";
import { Tools } from "../Tools";
export class RankPrizePanel extends Panel {
	get groupNames() { return ["RankPrizePanel"] }
	get skinName() { return "RankPrizePanel" }
	acceptBtn: FYGE.Button;
	closeBtn: FYGE.Button;
	img: FYGE.Sprite;
	rank: FYGE.TextField

	data: {
		rank: string;
		name: string;
		showImage: string;
		type: number
		_id: string
		goodId: string
	}


	initUi() {
		//奖品图片
		this.img.width = this.img.width;
		this.img.height = this.img.height;
		this.img.texture = FYGE.Texture.fromUrl(this.data.showImage);
		//文案
		this.rank.text = `第${this.data.rank}名`;
		this.rank.size = 46//psd导出的文案字号错的
		//领奖事件
		this.acceptBtn.addEventListener(FYGE.MouseEvent.CLICK, () => {
			Tools.btnDelay(this.acceptBtn)
			console.log(this.data.type)
			if (this.data.type == 1) {
				//权益  TODO确认，id
				sendTbNet(TbNetName.receiveEnamePrize, { id: this.data._id },
					(success, res) => {
						if (!success || !res) {
							showToast('奖品发放失败\n请前往我的奖品处进行处理');
							this.hidePanel();
							return;
						}
						if (res.data && res.data.drawStatus == 3) {
							showToast('奖品发放成功\n请前往我的奖品处查看');
						} else {
							showToast('奖品发放失败\n请前往我的奖品处进行处理');
						}
						this.hidePanel();
					}, true
				);
			}
			else if (this.data.type == 3) {
				//实物
				sendTbNet(TbNetName.getUserAddress, { prizeId: this.data._id },
					(success, res) => {
						if (!success) {
							showToast('奖品发放失败\n请前往我的奖品处进行处理');
							return;
						}
						showToast('奖品发放成功\n请前往我的奖品处查看');
						this.hidePanel();
					}, true
				);
			} else {
				this.hidePanel()
			}
		}, this)

	}
}
