import { RES } from "../../module/RES";
import { Scene } from "../../module/views/Scene";
import { Tools } from "../Tools";
import UI from "../UI";

const list = [
  {
    type: 1,
    isBack: true,
  },
  {
    type: 2,
    isBack: true,
  },
  {
    type: 3,
    isBack: true,
  },
  {
    type: 5,
    isBack: true,
  },
  {
    type: 1,
    isBack: true,
  },
  {
    type: 2,
    isBack: true,
  },
  {
    type: 3,
    isBack: true,
  },
  {
    type: 4,
    isBack: true,
  },
  {
    type: 1,
    isBack: true,
  },
  {
    type: 2,
    isBack: true,
  },
  {
    type: 5,
    isBack: true,
  },
  {
    type: 4,
    isBack: true,
  },
];
export class PlayScene extends Scene {
  get groupNames() {
    return ["playScene"];
  }
  cardBg: FYGE.Sprite;
  cardList: Card[] = [];
  arr = JSON.parse(JSON.stringify(list)).sort(() => Math.random() - 0.5);
  initUi() {
    this.cardBg = UI.Sp(this, "cardBg.png", 10, 450);
    this.arr.map((item, i) => {
      const card = new Card({
        ...item,
        index: i,
      });
      this.cardList.push(card);
      this.cardBg
        .addChild(card)
        .position.set(-200, 80 + Math.floor(i / 4) * 220);
      FYGE.Tween.get(this.cardList[i].position).to(
        {
          x: 74 + Math.floor(i % 4) * 152,
        },
        500
      );
    })
  }
  start(data) {
    super.start();
  }
  initEvents() {
    super.initEvents();
  }
  removeEvents() {
    super.removeEvents();
  }
}

class Card extends FYGE.Container {
  img;
  constructor(data?) {
    super();
    this.initUi(data);
  }
  initUi(data) {
    this.img = UI.Sp(this, "back.png", 0, 0);
    this.img.anchorX = 63;
    this.img.anchorY = 85;
    this.addEventListener(
      FYGE.MouseEvent.CLICK,
      function () {
        this.clickCard(data);
      },
      this
    );
  }
  clickCard(data) {
    console.log("点击");
    FYGE.Tween.get(this.img)
      .to(
        {
          scaleX: 0,
        },
        500
      )
      .call(() => {
        if (data.isBack) {
          this.img.texture = FYGE.Texture.fromUrl("font" + data.type + ".png");
          data.isBack = false;
        } else {
          this.img.texture = FYGE.Texture.fromUrl("back.png");
          data.isBack = true;
        }
        FYGE.Tween.get(this.img).to(
          {
            scaleX: 1,
          },
          500
        );
      });
  }
}
