//默认参数配置
const defaultConfig = {
    a: 1,
    b: 3
}
//对内暴露
export let config = defaultConfig;
/**
 * 对外方法暴露
 * @param cfg 
 */
export function setConfig(cfg: Partial<typeof defaultConfig>) {
    config = {
        ...defaultConfig,
        ...cfg
    }
}


//需要的所有资源的列表（换皮只需要文件夹里替换文件），canvas模块里仅仅是映射
const resList: { [key: string]: string } = {
    //
    aaa: "aaa.png",
    bbb: "bbb.svga",
    ccc: "ccc.spine"
}

let _getRes: (name: string) => any;
/**
 * 注册获取资源方法，
 * 纯canvas模块可以直接用RES：registerResGetFn(RES.getRes)
 * @param getRes 
 */
export function registerResGetFn(getRes: (name: string) => any) {
    _getRes = getRes;
}

export function registerResList() {

}
/**
 * 加载资源，canvas模块可以直接用RES.loadGroup
 */
export function loadResource() {

}
/**
 * 模块内获取资源方式，只有内部使用
 * @param name 
 */
export function getRes(name: string) {
    return resList[name] || null;
}
