const merge = require('webpack-merge');
const common = require('./webpack.common.js');
const webpack = require('webpack');
const MockWebpackPlugin = require('mock-webpack-plugin');
const mockConfig = require('./mock/config.js');

module.exports = merge(common, {
    mode: "development",
    devtool: 'eval-source-map',
    devServer: {
        contentBase: '.',
        proxy: {
            '/plugin/*':'http://localhost:3000',
            '/ngapi/*': 'http://localhost:3000',
            '/ngame/*': 'http://localhost:3000',
            '/hdtool/*': 'http://localhost:3000',
        }
    },
    plugins: [
        new MockWebpackPlugin({
            config: mockConfig,
            port: 3000
        })
    ]
});