const path = require("path");
const runScript = require("./runScript");

var fs = require("fs")
var skinUrl = "./resource/skin.json";
fs.watchFile(skinUrl, { persistent: true, interval: 2000 }, (curr, prev) => {
    const skinDataAll = fs.readFileSync(skinUrl)
    var endFile = `export const SkinJson = ${skinDataAll}`
    fs.writeFileSync("./src/SkinJson.ts", endFile);
    console.log("SkinJson.ts文件已更新")
})
let timer;
// 修改resource文件夹任意内容自动刷新资源，考虑做个节流
fs.watch('./resource/', { recursive: true }, (event, filename) => {

    if (
        filename === ".DS_Store"
        || filename === "res.json"
        || filename === "skin.json"
    ) return;

    timer && clearTimeout(timer)
    
    timer = setTimeout(() => {
        runScript(path.resolve('./scripts/flushRes.js'), (err) => {
            // console.log(err);
        });
    }, 1000)
});

runScript(path.resolve('./scripts/flushRes.js'), (err) => {
    // console.log(err);
});

const webpackDevServer = require('webpack-dev-server');
const webpack = require('webpack');

const config = require('../webpack.dev.js');
const options = {
    open: true,
    contentBase: '.',
    hot: true,
    host: 'localhost',
};

webpackDevServer.addDevServerEntrypoints(config, options);
const compiler = webpack(config);
const server = new webpackDevServer(compiler, options);

server.listen(8080, '0.0.0.0', () => {

});
