///////////////////时间相关的方法放这里


/**
 * 判断当前时间是否在指定时间区间内，每日，注意没判断起始时间是否肯定小于结束时间
 * @param beginTime 形如"9:30","09:30",起始时间
 * @param endTime 形如"21:30",结束时间
 */
export function checkAuditDayTime(beginTime: string, endTime: string, currentTimestamp: number = Date.now()): boolean {
    return !checkBeforeDayTime(beginTime, currentTimestamp) && checkBeforeDayTime(endTime, currentTimestamp)
}

/**
 * 判断当前时间是否在给定时间前,每天
 * 精确到分，有需要自行改造截取方法和setHours传参
 * @param time 形如"11:30","09:30"，小时 0（午夜） ~ 23（晚上11点），分0 ~ 59 之间，负数或超出，会进行进制换算
 * @returns 返回true表示当前时间小于传入时间，即未到传入时间
 */
export function checkBeforeDayTime(time: string, currentTimestamp: number = Date.now()): boolean {
    var nowDate = new Date(currentTimestamp);
    var timeDate = new Date(nowDate);
    var index = time.lastIndexOf("\:");
    var hour = time.substring(0, index);
    var minue = time.substring(index + 1, time.length);
    timeDate.setHours(+hour, +minue, 0, 0);
    return nowDate.getTime() < timeDate.getTime()
}

/**
 * 毫秒剩余时间转成时分秒，具体格式自行修改
 * 01时01分01秒
 * @param timeStamp 
 */
export function getShiFenMiaoByTimeStamp(timeStamp: number): string {
    var hours: any = Math.floor((timeStamp % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
    var minutes: any = Math.floor((timeStamp % (1000 * 60 * 60)) / (1000 * 60));
    var seconds: any = Math.floor((timeStamp % (1000 * 60)) / 1000);
    hours = hours < 10 ? ('0' + hours) : hours;
    minutes = minutes < 10 ? ('0' + minutes) : minutes;
    seconds = seconds < 10 ? ('0' + seconds) : seconds;
    // return hours + ":" + minutes + ":" + seconds;
    return hours + "时" + minutes + "分" + seconds + "秒";
}


/**
 * 根据时间戳返回各种格式，自行修改，到时加枚举
 * @param timeStamp 时间戳
 * @return 20190606 09:05:33  2019-06-06 09:05:33  2019/06/06 09:05:33  2019年3月12日10时9分29秒
 */
export function getDateTime(timeStamp: number): string {
    function add0(m: number) {
        return m < 10 ? '0' + m : m
    }
    var time = new Date(timeStamp);
    var y = time.getFullYear();
    var m = time.getMonth() + 1;
    var d = time.getDate();
    var h = time.getHours();
    var mm = time.getMinutes();
    var s = time.getSeconds();
    // return "" + y + add0(m) + add0(d) + ' ' + add0(h) + ':' + add0(mm) + ':' + add0(s);
    // return "" + y + '-' + add0(m) + '-' + add0(d) + ' ' + add0(h) + ':' + add0(mm) + ':' + add0(s);
    // return "" + y + '/' + add0(m) + '/' + add0(d) + ' ' + add0(h) + ':' + add0(mm) + ':' + add0(s);
    return y + "年" + m + '月' + d + '日' + h + '时' + mm + '分' + s + '秒'
}

/**
 * 日期格式转时间戳
 * 时间格式得用/，ios用-有问题，"2019/06/17 00:00:00",,,,ios也不能直接用Number(new Date())   
 * @param date "2019/06/17 00:00:00"  "2019-06-17 00:00:00"
 */
export function getTimeStampByDate(date: string) {
    return new Date(date.replace(/-/g, "/")).getTime();
}
/**
 * 快速获取年月日时分秒 "2021-02-01 18:32:32"
 * @param timeStamp 不传表示当前
 */
export function getDate(timeStamp: number = Date.now()): string {
    //有局限性，但是无妨 19暂时年份不会超
    return new Date(timeStamp + 8 * 3600 * 1000).toJSON().substr(0, 19).replace("T", " ");
}
/**
 * 判断两个时间戳是否为同一天
 * @param time1 
 * @param time2 
 */
export function checkSameDay(time1: number, time2: number): boolean {
    return new Date(time1).toDateString() === new Date(time2).toDateString()
}

