import { Item } from "../../module/views/Item";
import { Panel } from "../../module/views/Panel";
import { Tools } from "../Tools";
import { showWaiting, hideWaiting } from "../../module/ctrls";
import { sendTbNet, TbNetName, getTbData } from "../TaoBaoNet";
export class RankPanel extends Panel {
	get groupNames() { return ["RankPanel"] }
	get skinName() { return "RankPanel" }

	openTime: FYGE.TextField;

	rankNum: FYGE.TextField;
	nickName: FYGE.TextField;
	score: FYGE.TextField;

	closeBtn: FYGE.Button;

	/**
	 * 排行榜列表
	 */
	rankScroll: FYGE.ScrollList;
	/**
	 * 奖品列表
	 */
	prizeScroll: FYGE.ScrollList

	initUi() {
		//文案适配
		Tools.changeTextAlign(this.rankNum, FYGE.TEXT_ALIGN.CENTER, 130);

		Tools.changeTextAlign(this.score, FYGE.TEXT_ALIGN.RIGHT, 240);
		Tools.changeTextAlign(this.openTime, FYGE.TEXT_ALIGN.CENTER, 580)
		//去掉默认文案
		this.score.text = "";
		this.rankNum.text = "";
		this.nickName.text = "";

		this.rankScroll = this.addChild(
			new FYGE.ScrollList(
				RankItem,
				585,
				85,
				585,
				410
			)
		);
		this.rankScroll.position.set((750 - 585) / 2 + 45, 540);
		this.rankScroll.visible = false;


		this.prizeScroll = this.addChild(
			new FYGE.ScrollList(
				RankPrizeItem,
				160,
				192,
				590,
				192,
				false
			)
		);
		this.prizeScroll.position.set(80, 1065);
		this.prizeScroll.visible = false;


		this.updateScrollList();
	}

	private pageNo: number = 1;
	private total: number = 0;
	private loadFull: boolean = false;

	private updateScrollList() {

		if (this.loadFull) return;

		const pageSize = 20;
		showWaiting("加载中");
		sendTbNet(TbNetName.getRankList,
			{ pageNum: this.pageNo++, pageSize: 20 },
			(success, res) => {
				hideWaiting();
				if (!success || !res || !res.data) return;

				// this.total += pageSize; // 加上pageSize
				// if (this.total >= res.data.totalCount) { // 如果超过了总数则下次不继续加载
				// 	this.loadFull = true;
				// }
				//没返回totalCount就用list长度判断
				if (!res.data.list || !res.data.list.length) this.loadFull = true;
				//文本赋值
				this.nickName.text = res.data.detail.userNick;
				this.score.text = res.data.detail.totalScore + "分";
				this.rankNum.text = res.data.detail.rank == null ? "未入榜" : res.data.detail.rank;

				// 更新列表
				//排行榜是新增数据
				this.rankScroll.updateData(res.data.list, false);
				this.rankScroll.visible = true;

				//奖品列表数据重置
				this.prizeScroll.updateData(res.data.prizeList, true);
				this.prizeScroll.visible = true;

				//开奖时间
				var time = getTbData(TbNetName.getActivityBaseInfoById).data.endTime;//结束时间就是开奖时间
				this.openTime.text = this.getOpenPrizeTime(time);
			}
		);
	}

	public getOpenPrizeTime(now) {
		let date = new Date(now);
		let currentMonth = date.getMonth() + 1;
		let currentDay = date.getDate();
		let h = (date.getHours() < 10 ? '0' + date.getHours() : date.getHours()) //+ ':';
		// let m = (date.getMinutes() < 10 ? '0' + date.getMinutes() : date.getMinutes()) + ':';
		// let s = (date.getSeconds() < 10 ? '0' + date.getSeconds() : date.getSeconds());
		let str = "排行榜奖励" + currentMonth + "月" + currentDay + "日" + h + "点开奖";
		return str;
	}


	initEvents() {
		super.initEvents();
		this.rankScroll.addEventListener(FYGE.Event.SCROLL_TO_END, this.updateScrollList, this);
	}
	removeEvents() {
		super.removeEvents();
		this.rankScroll.removeEventListener(FYGE.Event.SCROLL_TO_END, this.updateScrollList, this);
	}
}


//TODO
class RankItem extends Item {
	get skinName() { return "RankItem" }
	num3: FYGE.Sprite;
	num2: FYGE.Sprite;
	num1: FYGE.Sprite;
	rank: FYGE.Sprite;
	nickName: FYGE.TextField;
	score: FYGE.TextField;

	rankNum: FYGE.BitmapText
	initUi(data?) {
		//分数适配居又
		Tools.changeTextAlign(this.score, FYGE.TEXT_ALIGN.RIGHT, 240)
		//加个位图字
		this.rankNum = this.addChild(new FYGE.BitmapText(Tools.getNumTextures("rankNum")))
		this.rankNum.position.set(this.rank.x + this.rank.width / 2, this.rank.y + this.rank.height / 2)
		this.removeChild(this.rank);
	}
	initData(id: number, data: { userNick: string, totalScore: number }): void {
		if (id < 0 || !data) return;
		super.initData(id, data);
		this.num1.visible = this.num2.visible = this.num3.visible = this.rankNum.visible = false;

		var rank = id + 1;
		if (rank == 1) {
			this.num1.visible = true;
		}
		else if (rank == 2) {
			this.num2.visible = true;
		}
		else if (rank == 3) {
			this.num3.visible = true;
		} else {
			this.rankNum.visible = true;
			this.rankNum.text = "" + rank;
		}
		this.nickName.text = data.userNick;
		this.score.text = data.totalScore + "分";
	}
}
class RankPrizeItem extends Item {
	get skinName() { return "RankPrizeItem" }
	nameTxt: FYGE.TextField;
	img: FYGE.Sprite;

	initUi(data?) {
		//文本居中
		Tools.changeTextAlign(this.nameTxt, FYGE.TEXT_ALIGN.CENTER, 146)
		//图片尺寸
		this.img.width = this.img.width;
		this.img.height = this.img.height;
	}

	initData(id: number, data: { name: string, image: string }): void {
		if (id < 0 || !data) return;
		super.initData(id, data);

		this.nameTxt.text = data.name;
		this.img.texture = FYGE.Texture.fromUrl(data.image);
	}
}
