///////淘宝环境下用svga的方法，不能放在RES里面，因为云函数路径没法自动生成
////资源可以放在resource里，但只限本地，不和其他需要的组混用
//脚本mergeJs里需要注释放开
// 'import * as SvgaParser from "svga-parser";\n' +
//淘宝项目中需要加npm包
//"svga-parser":"*"
/**
 * 所有用到的svga枚举，key就是名字，value就是云存储地址
 * k表示kid幼年，a表示adult成年
 * c表示const常态，f表示feed喂食
 */
export enum SvgaUrls {
    //小贱
    xiaojian_k_c = "cloud://3BA1EE46B105C2DFFA7A18295F346D2A//xiaojian_k_c.svga",
    xiaojian_k_f = "cloud://80940E86AAA3308275C77F8AB1CE6E10//xiaojian_k_f.svga",
    xiaojian_a_c = "cloud://80940E86AAA3308275C77F8AB1CE6E10//xiaojian_a_c.svga",
    xiaojian_a_f = "cloud://113220E46736B8389130E32C09AD8EA9//xiaojian_a_f.svga",
    //小美   cloud://80940E86AAA3308275C77F8AB1CE6E10//xiaojian_a_c.svga
    xiaomei_k_c = "cloud://4906799F3DE94ABDEC782CC6500BF944//xiaomei_k_c.svga",
    xiaomei_k_f = "cloud://0C1FF03240C0284EB540001CB73EA4D6//xiaomei_k_f.svga",
    xiaomei_a_c = "cloud://D65D439BCF3923F0772680E29B7A1B67//xiaomei_a_c.svga",
    xiaomei_a_f = "cloud://7C1572EEE6ED050A7F79F8C391474329//xiaomei_a_f.svga",
    //小酷
    xiaoku_k_c = "cloud://05FA1C9A39ECDF41B7AD4F5ABD9EAA1C//xiaoku_k_c.svga",
    xiaoku_k_f = "cloud://87E6DF0B56C8C032BA8E1F90BB54255A//xiaoku_k_f.svga",
    xiaoku_a_c = "cloud://B3F8278BD484680D6C9DD76B04CC5E96//xiaoku_a_c.svga",
    xiaoku_a_f = "cloud://1BAFE5981F1D74B3F4A9E3CF20EF4299//xiaoku_a_f.svga",

    //生成器粒子特效
    genParticles = "cloud://E3672473A8920B163EA62C144117FD01//genParticles.svga",

    //0s出现，间隔2秒
    butterfly0 = "cloud://B4F0300E5148F478B506DEDC26EA4C6C//butterfly0.svga",
    //1s出现，间隔2秒
    butterfly1 = "cloud://6F50E9CB7E6D221A8437575DDFAB9C6E//butterfly1.svga",


}
//缓存，数据
const SvgaCaches: {
    [key: string]: SvgaParser.VideoEntity
} = {}

//svga的Promise缓存
const SvgaProCaches: {
    [key: string]: Promise<SvgaParser.VideoEntity>
} = {};

export function loadSvga(url: SvgaUrls): Promise<SvgaParser.VideoEntity> {
    // let key = SvgaUrls[url];//只有数字枚举才能直接反向查找
    let key = ((enu, what) => {
        for (let item in enu) if (enu[item] == what) return item;
    })(SvgaUrls, url)
    //@ts-ignore  //不是淘宝环境，用本地
    let src = my ? url : "./resource/svgas/" + key + ".svga";
    //有加载好的
    if (SvgaCaches[key]) {
        return new Promise((r) => {
            r(SvgaCaches[key])
        })
    }
    //原先有promise且没加载好
    if (SvgaProCaches[key]) return SvgaProCaches[key];
    SvgaProCaches[key] = new Promise((resolve, reject) => {
        SvgaParser.loadSvga(
            src,
            (v) => {
                SvgaCaches[key] = v;
                delete SvgaProCaches[key]
                resolve(v);
            },
            (err) => {
                delete SvgaProCaches[key]
                console.log(err);
                reject(err)
            }
        )
    })
    return SvgaProCaches[key]
}

