import * as Matter from "matter-js";
import { RES } from "../../../module/RES";
import UI from "../../UI";

export default class Role extends FYGE.Container {
    public phyBody: Matter.Body;
    itemImg: FYGE.Sprite;
    beforeY = 0;
    direction = 'down';
    waittingSvga;
    jumpSvga;
    downSvga;
    lightSvga;
    bili;
    staY;

    constructor(data?) {
        super();
        this.staY = data.stageY;
        this.position.set(this.x, this.y);
        let itemImg = this.itemImg = UI.Sp(this, "controlpeo.png", 0, 0);
        let scale = this.bili = document.body.clientWidth / 750;
        // 至于为什么比对的位置, FYGE的适配缩放, 以及Main的剪裁
        this.phyBody = Matter.Bodies.rectangle(this.x * scale + itemImg.width * scale / 2, this.y * scale + itemImg.height * scale *0.9 - data.stageY * scale, itemImg.width * scale*0.5, (itemImg.height - 120) * scale, {
            isStatic: false,
            // isSensor: true, // 传感器，可以检测到碰撞，但是不参与碰撞
            // restitution: 0.8, // 定义刚体恢复（弹性）的数字
            // friction: 0.01, // 设置摩擦力
            // density: 0.05,// 定义刚体密度的数字，即单位面积的质量
            // frictionAir: 0.01, // 设置空气摩擦力
            render: {
                fillStyle: "red" // 填充的颜色
            }
        });
        // 绘制ip
        this.getSvga()
        this.setPhyPos();
        this.addEventListener(
            FYGE.Event.ADDED_TO_STAGE,
            () => {
                this.addEventListener(FYGE.Event.ENTER_FRAME, this.onFarm, this);
            },
            this
        );
    }
    async getSvga() {
        this.jumpSvga = new FYGE.SvgaAni(await RES.getResAsync("jumppeo.svga"));
        this.jumpSvga.position.set(-(this.jumpSvga.videoWidth - this.itemImg.width) / 2, -(this.jumpSvga.videoHeight - this.itemImg.height) / 2)
        this.itemImg.addChild(this.jumpSvga);


        this.downSvga = new FYGE.SvgaAni(await RES.getResAsync("crypeo.svga"));
        this.downSvga.position.set(-(this.downSvga.videoWidth - this.itemImg.width) / 2, -(this.downSvga.videoHeight - this.itemImg.height) / 2)
        this.downSvga.visible = false
        this.itemImg.addChild(this.downSvga);

        this.lightSvga = new FYGE.SvgaAni(await RES.getResAsync("light.svga"));
        this.lightSvga.position.set(-(this.lightSvga.videoWidth - this.itemImg.width) / 2, -(this.lightSvga.videoHeight - this.itemImg.height) / 2)
        this.lightSvga.visible = false
        this.itemImg.addChild(this.lightSvga);
    }

    leftMove() {
        Matter.Body.applyForce(this.phyBody, this.phyBody.position, {
            x: -0.01,
            y: 0
        });
    }

    rightMove() {
        Matter.Body.applyForce(this.phyBody, this.phyBody.position, {
            x: 0.01,
            y: 0
        });
    }

    /** 根据物理刚体，更新当前的坐标。 */
    private onFarm() {
        let Tx = (this.phyBody.position.x - this.itemImg.width * this.bili / 2) / this.bili;
        let Ty = (this.phyBody.position.y + (this.staY * this.bili) - this.itemImg.height * this.bili*0.9) / this.bili;

        this.x = Tx;
        this.y = Ty;
        if (Tx > 750) {
            this.fx = 0;
            this.fy = Ty;
        } else if (Tx < 0) {
            this.fx = 750 - this.itemImg.width;
            this.fy = Ty
        } else {
            this.fx = Tx;
            this.fy = Ty
        }
    }

    jump() {
        setTimeout(() => {
            if (this.jumpSvga) {
                this.jumpSvga.visible = true
                this.jumpSvga.startAniRange(1, undefined, 1)
            }
            if (this.downSvga) {
                this.downSvga.visible = false
            }
            Matter.Body.setVelocity(this.phyBody, { x: 0, y: -8 }); // 立即设置刚体的线速度。位置、角度、力等不变
        })
    }

    set fx(value: number) {
        this.position.x = value;
        this.setPhyPos();
    }

    set fy(value: number) {
        this.position.y = value;
        this.setPhyPos();
    }

    setPhyPos() {
        Matter.Body.setPosition(this.phyBody, {
            x: this.x * this.bili + this.itemImg.width * this.bili / 2,
            y: this.y * this.bili + this.itemImg.height * this.bili*0.9 - this.staY * this.bili,
        });
    }
}