import * as Matter from "matter-js";
import { RES } from "../../../module/RES";

export default class ObstacleProp extends FYGE.Container {
    public phyBody: Matter.Body;
    itemImg: FYGE.Sprite;
    constructor() {
        super();
        let itemImg = this.itemImg = new FYGE.Sprite();
        itemImg.texture = RES.getRes("monster.png");

        itemImg.position.set(-itemImg.width / 2, -itemImg.height / 2);
        this.addChild(itemImg);

        this.phyBody = Matter.Bodies.rectangle(this.x, this.y, itemImg.width , itemImg.height , {
            isStatic: true,
            isSensor: true, // 传感器，可以检测到碰撞，但是不参与碰撞
        });

        this.phyBody.gameType = 'dieProp';

        setTimeout(() => {
            this.setPhyPos();
        }, 500)
    }

    set fx(value: number) {
        this.position.x = value;
        this.setPhyPos();
    }

    set fy(value: number) {
        this.position.y = value;
        this.setPhyPos();
    }

    setPhyPos() {
        try {
            Matter.Body.setPosition(this.phyBody, {
                x: (this.x),
                y: (this.y),
            });
        } catch (e) { }
    }


}