import * as Matter from "matter-js";
import { RES } from "../../../module/RES";
import UI from "../../UI";

export default class MapItem extends FYGE.Container {
    public phyBody: Matter.Body;
    itemImg: FYGE.Sprite;
    fx;
    fy;
    index;
    constructor(data?) {
        super();
        this.fx = data.fx;
        this.fy = data.fy;
        this.index = data.index;
        this.position.set(this.fx, this.fy);
        let itemImg = this.itemImg = UI.Sp(this, "cloud.png", 0, 0);
        UI.Txt(this, this.index, 20, "#ff0000", FYGE.TEXT_ALIGN.LEFT, 100, 0, 0)
        var scale = document.body.clientWidth / 750;
        var desW = 750;
        var divW = document.body.clientWidth;
        var divH = document.body.clientHeight;
        // 至于为什么比对的位置, FYGE的适配缩放, 以及Main的剪裁
        this.phyBody = Matter.Bodies.rectangle(this.fx*scale+itemImg.width*scale/2, this.fy*scale+itemImg.height*scale/2-data.stageY*scale,itemImg.width*scale*0.8, 5, {
            isStatic: true,
            friction: 1,
            isSensor: true, // 传感器，可以检测到碰撞，但是不参与碰撞
            render: {
                fillStyle: "blue" // 填充的颜色
            }
        });
        this.phyBody.objType = "cloud"
    }
}