
import * as Matter from "matter-js";
import { RES } from "../../../module/RES";
import UI from "../../UI";
export default class AddProp extends FYGE.Container {
    public phyBody: Matter.Body;
    itemImg: FYGE.Sprite;
    fx;
    fy;
    wordTx;
    constructor(data?) {
        super();
        this.fx = data.fx;
        this.fy = data.fy;
        this.wordTx = data.wordTx;
        this.position.set(this.fx, this.fy);

        let itemImg = this.itemImg = UI.Sp(this, `word_${this.wordTx}.png`, 0, 0);
        var scale = document.body.clientWidth / 750;
        this.phyBody = Matter.Bodies.rectangle(this.fx*scale+itemImg.width*scale/2, this.fy*scale+itemImg.height*scale/2-data.stageY*scale, itemImg.width*scale, itemImg.height*scale, {
            isStatic: true,
            friction: 1,
            isSensor: true, // 传感器，可以检测到碰撞，但是不参与碰撞
            render: {
                fillStyle: "blue" // 填充的颜色
            }
        });
        this.phyBody.objType = "word";
        this.phyBody.wordTx = this.wordTx;
        this.phyBody.nodeTx = this;
    }
}