import { Panel } from "../../module/views/Panel";
import { RES } from "../../module/RES";
import { changeScene } from "../../module/ctrls";
import { StartScene } from "../scenes/StartScene";
import { getWebData, WebNetName, LOG_TYPE } from "../webNet";
export class SuccessPanel extends Panel {
    get groupNames() { return ["SuccessPanel"] };
    get skinName() { return "SuccessPanel" };

    sucbg: FYGE.Sprite;
	closebtn: FYGE.Button;
	sure: FYGE.Button;
	sctitle: FYGE.TextField;
	score: FYGE.TextField;
	get: FYGE.TextField;
	sunscore: FYGE.TextField;
	sun: FYGE.Sprite;
	line: FYGE.Sprite;
    star: FYGE.Sprite;
    light: FYGE.Sprite;
	
    initUi() {

    }
    async start(data) {
        super.start();
        this.light.anchorX = 231.5
        this.light.anchorY = 234
        this.score.textWidth = 292;
        this.score.textAlign = FYGE.TEXT_ALIGN.CENTER
        FYGE.Tween.get(this.light,{loop:true})
        .to({rotation:360},3000)
        this.star.visible = false
        let svgashow =new FYGE.SvgaAni(await RES.getResAsync("popstar.svga"))
        this.addChild(svgashow)
        svgashow.startAniRange(0,undefined,1)
        svgashow.position.set(207,368)
        let endInfo = getWebData(WebNetName.submitGame).data
        this.score.text = endInfo.score+""
        this.sunscore.text = "x"+endInfo.sunNum+""
    }
    back(){
        this.hidePanel()
        changeScene(StartScene)
    }
    initEvents() {
        super.initEvents();
        this.closebtn.addEventListener(FYGE.MouseEvent.CLICK,this.back,this)
        this.sure.addEventListener(FYGE.MouseEvent.CLICK,this.back,this)
    }
    removeEvents() {
        super.removeEvents();
        this.closebtn.removeEventListener(FYGE.MouseEvent.CLICK,this.back,this)
        this.sure.removeEventListener(FYGE.MouseEvent.CLICK,this.back,this)
    }
}

