import { Panel } from "../../module/views/Panel";
import { getWebData, WebNetName } from "../webNet";
import { RES } from "../../module/RES";
import { getCurrentScene } from "../../module/ctrls";
import { GameScene } from "../scenes/GameScene";
import { StartScene } from "../scenes/StartScene";
import UI from "../UI";
import { Tools } from "../Tools";
export class GuidePanel extends Panel {
    get groupNames() { return ["GuidePanel", "GameScene"] };
    get skinName() { return "GuidePanel" };

    rectlayer;
    clicklayer;
    guideStep = 1;
    svga
    
    initUi() {

    }
    svga
    async start(data) {
        super.start();
        this.clicklayer = UI.Rect(this, 750, 1624, 0x000000, 0, 0, 0, 0.01);
        this.rectlayer = UI.Ctn(this, 0, 0);
        this.rectlayer.mouseEnable = false
        this.rectlayer.mouseChildren = false

        let svgashow = this.svga = new FYGE.SvgaAni(await RES.getResAsync("guidecount.svga"));
        this.svga.position.set(170, 660)
        this.svga.visible = false
        this.svga.stop()
        this.addChild(svgashow);
        this.clicklayer.addEventListener(FYGE.MouseEvent.CLICK, () => {
            if (this.guideStep < 4) {
                this.guideStep++
                this.guideUI();
            } else if((this.guideStep == 4)) {
                this.guideStep++
                this.showCount();
            }
        }, this)
        if(getWebData(WebNetName.indexInfo).data.ifFirstPlay){
            this.guideUI();
        } else {
            this.showCount();
        }
        // GameScene.instance.scorenum.text = "0"
        // GameScene.instance.cdnum.text = StartScene.instance.gameInfo.duration
        // svgashow.lockStep = true
    }
    step3_img;
    async guideUI() {
        this.rectlayer.removeChildren()
        if (this.guideStep == 1) {
            UI.Sp(this.rectlayer, 'step1_img.png', 48, 860);
            let step1_tips = UI.Sp(this.rectlayer, 'step1_tips.png', 188, 776);
            FYGE.Tween.get(step1_tips, {
                loop: true
            })
            .to({ alpha: 0.2},500)
            .to({ alpha: 1},500)

        } else if (this.guideStep == 2) {
            UI.Sp(this.rectlayer, 'step2_img.png', 50, 492);
            let step2_tips = UI.Sp(this.rectlayer, 'step2_tips.png', 198, 900);
            FYGE.Tween.get(step2_tips, {
                loop: true
            })
            .to({ alpha: 0.2},500)
            .to({ alpha: 1},500)
        } else if (this.guideStep == 3) {
            this.step3_img = UI.Sp(this.rectlayer, 'step3_img.png', 280, 330);
            this.cdUIRender(Tools.configInfo.time)
            let step3_tips = UI.Sp(this.rectlayer, 'step3_tips.png', 236, 850);
            FYGE.Tween.get(step3_tips, {
                loop: true
            })
            .to({ alpha: 0.2},500)
            .to({ alpha: 1},500)
        } else if (this.guideStep == 4){
            let atmosphere = new FYGE.SvgaAni(await RES.getResAsync("atmosphere.svga"))
            this.rectlayer.addChild(atmosphere)
            atmosphere.position.set(18, 324)
            UI.Sp(this.rectlayer, 'step4_img.png', 95, 540);
        }
    }
    cdUIRender(num = 60) {
        // 先清除所有节点
        this.step3_img.removeChildren();
        let str = num + 's';
        let arr = str.split("");
        let startPos = (192 - (30 * arr.length)) / 2
        arr.forEach((item, index) => {
            UI.Sp(this.step3_img, `num_${item}.png`, startPos + (index * 30), 46)
        })
    }
    showCount(){
        this.removeChild(this.rectlayer)
        this.svga.visible = true
        this.svga.startAniRange(1,105,1,()=>{
            this.removeChild(this.svga)
            setTimeout(()=>{
                this.hidePanel()
                getCurrentScene().upDateInfo()
            },100)
        })
    }
    initEvents() {
        super.initEvents();

    }
    removeEvents() {
        super.removeEvents();

    }
}

