

import { layers, destroyLayers } from "../module/views/layers";
import { RES } from "../module/RES";
import { changeScene, showWaiting, destroyAllCtrls, showPanel, hideWaiting } from "../module/ctrls";

import { ResJson } from "./ResJson";
import { destroyTbNetData, getTbServerTime, sendTbNet, TbNetName } from "./TaoBaoNet";
import { SkinJson } from "./SkinJson";
import { G_EVENT } from "./common/G_EVENT";
import { Tools } from "./Tools";
import { destroyWebNetData } from "./webNet";
import { StartScene } from "./scenes/StartScene";

/**
 * 全局事件，为了和小程序交互
 * 有可能多处页面用到，所以单开
 */
export const GDispatcher = new FYGE.EventDispatcher();

export class Main {
    //主舞台
    stage: FYGE.Stage;
    private requestID;
    private _pause: boolean;
    private canvas: HTMLCanvasElement
    constructor(canvas: HTMLCanvasElement, data = {
        time: 60,
        longitude: "",
        latitude: ""
    }) {
        Tools.configInfo = data;
        var sysInfo;
        //淘宝小程序环境就用canvas初始化
        if (!window) {//自行处理吧，这么判断也不保险，万一淘宝小程序加进了window
            FYGE.initedByCanvas(canvas)//里面会设置env为tb，这个很重要
            //@ts-ignore 存在my就初始化
            sysInfo = my.getSystemInfoSync()
        }
        //建舞台
        var stage = new FYGE.Stage(
            canvas,//canvas标签
            750,//设计宽度，按设计搞给的就行
            1624,//设计高度
            sysInfo && sysInfo.windowWidth || document.body.clientWidth, //显示宽度，全屏就是屏幕宽度
            sysInfo && sysInfo.windowHeight || document.body.clientHeight,//显示高度，全屏就是屏幕高度
            FYGE.RENDERER_TYPE.CANVAS,//渲染模式canvas
            true, //视窗居中裁切
            false,//不定高，定宽适配
            sysInfo && sysInfo.pixelRatio || window.devicePixelRatio || 1//分辨率
        );
        this.stage = stage;
        this.canvas = canvas;//赋值下，为了下面的destroy的cancelAnimationFrame
        //stage初始化
        stage.addEventListener(FYGE.Event.INIT_STAGE, this.onAddToStage, this);
        //循环
        var self = this;
        loop();
        function loop() {
            if (!self._pause) {
                // stats.begin();
                FYGE.Tween.flush()
                stage.flush();
                // stats.end();
            }
            //@ts-ignore 为了兼容多page的canvas
            FYGE.getEnv() == "tb" ? self.requestID = canvas.requestAnimationFrame(loop) :
                self.requestID = window.requestAnimationFrame(loop);
        }
    }

    private async onAddToStage() {
        //初始化层级
        layers.init(this.stage);
        console.log("初始化层级完成")
        //初始化资源配置
        RES.loadConfig(ResJson);
        console.log("初始化资源配置完成")
        //皮肤配置加载
        RES.loadSkinConfig(SkinJson);
        console.log("初始化皮肤配置完成")
        //加载通用资源
        await RES.loadGroup("common");
        console.log("通用资源加载完成")
        //h5环境时，隐藏加载中
        if (FYGE.getEnv() == "web" && document.getElementById("__loading__")) document.getElementById("__loading__").style.display = "none";
        changeScene(StartScene)
        

        // 没有loading 就在这里拿到全局数据
        // showWaiting();
        // Promise.all([
        //     sendTbNet(TbNetName.getAppData),//用户基础信息
        //     sendTbNet(TbNetName.getActivityBaseInfoById),//活动基础信息
        //     sendTbNet(TbNetName.getGameCounts),//游戏次数
        //     RES.loadGroup("StartScene")//首页资源也一并加载了
        // ]).then((results) => {
        //     hideWaiting();
        //     //全局数据
        //     Tools.globalData = results[0].data;
        //     // 活动信息获取成功后，游戏次数获取成功后
        //     if (results[1].success && results[2].success) {
        //         //游戏次数赋值
        //         Tools.gameInfo = Tools.gameInfo || {};
        //         Tools.gameInfo.gameCounts = results[2].data.gameCounts;
        //         //判断是否结束
        //         getTbServerTime().then((time) => {
        //             Tools.gameInfo.isEnd = results[1].data.endTime < time;
        //         });
        //         //打开首页
        //         changeScene(StartScene, {})
        //         // showPanel(GameOverPanel,{rank:33,credits:222,curScore:200,totalScore:6999})
        //     }
        // })
    }

    /**
     * 在小程序显示时调用onShow
     */
    run() {
        this._pause = false;
        //@ts-ignore Tween计时清零
        FYGE.Tween._lastTime = null;
        //触发onShow
        GDispatcher.dispatchEvent({ type: G_EVENT.ON_SHOW });
    }
    /**
     * 在小程序隐藏时调用onHide
     */
    pause() {
        // this._pause = true;//先不暂停了
        //触发onHide
        GDispatcher.dispatchEvent({ type: G_EVENT.ON_HIDE });
    }

    /**
     * 添加全局事件，用于小程序的交互调用
     * 一直很犹豫要不要放在main的实例里，还是和Main同级导出，还有上面的pause，run，下面的事件等
     * @param name
     * @param fun
     * @param thisObj
     */
    addGlobalEvent(name: string, fun: Function, thisObj?: any, once: boolean = false) {
        if (once) {
            GDispatcher.once(name, fun, thisObj)
        } else {
            GDispatcher.addEventListener(name, fun, thisObj)
        }
    }
    /**
     * 派发全局事件，用于小程序的交互调用
     * @param name 可以是事件名，也可以是事件
     * @param data
     */
    dispatchGlobalEvent(name: string | any, data?: any) {
        GDispatcher.dispatchEvent(name, data)
    }
    /**
     * 移除全局事件，用于小程序交互调用
     * @param name
     * @param fun
     * @param thisObj
     */
    removeGlobalEvent(name: string, fun: Function, thisObj?: any) {
        GDispatcher.removeEventListener(name, fun, thisObj)
    }


    //在小程序页面卸载时调用onUnload，多次销毁后会有问题，再检查
    destroy() {
        //Tween都移除，注意吧，可能原先的也被移除,,对于多page时注意，会把其他页面的也去掉
        FYGE.Tween.removeAllTweens()
        //停掉计时器
        //@ts-ignore 为了兼容多page的canvas
        FYGE.getEnv() == "tb" ? this.canvas.cancelAnimationFrame(this.requestID) :
            window.cancelAnimationFrame(this.requestID);
        //层级销毁
        destroyLayers()
        //销毁控制器
        destroyAllCtrls();
        //舞台销毁
        this.stage.destroy();
        //全局事件置空
        GDispatcher.removeAllEventListener();
        //淘宝环境网络数据记录清空
        destroyTbNetData();
        //web环境其实没必要
        // destroyWebNetData()
    }
}

// function aa(){
//     for (let i = 0; i < 10; i++) {
//         setTimeout(() => {
//             console.log(i)
//         })
//     }
// }

// function aa(){
//     var a=[]
//     for (let i of a) {
//        console.log(i)
//     }
// }

