var fs = require("fs");
const babel = require('@babel/core');
// console.log(babel)
async function  createHtml(url) {
    var js = `//yun.duiba.com.cn/db_games/${url}/output.js`;
    var htmlData = fs.readFileSync("./index.html").toString();
    var string = await es6ToEs5(htmlData);
    //写入released
    fs.writeFileSync("./released/index.html", string.replace("output.js", js))
}

/**ES6转ES5 */
function es6ToEs5(htmlPluginData) {
    return new Promise(function (resolve) {
        const scriptRegExp = /<script>[\s\S]*?<\/script>/gi
        let htmlData = htmlPluginData.replace(scriptRegExp, function (match) {
            const code = match.replace("<script>", "").replace("</script>", "");
            const es5Code = babel.transform(code, { 'presets': ['@babel/preset-env'] }).code;
            return `<script>${es5Code}\n</script>`;
        });
        resolve(htmlData);
    });
}

module.exports = createHtml