import { Panel } from "../../module/views/Panel";
import { getTbData, TbNetName } from "../TaoBaoNet";
import { Tools } from "../Tools";
export class RulePanel extends Panel {
	get groupNames() { return ["RulePanel"] }
	get skinName() { return "RulePanel" }
	ruleTxt: FYGE.TextField;
	knowBtn: FYGE.Button;
	closeBtn: FYGE.Button;

	//两个按钮都是关闭作用
	get closeBtns() {
		return [this.closeBtn, this.knowBtn];
	}

	start(data) {
		super.start();
		//取接口数据
		var ruleStr = getTbData(TbNetName.getActivityBaseInfoById).data.rule;//htmlToPureText(this.data.rule);带标签的规则
		//文案
		var scroll = this.addChild(new FYGE.ScrollPage(610, 816, 100, true, false))
		scroll.position.copy(this.ruleTxt.position)
		this.removeChild(this.ruleTxt);
		//加文案
		var txt = scroll.view.addChild(Tools.getText(
			ruleStr,
			30,//this.ruleTxt.size,
			this.ruleTxt.fillColor,
			FYGE.TEXT_ALIGN.LEFT,
			610
		))
		//多行设置
		txt.lineType = FYGE.TEXT_lINETYPE.MULTI;
		//行高设置
		txt.lineHeight = 42;
		//滚动最大长度按文本高度
		scroll.maxDistance = txt.textHeight
	}
}


const ruleTemplate = `啊企鹅去欧文u去外婆偶尔u欺骗我如情人坡i去哦日期【人贫穷人品【去哦微软【哦前往平壤【 去哦【让我气泡【让我去【王培荣亲王【人跑去欧文人【强我弱【\n 去哦人权为荣哦破千万人脾气【微软哦亲哦人气泡【 人游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则
游戏规则游戏规则游戏规则游戏规则游戏规则`
