import { Panel } from "../../module/views/Panel";
import { Tools } from "../Tools";
export class RankNoPrizePanel extends Panel {
	get groupNames() { return ["RankNoPrizePanel"] }
	get skinName() { return "RankNoPrizePanel" }
	rankTxt: FYGE.TextField;
	closeBtn: FYGE.Button;
	knowBtn: FYGE.Button;

	//传入数据格式
	data: {
		rank: number
	}

	//两个按钮都时关闭
	get closeBtns() {
		return [this.closeBtn, this.knowBtn]
	}

	initUi() {
		Tools.changeTextAlign(this.rankTxt, FYGE.TEXT_ALIGN.CENTER, 300);
		this.rankTxt.text = "" + this.data.rank;
	}
}
