import { changeScene, wait } from "../../module/ctrls";
import { RES } from "../../module/RES";
import { Scene } from "../../module/views/Scene";
import { ProgressBarS } from "../common/ProgressBarS";
import { getTbServerTime, sendTbNet, TbNetName } from "../TaoBaoNet";
import { Tools } from "../Tools";
import { StartScene } from "./StartScene";

const words = [
    {
        "name": "load_l",
        "x": 206,
        "y": 680,
    },
    {
        "name": "load_o",
        "x": 249,
        "y": 680,
    },
    {
        "name": "load_a",
        "x": 298,
        "y": 680,
    },
    {
        "name": "load_d",
        "x": 346,
        "y": 680,
    },
    {
        "name": "load_i",
        "x": 396,
        "y": 680,
    },
    {
        "name": "load_n",
        "x": 422,
        "y": 680,
    },
    {
        "name": "load_g",
        "x": 472,
        "y": 680,
    },
    {
        "name": "load_dian",
        "x": 527,
        "y": 706,
    },
    {
        "name": "load_dian",
        "x": 546,
        "y": 706,
    },
    {
        "name": "load_dian",
        "x": 564,
        "y": 706,
    }
]


export class LoadingScene extends Scene {
    get groupNames() {
        return ["loading"]
    }

    progressBar: ProgressBarS;

    initUi() {
        //适配
        // this.y = -layers.stageOffsetY
        //背景
        // this.addChild(FYGE.Sprite.fromUrl("xxxxxxxx"))
        //     .position.set(0, 0)

        //进度条底图
        this.addChild(FYGE.Sprite.fromFrame("进度条底.png"))
            .position.set((750 - 577) / 2, 1288 - 24)
        //进度条
        var pro = this.addChild(FYGE.Sprite.fromFrame("进度条.png"));
        pro.position.set((750 - 577) / 2, 1288 - 24)
        //进度条托管
        this.progressBar = new ProgressBarS(pro);

        //加个动效
        words.forEach(async (w, i) => {
            var word = this.addChild(new FYGE.Sprite(RES.getRes(w.name+".png")))
            word.position.set(w.x,w.y);
            if (i % 2) await new Promise<void>((r) => {
                wait(r, 400)
            })
            FYGE.Tween.get(word, { loop: true })
                .to({ y: w.y - 4 }, 400,FYGE.Ease.sineInOut)
                .to({ y: w.y }, 400,FYGE.Ease.sineInOut)
        })
    }

    async start() {
        super.start()

        //监听进度条事件
        this.addEventListener(FYGE.Event.PROGRESS, this.progressEvent, this)
        //首次进度一点
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.2)
        //接口1
        var res = await sendTbNet(TbNetName.getAppData)//用户基础信息
        //做些啥?
        Tools.globalData = res.data;
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.3);
        // 接口2
        var res1 = await sendTbNet(TbNetName.getActivityBaseInfoById)
        //做些啥?
        if (!res1.success) return
        //判断是否结束
        getTbServerTime().then((time) => {
            Tools.gameInfo = Tools.gameInfo || {};
            Tools.gameInfo.isEnd = res1.data.endTime < time;
        });
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.5);
        //
        var res2 = await sendTbNet(TbNetName.getGameCounts)
        if (!res2.success) return
        Tools.gameInfo.gameCounts = res2.data.gameCounts;
        //资源1
        await RES.loadGroup("StartScene")
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.6);
        //资源2
        // await RES.loadGroup("mapCrabEffect")
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.7);
        //星火资源
        // await RES
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.8);
        //随便异步示例
        await new Promise((r) => {
            setTimeout(r, 1000)
        })
        this.dispatchEvent(FYGE.Event.PROGRESS, 1);
    }

    progressEvent(e: FYGE.Event) {
        let pro = e.data;
        FYGE.Tween.removeTweens(this.progressBar)
        FYGE.Tween.get(this.progressBar)
            .to({ value: pro }, 2000)
            .call(() => {
                if (pro >= 1) {
                    this.removeEventListener(FYGE.Event.PROGRESS, this.progressEvent, this);
                    changeScene(StartScene)
                }
            })
    }
}



