import { Panel } from "../../module/views/Panel";
import { sendTbNet, TbNetName } from "../TaoBaoNet";
import { Tools } from "../Tools";
import { showWaiting, hideWaiting } from "../../module/ctrls";
import { GDispatcher } from "../Main";
import { G_EVENT } from "../common/G_EVENT";
export class HelpPanel extends Panel {
	get groupNames() { return ["HelpPanel"] }
	get skinName() { return "HelpPanel" }
	helpBtn: FYGE.Button;
	closeBtn: FYGE.Button;

	start(data) {
		super.start();
		this.helpBtn.addEventListener(FYGE.MouseEvent.CLICK, async () => {
			// this.hidePanel();
			showWaiting()
			var res = await sendTbNet(TbNetName.doHelp, { inviteId: Tools.globalData.inviteId })
			hideWaiting();
			if (res.success) {//成功助力
				this.hidePanel();//关闭自己，
				//刷新次数接口
				showWaiting();
				var res = await sendTbNet(TbNetName.getGameCounts);
				hideWaiting();
				if (res.success) Tools.gameInfo.gameCounts = res.data.gameCounts;
				GDispatcher.dispatchEvent(G_EVENT.UPDATE_SCENE);
			} else {
				//TODO根据code确定如何反馈，会员等等

			}
		}, this)
	}

}
