import { RES } from "../../../module/RES";

export default class Role extends FYGE.Container {
    roleImg: FYGE.Sprite;
    direction;
    jumpSvga;
    downSvga;
    lightSvga;
    currentIndex = -2;
    item;
    isMove;

    constructor() {
        super();

        let roleImg = this.roleImg = new FYGE.Sprite();
        roleImg.texture = RES.getRes("controlpeo.png");
        this.getSvga()

        // this.addEventListener(
        //     FYGE.Event.ADDED_TO_STAGE,
        //     () => {
        //         this.addEventListener(FYGE.Event.ENTER_FRAME, this.onFarm, this);
        //     },
        //     this
        // );
    }
    async getSvga(){
        this.jumpSvga = new FYGE.SvgaAni(await RES.getResAsync("jumppeo.svga"));
        this.jumpSvga.position.set(-this.jumpSvga.videoWidth / 2, -this.jumpSvga.videoHeight / 2)
        this.jumpSvga.visible = false
        this.addChild(this.jumpSvga);

        this.downSvga = new FYGE.SvgaAni(await RES.getResAsync("crypeo.svga"));
        this.downSvga.position.set(-this.downSvga.videoWidth / 2, -this.downSvga.videoHeight / 2)
        this.addChild(this.downSvga);

        this.lightSvga = new FYGE.SvgaAni(await RES.getResAsync("light.svga"));
        this.lightSvga.position.set(-this.lightSvga.videoWidth / 2, -this.lightSvga.videoHeight / 2)
        this.lightSvga.visible = false
        this.addChild(this.lightSvga);
    }

    leftMove(data, callback){
        if (this.currentIndex%2 == 0) {
            if (this.isMove) return
            this.isMove = true
            this.item = data.item
            this.direction = 'left'
            this.downSvga.visible = false
            this.jumpSvga.visible = true,
            this.jumpSvga.startAniRange(1, undefined, 1)
            FYGE.Tween.get(this.position).to({
                x: this.item.position.x + 20,
                y: this.item.position.y - 110
            }, 350, FYGE.Ease.quadInOut)
            .call(() => {
                // console.log("播放完成")
                callback && callback(this.item)
                this.currentIndex = this.item.index;
                this.downSvga.visible = true
                this.jumpSvga.visible = false
                this.isMove = false
                this.lightSvga.visible = true
                this.lightSvga.startAniRange(1, undefined, 1, () => {
                    this.lightSvga.visible = false
                })
            })
        }
    }

    rightMove(data, callback){
        if (this.currentIndex%2 == 1) {
            if (this.isMove) return
            this.isMove = true
            this.item = data.item
            console.log('右移动', this.item.position.x)
            this.direction = 'right'
            this.downSvga.visible = false
            this.jumpSvga.visible = true
            this.jumpSvga.startAniRange(1, undefined, 1)
            FYGE.Tween.get(this.position).to({
                x: this.item.position.x + 20,
                y: this.item.position.y - 110
            }, 350, FYGE.Ease.quadInOut)
            .call(() => {
                console.log("播放完成")
                callback && callback(this.item)
                this.currentIndex = this.item.index
                this.downSvga.visible = true
                this.jumpSvga.visible = false
                this.isMove = false
                this.lightSvga.visible = true
                this.lightSvga.startAniRange(1, undefined, 1, () => {
                    this.lightSvga.visible = false
                })
            })
        }
    }

    // 人物自由落地
    onFreeFall(position, data, callback) {
        this.item = data.item
        this.position.set(position.x, position.y - 800)
        this.downSvga.visible = false
        this.jumpSvga.visible = true,
        this.jumpSvga.startAniRange(1, undefined, 1)
        FYGE.Tween.get(this.position, {
            onChange: () => {
                
            }
        }).to({
            x: position.x + 20,
            y: position.y - 110
        }, 500, FYGE.Ease.quadInOut)
        .call(() => {
            console.log("播放完成")
            callback && callback(this.item)
            this.currentIndex = this.item.index;
            this.downSvga.visible = true
            this.jumpSvga.visible = false
        })
    }

    addScore(num: number | string, color: string) {
        var score = this.addChild(new FYGE.TextField());
        score.x = -300 / 2;
        score.y = -280 / 2 - 50;
        score.size = 40;
        score.bold = true;
        score.text = num + '';
        score.textWidth = 300;
        score.textAlign = FYGE.TEXT_ALIGN.CENTER;


        score.fillColor = color;

        FYGE.Tween.get(score, { loop: false }).to({
            y: -280 / 2 - 100,

        }, 1000, FYGE.Ease.quadInOut).call(() => {
            // score.destroy()

            FYGE.Tween.get(score, { loop: false }).to({
                alpha: 0,
            }, 300).call(() => {
                score.destroy()
            })

        })

    }

    jump() {
        // if( this.direction == 'up'){return};
        // setTimeout(()=>{
        //     Matter.Body.applyForce(this.phyBody, this.phyBody.position, {
        //         x: 0,
        //         y: -1.2
        //     });
        // })
    }

    onMouseDown(e) {
        let offsetX = e.stageX - this.x;
        let offsetY = e.stageY - this.y;
        this.stage.addEventListener(
            FYGE.MouseEvent.MOUSE_MOVE,
            function (event) {
                let resx = event.stageX - offsetX;
                let resy = event.stageY - offsetY;
                if (resx < 50 || resx > 700) { return }
                this.x = resx;
            },
            this
        );

        this.stage.addEventListener(
            FYGE.MouseEvent.MOUSE_UP,
            function (event) {
                this.stage.removeAllEventListener()
            },
            this
        );
    }

    set fx(value: number) {
        this.position.x = value;
    }

    set fy(value: number) {
        this.position.y = value;
    }
}