import * as Matter from "matter-js";
import { RES } from "../../../module/RES";

export default class Cloud extends FYGE.Container {
    public phyBody: Matter.Body;
    itemImg: FYGE.Sprite;
    direction;
    constructor(data?) {
        super();
        this.direction = data
        let itemImg = this.itemImg = new FYGE.Sprite();
        itemImg.texture = RES.getRes("cloud.png");
        // itemImg.position.set(-itemImg.width / 2, -10);
        this.addChild(itemImg);

        this.phyBody = Matter.Bodies.rectangle(this.x, this.y, itemImg.width, 5, {
            isStatic: true,
            friction: 1,
            render: {
                fillStyle: '#000000'
            },
            isSensor: true, // 传感器，可以检测到碰撞，但是不参与碰撞
        });
        this.phyBody.gameType = 'item'

        setTimeout(() => {
            this.setPhyPos();
        }, 200)
    }

    set fx(value: number) {
        this.position.x = value;
        this.setPhyPos();
    }

    set fy(value: number) {
        this.position.y = value;
        this.setPhyPos();
    }

    setPhyPos() {
        Matter.Body.setPosition(this.phyBody, {
            x: (this.x),
            y: (this.y),
        });
    }


}