import { Scene } from "../../module/views/Scene";
import { changeScene, showPanel, showToast } from "../../module/ctrls";
import { GameScene } from "./GameScene";
import { RES } from "../../module/RES";
import { RulePanel } from "../panels/RulePanel";
import { sendWebNet, WebNetName, getPxTokenSave, getWebData } from "../webNet";
import { GDispatcher } from "../Main";
import { getUrlParams } from "../../module/web/webTools";
const allWords:any = ['闲', '看', '晴', '云', '自', '卷', '舒', '静', '水', '流', '深', '心', '无', '意', '在', '休']
export class StartScene extends Scene {
    get groupNames() { return ["StartScene"] };
    get skinName() { return "StartScene" };

    startbtn;
    startbg: FYGE.Sprite;
    collect: FYGE.Sprite;
    titlelab: FYGE.TextField;
    backbrn: FYGE.Sprite;
    rulebtn: FYGE.Sprite;
    public static instance: StartScene
    indexInfo;
    initUi() {
    }
    async start(data) {
        super.start();
        StartScene.instance  = this;
        let svgashow = new FYGE.SvgaAni(await RES.getResAsync("startpeople.svga"))
        this.addChild(svgashow)
        svgashow.position.set(83, 590)

        this.startbtn = new FYGE.SvgaAni(await RES.getResAsync("startbtn.svga"))
        this.addChild(this.startbtn)
        this.startbtn.position.set(208, 1246)
        this.startbtn.addEventListener(FYGE.MouseEvent.CLICK, this.openGame, this)

        this.titlelab.textWidth = 750;
        this.titlelab.textAlign = FYGE.TEXT_ALIGN.CENTER
        
        this.getIndexInfo()
    }
    async getIndexInfo() {
        const { success, data, desc } = await sendWebNet(WebNetName.indexInfo, {
            activityId: getUrlParams('activityId'),
            type: 3
        })
        if (!success) {
            showToast(desc || "网络开小差了，稍后再试")
            return
        }

        this.indexInfo = data
        this.titlelab.text = "今日收集字数( " + data.collectCount + " / 16 )"
 
        // this.openGame()
    }
    openRule() {
        GDispatcher.dispatchEvent("openRule");
    }
    startId;
    getWordList() {
        let dataInfo = getWebData(WebNetName.indexInfo).data.dataInfo;
        let hasWordList:any = [];
        let noWordList:any = [];
        dataInfo.forEach(item => {
            if (item.context) {
                hasWordList = hasWordList.concat(item.context.split(""))
            }
        })
        allWords.forEach(item => {
            if (!hasWordList.includes(item) && !noWordList.includes(item)) {
                noWordList.push(item)
            }
        })
        return noWordList
    }
    async openGame() {
        this.btnDelay(this.startbtn)
        if (this.getWordList().length == 0) {
            showToast("您已获取今日全部游戏奖励，\n请明日再来");
            return
        }
        const { success, code, data, desc } = await sendWebNet(WebNetName.startGame, { 
            activityId: getUrlParams('activityId'),
            type: 3
        })
        if (success) {
            this.startId = data.startId;
            changeScene(GameScene)
        } else {
            showToast(desc || "网络开小差了，稍后再试")
        }
    }
    goback() {
        GDispatcher.dispatchEvent("backIndex");
    }
    async openCollect() {
        let dataInfo = getWebData(WebNetName.indexInfo).data.dataInfo;
        if (!dataInfo) {
            await this.getIndexInfo()
        }
        GDispatcher.dispatchEvent("openCollect", getWebData(WebNetName.indexInfo).data.dataInfo);
    }
    initEvents() {
        super.initEvents();
        this.rulebtn.addEventListener(FYGE.MouseEvent.CLICK, this.openRule, this)
        this.backbrn.addEventListener(FYGE.MouseEvent.CLICK, this.goback, this)
        this.collect.addEventListener(FYGE.MouseEvent.CLICK, this.openCollect, this)

    }
    removeEvents() {
        super.removeEvents();
        this.startbtn.removeEventListener(FYGE.MouseEvent.CLICK, this.openGame, this)
        this.rulebtn.removeEventListener(FYGE.MouseEvent.CLICK, this.openRule, this)
        this.backbrn.removeEventListener(FYGE.MouseEvent.CLICK, this.goback, this)
        this.collect.removeEventListener(FYGE.MouseEvent.CLICK, this.openCollect, this)
    }
}

