import { Panel } from "../../module/views/Panel";
import { sendWebNet, WebNetName, LOG_TYPE } from "../webNet";
import { showToast } from "../../module/ctrls";
import { RES } from "../../module/RES";
export class RulePanel extends Panel {
    get groupNames() { return ["RulePanel"] };
    get skinName() { return "RulePanel" };

    rulebg: FYGE.Sprite;
	closebtn: FYGE.Button;
	ruleLab: FYGE.TextField;
    
    ruleInfo;
    initUi() {
        
    }
    async start() {
        super.start();
        let atmosphere = new FYGE.SvgaAni(await RES.getResAsync("atmosphere.svga"))
        this.addChildAt(atmosphere, -1)
        atmosphere.position.set(18, 280);

        this.removeChild(this.ruleLab);
        this.ruleInfo = `1、游戏名称：闲看晴云自卷舒
		2、游戏时间：2023.3.22-2023.4.11
		3、活动介绍：
		点击【去找字】按钮进入游戏页，左右滑动控制火车IP人物跳一跳，跳一跳的过程中碰到文字即可收集，文字随机刷新，参与游戏集文字，每日根据如下集齐情况分别获得对应平和星奖励，每日不限次数参与挑战，直至集齐；每日仅首次集齐获得平和星奖励；
		闲云晴云自卷舒——集齐得20平和星
		静水流深——集齐得5平和星
		云卷云舒——集齐得5平和星
		心无意——集齐得5平和星
		自在休闲——集齐得5平和星`
        let section;
        if (!section) {//避免文案过长，用这种方式
            document.getElementById("cusEngine").style.position = "absolute"
            section = document.createElement('section');
            section.id = "rule";
            section.style.overflowX = "hidden";
            section.style.overflowY = "auto";
            section.style.width = 476 + "px";
            section.style.height = 378 + "px";
            section.style.lineHeight = 42 + "px";
            section.style.fontSize = 22 + 'px';
            section.style.color = "#b34112";
            section.style.whiteSpace = "pre-line";
            section.innerHTML = this.ruleInfo;
        }
        var rule = this.addChild(new FYGE.FloatDisplay());
        rule.position.set(this.ruleLab.x,this.ruleLab.y)
        rule.init(section);
    }
    initEvents() {
        super.initEvents();
        this.closebtn.addEventListener(FYGE.MouseEvent.CLICK,this.hidePanel,this)

    }
    removeEvents() {
        super.removeEvents();
        this.closebtn.removeEventListener(FYGE.MouseEvent.CLICK,this.hidePanel,this)

    }
}

