import { Panel } from "../../module/views/Panel";
import { changeScene, getCurrentScene, showPanel, showToast } from "../../module/ctrls";
import { StartScene } from "../scenes/StartScene";
import { GuidePanel } from "./GuidePanel";
import { getWebData, WebNetName, LOG_TYPE, getPxTokenSave, sendWebNet } from "../webNet";
export class FailPanel extends Panel {
    get groupNames() { return ["FailPanel"] };
    get skinName() { return "FailPanel" };

    failbg: FYGE.Sprite;
    failtitle: FYGE.TextField;
    score: FYGE.TextField;
    closebtn: FYGE.Button;
    knowbtn: FYGE.Button;
    restartbtn: FYGE.Button;

    initUi() {

    }
    start(data) {
        super.start();
        let endInfo = getWebData(WebNetName.submitGame).data
        this.score.text = endInfo.score + ""
        this.score.x = 92
        this.score.textWidth = 568
        this.score.textAlign = FYGE.TEXT_ALIGN.CENTER
    }
    back() {
        this.hidePanel()
        changeScene(StartScene)
    }
    isOpen = false
    async restart() {
        this.btnDelay(this.restartbtn)
        if (!this.isOpen) {
            this.isOpen = true
            let token = await getPxTokenSave()
            const { success, data, message } = await sendWebNet(WebNetName.startGame, { token: token })
            if (!success) {
                this.isOpen = false
                showToast(message || "网络开小差了，稍后再试~")
                return
            }
            this.isOpen = false
            this.hidePanel()
            getCurrentScene().initMap()
            showPanel(GuidePanel)
        }
    }
    initEvents() {
        super.initEvents();
        this.closebtn.addEventListener(FYGE.MouseEvent.CLICK, this.back, this)
        this.knowbtn.addEventListener(FYGE.MouseEvent.CLICK, this.back, this)
        this.restartbtn.addEventListener(FYGE.MouseEvent.CLICK, this.restart, this)
    }
    removeEvents() {
        super.removeEvents();
        this.closebtn.removeEventListener(FYGE.MouseEvent.CLICK, this.back, this)
        this.knowbtn.removeEventListener(FYGE.MouseEvent.CLICK, this.back, this)
        this.restartbtn.removeEventListener(FYGE.MouseEvent.CLICK, this.restart, this)
    }
}

