
const cache: {
    [key: string]: FYGE.Texture
} = {}
/**
 * 
 * @param lightColor 颜色
 * @param lightRadius 光环半径
 * @param lightNum 光环扇形数量
 * @param bgColor 背光颜色
 * @param bgRadius 背光半径
 */
export function getLightBgTexture(
    lightColor: string = "#fffbb0",
    lightRadius: number = 425,
    lightNum: number = 18,
    bgColor: string = lightColor,
    bgRadius: number = lightRadius - 25
) {
    const cacheKey = `${lightColor}_${lightRadius}_${lightNum}_${bgColor}_${bgRadius}`;
    //缓存过就返回
    if (cache[cacheKey]) return cache[cacheKey];
    const canvas = FYGE.createCanvas()// document.createElement("canvas");
    canvas.width = canvas.height = lightRadius * 2;
    const x = lightRadius, y = x;
    const ctx = canvas.getContext("2d");
    //这一步为了淘宝
    ctx.clearRect(0, 0, canvas.width, canvas.height)
    //最大值18，否则开放每个灯光角度
    lightNum = Math.floor(Math.min(18, lightNum));
    //背景的光晕
    var colorObj = ctx.createRadialGradient(x, y, 0, x, y, bgRadius);
    colorObj.addColorStop(0, bgColor);
    colorObj.addColorStop(1, bgColor + "00");
    ctx.fillStyle = colorObj;
    ctx.beginPath();
    ctx.arc(x, y, lightRadius, 0, 2 * Math.PI)
    ctx.fill()
    //径向的光
    var colorObj = ctx.createRadialGradient(x, y, 0, x, y, lightRadius);
    colorObj.addColorStop(0, lightColor);
    colorObj.addColorStop(1, lightColor + "00");
    ctx.fillStyle = colorObj;
    ctx.beginPath();
    var anglePer = Math.PI / 12;
    var delta = Math.PI * 2 / lightNum;
    for (var i = 0; i < lightNum; i++) {
        ctx.moveTo(x, y)
        ctx.arc(x, y, lightRadius, Math.PI * 1.5 - anglePer / 2 + delta * i, Math.PI * 1.5 + anglePer / 2 + delta * i)
    }
    ctx.fill();
    //缓存
    cache[cacheKey] = FYGE.Texture.fromCanvas(canvas);
    return cache[cacheKey];
}