import {useCallback, useState} from "react";

const useFormState = (initialValues = {}) => {
    const [input, setInput] = useState(initialValues)

    const setInputData = useCallback((name, value) => {
        setInput(() => Object.assign({}, {...input}, {[name]: value}))
    }, [input])

    return [input, setInputData]
}


const useDrag = () => {

}



//这个hook很有意思，怎么样保存return出去的那个组件的数据呢
// function usePopContainer(props) {
//     const dragRef = useRef()
//     const [offset, setOffset] = useState({x: 0, y: 0})
//     const [draggable, setDraggable] = useState(false)
//     const handleMouseDown = e => {
//         e.stopPropagation()
//         setDraggable(true)
//         setOffset({
//             x: e.clientX - dragRef.current['getBoundingClientRect']().x,
//             y: e.clientY - dragRef.current['getBoundingClientRect']().y
//         })
//     }
//
//     const handleMouseUp = () => setDraggable(false)
//     const handleMouseMove = e => {
//         if (draggable) {
//             dragRef.current.style.transform = `translate(${e.clientX - offset.x}px,${e.clientY - offset.y}px)`
//             console.log(dragRef.current.style.transform)
//         }
//     }
//     return {
//         PopContainer: props => (
//             <div className="drag-Container"
//                  onMouseUp={() => handleMouseUp()}
//                  onMouseMove={(e) => handleMouseMove(e)}>
//                 <div className="Pop-container"
//                      ref={dragRef}
//                 >
//                     {props.children}
//                 </div>
//             </div>
//         ),
//         dragMouseDown: e => handleMouseDown(e)
//     }
// }

export {
    useFormState,
    useDrag,
}
