import logo from "../../static/logo.png";
import './index.scss'
import ToolType from "../../component/ToolType/ToolType";
import Content from '../../component/ContentAdmin/Content'
import {PopContext, Root} from "../../dataCenter/Root";
import {useContext, useEffect, useState} from "react";
import {NEED_UPDATE_INDEX} from "../../dataCenter/action";
import AdminIndex from "../../component/AdminIndex/AdminIndex";

function Index() {
    const [pop, setPop] = useState()
    const {fetchData, dataCenter, dispatch} = useContext(Root)
    const showPop = popComponent => {
        setPop(popComponent)
    }
    const getUser = () => {
        fetchData('/users/getUser', {uid: '100001'}, 'userInfo')
            .catch(res =>
                res.code === 70001 && (window.location.href = '/login')
            )
    }

    useEffect(() => {
        fetchData('/query/queryType', {}, 'type')
            .then(()=> fetchData('/query/queryChildType',{type_id: dataCenter.type_id},'childType'))
            .then(() => dispatch(NEED_UPDATE_INDEX()))
    }, [dataCenter.type_id])

    useEffect(() => {
        if (dataCenter.needUpdateIndex) {
            const _typeId = dataCenter.type_id === 'all' ? {} : dataCenter.type_id === 'follow' ? {
                isFollow: true,
                type_id: JSON.stringify(dataCenter.userInfo.follow)
            } : {type_id: dataCenter.type_id}
            fetchData('/query/queryToolBox', _typeId, 'toolBox').then(() => dispatch(NEED_UPDATE_INDEX()))
        }
    }, [dataCenter.needUpdateIndex])

    useEffect(() => {
        getUser()
    }, [])

    return (
        <PopContext.Provider value={{hidePop: () => setPop(''), showPop: popName => showPop(popName)}}>
            <div className="index">
                <div className="welcome-top">
                    <span>欢迎您！
                        <span className="welcome-uname">{dataCenter?.userInfo?.uname}</span>
                        <a className="login-btn">退出登录</a>
                    </span>
                </div>
                <div className="nav">
                    <div className="nav-title">
                        <img src={logo} alt=""/>
                    </div>
                    <div className="nav-weather">
                        <iframe width="360" height="40" frameBorder="0" scrolling="no" hspace="0"
                                src="https://i.tianqi.com/?c=code&a=getcode&id=40&icon=1"/>
                    </div>
                </div>
                <div className="tool-nav">
                    <ToolType/>
                </div>
                <div className="container">
                    <Content/>
                </div>
                {
                    pop
                }
                <div className="index-footer">
                    兑吧研发中心·杭州兑吧网络科技游戏公司版权所有
                    <br/>
                    浙ICP备14017299号-1
                </div>
                <AdminIndex/>
            </div>
        </PopContext.Provider>
    )
}

export default Index

