import { Menu, Modal, Popconfirm, Space, Table, message } from 'antd';
import React, { useContext, useEffect, useState } from 'react';
import TypeModal from '../modal/TypeModal'
import { NEED_UPDATE_INDEX } from "../dataCenter/action";
import { Root } from "../dataCenter/Root";

const menu = (
    <Menu>
        <Menu.Item>Action 1</Menu.Item>
        <Menu.Item>Action 2</Menu.Item>
    </Menu>
);

function RemoveType({ visible, onCancel }) {

    const [typeModal, setTypeModal] = useState(false)
    const [typeData, settypeData] = useState('')
    const [oldData, setoldData] = useState('')
    const { fetchData, dataCenter, dispatch } = useContext(Root)

    const changType = (data) => {
        setoldData(data)
        setTypeModal(true)
    }

    const changeData = (list, cb) => {
        return list.map((item, index) => {
            const res = cb(item);
            if (item.children) res.children = changeData(item.children, item => ({
                isRemove: true,
                key: item.child_type_id,
                type_id: item.child_type_id,
                type_name: item.child_type_name,
            }));
            return res;
        })
    }

    const removeType = (data) => {
        fetchData('/typeManage/deleteChildType', { child_type_id: data.type_id })
            .then((res) => {
                if (res.success) {
                    message.success('刪除成功')
                    dispatch(NEED_UPDATE_INDEX())
                    queryData()
                    // onCancel()
                }else{
                    message.error('刪除失败')
                }
            })
    }

    const queryData = () => {
        dataCenter?.type && fetchData('/typeManage/queryTypeForManage', {}, 'childTypeData')
            .then((res) => {
                // console.log(res.data);
                const newData = changeData(res.data, item => ({
                    key: item.type_id,
                    type_id: item.type_id,
                    type_name: item.type_name,
                }));
                // console.log(newData);
                settypeData(newData)
            })
    }

    useEffect(() => {
        queryData()
    }, [])

    const columns = [
        { title: '类型名', width: 100, dataIndex: 'type_name', key: 'type_name' },
        { title: 'Id', width: 100, dataIndex: 'type_id', align: 'center', key: 'type_id' },
        {
            title: '操作', width: 100, key: 'operation', align: 'center',
            render: (text, record) => (
                <Space size="middle">
                    {record.isRemove && <Popconfirm title="确定删除吗？" okText="确定" cancelText="取消" onConfirm={() => removeType(record)}>
                        <a href="#" >删除</a>
                    </Popconfirm>}
                    <a href="#" onClick={() => changType(record)}>修改</a>
                </Space>
            )
        },
    ];

    return (
        <Modal
            visible={visible}
            title="类型管理"
            okText="确定"
            cancelText="取消"
            width='1000px'
            onCancel={onCancel}
            onOk={onCancel}
        >
            <Table
                columns={columns}
                dataSource={typeData}
            />
            {typeModal && <TypeModal
                visible={typeModal}
                onCancel={() =>
                    setTypeModal(false)
                }
                queryData={() =>
                    queryData()
                }
                data={oldData}
            />}
        </Modal>

    );
}
export default RemoveType
